///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////



//////////////////////////////////////////////////
// StopwatchTimer.C: A clock class for the stopwatch
///////////////////////////////////////////////////
#include "StopwatchTimer.h"
#include "Face.h"

StopwatchTimer::StopwatchTimer ( XtAppContext  app, 
				Face         *face, 
				int           interval ) : 
				Timer ( app, interval )
{
    _face = face;
}

void StopwatchTimer::reportTime ( float time )
{
    _face->setTime ( time );
}
