///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////
// Command.C: Manage a set of command buttons
/////////////////////////////////////////////////////////
#include "stdlib.h"
#include "TicTacToe.h"
#include "Command.h"
#include "Engine.h"
#include <Xm/Form.h>
#include <Xm/PushB.h>

Command::Command ( const char      *name, 
		   Widget     parent,
		   TicTacToe *game ) : UIComponent ( name )
{
    _game = game;	
    
    // Set up an XmForm widget to manage the buttons
    
    _w = XmCreateForm ( parent, _name, NULL, 0 );
    
    installDestroyHandler();	
    
    // Create the command buttons and attach callbacks
    
    _newGame = 
	XtVaCreateManagedWidget ( "newGame", 
				  xmPushButtonWidgetClass, _w,
				  XmNtopOffset,        5,
				  XmNbottomOffset,     5,
				  XmNleftOffset,       5,
				  XmNtopAttachment,    XmATTACH_FORM,
				  XmNleftAttachment,   XmATTACH_FORM,
				  XmNrightAttachment,  XmATTACH_NONE,
				  XmNbottomAttachment, XmATTACH_FORM,
				  NULL );
    
    _quit = XtVaCreateManagedWidget ( "quit", 
                                      xmPushButtonWidgetClass, _w,
                                      XmNtopOffset,        5,
                                      XmNbottomOffset,     5,
                                      XmNrightOffset,      5,
                                      XmNtopAttachment,    XmATTACH_FORM,
                                      XmNleftAttachment,   XmATTACH_NONE,
                                      XmNrightAttachment,  XmATTACH_FORM,
                                      XmNbottomAttachment, XmATTACH_FORM,
                                      NULL );
    
    XtAddCallback ( _newGame, 
		    XmNactivateCallback, 
		    &Command::newGameCallback, 
		    ( XtPointer ) this );
    
    XtAddCallback ( _quit,
		    XmNactivateCallback,
		    &Command::quitCallback,
		    ( XtPointer ) this );
}

void Command::newGameCallback ( Widget w, 
				XtPointer clientData, 
				XtPointer callData)
{
    Command *obj = ( Command * ) clientData;
    obj->newGame ( w, callData );
}

void Command::newGame ( Widget, XtPointer )
{
    _game->engine()->reset();
}

void Command::quitCallback ( Widget w, 
			     XtPointer clientData, 
			     XtPointer callData)
{
    Command *obj = ( Command * ) clientData;
    obj->quit ( w, callData );
}

void Command::quit ( Widget, XtPointer )
{
    _game->engine()->quit();
}

