///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////



///////////////////////////////////////////////////////////////
// Command.h
///////////////////////////////////////////////////////////////
#ifndef COMMAND_H
#define COMMAND_H
#include "UIComponent.h"

class TicTacToe;

class Command: public UIComponent {
    
public:
    
    Command ( const char *, Widget, TicTacToe * ); 
    virtual const char * const className() { return ( "Command" ); };
    
protected:
    
    Widget     _newGame;
    Widget     _quit;
    TicTacToe *_game;
    virtual void newGame( Widget, XtPointer );
    virtual void quit( Widget, XtPointer );
    
private:
    
    static void newGameCallback ( Widget, XtPointer, XtPointer );
    static void quitCallback ( Widget, XtPointer, XtPointer );
};
#endif
