///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////
// GameBoard.h: A tic-tac-toe board
///////////////////////////////////////////////////////////////
#ifndef GAMEBOARD_H
#define GAMEBOARD_H
#include <Xm/Xm.h>
#include "UIComponent.h"
class TicTacToe;

class GameBoard: public UIComponent {
    
public:
    
    GameBoard ( const char *, Widget, TicTacToe * ); 
    virtual ~GameBoard();
    void highlightSquare ( int square );   // Highlight single square
    void deemphasizeSquare ( int square ); // Fade square to 2D
    void activateSquare ( int square );    // Allow input to square
    void deactivateSquare ( int square );  // Shut off input
    virtual void markO ( int square );     // Put an X in the square
    virtual void markX ( int square );     // Put an O in the square
    void clear();                          // Clear and reset board
    virtual const char *const className() { return ( "GameBoard" ); }
protected:
    
    Widget     _grid[9];          // 3 X 3 square of buttons
    GC         _gc;
    int        _gridSize;         // Size of each square
    TicTacToe *_game;
    Pixel      _highlightColor;   // Color of border when in 
                                    // an active square
    Pixel      _noHighlightColor; // Border color of inactive squares
    Dimension  _shadowThickness;  // Default shadow width of a square
    
    // Methods for refreshing the squares and getting input
    
    virtual void drawX ( Widget );
    virtual void drawO ( Widget );
    
private:
    
    void mark ( int ); // Handle user marking a square
    
    // Callbacks registered with widgets in the grid
    
    static void markCallback ( Widget, XtPointer, XtPointer );
    static void drawXCallback ( Widget, XtPointer, XtPointer );
    static void drawOCallback ( Widget, XtPointer, XtPointer ); 
};
#endif





























































































































































































