///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////



/////////////////////////////////////////////////////////////////////
// QuestionTestWindow.C: Test the QuestionDialogManager class
////////////////////////////////////////////////////////////////////
#include "QuestionTestWindow.h"
#include "QuestionDialogManager.h"
#include <Xm/PushB.h>

void postDialogCallback ( Widget, XtPointer, XtPointer );
void cancelCallback ( void *data );
void okCallback ( void * );

Widget QuestionTestWindow::createWorkArea ( Widget parent )
{
    Widget button = XtCreateManagedWidget ( "push_to_test", 
					    xmPushButtonWidgetClass,
					    parent, NULL, 0 );
    
    XtAddCallback ( button, XmNactivateCallback,
		    postDialogCallback,  NULL );
    return ( button );
}
void postDialogCallback ( Widget, XtPointer, XtPointer )
{
    theQuestionDialogManager->post ( "Can you answer the question?", 
				     (void *) NULL,
				     okCallback, 
				     cancelCallback );
}
void cancelCallback ( void * ) 
{
    cout << "No" << "\n" << flush;
}
void okCallback ( void * )
{
    cout << "Yes" << "\n" << flush;
}








