///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////
// MenuDemoApp.h: An application class for the menu demo program
///////////////////////////////////////////////////////////////////////
#ifndef MENUDEMOAPP_H
#define MENUDEMOAPP_H
#include "Application.h"
class Cmd;

class MenuDemoApp : public Application {
    
public:
    MenuDemoApp ( const char * );
    virtual ~MenuDemoApp();     
    
    // Provide access functions for all Cmd objects
    
    Cmd *quitCmd()    { return ( _quit ); }
    Cmd *manageCmd()  { return ( _manage ); }
    Cmd *iconifyCmd() { return ( _iconify ); }
    Cmd *xCmd() { return ( _x ); }
    Cmd *yCmd() { return ( _y ); }
    Cmd *zCmd() { return ( _z ); }
    
    virtual const char *const className() { return ( "MenuDemoApp" ); }
    
protected:
    // Maintain pointers to Cmd objects used throughout the application
    
    Cmd *_quit;
    Cmd *_manage;
    Cmd *_iconify;
    Cmd *_x;
    Cmd *_y;
    Cmd *_z;
};
// Classes that need to retrieve the MenuDemoApps Cmd objects
// need a pointer to an Application object that supports
// MenuDemoApps extended protocol

extern MenuDemoApp *theMenuDemoApp;
#endif




