<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:smll="http://schemas.amsd.com/mpmu/smlan/logical"
    xmlns:mv="http://schemas.amsd.com/mpmu/marvel/general"
    exclude-result-prefixes="smll mv"
    version="1.8"
>
    <xsl:output indent="yes" method="xml" encoding="UTF-8"/>
    
    <xsl:variable name="mv-uri">http://schemas.amsd.com/mpmu/marvel/general</xsl:variable>
    <xsl:variable name="smll-uri">http://schemas.amsd.com/mpmu/smlan/logical</xsl:variable>
    <xsl:variable name="definesXml">urn:xmls-amsd-com:mpmu:defines</xsl:variable>
    <xsl:variable name="logicalXml">urn:xmls-amsd-com:mpmu:smlan:logical</xsl:variable>
    
    
    <xsl:template match="smll:GetFirmwareVersions">
        <xsl:variable name="agent" select="name(current()/smll:Input/smll:Destination/*)"/>
        <xsl:variable name="mloop" select="document($definesXml)/Defs/DataType[@name='Firmware']/Define/Detail[@value=$agent]"/>
        <xsl:variable name="sloop" select="document($definesXml)/Defs/DataType[@name='FirmwareState']"/>

        <xsl:if test="not($mloop)">
            <xsl:message terminate="yes">check defines for Firmware Modules</xsl:message>
        </xsl:if>

        <xsl:if test="not($sloop)">
            <xsl:message terminate="yes">check defines for Firmware module states</xsl:message>
        </xsl:if>

        <xsl:variable name="cmd" select="."/>
        
        <xsl:element name="GetFirmwareVersions" namespace="">
            <xsl:for-each select="$mloop">
                <xsl:variable name="module" select="string(../@id)"/>
                <xsl:variable name="mname" select="string(@name)"/>
                <xsl:for-each select="$sloop/Define">
					<xsl:if test="@name='permanent' or $mname='Own'">
						<xsl:element name="GetFirmwareVersion" namespace="{$smll-uri}">
							<xsl:apply-templates select="$cmd/smll:Input" mode="fws">
								<xsl:with-param name="module" select="$module"/>
								<xsl:with-param name="state" select="string(@id)"/>
							</xsl:apply-templates>
						</xsl:element>
					</xsl:if>					
                </xsl:for-each>
            </xsl:for-each>
        </xsl:element>
    </xsl:template>

    <xsl:template match = "mv:MarvelRef" mode="fws">
        <xsl:param name="module"/>
        <xsl:param name="state"/>
        
        <xsl:element name="MarvelFirmwareVersionRef" namespace="{$mv-uri}">
            <xsl:apply-templates select="@*" mode="fws"/>
            <xsl:attribute name="module" namespace="">
                <xsl:value-of select="$module"/>
            </xsl:attribute>
            <xsl:attribute name="state" namespace="">
                <xsl:value-of select="$state"/>
            </xsl:attribute>
        </xsl:element>
    </xsl:template>
    
    <xsl:template match = "mv:SystemBoxRef" mode="fws">
        <xsl:param name="module"/>
        <xsl:param name="state"/>
        
        <xsl:element name="SystemBoxFirmwareVersionRef" namespace="{$mv-uri}">
            <xsl:apply-templates select="@*" mode="fws"/>
            <xsl:attribute name="module" namespace="">
                <xsl:value-of select="$module"/>
            </xsl:attribute>
            <xsl:attribute name="state" namespace="">
                <xsl:value-of select="$state"/>
            </xsl:attribute>
        </xsl:element>
    </xsl:template>

    <xsl:template match = "mv:ComboBoxRef" mode="fws">
        <xsl:param name="module"/>
        <xsl:param name="state"/>

        <xsl:element name="ComboBoxFirmwareVersionRef" namespace="{$mv-uri}">
            <xsl:apply-templates select="@*" mode="fws"/>
            <xsl:attribute name="module" namespace="">
                <xsl:value-of select="$module"/>
            </xsl:attribute>
            <xsl:attribute name="state" namespace="">
                <xsl:value-of select="$state"/>
            </xsl:attribute>
        </xsl:element>
    </xsl:template>

    <xsl:template match = "mv:IOBoxRef" mode="fws">
        <xsl:param name="module"/>
        <xsl:param name="state"/>
        
        <xsl:element name="IOBoxFirmwareVersionRef" namespace="{$mv-uri}">
            <xsl:apply-templates select="@*" mode="fws"/>
            <xsl:attribute name="module" namespace="">
                <xsl:value-of select="$module"/>
            </xsl:attribute>
            <xsl:attribute name="state" namespace="">
                <xsl:value-of select="$state"/>
            </xsl:attribute>
        </xsl:element>
    </xsl:template>
    
    <xsl:template match = "mv:DualCPUModuleRef" mode="fws">
        <xsl:param name="module"/>
        <xsl:param name="state"/>
        
        <xsl:element name="DualCPUModuleFirmwareVersionRef" namespace="{$mv-uri}">
            <xsl:apply-templates select="@*" mode="fws"/>
            <xsl:attribute name="module" namespace="">
                <xsl:value-of select="$module"/>
            </xsl:attribute>
            <xsl:attribute name="state" namespace="">
                <xsl:value-of select="$state"/>
            </xsl:attribute>
        </xsl:element>
    </xsl:template>
    
    <xsl:template match = "node()|@*" mode="fws">
        <xsl:param name="module"/>
        <xsl:param name="state"/>
        <xsl:copy>
            <xsl:apply-templates select="node()|@*" mode="fws">
                <xsl:with-param name="module" select="$module"/>
                <xsl:with-param name="state" select="$state"/>
            </xsl:apply-templates>
        </xsl:copy>
    </xsl:template>
    
    <xsl:template match="GetFirmwareVersionsResponse">
        <xsl:variable name="agent" select="name(document($logicalXml)/*/smll:Input/smll:Destination/*)"/>
        <xsl:variable name="mloop" select="document($definesXml)/Defs/DataType[@name='Firmware']/Define/Detail[@value=$agent]"/>
        
        <xsl:variable name="fwStates" select="document($definesXml)/Defs/DataType[@name='FirmwareState']"/>
        <xsl:variable name="permanentState" select="string($fwStates/Define[string(@name)='permanent']/@id)"/>
        <xsl:variable name="runningState" select="string($fwStates/Define[string(@name)='running']/@id)"/>

        <xsl:variable name="cur" select="."/>
        <xsl:element name="Output" namespace="{$smll-uri}">
            <xsl:element name="FirmwareModules" namespace="{$mv-uri}">
                <xsl:for-each select="$mloop">
                    <xsl:variable name="module" select="string(../@id)"/>
                    <xsl:variable name="ver" select="$cur/smll:Output/mv:FirmwareVersion[string(@module)=string($module)]"/>
                    <xsl:element name="FirmwareModule" namespace="{$mv-uri}">
                        <xsl:attribute name="isShadow">
                            <xsl:value-of select="@name='Shadow'"/>
                        </xsl:attribute>
                        <xsl:attribute name="module">
                            <xsl:value-of select="string($module)"/>
                        </xsl:attribute>
                        <xsl:if test="$ver">
                            <xsl:variable name="permanent" select="$ver[string(@state)=string($permanentState)]"/>
                            <xsl:if test="$permanent">
                                <xsl:attribute name="imageRevision" namespace="">
                                    <xsl:value-of select="string($permanent/@imageRevision)"/>
                                </xsl:attribute>
                                <xsl:attribute name="majorProtocolRevision" namespace="">
                                    <xsl:value-of select="string($permanent/@majorProtocolRevision)"/>
                                </xsl:attribute>
                                <xsl:attribute name="minorProtocolRevision" namespace="">
                                    <xsl:value-of select="string($permanent/@minorProtocolRevision)"/>
                                </xsl:attribute>
                            </xsl:if>
                            <xsl:variable name="running" select="$ver[string(@state)=string($runningState)]"/>
                            <xsl:if test="$running and @name='Own'">
                                <xsl:attribute name="imageRevisionRunning" namespace="">
                                    <xsl:value-of select="string($running/@imageRevision)"/>
                                </xsl:attribute>
                                <xsl:attribute name="majorProtocolRevisionRunning" namespace="">
                                    <xsl:value-of select="string($running/@majorProtocolRevision)"/>
                                </xsl:attribute>
                                <xsl:attribute name="minorProtocolRevisionRunning" namespace="">
                                    <xsl:value-of select="string($running/@minorProtocolRevision)"/>
                                </xsl:attribute>
                            </xsl:if>
                        </xsl:if>
                    </xsl:element>
                </xsl:for-each>
            </xsl:element>
        </xsl:element>
    </xsl:template>

    <xsl:template match="smll:GetEnvironment">
        <xsl:variable name="refName" select="name(smll:Input/smll:Destination/*)"/>
        <xsl:element name="GetEnvironment">
            <xsl:if test="$refName='SystemBoxRef' or $refName='IOBoxRef' or $refName='ComboBoxRef'">
                <xsl:element name="GetFans" namespace="{$smll-uri}">
                    <xsl:apply-templates mode="copyBody"/>
                </xsl:element>
            </xsl:if>
            <xsl:element name="GetVoltages" namespace="{$smll-uri}">
                <xsl:apply-templates mode="copyBody"/>
            </xsl:element>
            <xsl:element name="GetTemperatures" namespace="{$smll-uri}">
                <xsl:apply-templates mode="copyBody"/>
            </xsl:element>
        </xsl:element>
    </xsl:template>

    <xsl:template match="GetEnvironmentResponse">
        <xsl:element name="Output" namespace="{$smll-uri}">
            <xsl:element name="Environment" namespace="{$mv-uri}">
                <xsl:for-each select="smll:Output">
                    <xsl:apply-templates mode="copyBody"/>
                </xsl:for-each>
            </xsl:element>
        </xsl:element>
    </xsl:template>

    <xsl:template match="smll:GetAlertSupport">
        <xsl:element name="GetAlertSupport">
            <xsl:element name="GetFirmwareVersion" namespace="{$smll-uri}">
                <xsl:element name="Input" namespace="{$smll-uri}">
                    <xsl:element name="Destination" namespace="{$smll-uri}">
                        <xsl:element name="SystemBoxFirmwareVersionRef" namespace="{$mv-uri}">
                            <xsl:attribute name="marvelId">
                                <xsl:value-of select="smll:Input/smll:Destination/mv:*/@marvelId"/>
                            </xsl:attribute>
                            <xsl:attribute name="rackNumber">
                                <xsl:value-of select="'0'"/>
                            </xsl:attribute>
                            <xsl:attribute name="boxNumber">
                                <xsl:value-of select="'0'"/>
                            </xsl:attribute>
                            <xsl:attribute name="module">
                                <xsl:value-of select="'fW5'"/>
                            </xsl:attribute>
                            <xsl:attribute name="state">
                                <xsl:value-of select="'mw2'"/>
                            </xsl:attribute>
                        </xsl:element>
                    </xsl:element>
                </xsl:element>
            </xsl:element>
        </xsl:element>
    </xsl:template>

    <xsl:template match="GetAlertSupportResponse">
        <xsl:element name="Output" namespace="{$smll-uri}">
            <xsl:element name="Marvel" namespace="{$mv-uri}">
                <xsl:attribute name="marvelId">
                    <xsl:value-of select="smll:Input/smll:Destination/mv:*/@marvelId"/>
                </xsl:attribute>
                <xsl:attribute name="alertSupport">
                    <xsl:value-of select="number (smll:Output/mv:FirmwareVersion/@minorProtocolRevision) > 9"/>
                </xsl:attribute>
            </xsl:element>
        </xsl:element>
    </xsl:template>

    <xsl:template match="smll:GetComboBoxConfiguration">
        <xsl:element name="GetComboBoxConfiguration">
            <xsl:element name="GetSystemBoxConfiguration" namespace="{$smll-uri}">
                    <xsl:apply-templates mode="copyBody"/>
            </xsl:element>
        </xsl:element>
    </xsl:template>

    <xsl:template match="GetComboBoxConfigurationResponse">
        <xsl:element name="Output" namespace="{$smll-uri}">
            <xsl:if test="smll:Output/mv:SystemBox">
                <xsl:element name="ComboBox" namespace="{$mv-uri}">

                    <xsl:apply-templates select="smll:Output/mv:SystemBox/@*" mode="copyBody"/>
                    <xsl:apply-templates select="smll:Output/mv:SystemBox/*" mode="copyBody"/>

                    <xsl:element name="IORiser" namespace="{$mv-uri}">
                        <xsl:attribute name="number" namespace="">
                            <xsl:value-of select="0"/>
                        </xsl:attribute>
                    </xsl:element>
                </xsl:element>
            </xsl:if>
        </xsl:element>
    </xsl:template>

    <xsl:template match = "node()|@*" mode="copyBody">
        <xsl:copy>
            <xsl:apply-templates select="node()|@*" mode="copyBody"/>
        </xsl:copy>
    </xsl:template>
</xsl:stylesheet>
