<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:mv="http://schemas.amsd.com/mpmu/marvel/general"
                xmlns:cnfg="http://schemas.amsd.com/mpmu/marvel/configuration"

                exclude-result-prefixes="mv cnfg"
>

    <xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes" />
    <xsl:strip-space elements="*" />

    <xsl:param name="isExtractConfiguration" select="'false'" />
    <xsl:param name="id" />

    <xsl:variable name="urnPrefix" select="'urn:amsd.com:mpmu:server:'" />
    <xsl:variable name="logicalConfigurationURI" select="concat ($urnPrefix, 'logicalConfiguration')" />

    <xsl:variable name="templatesURI" select="concat ($urnPrefix, 'templates')" />
    <!--xsl:variable name="templates" select="document ($templatesURI)" /-->

    <xsl:template match="/*|mv:Marvels">
        <!--xsl:element name="dummy:Configuration" namespace="urn:dummy:dummy">
        </xsl:element-->
        <xsl:choose>
            <xsl:when test="$id">
                <xsl:apply-templates select="*[@id = $id]" mode="extractConfiguration" />
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates select="." mode="extractConfiguration" />
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="mv:Marvel" mode="extractConfiguration">
        <xsl:copy>
            <xsl:apply-templates select="@*" mode="extractConfiguration" />

            <xsl:if test="not (@type)">
                <xsl:attribute name="type">
                    <xsl:value-of select="'live'" />
                </xsl:attribute>
            </xsl:if>
            
            <xsl:if test="$isExtractConfiguration='true'">
                <xsl:choose>
                    <xsl:when test="@templateRef">
                        <xsl:variable name="template" select="document ($templatesURI)/cnfg:MarvelTemplates/cnfg:MarvelTemplate[@id = current ()/@templateRef]" />
                        <xsl:apply-templates select="$template/*" mode="extractConfiguration" />
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:apply-templates select="*" mode="extractConfiguration" />
                    </xsl:otherwise>
                </xsl:choose>
                <xsl:variable name="marvelId" select="@id" />
                <xsl:for-each select="document ($logicalConfigurationURI)/*">
                    <!--xsl:apply-templates select="id (@id)/*" mode="copyLogicalConfiguration" /-->
                    <xsl:apply-templates select="//*[@id = $marvelId]/*" mode="copyLogicalConfiguration" />
                </xsl:for-each>
            </xsl:if>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="cnfg:LogicalCPUs" mode="extractConfiguration" />

    <xsl:template match="@cnfg:*" mode="extractConfiguration">
        <xsl:variable name="attributeName">
            <xsl:choose>
                <xsl:otherwise>
                    <xsl:value-of select="local-name ()" />
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>

        <xsl:attribute name="{$attributeName}" namespace="http://schemas.amsd.com/mpmu/marvel/general">
            <xsl:value-of select="." />
        </xsl:attribute>
    </xsl:template>

    <xsl:template match="cnfg:*" mode="extractConfiguration">
        <xsl:variable name="elementName">
            <xsl:choose>
                <xsl:when test="local-name () = 'MarvelConfigurations'">
                    <xsl:value-of select="'Marvels'" />
                </xsl:when>
                <xsl:when test="local-name () = 'MarvelConfiguration'">
                    <xsl:value-of select="'Marvel'" />
                </xsl:when>
                <xsl:when test="local-name () = 'MarvelTemplates'">
                    <xsl:value-of select="'Marvels'" />
                </xsl:when>
                <xsl:when test="local-name () = 'MarvelTemplate'">
                    <xsl:value-of select="'Marvel'" />
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="local-name ()" />
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>

        <xsl:element name="{$elementName}" namespace="http://schemas.amsd.com/mpmu/marvel/general">
            <xsl:if test="$elementName = 'Marvels'">
                <xsl:attribute name="id" namespace="">
                    <xsl:value-of select="'MVS'" />
                </xsl:attribute>
            </xsl:if>

            <xsl:if test="($elementName = 'Marvel') and not (@type)">
                <xsl:attribute name="type">
                    <xsl:value-of select="'live'" />
                </xsl:attribute>
            </xsl:if>

            <xsl:variable name="template" select="document ($templatesURI)/cnfg:MarvelTemplates/cnfg:MarvelTemplate[@id = current ()/@templateRef]" />
            <xsl:apply-templates select="@*|*" mode="extractConfiguration" />
        </xsl:element>
    </xsl:template>

    <xsl:template match="@*|*" mode="extractConfiguration">
        <xsl:copy>
            <xsl:apply-templates select="@*|*" mode="extractConfiguration" />
        </xsl:copy>
    </xsl:template>

    <xsl:template match="@*|*" mode="copyLogicalConfiguration">
        <xsl:copy>
            <xsl:apply-templates select="@*|*" mode="copyLogicalConfiguration" />
        </xsl:copy>
    </xsl:template>

    <xsl:template match="*">
        <xsl:message terminate="yes" />
    </xsl:template>

</xsl:stylesheet>
