<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:mv="http://schemas.amsd.com/mpmu/marvel/general"
                exclude-result-prefixes="mv"
>

    <xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes" />
    <xsl:strip-space elements="*" />

    <xsl:param name="platformType" select="'8P System'" />


    <xsl:template match="/">
        <xsl:choose>
            <xsl:when test="$platformType = '2P System'">
                <xsl:apply-templates select="@*|*" />
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates select="@*|*" mode="copyOnly" />
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="mv:*">
        <xsl:variable name="elementName">
            <xsl:choose>
                <xsl:when test="starts-with (local-name (), 'SystemBox') and
                                (string-length (substring-before (local-name (), 'Ref')) + 3 =
                                 string-length (local-name ()))
                               ">
                    <xsl:value-of select="concat ('ComboBox', substring-after (local-name (), 'SystemBox'))" />
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="local-name ()" />
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:element name="{$elementName}" namespace="http://schemas.amsd.com/mpmu/marvel/general">
            <xsl:apply-templates select="@*|*" />
        </xsl:element>
    </xsl:template>

    <xsl:template match="@*|*" mode="copyOnly">
        <xsl:copy>
            <xsl:apply-templates select="@*|*" mode="copyOnly" />
        </xsl:copy>
    </xsl:template>

    <xsl:template match="@*|*">
        <xsl:copy>
            <xsl:apply-templates select="@*|*" />
        </xsl:copy>
    </xsl:template>

</xsl:stylesheet>
