<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:mv="http://schemas.amsd.com/mpmu/marvel/general"
                xmlns:smll="http://schemas.amsd.com/mpmu/smlan/logical"
                xmlns:mi="http://schemas.amsd.com/mpmu/server/meta"
                exclude-result-prefixes="mv smll mi"
>

    <xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes" />
    <xsl:strip-space elements="*" />

    <xsl:variable name="defaultPlatformType" select="'8P System'" />
    <xsl:param name="platformType" select="$defaultPlatformType" />

    <xsl:key name="connection" match="mv:FirstEndRef|mv:SecondEndRef" use="concat (@x, ':', @y)" />
    <xsl:template match="smll:GetIPConnections">
        <xsl:element name="LogicalCPUs" namespace="{namespace-uri (smll:Output/mv:IPConnections)}">
            <xsl:variable name="connections" select="smll:Output/mv:IPConnections/mv:IPConnection" />
            <xsl:for-each select="$connections/*[not (key ('connection', concat (@x, ':', @y))[2]) or
                                                 not ((. | key ('connection', concat (@x, ':', @y))[1])[2])
                                                ]">
                <xsl:sort select="concat (@x, ':', @y)" order="ascending" />

                <xsl:if test="$platformType = $defaultPlatformType or @x = 0">
                    <xsl:element name="LogicalCPU" namespace="{namespace-uri (.)}">
                        <xsl:attribute name="x" namespace="">
                            <xsl:value-of select="@x" />
                        </xsl:attribute>
                        <xsl:attribute name="y" namespace="">
                            <xsl:value-of select="@y" />
                        </xsl:attribute>
                    </xsl:element>
                </xsl:if>
            </xsl:for-each>
        </xsl:element>
    </xsl:template>

    <xsl:template match="smll:*">
        <xsl:message terminate="yes" />
    </xsl:template>

</xsl:stylesheet>
