<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:mv="http://schemas.amsd.com/mpmu/marvel/general"
                xmlns:smll="http://schemas.amsd.com/mpmu/smlan/logical"
                xmlns:mi="http://schemas.amsd.com/mpmu/server/meta"
>

    <xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>
    <xsl:strip-space elements="*" />

    <xsl:variable name="IDAssignment" select="document ('MetaInfo.xml')/mi:MetaInfo/mi:IDAssignment" />

    <xsl:variable name="separator" select="'-'" />

    <!-- Templates for creating ID/IDREF -->
    <!-- "prefix"'s mode templates -->
    <xsl:template match="smll:Input" mode="prefix">
        <xsl:apply-templates select="smll:Destination/*" mode="prefix" />
    </xsl:template>

    <xsl:template match="mv:*" mode="prefix">
        <xsl:param name="refType" select="''" />
        <xsl:param name="refName" select="local-name ()" />
        <xsl:param name="platformType" select="'8P System'" />

        <!--xsl:param name="refElement" select="$IDAssignment/mi:Element[@refType=$IDAssignment/mi:RefElement[@name=$refName and @parentName=local-name (current ()/..)]/@type]|$IDAssignment/mi:Element[@refType=$IDAssignment/mi:RefElement[@name=$refName]/@type]" /-->

        <xsl:variable name="refElementName">
            <xsl:choose>
                <xsl:when test ="$refType != ''">
                    <xsl:value-of select="$refType" />
                </xsl:when>
                <xsl:otherwise>
                    <xsl:choose>
                        <xsl:when test="$IDAssignment/mi:RefElement[@name=$refName and @parentName=local-name (current ()/..) and @platformType=$platformType]">
                            <xsl:value-of select="$IDAssignment/mi:RefElement[@name=$refName and @parentName=local-name (current ()/..) and @platformType=$platformType]/@type" />
                        </xsl:when>
                        <xsl:when test="$IDAssignment/mi:RefElement[@name=$refName and @parentName=local-name (current ()/..)]">
                            <xsl:value-of select="$IDAssignment/mi:RefElement[@name=$refName and @parentName=local-name (current ()/..)]/@type" />
                        </xsl:when>
                        <xsl:when test="$IDAssignment/mi:RefElement[@name=$refName and @platformType=$platformType]">
                            <xsl:value-of select="$IDAssignment/mi:RefElement[@name=$refName and @platformType=$platformType]/@type" />
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="$IDAssignment/mi:RefElement[@name=$refName]/@type" />
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>

<!--
        <xsl:variable name="refElementName">
            <xsl:choose>
                <xsl:when test="$IDAssignment/mi:RefElement[@name=$refName and @parentName=local-name (current ()/..)]">
                    <xsl:value-of select="$IDAssignment/mi:RefElement[@name=$refName and @parentName=local-name (current ()/..)]/@type" />
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="$IDAssignment/mi:RefElement[@name=$refName]/@type" />
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>

-->

        <xsl:variable name="refElement" select="$IDAssignment/mi:Element[@refType=$refElementName]" />

<!--
        <xsl:message>
            <xsl:value-of select="concat ('  parentName - ', $IDAssignment/mi:RefElement[@name=$refName]/@parentName)" />
            <xsl:value-of select="concat (', local-name (current ()/..) - ', local-name (current ()/..))" />
            <xsl:value-of select="concat (', choose 1 - ', $IDAssignment/mi:RefElement[@name=$refName and @parentName=local-name (current ()/..)]/@type)" />
            <xsl:value-of select="concat (', choose 2 - ', $IDAssignment/mi:RefElement[@name=$refName]/@type)" />
            <xsl:value-of select="concat (', choose - ', $IDAssignment/mi:RefElement[@name=$refName and @parentName=local-name (current ()/..)]/@type |
                                                         $IDAssignment/mi:RefElement[@name=$refName]/@type)" />
            <xsl:value-of select="concat (', refElementName - ', $refElementName)" />
            <xsl:value-of select="concat (', refElement - ', $refElement)" />
        </xsl:message>
-->

        <xsl:variable name="idPrefix">
            <xsl:choose>
                <xsl:when test ="$refElement/@idPrefix">
                    <xsl:value-of select="$refElement/@idPrefix" />
                </xsl:when>
                <xsl:when test ="$refElement/@idAdditionalPrefix">
                    <xsl:message terminate="yes">
                        <xsl:value-of select="'idAdditionalPrefix processing not implemented yet.'" />
                    </xsl:message>
                    <!--xsl:value-of select="concat ($parentPrefix, $element/@idAdditionalPrefix)" /-->
                </xsl:when>
                <xsl:otherwise>
                    <xsl:message terminate="yes" />
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:value-of select="$idPrefix" />
    </xsl:template>

    <!-- "createIDREF"'s mode templates -->
    <xsl:template match="smll:Input" mode="createID.IDREF">
        <xsl:apply-templates select="smll:Destination/*" mode="createID.IDREF" />
    </xsl:template>

    <xsl:template match="mv:*" name="Ref2ID" mode="createID.IDREF">
        <xsl:param name="refName" select="local-name ()" />
        <xsl:param name="platformType" select="'8P System'" />
<!--
        <xsl:message>
            <xsl:value-of select="concat ('  createID.IDREF', '')" />
            <xsl:value-of select="concat (', local-name() - ', local-name ())" />
            <xsl:value-of select="concat (', refName - ', $refName)" />
            <xsl:value-of select="concat (', platformType - ', $platformType)" />
        </xsl:message>
-->
        <!--xsl:variable name="refElement" select="$IDAssignment/mi:Element[@refType=$IDAssignment/mi:RefElement[@name=$refName and @parentName=local-name (current ()/..)]/@type]|$IDAssignment/mi:Element[@refType=$IDAssignment/mi:RefElement[@name=$refName]/@type]" /-->

        <xsl:variable name="refElementName">
            <xsl:choose>
                <xsl:when test="$IDAssignment/mi:RefElement[@name=$refName and @parentName=local-name (current ()/..) and @platformType=$platformType]">
                    <xsl:value-of select="$IDAssignment/mi:RefElement[@name=$refName and @parentName=local-name (current ()/..) and @platformType=$platformType]/@type" />
                </xsl:when>
                <xsl:when test="$IDAssignment/mi:RefElement[@name=$refName and @parentName=local-name (current ()/..)]">
                    <xsl:value-of select="$IDAssignment/mi:RefElement[@name=$refName and @parentName=local-name (current ()/..)]/@type" />
                </xsl:when>
                <xsl:when test="$IDAssignment/mi:RefElement[@name=$refName and @platformType=$platformType]">
                    <xsl:value-of select="$IDAssignment/mi:RefElement[@name=$refName and @platformType=$platformType]/@type" />
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="$IDAssignment/mi:RefElement[@name=$refName]/@type" />
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>

        <xsl:variable name="refElement" select="$IDAssignment/mi:Element[@refType=$refElementName]" />

<!--
        <xsl:message>
            <xsl:value-of select="concat ('  parentName - ', $IDAssignment/mi:RefElement[@name=$refName]/@parentName)" />
            <xsl:value-of select="concat (', local-name (current ()/..) - ', local-name (current ()/..))" />
        </xsl:message>

        <xsl:message>
            <xsl:value-of select="concat ('  refType - ', $refElementName)" />
            <xsl:value-of select="concat (', refElementName - ', $refElement/@name)" />
        </xsl:message>
-->

        <xsl:apply-templates select="." mode="prefix">
            <xsl:with-param name="refType" select="$refElementName" />
        </xsl:apply-templates>

        <xsl:value-of select="$separator" />

        <xsl:call-template name="Ref2ID0">
            <xsl:with-param name="castTo" select="$refElement/@refType" />
        </xsl:call-template>
    </xsl:template>

    <!-- "convert"'s mode templates -->
    <xsl:template match="smll:Input" mode="convert">
        <xsl:apply-templates select="smll:Destination/*" mode="convert" />
    </xsl:template>

    <xsl:template match="mv:MarvelRef" name="AsMarvelRef" mode="convert">
        <xsl:value-of select="substring-after (@marvelId, $separator)" />
    </xsl:template>

    <xsl:template match="mv:*" name="Ref2ID0" mode="convert">
        <xsl:param name="castTo" select="local-name ()" />
        <xsl:variable name="refElement" select="$IDAssignment/mi:Element[@refType=$castTo]" />
        <xsl:variable name="parent" select="$IDAssignment/mi:Element[@refType=$refElement/@parentType]" />

        <xsl:choose>
            <xsl:when test="not ($parent)">
                <xsl:call-template name="AsMarvelRef" />
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="Ref2ID0">
                    <xsl:with-param name="castTo" select="$parent/@refType" />
                </xsl:call-template>

                <xsl:choose>
                    <xsl:when test="$refElement/@localId">
                        <xsl:value-of select="concat ($separator, @*[local-name ()=$refElement/@localIdInRef])" />
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:variable name="current" select="." />
                        <xsl:for-each select="$refElement/mi:LocalIdInRef">
                            <xsl:value-of select="concat ($separator, $current/@*[local-name ()=current ()/@name])" />
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <!-- TODO: Cabling state of Marvel don't support FillInID by general template -->
<!--
    <xsl:template match="mv:IPCable">
        <xsl:param name="parentId" />

        <xsl:variable name="firstEndRef">
            <xsl:for-each select="mv:FirstEndRef">
                <xsl:call-template name="AsBoxRef" />
            </xsl:for-each>
        </xsl:variable>
        <xsl:variable name="secondEndRef">
            <xsl:for-each select="mv:SecondEndRef">
                <xsl:call-template name="AsBoxRef" />
            </xsl:for-each>
        </xsl:variable>

        <xsl:call-template name="Process">
            <xsl:with-param name="prefix" select="'IPC'" />
            <xsl:with-param name="parentId" select="$parentId" />
            <xsl:with-param name="localId" select="concat ($firstEndRef, $separator, mv:FirstEndRef/@portDirection, $separator, $secondEndRef, $separator, mv:SecondEndRef/@portDirection)" />
        </xsl:call-template>
    </xsl:template>

    <xsl:template match="mv:IOCable">
        <xsl:param name="parentId" />

        <xsl:variable name="ioRiserEndRef">
            <xsl:for-each select="mv:IORiserEndRef">
                <xsl:call-template name="AsIORiserRef" />
            </xsl:for-each>
        </xsl:variable>
        <xsl:variable name="cpuEndRef">
            <xsl:for-each select="mv:CPUEndRef">
                <xsl:call-template name="AsCPURef" />
            </xsl:for-each>
        </xsl:variable>

        <xsl:call-template name="Process">
            <xsl:with-param name="prefix" select="'IOC'" />
            <xsl:with-param name="parentId" select="$parentId" />
            <xsl:with-param name="localId" select="concat ($ioRiserEndRef, $separator, $cpuEndRef)" />
        </xsl:call-template>
    </xsl:template>


    <xsl:template match="mv:*">
        <xsl:param name="parentId"/>
        <xsl:param name="elementName" select="local-name ()" />
        <xsl:variable name="element" select="$IDAssignment/Element[@name=$elementName]" />

        <xsl:call-template name="Process">
            <xsl:with-param name="prefix" select="$element/@idPrefix" />
            <xsl:with-param name="parentId" select="$parentId" />
            <xsl:with-param name="localId">
                <xsl:choose>
                    <xsl:when test="$element/@localId">
                        <xsl:value-of select="concat ($separator, @*[local-name ()=$element/@localId])" />
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:variable name="current" select="." />
                        <xsl:for-each select="$element/localId">
                            <xsl:value-of select="concat ($separator, $current/@*[local-name ()=current ()/@name])" />
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:with-param>
        </xsl:call-template>
    </xsl:template>
-->
</xsl:stylesheet>
