<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:mv="http://schemas.amsd.com/mpmu/marvel/general"
                xmlns:smll="http://schemas.amsd.com/mpmu/smlan/logical"
                xmlns:mi="http://schemas.amsd.com/mpmu/server/meta"
                exclude-result-prefixes="mv smll mi"
>

    <xsl:output method="xml" indent="yes" version="1.0" encoding="UTF-8" />
    <xsl:strip-space elements="*" />

    <xsl:variable name="urnPrefix" select="'urn:amsd.com:mpmu:server:'" />
    <xsl:variable name="configurationURI" select="concat ($urnPrefix, 'configuration')" />

    <xsl:param name="MergeWithoutConfiguration" select="'false'" />

    <xsl:param name="marvelId" select="/smll:*/smll:Input/smll:Destination/mv:*/@marvelId" /> 
    <xsl:variable name="marvelConfiguration" select="document ($configurationURI)/mv:Marvels/mv:Marvel[@id = $marvelId]" /> 

    <!-- Merge Physical configuration -->
    <xsl:template match="/smll:GetTopology">
        <xsl:copy>
            <xsl:choose>
                <xsl:when test="not ($MergeWithoutConfiguration='true')">
                    <xsl:apply-templates select="@*|*" />
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates select="@*|*" mode="MergeWithoutConfiguration" />
                </xsl:otherwise>
            </xsl:choose>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="mv:Racks">
        <xsl:copy>
            <xsl:apply-templates select="@*|*" />

            <xsl:variable name="sourceDocument" select="/" />
            <xsl:variable name="sourceRacks" select="." />
            <xsl:for-each select="$marvelConfiguration/mv:Racks/mv:Rack">
                <xsl:if test="not ($sourceRacks/mv:Rack[@number=current ()/@number])">
                    <xsl:apply-templates select="." mode="additional" />
                </xsl:if>
            </xsl:for-each>
        </xsl:copy>
    </xsl:template>

    <xsl:template name="BoxSize">
        <xsl:param name="boxName" select="local-name ()" />

        <xsl:value-of select="document ('MetaInfo.xml')/mi:MetaInfo/mi:PhysicalDimensions/mi:Box[@name = $boxName]/@size" />
    </xsl:template>

    <xsl:template name="CalculateBoxPosition">
        <xsl:param name="index" select="1" />
        <xsl:param name="position" select="0" />

        <xsl:choose>
            <xsl:when test="not ($index=position ())">
                <xsl:variable name="boxSize">
                    <xsl:call-template name="BoxSize">
                        <xsl:with-param name="boxName" select="local-name (../*[$index])" />
                    </xsl:call-template>
                </xsl:variable>
                <xsl:call-template name="CalculateBoxPosition">
                    <xsl:with-param name="index" select="$index + 1" />
                    <xsl:with-param name="position" select="$position + $boxSize" />
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$position" />
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="mv:Rack" mode="MergeWithoutConfiguration">
        <xsl:copy>
            <xsl:apply-templates select="@*" mode="MergeWithoutConfiguration" />

            <xsl:attribute name="position">
                <xsl:value-of select="@number" />
            </xsl:attribute>

            <xsl:attribute name="row">
                <xsl:value-of select="number ('0')" />
            </xsl:attribute>

            <xsl:for-each select="*">
                <xsl:copy>
                    <xsl:apply-templates select="@*" mode="MergeWithoutConfiguration" />

                    <xsl:attribute name="position">
                        <xsl:call-template name="CalculateBoxPosition" />
                    </xsl:attribute>

                    <xsl:attribute name="size">
                        <xsl:call-template name="BoxSize" />
                    </xsl:attribute>

                    <xsl:apply-templates select="*" mode="MergeWithoutConfiguration" />
                </xsl:copy>
            </xsl:for-each>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="mv:Rack">
        <xsl:choose>
            <xsl:when test="(@number = 0) and boolean ($marvelConfiguration/mv:Racks/mv:Rack[@number=0][2])">
                <xsl:apply-templates select="." mode="doubleZero" />
            </xsl:when>
            <xsl:otherwise>
                <xsl:variable name="rackNumber" select="@number" />
                <xsl:variable name="rackConfiguration" select="$marvelConfiguration/mv:Racks/mv:Rack[@number=$rackNumber]" />
                <xsl:choose>
                    <xsl:when test="$rackConfiguration">
                        <xsl:copy>
                            <xsl:apply-templates select="@*" />

                            <xsl:variable name="rackPosition" select="$rackConfiguration/@position" />
                            <xsl:if test="not (@position)">
                                <xsl:attribute name="position"><xsl:value-of select="$rackPosition" /></xsl:attribute>
                            </xsl:if>
                            <xsl:variable name="rackRow" select="$rackConfiguration/@row" />
                            <xsl:if test="not (@row)">
                                <xsl:attribute name="row"><xsl:value-of select="$rackRow" /></xsl:attribute>
                            </xsl:if>

                            <xsl:if test="/smll:GetTopology">
                                <xsl:apply-templates select="$rackConfiguration/*" mode="additional" />
                            </xsl:if>

                            <xsl:apply-templates select="*" />
                        </xsl:copy>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:message>Invalid Configuration</xsl:message>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="mv:Rack" mode="doubleZero">
        <xsl:variable name="rackNumber" select="@number" />
        <xsl:if test="$rackNumber != 0">
            <xsl:message>Invalid Configuration</xsl:message>
        </xsl:if>

        <xsl:variable name="sourceRack" select="." />
        <xsl:variable name="source" select="/" />
        <xsl:for-each select="$marvelConfiguration/mv:Racks/mv:Rack[@number=$rackNumber]">
            <xsl:copy>
                <xsl:apply-templates select="$sourceRack/@*" />

                <xsl:variable name="rackPosition" select="@position" />
                <xsl:attribute name="position"><xsl:value-of select="$rackPosition" /></xsl:attribute>

                <xsl:variable name="rackRow" select="@row" />
                <xsl:if test="not ($sourceRack/@row)">
                    <xsl:attribute name="row"><xsl:value-of select="$rackRow" /></xsl:attribute>
                </xsl:if>

                <xsl:variable name="secondZeroRack" select="@secondZeroRack" />
                <xsl:if test="$secondZeroRack">
                    <xsl:attribute name="secondZeroRack"><xsl:value-of select="$secondZeroRack" /></xsl:attribute>
                </xsl:if>

                <xsl:if test="$source/smll:GetTopology">
                    <xsl:apply-templates select="*" mode="additional" />
                </xsl:if>

                <xsl:apply-templates select="$sourceRack/*" mode="doubleZero">
                    <xsl:with-param name="rackConfiguration" select="." />
                </xsl:apply-templates>
            </xsl:copy>
        </xsl:for-each>
    </xsl:template>

    <xsl:template match="mv:SystemBox|mv:IOBox|mv:ComboBox|mv:PowerSupplySubRack">
        <xsl:variable name="rackNumber" select="../@number" />
        <xsl:variable name="boxName" select="local-name()" />
        <xsl:variable name="boxNumber" select="@number" />
        <xsl:variable name="box" select="$marvelConfiguration/mv:Racks/mv:Rack[@number=$rackNumber]/*[local-name () = $boxName and @number=$boxNumber]" />

        <xsl:choose>
            <xsl:when test="$box">
                <xsl:copy>
                    <xsl:apply-templates select="@*" />

                    <xsl:for-each select="$box/@*[local-name () != 'number']">
                        <xsl:attribute name="{local-name ()}">
                            <xsl:value-of select="string ()" />
                        </xsl:attribute>
                    </xsl:for-each>

                    <xsl:apply-templates select="*" />
                </xsl:copy>
            </xsl:when>
            <xsl:otherwise>
                <xsl:message>Invalid Configuration</xsl:message>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="mv:SystemBox|mv:IOBox|mv:ComboBox|mv:PowerSupplySubRack" mode="doubleZero">
        <xsl:param name="rackConfiguration" select="$marvelConfiguration/mv:Racks/mv:Rack[@number=current ()/../@number]" />

        <xsl:variable name="rackNumber" select="../@number" />
        <xsl:if test="$rackNumber != 0">
            <xsl:message>Invalid Configuration</xsl:message>
        </xsl:if>

        <xsl:variable name="boxName" select="local-name()" />
        <xsl:variable name="boxNumber" select="@number" />
        <xsl:variable name="box" select="$rackConfiguration/*[local-name () = $boxName and @number=$boxNumber]" />

        <xsl:choose>
            <xsl:when test="$box">
                <xsl:copy>
                    <xsl:apply-templates select="@*" />

                    <xsl:for-each select="$box/@*[local-name () != 'number']">
                        <xsl:attribute name="{local-name ()}">
                            <xsl:value-of select="string ()" />
                        </xsl:attribute>
                    </xsl:for-each>

                    <xsl:apply-templates select="*" />
                </xsl:copy>
            </xsl:when>
            <xsl:otherwise>
                <xsl:if test="not ($marvelConfiguration/mv:Racks/mv:Rack[@number=current ()/../@number]/*[local-name () = $boxName and @number=$boxNumber])">
                    <xsl:message>Invalid Configuration</xsl:message>
                </xsl:if>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="mv:Rack|mv:HubShelf|mv:StorageShelf|mv:PowerShelf" mode="additional">
        <xsl:copy>
            <xsl:apply-templates select="@*" />
            <xsl:apply-templates select="*" mode="additional" />
        </xsl:copy>
    </xsl:template>

    <xsl:template match="@*|*" mode="additional" />

    <!-- Merge Logical configuration -->

    <xsl:template match="mv:LogicalCPUs" >
        <xsl:copy>
            <xsl:apply-templates select="@*|*" />

            <xsl:variable name="sourceDocument" select="/" />
            <xsl:variable name="sourceCPUs" select="." />
            <xsl:for-each select="$marvelConfiguration/mv:LogicalCPUs/mv:LogicalCPU">
                <xsl:if test="not ($sourceCPUs/mv:LogicalCPU[(@x = current ()/@x) and (@y = current ()/@y)])">
                    <xsl:apply-templates select="." />
                </xsl:if>
            </xsl:for-each>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="@*|*" mode="MergeWithoutConfiguration">
        <xsl:copy>
            <xsl:apply-templates select="@*|*" mode="MergeWithoutConfiguration" />
        </xsl:copy>
    </xsl:template>

    <xsl:template match="@*|*">
        <xsl:copy>
            <xsl:apply-templates select="@*|*" />
        </xsl:copy>
    </xsl:template>
</xsl:stylesheet>
