<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:mv="http://schemas.amsd.com/mpmu/marvel/general"
                xmlns:smll="http://schemas.amsd.com/mpmu/smlan/logical"
                xmlns:mi="http://schemas.amsd.com/mpmu/server/meta"
                xmlns:er="http://schemas.amsd.com/mpmu/server/events-reaction"
                exclude-result-prefixes="mv smll mi er"
>

    <xsl:import href="FillInID.xslt" />

    <xsl:output method="xml" indent="yes" version="1.0" encoding="UTF-8" omit-xml-declaration="yes" />
    <xsl:strip-space elements="*" />

    <xsl:include href="IDKnowledge.xslt" />

    <!--xsl:variable name="separator" select="'-'" /-->

    <xsl:template match="mv:*" mode="FillInIDInUpdate">
        <xsl:param name="parentId" />
<!--
        <xsl:message>
            <xsl:value-of select="concat ('  element = ', local-name ())" />
            <xsl:value-of select="concat (', parentId = ', $parentId)" />
        </xsl:message>
-->

<!--
        <xsl:apply-templates select=".">
            <xsl:with-param name="parentId" select="$parentId"/>
        </xsl:apply-templates>
-->
        <xsl:call-template name="FillInIDElement">
            <xsl:with-param name="parentId" select="$parentId"/>
        </xsl:call-template>
    </xsl:template>

    <xsl:template match="*|@*" mode="FillInIDInUpdate">
        <!--xsl:param name="parentId" /-->

        <xsl:copy>
            <xsl:apply-templates select="*|@*" mode="FillInIDInUpdate">
                <xsl:with-param name="parentId" select="substring-after (@parentElementID, $separator)"/>
            </xsl:apply-templates>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="/">
<!--
        <xsl:message>
            <xsl:value-of select="concat ('  UpdateCreator', '')" />
            <xsl:value-of select="concat (', name - ', local-name (/*))" />
        </xsl:message>
-->

        <xsl:element name="Update" namespace="http://schemas.amsd.com/mpmu/data/update">
            <xsl:choose>
                <xsl:when test="*/smll:Updates">
                    <xsl:apply-templates select="*/smll:Updates/*" mode="FillInIDInUpdate" />
                </xsl:when>
                <xsl:when test="*/smll:Output/*">
                    <xsl:apply-templates select="*/smll:Output/*" />
                </xsl:when>
                <xsl:when test="*/smll:Output">
                    <xsl:apply-templates select="*/smll:Output" />
                </xsl:when>
                <xsl:when test="mv:Events">
                    <xsl:for-each select="mv:Events/mv:Event">
<!--
                        <xsl:message>
                            <xsl:value-of select="concat ('  name - ', local-name ())" />
                            <xsl:value-of select="concat (', id - ', @id)" />
                        </xsl:message>
-->
                        <xsl:if test="not (document ('EventsReaction.xml')/er:Events/er:Event[@type = current ()/@type]/@suppressUpdate = 'true')">
                            <xsl:call-template name="updateSelf">
                                <xsl:with-param name="parentElementID" select="../@id" />
                            </xsl:call-template>
                        </xsl:if>
                    </xsl:for-each>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:message terminate="yes" />
                </xsl:otherwise>
            </xsl:choose>
        </xsl:element>
    </xsl:template>

    <xsl:template name="updateSelf">
        <xsl:param name="category">
            <xsl:apply-templates select="." mode="category" />
        </xsl:param>
        <xsl:param name="rootElementName" select="local-name()" />
        <xsl:param name="rootElementNamespace" select="namespace-uri ()" />
        <xsl:param name="rootElementNameID" select="''" />
        <xsl:param name="parentElementID">
            <xsl:apply-templates select="../../smll:Input" mode="createIDREF" />
        </xsl:param>

<!--
        <xsl:message>
            <xsl:value-of select="concat ('  updateSelf', '')" />
            <xsl:value-of select="concat (', rootElementName = ', $rootElementName)" />
            <xsl:value-of select="concat (', rootElementNameID = ', $rootElementNameID)" />
            <xsl:value-of select="concat (', parentElementID = ', $parentElementID)" />
        </xsl:message>
-->

        <xsl:element name="ElementUpdate" namespace="http://schemas.amsd.com/mpmu/data/update">
            <xsl:attribute name="category">
                <xsl:value-of select="$category" />
            </xsl:attribute>
            <xsl:attribute name="parentElementID">
                <xsl:value-of select="$parentElementID" />
            </xsl:attribute>

            <xsl:call-template name="setUpdateMode">
                <xsl:with-param name="actionName" select="local-name (/*)" />
            </xsl:call-template>

            <xsl:element name="{$rootElementName}" namespace="{$rootElementNamespace}">
                <xsl:if test="$rootElementNameID != ''">
                    <xsl:attribute name="id">
                        <xsl:value-of select="$rootElementNameID" />
                    </xsl:attribute>
                </xsl:if>
                <xsl:apply-templates select="@*|*" mode="copyOnly" />
            </xsl:element>
<!--
            <xsl:copy>
                <xsl:apply-templates select="@*|*" mode="copyOnly" />
            </xsl:copy>
-->
        </xsl:element>

        <xsl:apply-templates select="." mode="additionalUpdates">
            <xsl:with-param name="category" select="$category" />
            <xsl:with-param name="parentElementID" select="$parentElementID" />
        </xsl:apply-templates>
    </xsl:template>

    <xsl:template name="updateContents">
        <xsl:param name="category">
            <xsl:apply-templates select="." mode="category" />
        </xsl:param>
        <xsl:param name="rootElementName" select="local-name()" />
        <xsl:param name="rootElementNamespace" select="namespace-uri ()" />
        <xsl:param name="rootElementNameID" select="''" />
        <xsl:param name="selfElementID">
            <xsl:apply-templates select="../../smll:Input" mode="createIDREF" />
        </xsl:param>

<!--
        <xsl:message>
            <xsl:value-of select="concat ('  updateContents', '')" />
            <xsl:value-of select="concat (', rootElementName = ', $rootElementName)" />
            <xsl:value-of select="concat (', rootElementNameID = ', $rootElementNameID)" />
            <xsl:value-of select="concat (', selfElementID = ', $selfElementID)" />
        </xsl:message>
-->

        <xsl:for-each select="@*[local-name () != 'id' and local-name () != 'number']">
            <xsl:element name="AttributeUpdate" namespace="http://schemas.amsd.com/mpmu/data/update">
                <xsl:attribute name="category">
                    <xsl:value-of select="$category" />
                </xsl:attribute>
                <xsl:attribute name="parentElementID">
                    <xsl:value-of select="$selfElementID" />
                </xsl:attribute>
                <xsl:attribute name="name">
                    <xsl:value-of select="local-name ()" />
                </xsl:attribute>
                <xsl:attribute name="value">
                    <xsl:value-of select="string ()" />
                </xsl:attribute>
            </xsl:element>
        </xsl:for-each>
        <xsl:for-each select="*">
            <xsl:element name="ElementUpdate" namespace="http://schemas.amsd.com/mpmu/data/update">
                <xsl:attribute name="category">
                    <xsl:value-of select="$category" />
                </xsl:attribute>
                <xsl:attribute name="parentElementID">
                    <xsl:value-of select="$selfElementID" />
                </xsl:attribute>

                <xsl:call-template name="setUpdateMode">
                    <xsl:with-param name="actionName" select="local-name (/*)" />
                </xsl:call-template>

                <xsl:element name="{$rootElementName}" namespace="{$rootElementNamespace}">
                    <xsl:if test="$rootElementNameID != ''">
                        <xsl:attribute name="id">
                            <xsl:value-of select="$rootElementNameID" />
                        </xsl:attribute>
                    </xsl:if>
                    <xsl:apply-templates select="@*|*" mode="copyOnly" />
                </xsl:element>
<!--
                <xsl:copy>
                    <xsl:apply-templates select="@*|*" mode="copyOnly" />
                </xsl:copy>
-->
            </xsl:element>
        </xsl:for-each>

        <xsl:apply-templates select="." mode="additionalUpdates">
            <xsl:with-param name="category" select="$category" />
            <xsl:with-param name="parentElementID" select="$selfElementID" />
        </xsl:apply-templates>
    </xsl:template>


    <xsl:template name="updateAttribute">
        <xsl:param name="category">
            <xsl:apply-templates select=".." mode="category" />
        </xsl:param>
        <xsl:param name="parentElementID">
            <xsl:apply-templates select="../../../smll:Input" mode="createIDREF" />
        </xsl:param>

<!--
        <xsl:message>
            <xsl:value-of select="concat ('  updateAttribute', '')" />
            <xsl:value-of select="concat (', parentElementID = ', $parentElementID)" />
        </xsl:message>
-->

        <xsl:element name="AttributeUpdate" namespace="http://schemas.amsd.com/mpmu/data/update">
            <xsl:attribute name="category">
                <xsl:value-of select="$category" />
            </xsl:attribute>
            <xsl:attribute name="parentElementID">
                <xsl:value-of select="$parentElementID" />
            </xsl:attribute>
            <xsl:attribute name="name">
                <xsl:value-of select="local-name ()" />
            </xsl:attribute>
            <xsl:attribute name="value">
                <xsl:value-of select="string ()" />
            </xsl:attribute>
        </xsl:element>
    </xsl:template>

    <xsl:template match="/*/smll:Output/*">
        <xsl:call-template name="updateSelf" />
    </xsl:template>

    <xsl:template match="/*/smll:Output/*" mode="additionalUpdates" />

    <!--xsl:template match="/smll:GetSystemBoxConfiguration/smll:Output/mv:SystemBox|/smll:GetIOBoxConfiguration/smll:Output/mv:IOBox">
        <xsl:call-template name="updateContents" />
    </xsl:template-->

    <xsl:template match="/smll:GetSystemPowerSupplies/smll:Output/mv:Rack">
        <xsl:variable name="category">
            <xsl:apply-templates select="." mode="category" />
        </xsl:variable>

        <xsl:for-each select="*">
            <xsl:call-template name="updateSelf">
                <xsl:with-param name="category" select="$category" />
                <xsl:with-param name="parentElementID" select="../@id" />
            </xsl:call-template>
        </xsl:for-each>
    </xsl:template>

    <xsl:template match="/smll:GetSystemPowerSupplies/smll:Output" />

    <xsl:template match="/smll:GetSystemPowerInterfaces/smll:Output/mv:Rack">
        <xsl:variable name="category">
            <xsl:apply-templates select="." mode="category" />
        </xsl:variable>

        <xsl:for-each select="*/*">
            <xsl:call-template name="updateSelf">
                <xsl:with-param name="category" select="$category" />
                <xsl:with-param name="parentElementID" select="../@id" />
            </xsl:call-template>
        </xsl:for-each>
    </xsl:template>

    <xsl:template match="/smll:GetInternalPowerSupplies/smll:Output/mv:PowerSupply">
        <xsl:if test="position () = 1">
             <xsl:apply-templates select=".." />
        </xsl:if>
    </xsl:template>

    <xsl:template match="/smll:GetInternalPowerSupplies/smll:Output">
        <xsl:call-template name="updateSelf">
            <xsl:with-param name="category" select="'physical'" />
            <xsl:with-param name="rootElementName" select="substring-before (local-name (../smll:Input/smll:Destination/*), 'Ref')" />
            <xsl:with-param name="rootElementNamespace" select="'http://schemas.amsd.com/mpmu/marvel/general'" />
            <xsl:with-param name="rootElementNameID">
                <xsl:apply-templates select="../smll:Input" mode="createIDREF" />
            </xsl:with-param>
            <xsl:with-param name="parentElementID">
                <xsl:apply-templates select="../smll:Input" mode="createIDREF">
                    <xsl:with-param name="refName" select="'RackRef'" />
                </xsl:apply-templates>
            </xsl:with-param>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template match="/smll:GetPMUAgentAddress/smll:Output/mv:Marvel |
                         /smll:GetAlertSupport/smll:Output/mv:Marvel">
        <xsl:variable name="category">
            <xsl:apply-templates select="." mode="category" />
        </xsl:variable>

        <xsl:for-each select="@*[local-name () != 'marvelId']">
            <xsl:call-template name="updateAttribute">
                <xsl:with-param name="category" select="$category" />
                <xsl:with-param name="parentElementID" select="/smll:*/smll:Input/smll:Destination/mv:*/@marvelId" />
            </xsl:call-template>
        </xsl:for-each>
    </xsl:template>

    <xsl:template match="/smll:GetPartitioning/smll:Output/mv:LogicalCPUs" mode="additionalUpdates">
        <xsl:param name="category" />

        <xsl:for-each select="mv:LogicalCPU[@connectedIORiserRef]">
            <xsl:element name="AttributeUpdate" namespace="http://schemas.amsd.com/mpmu/data/update">
                <xsl:attribute name="category">
                    <xsl:value-of select="$category" />
                </xsl:attribute>
                <xsl:attribute name="parentElementID">
                    <xsl:value-of select="@connectedIORiserRef" />
                </xsl:attribute>
                <xsl:attribute name="name">
                    <xsl:value-of select="'connectedLogicalCPURef'" />
                </xsl:attribute>
                <xsl:attribute name="value">
                    <xsl:value-of select="@id" />
                </xsl:attribute>
            </xsl:element>
        </xsl:for-each>
    </xsl:template>

    <xsl:template match="mv:*|smll:LogFragment" mode="category">
        <xsl:variable name="category" select="document ('MetaInfo.xml')/mi:MetaInfo/mi:Categories/mi:Category/mi:ResponseRootElement[@name = local-name (current ())]/../@name" />
        <xsl:value-of select="$category" />
    </xsl:template>

    <xsl:template match="smll:Input" mode="createIDREF">
        <xsl:param name="refName" select="''" />

        <xsl:choose>
            <xsl:when test="$refName != ''">
                <xsl:apply-templates select="smll:Destination/*" mode="createID.IDREF">
                    <xsl:with-param name="refName" select="$refName" />
                </xsl:apply-templates>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates select="smll:Destination/*" mode="createID.IDREF" />
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="/smll:GetSystemBoxConfiguration/smll:Input|
                         /smll:GetIOBoxConfiguration/smll:Input|
                         /smll:GetComboBoxConfiguration/smll:Input
                        " mode="createIDREF">
        <xsl:apply-templates select="smll:Destination/*" mode="createID.IDREF">
            <xsl:with-param name="refName" select="'RackRef'" />
        </xsl:apply-templates>
    </xsl:template>

    <xsl:template match="/smll:GetLog/smll:Input" mode="createIDREF">
        <xsl:apply-templates select="smll:Destination/*" mode="createID.IDREF">
            <xsl:with-param name="refName" select="'LogsRef'" />
        </xsl:apply-templates>
    </xsl:template>

    <xsl:template match="/smll:GetSwitch/smll:Input" mode="createIDREF">
        <xsl:apply-templates select="smll:Destination/*" mode="createID.IDREF">
            <xsl:with-param name="refName" select="'RacksRef'" />
        </xsl:apply-templates>
    </xsl:template>

    <xsl:template name="setUpdateMode">
        <xsl:param name="actionName" />

        <xsl:variable name="updateMode" select="document ('UpdateCreator.xml')/UpdateInfo/UpdatePacket[@action = $actionName]/@mode" />
        <xsl:variable name="nonMergeableNodes" select="document ('UpdateCreator.xml')/UpdateInfo/UpdatePacket[@action = $actionName]/@nonMergeableNodes" />

        <xsl:if test="$updateMode">
            <xsl:attribute name="mode">
                <xsl:value-of select="$updateMode" />
            </xsl:attribute>
            <xsl:if test="$updateMode='merge' and $nonMergeableNodes">
                <xsl:attribute name="nonMergeableNodes">
                    <xsl:value-of select="$nonMergeableNodes" />
                </xsl:attribute>
            </xsl:if>
        </xsl:if>
    </xsl:template>

    <xsl:template match="@*|*" mode="copyOnly">
        <xsl:copy>
            <xsl:apply-templates select="@*|*" mode="copyOnly" />
        </xsl:copy>
    </xsl:template>
    
    <xsl:template match="@*|*" name="copyTemplate">
        <xsl:copy>
            <xsl:apply-templates select="@*|*" />
        </xsl:copy>
    </xsl:template>

    <!--xsl:template match="*|@*|text()|comment()|processing-instruction()" mode="*" /-->

</xsl:stylesheet>
