#!/usr/bin/sh
# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: button.tcl,v $
# Revision 1.1.1.1  2003/01/22 17:48:58  ajay
# Checking in SUIT to CVS.
#
# Revision 1.1.2.5  1998/11/10  15:49:00  William_Athanasiou
# 	Stop return event from propagating to default button
# 	[1998/11/10  15:46:51  William_Athanasiou]
#
# Revision 1.1.2.4  1998/10/02  20:30:11  William_Athanasiou
# 	Add reverse video of selected button
# 	[1998/10/02  20:15:50  William_Athanasiou]
# 
# Revision 1.1.2.3  1998/02/26  21:26:50  William_Athanasiou
# 	Add keyboard traversal shortcuts
# 	[1998/02/26  21:24:30  William_Athanasiou]
# 
# Revision 1.1.2.2  1997/05/07  18:07:51  William_Athanasiou
# 	Initial version
# 	[1997/05/07  17:40:05  William_Athanasiou]
# 
# $EndLog$
# 
# @(#)$RCSfile: button.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/22 17:48:58 $
# 
# button.tcl --
#
# This file defines the default bindings for Tk label, button,
# checkbutton, and radiobutton widgets and provides procedures
# that help in implementing those bindings.
#
# @(#) $Id: button.tcl,v 1.1.1.1 2003/01/22 17:48:58 ajay Exp $
#
# Copyright (c) 1992-1994 The Regents of the University of California.
# Copyright (c) 1994 Sun Microsystems, Inc.
# Copyright (c) 1995 Cleveland Clinic Foundation
#
# See the file "license.terms" for information on usage and redistribution
# of this file, and for a DISCLAIMER OF ALL WARRANTIES.
#

#-------------------------------------------------------------------------
# The code below creates the default class bindings for buttons.
#-------------------------------------------------------------------------

bind Button <space> {
    tkButtonInvoke %W
}
bind Button <Return> {
    if !$tk_strictMotif {
	tkButtonInvoke %W
       break
    }
}
bind Button <FocusIn> {
    %W configure -reverse 1
}
bind Button <FocusOut> {
    %W configure -reverse 0
}


bind Checkbutton <space> {
    tkCheckRadioInvoke %W
}
bind Checkbutton <Return> {
    if !$tk_strictMotif {
	tkCheckRadioInvoke %W
       break
    }
}

bind Radiobutton <space> {
    tkCheckRadioInvoke %W
}
bind Radiobutton <Return> {
    if !$tk_strictMotif {
	tkCheckRadioInvoke %W
       break
    }
}

# WRA - add traversal bindings.
bind Button <Up> {focus [tk_focusPrev %W]}
bind Button <Left> {focus [tk_focusPrev %W]}
bind Button <Down> {focus [tk_focusNext %W]}
bind Button <Right> {focus [tk_focusNext %W]}

bind Checkbutton <Up> {focus [tk_focusPrev %W]}
bind Checkbutton <Left> {focus [tk_focusPrev %W]}
bind Checkbutton <Down> {focus [tk_focusNext %W]}
bind Checkbutton <Right> {focus [tk_focusNext %W]}

bind Radiobutton <Up> {focus [tk_focusPrev %W]}
bind Radiobutton <Left> {focus [tk_focusPrev %W]}
bind Radiobutton <Down> {focus [tk_focusNext %W]}
bind Radiobutton <Right> {focus [tk_focusNext %W]}
# WRA - end traversal bindings.

# tkButtonInvoke --
# The procedure below is called when a button is invoked through
# the keyboard.  It simulate a press of the button via the mouse.
#
# Arguments:
# w -		The name of the widget.

proc tkButtonInvoke w {
    if {[$w cget -state] != "disabled"} {
	set oldState [$w cget -state]
	$w configure -state active
	update idletasks
	after 100
	$w configure -state $oldState
	uplevel #0 [list $w invoke]
    }
}

# tkCheckRadioInvoke --
# The procedure below is invoked when the mouse button is pressed in
# a checkbutton or radiobutton widget, or when the widget is invoked
# through the keyboard.  It invokes the widget if it
# isn't disabled.
#
# Arguments:
# w -		The name of the widget.

proc tkCheckRadioInvoke w {
    if {[$w cget -state] != "disabled"} {
	uplevel #0 [list $w invoke]
    }
}
