#!/usr/bin/sh
# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: command.tcl,v $
# Revision 1.1.1.1  2003/01/22 17:48:58  ajay
# Checking in SUIT to CVS.
#
# Revision 1.1.2.2  1997/05/07  18:07:53  William_Athanasiou
# 	Initial version
# 	[1997/05/07  17:40:08  William_Athanasiou]
#
# $EndLog$
# 
# @(#)$RCSfile: command.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/22 17:48:58 $
# 
# command.tcl --
#
# This file defines the CTk command dialog procedure.
#
# @(#) $Id: command.tcl,v 1.1.1.1 2003/01/22 17:48:58 ajay Exp $
#
# Copyright (c) 1995 Cleveland Clinic Foundation
#
# See the file "license.terms" for information on usage and redistribution
# of this file, and for a DISCLAIMER OF ALL WARRANTIES.
#

proc ctkDialog {} {ctkCommand .ctkDlg}

# ctkCommand --
#
proc ctkCommand w {
    if [winfo exists $w] {
    	wm deiconify $w
	raise $w
    } else {
	toplevel $w -class Dialog -width 30 -height 10
	wm title $w Command
	entry $w.entry
	text $w.output -state disabled -takefocus 1
	button $w.close -command "wm withdraw $w" -text Close

	pack $w.entry -side top -fill x
	pack $w.output -side top -fill both -expand 1
	pack $w.close -side bottom

	bind $w.entry <Return> "ctkCommandRun $w"
    }
    focus $w.entry
}

proc ctkCommandRun w {
    global errorInfo
    set code [catch {uplevel #0 [$w.entry get]} result]
    $w.output configure -state normal
    $w.output delete 1.0 end
    $w.output insert 1.0 $result
    if $code  { $w.output insert end "\n----\n$errorInfo" }
    $w.output mark set insert 1.0
    $w.output configure -state disabled
    $w.entry delete 0 end
}
