#!/usr/bin/sh
# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: ctk.tcl,v $
# Revision 1.1.1.1  2003/01/22 17:48:58  ajay
# Checking in SUIT to CVS.
#
# Revision 1.1.2.6  2000/01/21  03:08:57  Omar_Ortiz
# 	Files related to the tcl8.2 upgrade
#
# Revision 1.1.2.5  1998/10/16  20:27:32  William_Athanasiou
# 	add M-tab binding replaces shift-tab
# 	[1998/10/16  20:27:13  William_Athanasiou]
#
# Revision 1.1.2.4  1998/02/26  21:26:50  William_Athanasiou
# 	Add keyboard traversal shortcuts
# 	[1998/02/26  21:24:33  William_Athanasiou]
# 
# Revision 1.1.2.3  1997/11/17  17:46:10  William_Athanasiou
# 	Use <control-b> to backtab since <shift-tab> not supported
# 	[1997/11/17  17:45:22  William_Athanasiou]
# 
# Revision 1.1.2.2  1997/05/07  18:07:56  William_Athanasiou
# 	Initial version
# 	[1997/05/07  17:40:11  William_Athanasiou]
# 
# $EndLog$
# 
# @(#)$RCSfile: ctk.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/22 17:48:58 $
# 
# ctk.tcl --
#
# Initialization script normally executed in the interpreter for each
# CTk-based application.  Arranges class bindings for widgets.
#
# @(#) $Id: ctk.tcl,v 1.1.1.1 2003/01/22 17:48:58 ajay Exp $
#
# Copyright (c) 1992-1994 The Regents of the University of California.
# Copyright (c) 1994-1995 Sun Microsystems, Inc.
# Copyright (c) 1995 Cleveland Clinic Foundation
#
# See the file "license.terms" for information on usage and redistribution
# of this file, and for a DISCLAIMER OF ALL WARRANTIES.

# Insist on running with compatible versions of Tcl and Tk.

scan [info tclversion] "%d.%d" a b
if {($a != 7) && ($a != 8)} {
    error "wrong version of Tcl loaded ([info tclversion]): need 7.x or 8.x"
}
scan $tk_version "%d.%d" a b
if {($a != 4) || ($b < 0)} {
    error "wrong version of Tk loaded ($tk_version): need 4.x"
}
if {$tk_port != "curses"} {
    error "wrong port of Tk loaded ($tk_port): need curses"
}
unset a b

# Add Tk's directory to the end of the auto-load search path:

lappend auto_path $tk_library

# Turn off strict Motif look and feel as a default.

set tk_strictMotif 0

# ctk_unsupported --
# This procedure is invoked when a Tk command that is not implemented
# by Ctk is invoked.
#
# Arguments:
# cmd -		command that was invoked

proc ctk_unsupported cmd {
    catch {tkerror "Unsupported Tk command: $cmd"}
}

# tkScreenChanged --
# This procedure is invoked by the binding mechanism whenever the
# "current" screen is changing.  The procedure does two things.
# First, it uses "upvar" to make global variable "tkPriv" point at an
# array variable that holds state for the current display.  Second,
# it initializes the array if it didn't already exist.
#
# Arguments:
# screen -		The name of the new screen.

proc tkScreenChanged screen {
    set disp [file rootname $screen]
    uplevel #0 upvar #0 tkPriv.$disp tkPriv
    global tkPriv
    if [info exists tkPriv] {
	set tkPriv(screen) $screen
	return
    }
    set tkPriv(afterId) {}
    set tkPriv(buttons) 0
    set tkPriv(buttonWindow) {}
    set tkPriv(dragging) {}
    set tkPriv(focus) {}
    set tkPriv(grab) {}
    set tkPriv(grabType) {}
    set tkPriv(inMenubutton) {}
    set tkPriv(initMouse) {}
    set tkPriv(listboxPrev) {}
    set tkPriv(mouseMoved) 0
    set tkPriv(popup) {}
    set tkPriv(postedMb) {}
    set tkPriv(screen) $screen
    set tkPriv(selectMode) char
    set tkPriv(window) {}
}

# Do initial setup for tkPriv, so that it is always bound to something
# (otherwise, if someone references it, it may get set to a non-upvar-ed
# value, which will cause trouble later).

tkScreenChanged [winfo screen .]

# ----------------------------------------------------------------------
# Read in files that define all of the class bindings.
# ----------------------------------------------------------------------

source $tk_library/button.tcl
source $tk_library/entry.tcl
source $tk_library/listbox.tcl
source $tk_library/menu.tcl
source $tk_library/scrollbar.tcl
source $tk_library/text.tcl

# ----------------------------------------------------------------------
# Default bindings for keyboard traversal.
# ----------------------------------------------------------------------

bind all <Tab> {focus [tk_focusNext %W]}
bind all <Meta-Tab>  {focus [tk_focusPrev %W]}
bind all <Control-n> {focus [tk_focusNext %W]}
bind all <Control-p> {focus [tk_focusPrev %W]}
bind all <Control-c> ctkDialog
bind all <F2> {ctkNextTop %W}
