'\"
'\" Copyright (c) 1990-1994 The Regents of the University of California.
'\" Copyright (c) 1994-1996 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" RCS: @(#) $Id: checkbutton.n,v 1.1.1.1 2003/01/22 17:50:04 ajay Exp $
'\" 
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1.1.1 2003/01/22 17:50:06 ajay Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH checkbutton n 4.4 Tk "Tk Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
checkbutton \- Create and manipulate checkbutton widgets
.SH SYNOPSIS
\fBcheckbutton\fI pathName \fR?\fIoptions\fR?
.SO
\-activebackground	\-cursor	\-highlightthickness	\-takefocus
\-activeforeground	\-disabledforeground	\-image	\-text
\-anchor	\-font	\-justify	\-textvariable
\-background	\-foreground	\-padx	\-underline
\-bitmap	\-highlightbackground	\-pady	\-wraplength
\-borderwidth	\-highlightcolor	\-relief
.SE
.SH "WIDGET-SPECIFIC OPTIONS"
.OP \-command command Command
Specifies a Tcl command to associate with the button.  This command
is typically invoked when mouse button 1 is released over the button
window.  The button's global variable (\fB\-variable\fR option) will
be updated before the command is invoked.
.OP \-height height Height
Specifies a desired height for the button.
If an image or bitmap is being displayed in the button then the value is in
screen units (i.e. any of the forms acceptable to \fBTk_GetPixels\fR);
for text it is in lines of text.
If this option isn't specified, the button's desired height is computed
from the size of the image or bitmap or text being displayed in it.
.OP \-indicatoron indicatorOn IndicatorOn
Specifies whether or not the indicator should be drawn.  Must be a
proper boolean value.  If false, the \fBrelief\fR option is
ignored and the widget's relief is always sunken if the widget is
selected and raised otherwise.
.OP \-offvalue offValue Value
Specifies value to store in the button's associated variable whenever
this button is deselected.  Defaults to ``0''.
.OP \-onvalue onValue Value
Specifies value to store in the button's associated variable whenever
this button is selected.  Defaults to ``1''.
.OP \-selectcolor selectColor Background
Specifies a background color to use when the button is selected.
If \fBindicatorOn\fR is true then the color applies to the indicator.
Under Windows, this color is used as the background for the indicator
regardless of the select state.
If \fBindicatorOn\fR is false, this color is used as the background
for the entire widget, in place of \fBbackground\fR or \fBactiveBackground\fR,
whenever the widget is selected.
If specified as an empty string then no special color is used for
displaying when the widget is selected.
.OP \-selectimage selectImage SelectImage
Specifies an image to display (in place of the \fBimage\fR option)
when the checkbutton is selected.
This option is ignored unless the \fBimage\fR option has been
specified.
.OP \-state state State
Specifies one of three states for the checkbutton:  \fBnormal\fR, \fBactive\fR,
or \fBdisabled\fR.  In normal state the checkbutton is displayed using the
\fBforeground\fR and \fBbackground\fR options.  The active state is
typically used when the pointer is over the checkbutton.  In active state
the checkbutton is displayed using the \fBactiveForeground\fR and
\fBactiveBackground\fR options.  Disabled state means that the checkbutton
should be insensitive:  the default bindings will refuse to activate
the widget and will ignore mouse button presses.
In this state the \fBdisabledForeground\fR and
\fBbackground\fR options determine how the checkbutton is displayed.
.OP \-variable variable Variable
Specifies name of global variable to set to indicate whether
or not this button is selected.  Defaults to the name of the
button within its parent (i.e. the last element of the button
window's path name).
.OP \-width width Width
Specifies a desired width for the button.
If an image or bitmap is being displayed in the button then the value is in
screen units (i.e. any of the forms acceptable to \fBTk_GetPixels\fR);
for text it is in characters.
If this option isn't specified, the button's desired width is computed
from the size of the image or bitmap or text being displayed in it.
.BE

.SH DESCRIPTION
.PP
The \fBcheckbutton\fR command creates a new window (given by the
\fIpathName\fR argument) and makes it into a checkbutton widget.
Additional
options, described above, may be specified on the command line
or in the option database
to configure aspects of the checkbutton such as its colors, font,
text, and initial relief.  The \fBcheckbutton\fR command returns its
\fIpathName\fR argument.  At the time this command is invoked,
there must not exist a window named \fIpathName\fR, but
\fIpathName\fR's parent must exist.
.PP
A checkbutton is a widget
that displays a textual string, bitmap or image
and a square called an \fIindicator\fR.
If text is displayed, it must all be in a single font, but it
can occupy multiple lines on the screen (if it contains newlines
or if wrapping occurs because of the \fBwrapLength\fR option) and
one of the characters may optionally be underlined using the
\fBunderline\fR option.
A checkbutton has
all of the behavior of a simple button, including the
following: it can display itself in either of three different
ways, according to the \fBstate\fR option;
it can be made to appear
raised, sunken, or flat; it can be made to flash; and it invokes
a Tcl command whenever mouse button 1 is clicked over the
checkbutton.
.PP
In addition, checkbuttons can be \fIselected\fR.
If a checkbutton is selected then the indicator is normally
.VS
drawn with a selected appearance, and
a Tcl variable associated with the checkbutton is set to a particular
value (normally 1).
Under Unix, the indicator is drawn with a sunken relief and a special
color.  Under Windows, the indicator is drawn with a check mark inside.
If the checkbutton is not selected, then the indicator is drawn with a
deselected appearance, and the associated variable is
set to a different value (typically 0).
Under Unix, the indicator is drawn with a raised relief and no special
color.  Under Windows, the indicator is drawn without a check mark inside.
.VE
By default, the name of the variable associated with a checkbutton is the
same as the \fIname\fR used to create the checkbutton.
The variable name, and the ``on'' and ``off'' values stored in it,
may be modified with options on the command line or in the option
database.
Configuration options may also be used to modify the way the
indicator is displayed (or whether it is displayed at all).
By default a checkbutton is configured to select and deselect
itself on alternate button clicks.
In addition, each checkbutton monitors its associated variable and
automatically selects and deselects itself when the variables value
changes to and from the button's ``on'' value.

.SH "WIDGET COMMAND"
.PP
The \fBcheckbutton\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.CS
\fIpathName option \fR?\fIarg arg ...\fR?
.CE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for checkbutton widgets:
.TP
\fIpathName \fBcget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBcheckbutton\fR
command.
.TP
\fIpathName \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBcheckbutton\fR
command.
.TP
\fIpathName \fBdeselect\fR
Deselects the checkbutton and sets the associated variable to its ``off''
value.
.TP
\fIpathName \fBflash\fR
Flashes the checkbutton.  This is accomplished by redisplaying the checkbutton
several times, alternating between active and normal colors.  At
the end of the flash the checkbutton is left in the same normal/active
state as when the command was invoked.
This command is ignored if the checkbutton's state is \fBdisabled\fR.
.TP
\fIpathName \fBinvoke\fR
Does just what would have happened if the user invoked the checkbutton
with the mouse: toggle the selection state of the button and invoke
the Tcl command associated with the checkbutton, if there is one.
The return value is the return value from the Tcl command, or an
empty string if there is no command associated with the checkbutton.
This command is ignored if the checkbutton's state is \fBdisabled\fR.
.TP
\fIpathName \fBselect\fR
Selects the checkbutton and sets the associated variable to its ``on''
value.
.TP
\fIpathName \fBtoggle\fR
Toggles the selection state of the button, redisplaying it and
modifying its associated variable to reflect the new state.

.SH BINDINGS
.PP
Tk automatically creates class bindings for checkbuttons that give them
the following default behavior:
.VS
.IP [1]
On Unix systems, a checkbutton activates whenever the mouse passes
over it and deactivates whenever the mouse leaves the checkbutton.  On
Mac and Windows systems, when mouse button 1 is pressed over a
checkbutton, the button activates whenever the mouse pointer is inside
the button, and deactivates whenever the mouse pointer leaves the
button.
.VE
.IP [2]
When mouse button 1 is pressed over a checkbutton, it is invoked (its
selection state toggles and the command associated with the button is
invoked, if there is one).
.VS
.IP [3]
When a checkbutton has the input focus, the space key causes the checkbutton
to be invoked.  Under Windows, there are additional key bindings; plus
(+) and equal (=) select the button, and minus (-) deselects the button.
.VE
.PP
If the checkbutton's state is \fBdisabled\fR then none of the above
actions occur:  the checkbutton is completely non-responsive.
.PP
The behavior of checkbuttons can be changed by defining new bindings for
individual widgets or by redefining the class bindings.

.SH KEYWORDS
checkbutton, widget
