############################################################################
#
# Name:
#	sysman_menu.cb.tcl
#
# Abstract:
#	This file is the SUIT dialog callabacks for the sysman menu. 
#	It is sourced in the main SUIT application file, sysman_menu.tcl 
#
# Notes:
#
#
############################################################################


#
# Procedure:
#	sysman_menu initCB - SUIT calls this cb after our genUID 
#       (window definitions) have been processed. SUIT is completely 
#	init'd at this point
#
# Inputs:
#	None
# Outputs:
# 	None
# Returns:
#	None
# Notes:
#
sysman_menu proc initCB {} {

    global SM_menu_debug
    global SM_suit_initialized
    global SM_menu_initialized

    # If we haven't built the the menu tree yet
    if { $SM_menu_initialized == "false" } {
	SM_Initialize				;# Do so now
	set SM_menu_initialized true
    }

    # Set the title for the main window's list box to have 
    # the proper system name. There is a default in the catalog
    # if getconf fails. 
    if { [catch {exec /usr/bin/getconf PRODUCT_NAME} os_name] == 0 } {
	set list_title [SM_cat catgets menu_win_list_box_title_lbl]
	set list_title [format $list_title $os_name]
	menu_win.menu_tree setLabel $list_title
    }

    # Process command line arguments that require the menu UI to be defined
    SM_PostInitialize

    set SM_suit_initialized true


    if { $SM_menu_debug == "true" } {

	# Misc. gebugging placeholders:
	#SysmanMenu dump
	#$SM_menu_def_root Show_hierarchy

	#SysmanMenu build_array
	#puts "[$SM_menu_def_root show_menu_level]"
	#SysmanMenu show_menu_level
    #    puts "In init here"

    #    puts "leaf [Menu_leaf info instprocs]"
    #    puts "branch [Menu_branch info instprocs]"
    #    puts "class [SM_devices info class]"
    #    puts "procs [SM_devices info procs]"
    #    puts "args [SM_devices info args Is_item_expanded]" 
    #    puts "vars [SM_devices info vars]" 
    #   puts "Menu [Menu info instprocs]"
    #    Menu info instprocs
    #    Menu info superclass
    #    Menu info heritage
    #    Menu info instances
    #    puts "subclass [Menu info subclass]"

	#exit
    } ;# end if {debugging}



} ;# end proc sysman_menu initCB








############################################################################
#
# Main window callbacks
#
############################################################################


#
# Procedure:
#	menu_win displayCB - the display callback
#	for the main window. We set the title bar string
#	here. 
#
# Inputs:
#       None
# Outputs:
# 	None
# Returns:
#	None
# Notes:
#	The menu_title instvar is set in the SM_Process_CLI_Arguments
#	This represents the string specified by the -menu_title switch. 
#	If present, we use that string. 
#
menu_win proc displayCB {} {
    global SM_menu_main SM_menu_debug
    global SM_menu_title
    $self instvar menu_title

    set cat ${SM_menu_main}.cat


    if { [info exists menu_title] } {   ;# If -menu_title from the command line

	set title $menu_title		

    } else {				;# else use our standard title

	# Fix up the title bar for this window to read:
	# SysMan Menu on <hostname>
	set title [$cat get menu_win "lbl"]
	set title [format "$title" "[id host]"]
    }

    $self setLabel $title

}	;# end menu_win display CB


#
# Procedure:
#	menu_win.options invokeCB - called when a user selects
#	Find... in the main window. We display the Find Task By 
#	Keyword dialog box
#
# Inputs:
#	None
# Outputs:
# 	None
# Returns:
#	None
# Notes:
#
menu_win.options  proc invokeCB {} {

    options_db display


} ;# end menu_win.options invokeCB

#
# Procedure:
#	menu_win.exit invokeCB - called when a user selects
#	exit in the main window
#
# Inputs:
#	None
# Outputs:
# 	None
# Returns:
#	None
# Notes:
#
menu_win.exit  proc invokeCB {} {
  
    exit

} ;# end menu_win.exit invokeCB


############################################################################
#
# Main window list box callbacks
#
############################################################################


#
# Procedure:
#	menu_win.menu_tree init CB - the initialization callback
#	for the main window's list box that we use to display the tree 
#	hierarchy 
#
# Inputs:
#	None
# Outputs:
# 	None
# Returns:
#	None
# Notes:
#
#menu_win.menu_tree proc initCB {} {
#    global SM_menu_def_root
#
#
#
#}	;# end menu_win.menu_tree init CB


#
# Procedure:
#	menu_win.focushosts initCB - the initialization callback
#	for the main window's takesfocus options menu. This menu contains
#       the cluster alias name followed by the member names. 
#
# Inputs:
#	None
# Outputs:
# 	None
# Returns:
#	None
# Notes:
#	This proc can only be defined when we are in a cluster (cause otherwise
#	the UI is suppressed and the otcl object is not created)
#
#global SysmanOnCluster
#if {$SysmanOnCluster == 1} {
#
#    menu_win.focushosts proc initCB {} {
#	global SysmanFocusHost
#
#	set members [cluster member all]	;# First get all the members
#	set members [lsort $members]		;# Sort it
#	set members [linsert $members 0 [cluster alias]] ;# Prepend the alias
#
#	$self setValueList $members		;# Stick into the options menu
#
#
#	# If the user specificed -focus <hostname> on the command line
#	# then we want the focus menu to default to be that host
#	# Otherwise we want the alias selected
#	set selected 0			;# Default to alias - 0th list item
#	if { $SysmanFocusHost != "" } {
#	    # sysmansh guarantees that the -focus arg is valid
#	    # so we will find it in the lsearch
#	    set selected [lsearch -exact $members $SysmanFocusHost]
#	}
#
#	$self setVal [lindex $members $selected] ;# Set default focus
#
#
#    }	;# end menu_win.menu_tree init CB
#
#} ;# end if in a cluster

#
# Procedure:
#	menu_win.menu_tree.select invokeCB - called when a user selects
#	an item from the menu. If this is not leaf, then we
#	expand or collapse it. If it's a leaf we execute it. 
#
# Inputs:
#	None
# Outputs:
# 	None
# Returns:
#	None
# Notes:
#
menu_win.menu_tree.select  proc invokeCB {} {

    
    # Get selected item's numeric index in the list box
    set cursel_index [ menu_win.menu_tree curSelection ]

    # Given the selected item index, get the associated menu object
    set item [Map_selection_to_menu_object $cursel_index]

    # pjw: Hack! If the item's task is "manpage" then the -menu_help_volume
    # is assumed to be the man page flavor and we will use that to 
    # display a man page for this task. IOW, all this task is is a man
    # page. We know how to display Help On Item for the man page
    # (where -menu_help_volume is set it "manpage <name of the manpage>"
    # but we didn't have the feature of having launched task that just displays
    # a man page. ptyio doesn't work cause the text widget can't deal 
    # with the manpage's escape sequences. 
    # The proper implementation is to subclass
    # the Menu_leaf object with a Menu_leaf_help object whose 
    # Execute method just displays the page. That is too much work/too
    # risky when the following few lines will do.... Note that the
    # current implementation here only  works for leaves though 
    # (cause only leaves have targets)
    # The general feature we need here is the ability to display a manpage
    # or a message catalog string instead of running a task
    if { [$item info class] == "Menu_leaf" && \
         [$item set target] == "manpage"} {	;# if this app is just manpage
	SM_help_on_selected_item $item
	return
    }



    # Now "execute" this item. If it's a branch it updates
    # the list box with the new items. If it's a suitlet/mcl,
    # we run it
    $item Execute $cursel_index


} ;# end menu_win.menu_tree.select invokeCB

#
# Procedure:
#	menu_win.menu_tree.help_on_item invokeCB - get help 
#	on the item selected in the main list box
#
# Inputs:
#	None
# Outputs:
# 	None
# Returns:
#	None
# Notes:
#
menu_win.menu_tree.help_on_item  proc invokeCB {} {

    # Get selected item's numeric index in the list box
    set cursel_index [ menu_win.menu_tree curSelection ]

    # Given the selected item index, get the associated menu object
    set item [Map_selection_to_menu_object $cursel_index]

    SM_help_on_selected_item $item

} ;# end menu_win.menu_tree.help_on_item invokeCB


#
# Procedure:
#	menu_win.menu_tree.find invokeCB - called when a user selects
#	Find... in the main window. We display the Find Task By 
#	Keyword dialog box
#
# Inputs:
#	None
# Outputs:
# 	None
# Returns:
#	None
# Notes:
#	Gross hack, part 2. If the -menu_title flag is specified
#	we supress the find button. That means we have to supress
#	this callback definition as well:
#
global SM_captive_flag
if { $SM_captive_flag == "false" } {

    menu_win.menu_tree.find  proc invokeCB {} {

	find_db display

    } ;# end menu_win.menu_tree.find invokeCB

} ;# end if SM_captive_flag == true

############################################################################
#
# Find Task By Keyword dialog box callbacks
#
############################################################################

#
# Procedure:
#	find_db.cancel invokeCB - called when a user selects
#	cancel in the Find Task By Keywork dialog box
#
# Inputs:
#	None
# Outputs:
# 	None
# Returns:
#	None
# Notes:
#
find_db.cancel  proc invokeCB {} {
  
    find_db hide		;# Dismiss the dialog

} ;# end find_db.cancel invokeCB

#
# Procedure:
#	find_db.ok invokeCB - called when a user selects
#	OK in the Find Task By Keywork dialog box. We call 
#	the apply routine and then dismiss the dialog
#
# Inputs:
#	None
# Outputs:
# 	None
# Returns:
#	None
# Notes:
#
find_db.ok  proc invokeCB {} {

    global SM_status

    set status [find_db.apply invokeCB true]	;# Call Apply to do the work  

#    if { $status == $SM_status(SUCCESS) } {	;# If no errors
#        find_db hide				;# Then dismiss the dialog
#    }

} ;# end find_db.ok invokeCB


#
# Procedure:
#	find_db.apply invokeCB - called when a user selects
#	Apply in the Find Task By Keywork dialog box. We take
#	the specified keyword and build a new menu containing 
#	just the items that match
#
#	Each menu item has an optional keyword list (represented
#	as a tcl list). We simply use lsearch to find the menu objects
#	that have a match. 
#
# Inputs:
#	called_from_ok - true when the OK callback is calling
#			 us to do its' work. This param is needed cause
#			 SUIT enforces order of operations on hiding
#			 dialog boxes. We can't display the Tasks dialog
#			 in this routine and then hide the find dialog
#			 in the OK routine. 
# Outputs:
# 	None
# Returns:
#	success - when matching tasks are found
#	failure - when no tasks match. 
#	warning - when search text field is empty 
# Notes:
#
find_db.apply  proc invokeCB { {called_from_ok {} } } {
    global SM_menu_def_root  
    global SM_menu_main
    global SM_display_accelerators
    global SM_status

    set cat ${SM_menu_main}.cat

    set keyword [find_db.keyword getVal]

    if { [cequal $keyword ""] } {	;# If no keyword specified

	# Then if the user pressed OK, just dismiss the dialog
	# box (i.e. treat OK as a Cancel)
	if { $called_from_ok == "true" } {
	    find_db hide
	} 
	# For OK or an apply, it's a noop. Leave the box up
	return $SM_status(SUCCESS)	;# Then just do nothing
    }

    # Traverse the menu, collecting the menu objects that match this keyword
    set matching_tasks \
	[$SM_menu_def_root Find_task_by_keyword [string tolower $keyword]]

    
    if { [cequal $matching_tasks ""] } {;# If no tasks match
	SM_DisplayInfoMsg info info_no_match
	return $SM_status(FAILURE)
    } 

    tasks_db.tasks setVal [SM_build_task_list tasks_db.tasks $matching_tasks]

    # If the user pressed OK, dismiss the dialog
    if { $called_from_ok == "true" } {
	find_db hide
    }

    tasks_db display			;# Display the search results
    
    return $SM_status(SUCCESS)

} ;# end find_db.apply invokeCB
############################################################################
#
# Task list dialog box callbacks
#
############################################################################

#
# Procedure:
#	tasks_db.cancel invokeCB - called when a user selects
#	cancel in the Task List dialog
#
# Inputs:
#	None
# Outputs:
# 	None
# Returns:
#	None
# Notes:
#
tasks_db.cancel  proc invokeCB {} {
  
    tasks_db hide			;# Dismiss the dialog

} ;# end tasks_db.cancel invokeCB

#
# Procedure:
#	tasks_db.tasks.run invokeCB - called when a user selects
#	Run Task  in the Task List dialog box. 
#
# Inputs:
#	None
# Outputs:
# 	None
# Returns:
#	None
# Notes:
#
tasks_db.tasks.run  proc invokeCB {} {
  
    # Get the selected list item's userdata (our menu object)
    # Note that this is returned as a tcl list (cause the SUIT
    # list can have multiple selection. We are using only single selection. 
    set menu_obj [tasks_db.tasks getSelUserData]

    $menu_obj Execute			;# Make it so ;-)

} ;# end tasks_db.tasks.run invokeCB
#
# Procedure:
#	tasks_db.tasks.help_on_item invokeCB - called when a user selects
#	Run Task  in the Task List dialog box. 
#
# Inputs:
#	None
# Outputs:
# 	None
# Returns:
#	None
# Notes:
#
tasks_db.tasks.help_on_item  proc invokeCB {} {
  
    set menu_obj [tasks_db.tasks getSelUserData]
    SM_help_on_selected_item $menu_obj	;# Get help on it

} ;# end tasks_db.tasks.help_on_item invokeCB


############################################################################
#
# Options dialog box callbacks
#
############################################################################

#
# Procedure:
#	options_db.cancel invokeCB - called when a user selects
#	exit in the main window
#
# Inputs:
#	None
# Outputs:
# 	None
# Returns:
#	None
# Notes:
#
options_db.cancel  proc invokeCB {} {
  
    options_db hide			;# Dismiss the dialog

} ;# end options_db.cancel invokeCB

#
# Procedure:
#	options_db.ok invokeCB - called when a user selects
#	OK in the Options dialog box. 
#
# Inputs:
#	None
# Outputs:
# 	None
# Returns:
#	None
# Notes:
#
options_db.ok  proc invokeCB {} {

    global SM_display_accelerators
    global SM_menu_def_root

    set current_disp_accels $SM_display_accelerators

    # Save the value of the "Display Menu Accelerators" toggle
    if { [options_db.display_accelerators getVal] == 1 } {
	set SM_display_accelerators "true"
    } else {
	set SM_display_accelerators "false"
    }

    # Only reset the menu text if the value of the toggle has changed
    if { $current_disp_accels != $SM_display_accelerators } {

	# Save the index of the currently selection item
	set selection_index [menu_win.menu_tree curSelection]

	# Populate the UI with the new menu. Do this by first 
	# constructing the menu items as a plain list
	set menu_items \
		[$SM_menu_def_root Build_menu "" $SM_display_accelerators]

	# Now convert that to a keyed list for the SUIT list box
	set kl {}
	foreach item $menu_items {
	    menu_win.menu_tree setListItem kl $item $item
	}

	menu_win.menu_tree setVal $kl		;# Jam in new tree
						;# Restore the selection
	eval menu_win.menu_tree setSelection $selection_index
	
    }


    options_db hide			;# Dismiss the dialog

} ;# end options_db.ok invokeCB

#
# Procedure:
#	options_db.display_accelerators initCB - sets the intial 
#	value of the Display Menu Accelerators toggle to false. 
#
# Inputs:
#	None
# Outputs:
# 	None
# Returns:
#	None
# Notes:
#
options_db.display_accelerators  proc initCB {} {

    options_db.display_accelerators setVal 0

} ;# end options_db.display_accelerators initCB





#
# Procedure:
#	menu_win.help invokeCB - called when a user selects
#	Help in our main window
#
# Inputs:
#	None
# Outputs:
# 	None
# Returns:
#	None
# Notes:
#
menu_win.help  proc invokeCB {} {

    SM_help_on_menu $self		;# Help on the menu itself


} ;# end menu_win.help invokeCB

find_db.help  proc invokeCB {} {

    SM_help_on_menu $self

} ;# end find_db.help invokeCB

tasks_db.help  proc invokeCB {} {

   SM_help_on_menu $self		;# Help on the window itself

} ;# end tasks_db.help invokeCB

options_db.help  proc invokeCB {} {

    SM_help_on_menu $self

} ;# end options_db.help invokeCB

#
# Procedure:
#	SM_help_on_selected_item  - common help routine for 
#	invoking help on a selected item
#
# Inputs:
#	item - selected menu object
# Outputs:
# 	None
# Returns:
#	None
# Notes:
#	Yuck. The main menu's list and the Task List dialogs
#	are implemented differently. The former needs to jump
#	through some hoops to get the object name from the selected item. 
#	The latter stores the object name as userdata in the list. 
#	If the item paramter is non-null, the caller is Taks List dialog. 
#	Someday I need to fix the former list to use userdata. 
#	I think it wasn't available when I started coding thus the difference. 
#
proc SM_help_on_selected_item  { item } {

    $item instvar help_volume help_locid 

    # If this item has a non-default help vol name, then 
    # we need to tell SUIT
    if { $help_volume != "" } {


	# If the suitlet is a ptyiolet we display the man page
	# for the command. Such leaves have a -menu_help_volume
	# in the form:
	#	manpage <manpage_name> [<section>] [<manpath>]
	if { [llength $help_volume] >= 2 && \
	     [lindex $help_volume 0] == "manpage" } {	;# If a manpage spec.
	    
	    set manpage [lindex $help_volume 1]
	    set section [lindex $help_volume 2]		;# Null if unspecified
	    set manpath [lindex $help_volume 3]		;# Null if unspecified
	    SM_Display_Manpage $manpage $section $manpath

	} elseif { [lindex $help_volume 0] == "none_available" } {
	    SM_DisplayInfoMsg info info_no_help_available

	} else {	;# Display specified help volume/locid

	    # The title for the help dialog will be "<menu item name>: Help"
	    # Note that we use the SUIT catget method to get i18n_help_txt
	    # from the i18n catalog
	    set title \
		"[$item Get_item_text]: [sysman_menu catget help txt]"
	    sysman_menu setHelpName   $title
	    sysman_menu setHelpVolume $help_volume
	    sysman_menu helpOn	      $help_locid

	}

    } else {				;# help_vol is blank 

	# If we are a branch then there is no help! Display an info message
	if { [$item info class] == "Menu_branch" } {

	    SM_DisplayInfoMsg info info_no_help_for_branch

	} else {

	    # If we are a leaf then we derive the help name
	    # The SUIT default volume name is the same as the man Window name
	    # This is usually the same as the genUID filename. If it's not, 
	    # the user has to customize the menu definition to tell us that.
	    # [pjw: we shouldn't be doing this. We should get a SUIT
	    # entry point where we pass the name and let suit do this....
	    set task_spec [lindex [$item set target] 0]	;# Get the filename
	    
	    # If it has slashes, take the last path element (the name
	    # of the executable
	    set help_name [file tail $task_spec]
	    # In case there is an extension, strip it
	    set help_name [file rootname $help_name]

	    # The title for the help dialog will be "<menu item name>: Help"
	    # Note that we use the SUIT catget method to get i18n_help_txt
	    # from the i18n catalog
	    set title \
		"[$item Get_item_text]: [sysman_menu catget help txt]"
	    sysman_menu setHelpName $title	 ;# Tell SUIT the title
	    sysman_menu setHelpVolume $help_name ;# And the vol name
	    sysman_menu helpOn \
			[$item set help_locid]  ;# Bring it up!!
	    
	} ;# end if it's a branch

    } ;# end if help volume is non-null


} ;# end SM_help_on_selected_item


#
# Procedure:
#	SM_help_on_menu  - common help routine
#
# Inputs:
#	w - name of the help button that was pressed
# Outputs:
# 	None
# Returns:
#	None
# Notes:
#	We want to use the name of the dialog box as the location id. 
#	In this cause, the widget calling us is the help button itself
#	so the widget name is <window>.help. We simply strip off the .help
#
proc SM_help_on_menu  { w } {

    set i [string last "." $w]		;# Find the last "."
    incr i -1				;# Move one back from there
    set name [string range $w 0 $i]

    # We must always set the volume name in case the user has 
    # done a Help On Item and caused the volume to change
    sysman_menu setHelpName [SM_cat catgets help_db_title_lbl]
    sysman_menu setHelpVolume sysman_menu
    sysman_menu helpOn $name

} ;# end SM_help_on_menu invokeCB

############################################################################
#
# General purpose SUIT utility functions
#
############################################################################

#
# Procedure:
#	SM_build_task_list - converts a tcl list of menu objects into a 
#	tcl keyed list suitable for doing a setVal to a SUIT list widget
#	This list is used by the Find Tasks By Keyword dialogs
#
# Inputs:
#	menu_objs - list of menu objects that matched the search criteria
#		    of a find operation
#	suit_list - suit list widget. The setListItems is a method 
#		    on lists. 
# Outputs:
# 	None
# Returns:
#	a keyled list for use with a SUIT list widget. 
# Notes:
#
#
proc SM_build_task_list { suit_list menu_objs } {

    global SM_display_accelerators


    set items ""

    foreach obj $menu_objs {		;# For each menu object
					;# Get it's display string
	set task_name [$obj Get_item_text $SM_display_accelerators]
					;# And format for SUIT usage
	$suit_list setListItem items $task_name $obj
    }

    return $items


} ;# end SM_build_task_list



############################################################################
#
# Cluster Member dialog box callbacks
#
############################################################################

#
# Procedure:
#	members_db displayCB - create the list for use
#	in the Choose Focus Host dialog. 
#	In one case the list includes the alias and in the other it doesn't
#	Member-specific apps use the dialog sans the alias. General
#	focus apps cause also focus to the alias. 
#
# Inputs:
#	type - focus type of the suitlet. member_specific or cluster_wide
# Outputs:
# 	None
# Returns:
#	None
# Notes:
#	This displayCB is not used. Instead, see display_focushost_db.
#	it's a method on a leaf object that displays this dialog	
#
#members_db proc displayCB {} {
#
#
#} ;# end proc members_list displayCB 



#
# Procedure:
#	members_db.ok invokeCB - callback for Cluster Members dialog OK button
#       The user has selected the focushost from the list box. See what's
#	selected and set the global SM_focushost appropriately and then
#	invoke the appropriate suitlet. 
#
# Inputs:
#	None
# Outputs:
# 	None
# Returns:
#	None
# Notes:
#	
#

members_db.ok proc invokeCB {} {

    global SM_menu_debug    
    global SM_last_selected_member
    global SM_alias_selected

    set list members_db.members_list

    # Get selected item's display string and it's user data (which is 
    # the menu object to execute). Cursel is list containing
    # the displaystring/userdata pairs (e.g. {{terra up} SM_netman}
    # The display string in the list box is in the form
    #	hostname	status
    # so we parse out the name and save it in an instvar
    set cursel [$list getCurSelection]	   ;# List of display string/userdata 
    set cursel [lindex 	$cursel 0]	   ;# Get rid of outer list

    set item	     [lindex $cursel 1]			;# Get just userdata
    $item set focushost [lindex [lindex $cursel 0] 0]	;# Get the focus host

    # Remember the user's selection so we can set this dialog's
    # default's intelligently. See display_focushost_db for details
    if { [cluster alias] == [$item set focushost] } {
	set SM_alias_selected true
    } else {
	set SM_alias_selected false
	set SM_last_selected_member [$item set focushost] 
    }


    if { $SM_menu_debug == "true" } {
	puts "members_db.ok invokeCB: Focus host is: |[$item set focushost]|" 
        puts "			      item is: $item"
	puts "			      SM_alias_selected: $SM_alias_selected"
	puts "		  SM_last_selected_member: $SM_last_selected_member"
    }

    members_db hide				;# Tear it down

    $item Real_execute				;# Run the task focused

    return


}	;# end proc members_db.ok invokeCB

#
# Procedure:
#	members_db.cancel invokeCB - callback for Choose Focus Host dialog 
#	cancel button. 
#
# Inputs:
#	None
# Outputs:
# 	None
# Returns:
#	None
# Notes:
#       If the task was specified directly on the command line, then 
#       SM_run_leaf_directly is true and we should exit when the Choose
#	Focus Host dialog is canceled
#	
#

members_db.cancel proc invokeCB {} {

    global SM_leaf_needs_focus_dialog

    members_db hide			;# Tear down the dialog

    if { $SM_leaf_needs_focus_dialog == "true" } {
	exit
    }

    return

}	;# end proc members_db.cancel invokeCB


#
# Procedure:
#	members_db.help invokeCB - callback for Choose Focus Host dialog 
#	help button. 
#
# Inputs:
#	None
# Outputs:
# 	None
# Returns:
#	None
# Notes:
#	
#

members_db.help proc invokeCB {} {

    SM_help_on_menu $self		;# Help on the menu itself

}	;# end proc members_db.help invokeCB

#
# Procedure:
#	members_db.members_list.select invokeCB - called when a user double
#	clicks on an item from the focus dialog box. We invoke the OK
#	callback for the overall dialog in this case. 
#
# Inputs:
#	None
# Outputs:
# 	None
# Returns:
#	None
# Notes:
#	[pjw: Want a new SUIT feature here. -doubleClk for a list should
#	 be able to be an arbitrary button in the dialog overall dialog. 
#	 In this box, we really don't want a Select button at all. OK
#	 is more than enough]
#
members_db.members_list.select  proc invokeCB {} {

     members_db.ok invokeCB		;# Call the OK callback for the dialog

} ;# end members_db.members_list.select invokeCB

#
# Procedure:
#	manpage.ok invokeCB -  OK (dismiss) the current man page window
# Inputs:
#	None
# Outputs:
# 	None
# Returns:
#	None
# Notes:
#
manpage_db.ok  proc invokeCB {} {

    manpage_db hide

} ;# end manpage_db invokeCB

#
# Procedure:
#	SM_Display_Manpage -  set the title appropriately
#	each time the man page window is displayed
# Inputs:
#	manpage - name of the manpage to display
#	section - section it's in
# Outputs:
# 	None
# Returns:
#	None
# Notes:
#
proc SM_Display_Manpage { manpage {section {}} {manpath {}} } {
    global SM_menu_debug


    set title [SM_cat catgets manpage_db_title_lbl]  ;# Fetch win. title
    set title [format $title $manpage]		  ;# Fill in manpage name
    manpage_db setLabel $title			  ;# Tell suit

    if { $manpath == "" } {			  ;# If default manpath
        set mancommand "/usr/bin/man $section $manpage | /usr/bin/col -b"
    } else {					  ;# else add -M
        set mancommand \
	   "/usr/bin/man -M $manpath $section $manpage | /usr/bin/col -b"

    }

    set status [catch {eval exec $mancommand } manpagetext]

    if { $status == 0 } {			;# man was successful
	manpage_db.text setVal $manpagetext
	manpage_db display
    } else {					;# else man problem

	if { $SM_menu_debug == "true" } {
	    puts "man error: $manpagetext"
	}


	# Either the man pages are not installed or
	# the subset man needs for nroff etc is missing (OSFDCMT)
	# This latter issue produces the message:
	#    Cannot format manpage. /usr/bin/nroff is not installed.
	# 

	SM_DisplayInfoMsg info info_no_help_man_error $manpage

    }

} ;# SM_Display_Manpage







