############################################################################
#
# Name:
#	sysman_menu_definition.tcl
#
# Abstract:
#	Menu hierarchy definition for the base SysMan Menu
#
# Notes:
#	Do NOT edit this file. In order to extend the menu, 
#	add menu definition files to /usr/share/sysman/menu/tasks/<task dir>.
#	This file will be replaced by upgrade installations. 
#
#	External menu definitions files use the same syntax as the base menu
#	definition below but they additionally specify where to insert the menu
#	items in the hierarchy. For example, the network configuration 
#	applications add themselve to the SM_network_management branch
#	of the tree. This file defines the basic toplevel branches
#	and menu hierachy. If there are no leaf nodes for 
#	a particular branch, then that branch will not be displayed. 
#	
#
#	SM is the prefix we use to avoid TCL variable/proc name collisions
#	(SM == SysMan Menu). Each menu item MUST have a unique name.
#	Failure to follow this has has rather devasting effects. 
#	Each menu item below, branch or leaf, is a Object Tcl object. 
#	If you declare multiple objects of the same name, the last
#	one wins. 
#	
#	The message catalog conventions for each menu item are as follows:
#	   - each menu item defined here places it's message catalog
#	     entry in the main SysMan Menu message catalog
#	   - externally defined menu items place message catalog
#	     strings in private message catalogs specified by
#	     the -menu_catalog <catalog name> switch. 
#	   - the catalog string for a menu item is derived from it's 
#	     lowercased name. For exmaple, the branch:
#		Menu_branch SM_network_management {...}
#	     would have a catalog entry of:
#		sm_network_management_lbl "Network Management"
#
#
#
############################################################################

# This first defintion is a basic, task-oriented menu
Menu_branch SM_SysmanMenu {

    # Account Management
    Menu_branch SM_user_management {

		Menu_leaf SM_am_local_users \
		    -menu_accel "users" \
		    -menu_target \
			"account_management/account_management local_passwd"\
		    -menu_keywords sm_am_keywords \
		    -menu_help_volume account_management \
		    -menu_help_locid LocalUsers \
		    -menu_focus cluster_wide

		Menu_leaf SM_am_local_groups \
		    -menu_accel "groups" \
		    -menu_target \
			"account_management/account_management local_group"\
		    -menu_keywords sm_am_keywords \
		    -menu_help_volume account_management \
		    -menu_help_locid LocalGroups \
		    -menu_focus cluster_wide

		Menu_leaf SM_am_nis_users \
		    -menu_accel "nis_users" \
		    -menu_target \
			"account_management/account_management nis_passwd" \
		    -menu_keywords sm_am_keywords \
		    -menu_help_volume account_management \
		    -menu_help_locid NISUsers \
		    -menu_focus cluster_wide

		Menu_leaf SM_am_nis_groups \
		    -menu_accel "nis_groups" \
		    -menu_target \
			"account_management/account_management nis_group" \
		    -menu_keywords sm_am_keywords \
		    -menu_help_volume account_management \
		    -menu_help_locid NISgroups \
		    -menu_focus cluster_wide

		Menu_leaf SM_am_ldap_users \
		    -menu_accel "ldap_users" \
		    -menu_target \
			"account_management/account_management ldap_passwd" \
		    -menu_keywords sm_am_keywords \
		    -menu_help_volume account_management \
		    -menu_help_locid LDAPUsers \
		    -menu_focus cluster_wide

		Menu_leaf SM_am_ldap_groups \
		    -menu_accel "ldap_groups" \
		    -menu_target \
			"account_management/account_management ldap_group" \
		    -menu_keywords sm_am_keywords \
		    -menu_help_volume account_management \
		    -menu_help_locid LDAPgroups \
		    -menu_focus cluster_wide

    } -menu_leaf_default_privs AccountManagement \
      -menu_help_volume account_management \
      -menu_accel accounts	;# end SM_user_management

    # hardware management branch
    Menu_branch SM_hwmgmt {

            Menu_leaf SM_hwhierarchy  \
                -menu_keywords_msg sm_hwmgmt_keywords \
                -menu_accel "hw_hierarchy" \
		-menu_help_volume "manpage hwmgr" \
                -menu_target "ptyio/ptyio -outputonly 0 -menu_catalog sysman_menu -menu_title sm_hwhierarchy_lbl /sbin/hwmgr -view hierarchy"

            Menu_leaf SM_hwcluhierarchy  \
                -menu_keywords_msg sm_hwmgmt_keywords \
                -menu_accel "hw_cluhierarchy" \
		-menu_help_volume "manpage hwmgr" \
                -menu_target "ptyio/ptyio -outputonly 0 -menu_catalog sysman_menu -menu_title sm_hwcluhierarchy_lbl /sbin/hwmgr -view cluster"

            Menu_leaf SM_hwdevices  \
                -menu_keywords_msg sm_hwmgmt_keywords \
                -menu_accel "hw_devices" \
		-menu_help_volume "manpage hwmgr" \
                -menu_target "ptyio/ptyio -outputonly 0 -menu_catalog sysman_menu -menu_title sm_hwdevices_lbl /sbin/hwmgr -view devices"

            Menu_leaf SM_hwcpus  \
                -menu_keywords_msg sm_hwmgmt_keywords \
                -menu_accel "hw_cpus" \
		-menu_help_volume "manpage psrinfo" \
                -menu_target "ptyio/ptyio -outputonly 0 -menu_catalog sysman_menu -menu_title sm_processorinfo_lbl -- /usr/sbin/psrinfo -v"

	    Menu_leaf SM_hw_manage_cpus  \
		-menu_keywords_msg sm_hw_manage_cpus_keywords \
		-menu_accel "hw_manage_cpus" \
		-menu_help_volume "hotswap" \
		-menu_target "hotswap/hotswap" \
		-menu_privs HardwareManagement

	    Menu_leaf SM_hw_olar_policy_info  \
		-menu_keywords_msg sm_hw_olar_policy_info_keywords \
		-menu_accel "hw_olar_policy_info" \
		-menu_help_volume "manpage olar.config" \
		-menu_target "manpage"

    } -menu_help_volume sysman_menu \
      -menu_help_locid SM-hwmgmt \
      -menu_accel hardware

    # Mail branch
    Menu_branch SM_mail_management {
    } -menu_leaf_default_privs MailConfiguration \
      -menu_help_volume sysman_menu \
      -menu_help_locid SM-mail-management \
      -menu_accel mail \
      -menu_focus cluster_wide


    Menu_branch SM_monitoring_and_tuning {

	Menu_leaf SM_evm_viewer  \
	    -menu_accel "event_viewer" \
	    -menu_privs EventConfiguration \
	    -menu_target "evmviewer/evmviewer" \
	    -menu_keywords sm_evm_viewer_keywords \
	    -menu_focus both

	# Class scheduler branch
	Menu_branch SM_sched_classes {
	} -menu_help_volume clsschl \
	  -menu_help_locid SM-network-management \
	  -menu_accel class_sched

	# Insight Manager config
	Menu_leaf SM_imconfig \
	  -menu_accel "imconfig" \
	  -menu_privs SystemManagement \
	  -menu_target "imconfig/imconfig" \
	  -menu_help_locid "imconfig" \
	  -menu_keywords sm_imconfig_keywords \
	  -menu_focus member_specific

    }	-menu_leaf_default_privs SystemManagement \
        -menu_help_volume sysman_menu \
        -menu_help_locid SM-monitoring-and-tuning \
        -menu_accel monitoring	;# end monitoring and tuning

    Menu_branch SM_network_management {
   	Menu_leaf SM_netconfig_wizard \
        -menu_accel "net_wizard" \
        -menu_target "netconfig/wizard/wizard" \
        -menu_catalog "netconfig_menu.msg" \
        -menu_keywords sm_netconfig_wizard_keywords \
        -menu_help_volume netwizard \
	-menu_focus member_specific

	Menu_branch SM_network_basic {
   	} -menu_help_volume sysman_menu \
          -menu_help_locid SM-network-management \
          -menu_accel networkbasic

   	Menu_branch SM_network_additional {
		Menu_branch SM_bindconfiguration {
		} -menu_accel "dns" \
		  -menu_help_locid  Bind\
		  -menu_catalog "bindconfig_menu.msg" \
		  -menu_help_volume sysman_menu ;# end bindconfig

		Menu_branch SM_serial_line_networking {
		} -menu_accel serial_line \
		  -menu_help_locid SM-serial-line-networking \
		  -menu_help_volume sysman_menu ;# end serial_line_networking

   	}  -menu_help_volume sysman_menu \
           -menu_help_locid SM-network-additional \
	   -menu_accel networkadditional

    } -menu_leaf_default_privs NetworkConfiguration \
      -menu_help_volume sysman_menu \
      -menu_help_locid SM-network-management \
      -menu_accel network

    # branch for printer management
    Menu_branch SM_printers {
    } -menu_leaf_default_privs PrinterConfiguration \
      -menu_help_volume sysman_menu \
      -menu_help_locid SM-printers \
      -menu_accel printers	;# End printing

    # branch for security functionality
    Menu_branch SM_security {

	Menu_leaf SM_dopconfig \
                -menu_accel "dopconfig" \
                -menu_target "dopconfig/dopconfig" \
                -menu_keywords_msg sm_dopconfig_keywords \
		-menu_focus cluster_wide

	Menu_leaf SM_dopaction \
                -menu_accel "dopaction" \
                -menu_target "dopaction/dopaction" \
                -menu_keywords_msg sm_dopaction_keywords \
		-menu_focus cluster_wide

    } -menu_leaf_default_privs Security \
      -menu_help_volume sysman_menu \
      -menu_help_locid SM-security \
      -menu_accel security

    # This is a branch for software management
    Menu_branch SM_software {

	Menu_branch SM_software_installation {
	     Menu_leaf SM_software_install \
		-menu_accel "setldload" \
		-menu_target "setld/setldload/setldload" \
		-menu_keywords_msg sm_setldload_keywords \
		-menu_focus cluster_wide
	     Menu_leaf SM_software_list \
		-menu_accel "setldlist" \
		-menu_target "setld/setldlist/setldlist" \
		-menu_keywords_msg sm_setldlist_keywords \
		-menu_focus cluster_wide

	     Menu_leaf SM_software_remove \
		-menu_accel "setldd" \
		-menu_target "setld/setldd/setldd" \
		-menu_keywords_msg sm_setldd_keywords \
		-menu_focus cluster_wide

	} -menu_accel install

	Menu_branch SM_software_licenses {
	    # Menu_leaf SM_software_license_add
	    # Menu_leaf SM_software_license_issue
	    # Menu_leaf SM_software_license_list
	} -menu_accel licenses

    } -menu_leaf_default_privs SoftwareManagement \
      -menu_help_volume sysman_menu \
      -menu_help_locid SM-software \
      -menu_accel software
    

    Menu_branch SM_storage_management {

	# This branch is for filesystems management.
	Menu_branch SM_filesystems {

	    # This branch is for management of all filesystems types.
	    Menu_branch SM_fs_base {
		Menu_leaf SM_fs_dismount \
		    -menu_accel		"dismount" \
		    -menu_help_volume	none_available \
		    -menu_keywords	sm_fs_dismount_keywords \
		    -menu_target	"filesystems/dismount-file-system/fs_dismount"
		Menu_leaf SM_fs_df \
		    -menu_accel		"df" \
		    -menu_help_volume	none_available \
		    -menu_keywords	sm_fs_df_keywords \
		    -menu_target	"filesystems/display-mounted-file-systems/fs_df"
		Menu_leaf SM_fs_mount \
		    -menu_accel		"mount" \
		    -menu_help_volume	none_available \
		    -menu_keywords	sm_fs_mount_keywords \
		    -menu_target	"filesystems/mount-file-system/fs_mount"
	    }	-menu_accel		"generalfs" \
		-menu_help_volume	none_available

	    # This branch is for management of AdvFS file systems.
	    Menu_branch SM_fs_advfs {
	    }	-menu_accel		"advfs" \
		-menu_help_volume	none_available

	    # This branch is for management of UFS filesystems.
	    Menu_branch SM_fs_ufs {
		Menu_leaf SM_fs_newfs \
		    -menu_accel		"newfs" \
		    -menu_help_volume	none_available \
		    -menu_keywords	sm_fs_newfs_keywords \
		    -menu_target	"filesystems/newfs/fs_newfs"
	    }	-menu_accel		"ufs" \
		-menu_help_volume	none_available

	}   -menu_accel		"filesystems" \
	    -menu_help_volume	sysman_menu \
	    -menu_help_locid	SM-storage-management


	# This branch is for storage management.
	Menu_branch SM_storage_lsm {
	} -menu_accel		"lsm" \
	  -menu_help_volume	none_available

	Menu_leaf SM_bootable_tape  \
	    -menu_accel		"boot_tape" \
	    -menu_target	"bttape/bttape" \
	    -menu_keywords	sm_bootable_tape_keywords

	Menu_leaf SM_san_appliance  \
	    -menu_accel		"idsanappl" \
	    -menu_target	"sanappconfig/sanappconfig" \
	    -menu_focus		cluster_wide \
 	    -menu_keywords	sm_san_appliance_keywords

    }	-menu_leaf_default_privs	StorageConfiguration \
	-menu_help_volume		sysman_menu \
	-menu_help_locid		SM-storage-management \
	-menu_accel			storage


    Menu_branch SM_data_services {
	# Menu_leaf SM_data_serv_dmi_config
	# Menu_leaf SM_data_serv_dmi_deconfig
	# Menu_leaf SM_data_serv_ldap_config
	# Menu_leaf SM_data_serv_ldap_deconfig
	# Menu_leaf SM_data_serv_snmp_config
	# Menu_leaf SM_data_serv_snmp_deconfig

    } -menu_accel data_services

    Menu_branch SM_support_and_services {

    } -menu_leaf_default_privs SystemManagement \
      -menu_help_volume sysman_menu \
      -menu_help_locid SM-support-and-services \
      -menu_accel support

    # This is a branch for Trucluster specific management tasks
    Menu_branch SM_clusters {
	# Menu_leaf SM_clu_create
	# Menu_leaf SM_clu_show_members
	# Menu_leaf SM_clu_add_member
	# Menu_leaf SM_clu_delete_member
	# Menu_leaf SM_clu_aliases

	Menu_branch SM_caa {
        } -menu_accel caa	;# end CAA

	# Menu_lead SM_clu_ivp
	# Menu_leaf SM_clu_memory_channel_stats

    } -menu_leaf_default_privs ClusterManagement \
      -menu_help_volume sysman_menu \
      -menu_help_locid SM-clusters \
      -menu_accel clusters	;# end Clusters

    # This is a placeholder misc. management tasks that 
    # don't fall into the standard categories and are too small
    # to have cateories of their own. 
    Menu_branch SM_miscellaneous {

        Menu_leaf SM_shutdown  \
            -menu_accel "shutdown" \
            -menu_target "shutdown/shutdown" \
            -menu_keywords_msg sm_shutdown_keywords  \
	    -menu_focus both


	# Menu_leaf SM_power_mgmt 

        Menu_leaf SM_quicksetup  \
            -menu_accel "quicksetup" \
            -menu_target "qsetup/qsetup" \
            -menu_keywords_msg sm_qsetup_keywords 

    } -menu_leaf_default_privs SystemManagement \
      -menu_help_volume sysman_menu \
      -menu_help_locid SM-miscellaneous \
      -menu_accel general_tasks ;# end miscellaneous

} -menu_leaf_default_privs SystemManagement ;# End SM_SysmanMenu

