# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: sysman_menu_leaf_class.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:04:47  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.7.1  1999/12/16  20:57:03  William_Athanasiou
# 	sysman bulk submit for BL7
#
# Revision 1.1.2.34  1999/11/19  14:19:02  Peter_Wolfe
# 	Fix typos in Get_attributes. This code is for debugging only
#
# Revision 1.1.2.33  1999/04/27  02:53:08  Peter_Wolfe
# 	Fix for qar 70586. The -focus on the command line
# 	needs to set the default for the initial focus
# 	[1999/04/27  02:52:09  Peter_Wolfe]
#
# Revision 1.1.2.32  1999/02/23  03:57:28  Peter_Wolfe
# 	Add support for -list_hierarchy
# 	[1999/02/23  03:56:46  Peter_Wolfe]
# 
# Revision 1.1.2.31  1999/02/11  16:34:53  Peter_Wolfe
# 	Improve default for member specific apps
# 	[1999/02/11  16:34:23  Peter_Wolfe]
# 
# Revision 1.1.2.30  1999/02/10  06:05:37  Peter_Wolfe
# 	Stupid me didn't test this on a single system. (choose focus)
# 	[1999/02/10  06:05:17  Peter_Wolfe]
# 
# Revision 1.1.2.29  1999/02/09  03:24:08  Peter_Wolfe
# 	Add support for automatic use of Choose Focus Host dialog
# 	[1999/02/09  03:23:33  Peter_Wolfe]
# 
# Revision 1.1.2.28  1999/01/22  19:38:29  William_Athanasiou
# 	Add name to wait window
# 	[1999/01/22  19:38:13  William_Athanasiou]
# 
# Revision 1.1.2.27  1999/01/11  19:24:57  Peter_Wolfe
# 	Fix bug where sysman <accel> was supressing splahs screen
# 	[1999/01/11  19:24:20  Peter_Wolfe]
# 
# Revision 1.1.2.26  1998/12/07  17:58:24  William_Athanasiou
# 	Fix multiple invocation prob.
# 	[1998/12/07  17:57:34  William_Athanasiou]
# 
# Revision 1.1.2.25  1998/12/04  20:18:38  Peter_Wolfe
# 	Add -menu_focus support
# 	[1998/12/04  20:16:53  Peter_Wolfe]
# 
# Revision 1.1.2.24  1998/12/03  22:32:24  William_Athanasiou
# 	Fix global grab and refresh
# 	[1998/12/03  22:18:43  William_Athanasiou]
# 
# Revision 1.1.2.23  1998/10/29  15:52:15  Peter_Wolfe
# 	FIx cannot execute message
# 	[1998/10/29  15:52:02  Peter_Wolfe]
# 
# Revision 1.1.2.22  1998/10/27  13:58:25  Peter_Wolfe
# 	Re-enable splash screen for curses
# 	[1998/10/26  04:59:06  Peter_Wolfe]
# 
# Revision 1.1.2.21  1998/09/08  15:52:36  Peter_Wolfe
# 	Make menu keyword searches case insensitive
# 	[1998/09/05  02:32:54  Peter_Wolfe]
# 
# Revision 1.1.2.20  1998/08/13  04:37:49  Peter_Wolfe
# 	Fix debugging line
# 	[1998/08/11  04:25:14  Peter_Wolfe]
# 
# 	Add passing of -focus
# 	[1998/08/11  02:19:40  Peter_Wolfe]
# 
# Revision 1.1.2.19  1998/06/19  16:56:01  Fred_Cassirer
# 	Updated merge error, don't need to pass in menu args as dop alredy has these.
# 	[1998/06/19  16:55:33  Fred_Cassirer]
# 
# Revision 1.1.2.18  1998/06/17  19:25:36  Fred_Cassirer
# 	 	** Merge Information **
# 		** Command used:	bmerge **
# 		** Ancestor revision:	1.1.2.16 **
# 		** Merge revision:	1.1.2.17 **
# 	 	** End **
# 	Bmerged
# 	[1998/06/17  19:21:50  Fred_Cassirer]
# 
# 	Added support for _SUIT_SPLASH_SCREEN suppression
# 	Update to support dop actions
# 	[1998/06/15  21:14:03  Fred_Cassirer]
# 
# Revision 1.1.2.17  1998/06/05  20:03:48  Peter_Wolfe
# 	Fix _UIT_Suitlet invocation
# 	[1998/06/03  13:46:19  Peter_Wolfe]
# 
# 	Rework initialization code to avoid suit dependencies
# 	and allow faster startup and suitlet launching
# 	[1998/05/28  20:21:02  Peter_Wolfe]
# 
# Revision 1.1.2.16  1998/04/08  21:17:33  Fred_Cassirer
# 	 	** Merge Information **
# 		** Command used:	bsubmit **
# 		** Ancestor revision:	1.1.2.14 **
# 		** Merge revision:	1.1.2.15 **
# 	 	** End **
# 	Added "death of a child" support
# 	Added death of a child support, merged argument fixes from Pete
# 	[1998/04/08  20:47:19  Fred_Cassirer]
# 
# Revision 1.1.2.15  1998/04/07  15:17:14  Peter_Wolfe
# 	Fix bad command line passing bug. I wasn't passing
# 	the rest of the user's arguments - only the ones from
# 	the definition file itself.
# 	[1998/04/07  13:58:18  Peter_Wolfe]
# 
# Revision 1.1.2.14  1998/02/26  20:05:24  Peter_Wolfe
# 	Fix for 58523. Make idention of leaves clearer
# 	[1998/02/26  16:48:34  Peter_Wolfe]
# 
# Revision 1.1.2.13  1998/01/07  21:26:59  Peter_Wolfe
# 	Add show_all param to Get_tree_item_text to support -list
# 	[1998/01/07  21:05:42  Peter_Wolfe]
# 
# Revision 1.1.2.12  1998/01/06  22:04:36  Peter_Wolfe
# 	FIx bug where args being passed to Suitlet command were a list
# 	(i.e. needed an extra eval)
# 	[1998/01/06  22:03:52  Peter_Wolfe]
# 
# Revision 1.1.2.11  1997/12/09  17:26:21  Peter_Wolfe
# 	Add scroll param to Execute routine to keep it symmetric with
# 	a branch's execute routine.
# 	[1997/12/09  17:04:32  Peter_Wolfe]
# 
# Revision 1.1.2.10  1997/11/13  19:50:57  Peter_Wolfe
# 	menu_target instproc was accidentally deleted by the previous edit.
# 	Put it back.
# 	[1997/11/13  19:50:40  Peter_Wolfe]
# 
# Revision 1.1.2.9  1997/11/07  18:15:27  Richard_Taft
# 	Removed domain-specific Execute functions. Replaced with a call to Suitlet
# 	[1997/11/07  18:14:51  Richard_Taft]
# 
# Revision 1.1.2.8  1997/10/10  15:01:03  Peter_Wolfe
# 	Change SM_DisplayInfoMsg to SM_DisplayMsg generic routine
# 	[1997/10/10  14:50:24  Peter_Wolfe]
# 
# Revision 1.1.2.7  1997/08/07  18:04:15  Peter_Wolfe
# 	Fix cui suitlet launchinf by using system instead of exec
# 	Make web execute method call gui execute method.
# 	[1997/08/07  18:03:17  Peter_Wolfe]
# 
# Revision 1.1.2.6  1997/07/25  18:56:22  Fred_Cassirer
# 	Added support for arguments to target option.
# 	Changed the curses launch to use exec instead of source.
# 	[1997/07/25  18:51:37  Fred_Cassirer]
# 
# Revision 1.1.2.5  1997/07/02  23:04:36  Peter_Wolfe
# 	Add init proc. Consolidate info dialog processing
# 	[1997/07/02  22:59:37  Peter_Wolfe]
# 
# Revision 1.1.2.4  1997/07/01  14:54:39  Peter_Wolfe
# 	User fork/exec instead of system for executing tasks
# 	[1997/07/01  14:48:04  Peter_Wolfe]
# 
# Revision 1.1.2.3  1997/06/17  14:30:57  Peter_Wolfe
# 	Update for Display Accel's and Find Task By Keyword
# 	[1997/06/16  17:21:18  Peter_Wolfe]
# 
# Revision 1.1.2.2  1997/05/28  20:10:30  Peter_Wolfe
# 	Initial submit
# 	[1997/05/28  19:50:31  Peter_Wolfe]
# 
# $EndLog$
# 
# @(#)$RCSfile: sysman_menu_leaf_class.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:04:47 $
# 


############################################################################
#
# Name:
#	sysman_menu_leaf_class.tcl
#
# Abstract:
#	Main class definitions for the SysMan Menu leaves. 
#
# Notes:
#
# Class Description:
#	Menu_leaf is a subclass of Menu. A leaf is menu item that we 
#	can execute. Branch/leaves have several ploymorphic methods
#
############################################################################
#
Class Menu_leaf -superclass "Menu"

############################################################################
#
# Methods for the Menu_leaf object: 
#	- Init
#	- Execute
#	- Is_item_exapanded
#
############################################################################

#
# Procedure:
#	init - per-object instance initialization for menu leaf objects. 
#	Each menu item is represented by an object
# Inputs:
#	contents - any children menu items of this current item
#	args     - parameters (switches) for this menu item
# Outputs:
# 	None
# Returns:
#	None
# Notes:
# 	There is one nasty order-of-execution issue here. In Otcl, 
#	the "eval $self next $args" line causes the 
#	object's command line methods (Menu_leaf foo -menu_accel bar
#	where menu_accel is a method) to be invoked. That means that 
#	we have to initilize the objects instvars BEFORE the 
#	eval $self next $args line. This is different from 
#	C++ where you tend to init the superclass first and then 
#	override/init the subclass specific stuff later. 
#
Menu_leaf instproc init { args} {

    # Init our leaf specific instvars
    $self set target ""			;# Suitlet to execute
    
    eval {$self next ""} $args		;# Allow our superclass to init 

}
;# end Menu_leaf instproc init


#
# Procedure:
#	Menu_leaf Is_item_expanded - returns "no" unconditionally
#	since menu leaves don't expand
#
# Inputs:
#	None
# Outputs:
# 	None
# Returns:
#	None
# Notes:
#
Menu_leaf instproc Is_item_expanded { } {

    return "no"

} ;# end Menu_leaf Is_item_expanded

#
# Procedure:
#	Menu_leaf Execute - run the suitlet/mcl associated with this 
#       mcl. 
# Inputs:
# 	cursel_index - index of the selected menu item for this object
#		       Not used for a leaf 
#	scroll	     - true if selected item should be scrolled to top of 
#		       window. Not used for a leaf
# Outputs:
# 	None
# Returns:
#	None
# Notes:
#	In the case where we are invoked as "sysman foo" and foo
#	is a leaf, then we don't initialize SUIT (to avoid the
#	startup costs) and just launch the leaf directly. There
#	is of course a nasty catch 22 with this approach. The Suitlet
#	command is created dynamically since it is domain specific. 
#	We directly invoke the proper domain specific version. 
#
Menu_leaf instproc Execute { {cursel_index {}} {scroll {}} } {
    global SM_menu_main
    global SM_menu_def_root
    global SM_menu_tasks_dir
    global SM_menu_debug
    global SM_menu_ui_type
    global SM_arguments		;# User's command line arguments
    global SM_suit_initialized
    global SM_leaf_needs_focus_dialog;# True if leaf needs Choose Focus Host db
    global SysmanUi		;# Set by sysmansh
    global SysmanOnCluster	;# Set by sysmansh
    global env


    if { $SysmanOnCluster == 1 } {
	# If this app requires focus, then we display the Choose Focus 
	# Host dialog and the OK callback from there will dispath
	# Real_execute to do the actual launching. In that 
	# case, we need to 
	set focus_type [$self set focus]	;# Get this leaf's focus

	if { $focus_type != "none" && $focus_type != "cluster_wide" } {

	    $self display_focushost_db	;# Put up the Choose Focus Host db
	    return
	}
    }

    # If we reach here, then we no special focus is involved so 
    # launch the suitlet directly
    $self Real_execute


} ;# end Menu_leaf Execute


#
# Procedure:
#	Menu_leaf Real_execute - run the suitlet/mcl associated with this 
#       mcl. The execution phase had to broken across two steps:
#	Execute, the first proc that's called, checks
#	to see if the task needs focus. If so the Choose
#	Focus Host dialog is displayed. The OK callback
#	from that calls to here. If focus is not involved, then
#	Execute just passes through to us directly. 
# Inputs:
# 	cursel_index - index of the selected menu item for this object
#		       Not used for a leaf 
#	scroll	     - true if selected item should be scrolled to top of 
#		       window. Not used for a leaf
# Outputs:
# 	None
# Returns:
#	None
# Notes:
#	In the case where we are invoked as "sysman foo" and foo
#	is a leaf, then we don't initialize SUIT (to avoid the
#	startup costs) and just launch the leaf directly. There
#	is of course a nasty catch 22 with this approach. The Suitlet
#	command is created dynamically since it is domain specific. 
#	We directly invoke the proper domain specific version. 
#
Menu_leaf instproc Real_execute { {cursel_index {}} {scroll {}} } {
    global SM_menu_main
    global SM_menu_tasks_dir
    global SM_menu_debug
    global SM_menu_ui_type
    global SM_arguments		;# User's command line arguments
    global SM_suit_initialized
    global SysmanUi		;# Set by sysmansh
    global SysmanOnCluster	;# Set by sysmansh
    global env

    set cat ${SM_menu_main}.cat
    # Make sure the target exists for this menu item
    # It's a developer error if it doesn't
    if {[cequal [$self set target] ""] == 1 } {
	# Display the error: Error: menu task <this task> does not 
	# have an execution task defined for it. Please correct the 
	# menu definition file for this item and try again."
	set task_name [$self Get_item_text]
	SM_DisplayInfoMsg error error_task_has_no_target $task_name
	return
    }

    # For debugging, the tasks directory is a
    # list of directories. It defaults to /usr/share/sysman/menu/tasks. 
    # Suitlets live in subdirectories of this directory. Look in each 
    # until we find the given task file. 

    # The last element of the dirs list is the system default task 
    # directory  Save that away for use in any error messages below
    set default_tasks_dir [lindex $SM_menu_tasks_dir end]

    # Now search for the target in each of the directories
    set file [searchpath $SM_menu_tasks_dir [lindex [$self set target] 0]]

    # Set up some variables for any potential errors (so 
    # we don't dup code for the two cases below
    #
    # The target can contain arguments as well so we need to split the target
    # into suitlet name and arguments
    
    set task_name [$self Get_item_text]
    set task_file "$default_tasks_dir/[lindex [$self set target] 0]"
    set task_args "[lrange [$self set target] 1 end]"
    set task_accel [$self set accel]

 
    if { $SysmanOnCluster == 1 } {	;# If running on a cluster

	# If this host needs focus, adjust the arguments
	if { [$self info vars focushost] != "" } {
	    set focushost  [$self set focushost]
	    set SM_arguments "-focus $focushost $SM_arguments"
	}
    }



    if { $SM_menu_debug == "true" } {
	puts "Menu_leaf $self: Execute with args: |$task_args||$SM_arguments|"
    }

    if { $file == "" } {		;# If we can't find the task
	# Then display the error: Error invoking task "this task". 
	# The file: <this task's file> does not exist
	SM_DisplayInfoMsg error error_cannot_find_task_file \
			$task_name $task_file
	set SM_arguments ""		;# Clear command line args
	return
    } else {				;# run the suitlet/mcl

	if { [file executable $file] } {	 ;# If it's executable

	    # Run it! This is harder than it should be cause SUIT is 
	    # not initialized yet. We can't use the normal Suitlet command
	    # cause it doesn't exist yet (it's dynamically created at
	    # SUIT startup time). Instead, we explicitly create
	    # the correct _UIT_Suilet<domain> object. The init method
	    # for this object runs the specified suilet. 
	    # The one gotcha is that in the curses domain, we need
	    # to do a ctk_refresh (to avoid an issue where SUIT does
	    # two ctk_endwin's back to back causes an error.
	    # We also need to explicitly set SYSMANUI cause 
	    # otherwise the child process will inherit cli instead
	    # of of the default sysmansh (which has cui/ctk support). 
	    # We check to see if the shell has ctk support
	    # and if not, force the issue via the environment variable
	    global tk_port
	    if { $SM_menu_ui_type == "cui" || \
		 $SM_menu_ui_type == "cli" && [info exists tk_port] } {

		ctk_refresh
		set env(SYSMANUI) cui	;# If currently cli, force cui
	    }

	    # For the gui modes, we suppress the annoying splash screen and 
	    # use a watch cursor instead. There are two special cases
	    # where we leave the splash screen:
	    #   - if we are launching a leaf directly (e.g. sysman users)
	    #     There is no menu ui so the splash screen is needed
	    #   - in curses mode. Without the splash screen there
	    #     is an awkward moment when the screen is 
	    #     cleared but the launched suitlet hasn't started yet. 

            set env(_SUIT_SPLASH_SCREEN) 0

	    # If curses mode, enable splash
	    if { $SM_menu_ui_type == "cui"  || \
		 $SM_menu_ui_type == "cli"  || \
	         $SM_menu_ui_type == "menu"      } {
                set env(_SUIT_SPLASH_SCREEN) 1
	    } elseif { $SM_suit_initialized == "false" } {
		# We are running a accel directly (e.g. sysman users)
		set env(_SUIT_SPLASH_SCREEN) 1
	    }

	    # We don't pass arguments from the menu definition here as they are
	    # specified via the dop interface/actions. Any additional
	    # user-supplied arguments on our command line get passed in here.
	    # We call the lowerlevel _UIT_Suitlet<ui> directly
	    # cause in the case of sysman <accel> SUIT is not inited
	    # by the time we reach here. This is intentional - we don't
	    # want to incur the initialization cost twice!
	    set instance [eval { _UIT_Suitlet[SM_GetUI $SM_menu_ui_type] \
				    gensym $task_accel} $SM_arguments]
	    $instance label $task_name
	    $instance start -callback childExitCB
	} else {		;# Else no executable. Display an error
	   SM_DisplayInfoMsg error error_task_is_not_executable \
				    $task_name $task_file
	}

	set SM_arguments ""		;# Clear command line args

    } ;# end if we can't find the task
	


} ;# end Menu_leaf Real_execute

#
# Procedure:
#	menu_target - the name of a suitlet/mcl to execute when the user
#	chooses this menu item. 
# Inputs:
#	args - the filename of the suitlet/mcl
# Outputs:
# 	None
# Returns:
#	None
# Notes:
# 	
#
Menu_leaf instproc menu_target { target_name } {

    $self set target $target_name

}				 ;# end menu_target

#
# Procedure:
#	menu_keywords - msg. catalog identifier this menu items keywords
#
# Inputs:
#	kw_list - the name of the message catalog identifier for the 
#		   keyword list
# Outputs:
# 	None
# Returns:
#	None
# Notes:
# 	
#	
#	
#
Menu_leaf instproc menu_keywords { kw_list } {

    $self set keywords $kw_list

}				 ;# end proc menu_keywords


#
# Procedure:
#	menu_keywords_msg - This is the same as the above but is 
#	using the original, now deprecated instproc name. I need
#	to retain this for compatability with existing SUITlets. 
# Inputs:
#	msg_name - the name of the message catalog identifier for the 
#		   keyword list
# Outputs:
# 	None
# Returns:
#	None
# Notes:
#
Menu instproc menu_keywords_msg { msg_name } {

    $self set keywords $msg_name

}				 ;# end proc menu_keywords_msg

#
# Procedure:
#	menu_focus - Type of cluster focus appropriate for this leaf. 
#	The valid values are:
#		member_specific - this app requires member focus
#				  (e.g. configure interfaces). This
#				  is a cluster aware app
#		cluster_wide	- this app operates only on shared data
#				  (e.g. account manager)
#		none		- this app is not cluster aware (e.g. 
#				  vmstat). It needs to run on the local member
#		both		- this app can do cluster wide or member
#				  specific operations (e.g. nfsconfig
#				  via rc.config.common and rc.config
#       Note that the default is none 
# Inputs:
#	type - the focus type for this app
# Outputs:
# 	None
# Returns:
#	None
# Notes:
#
Menu instproc menu_focus { type } {

    $self set focus $type

}				 ;# end proc menu_focus

#
# Procedure:
#	Get_tree_item_text - returns the display string for this menu leaf
#	We use a vertical bar to represent the tree structure. For example:
#	    + Accounts
#	    + Event Management
#	    + Monitoring and Tuning
#	    - Networking
#	       + Configuration
#	       | Network Interfaces daemon status
#	       | {Re}start Network Services
#
# Inputs:
#	accel - true if the menu accelerator should be displayed
#		along with the menu text
#       show_all - not used for a menu leaf
# Outputs:
# 	None
# Returns:
#	None
# Notes:
#
Menu_leaf instproc Get_tree_item_text { {accel {}} {show_all {} }} {

    # Prepend a leading space so that the leaf's text aligns
    # aligns with the text of a +/- branch item
    return "| [$self Get_item_text $accel]"

}			;# end instproc Get_tree_item_text

#
# Procedure:
#	addSubtree - for a menu leaf it's an error to attempt
#	to add a subtree to it. It's possible to attempt this accidentally
#	however (when customizing the menu) so we want to handle it 
#	gracefully by displaying a warning. 
#
# Inputs:
#	st - the name of the branch to add to 
# Outputs:
# 	None
# Returns:
#	None
# Notes:
#
Menu_leaf instproc addSubtree {st} {
    global SM_menu_main


    # Display the message: Warning: You cannot add <subtree name> as 
    # a subtree of <this leaf> because <this leaf> is a menu leaf
    SM_DisplayInfoMsg error error_child_added_to_leaf $st $self
    
}			;# end instproc addSubtree


#
# Procedure:
#	display_focushost_db - creates the appropriate list
#	entries for the Choose Focus Host db, populates the list
#	box and displays the db. We do this here as an instproc
#	cause the SUIT displayCB doesn't take arguments. I don't
#	want to pass the data via globals. (ie. the object, it's 
#	focus type, etc.)
#
# Inputs:
#	SM_last_focus_type - this global is set after the user
#	makes a selection from the list box
# Outputs:
# 	None
# Returns:
#	None
# Notes:
#	The user doesn't know or care that we are jamming a new list
#	into the listbox every time. We have to preserve the last
#	selected item whenever possible. The trick is that
#	one version of the list box has the alias in it and the 
#	other doesn't. IOW, he might run a "both" app and then 
#	a member-specific app. If he selects the alias when he runs
#	the "both" app and then the first member for the member specific app, 
#	what should be the default selection when he runs the next
#	"both" app? The rule will be the last selected item wins so 
#	the member will win. If the order was memeber-specific app, both/alias 
#	app, member_specific app then the last selected member-specific
#	node will be selected. Stated a simpler way. Anytime you pick a member,
#	that member will be the default selection in the next dialog. 
#	Anytime you choose an alias (i.e. a both app), the alias will be
#	the default if the next app is also a both app. 
#
Menu_leaf instproc display_focushost_db {} {

    global SM_menu_debug
    global SM_alias_selected		;# True if alias selected 
    global SM_last_selected_member	;# Last member selected
    global SysmanFocusHost

    set list members_db.members_list	;# Shorter name is easier

    set max_name_len 0		;# Longest member name we've seen
    set mem_list ""


    if { [$self set focus] == "both" } {
	# First entry is the list is the alias name
	lappend mem_list "[cluster alias] up"
	set max_name_len [string length "[cluster alias]" ]
    }

    set members [cluster member all]	;# Get all the member names
    set members [lsort $members]	;# Sort them (but not the alias)
    foreach member $members {

	# Get state (up or down)
	set mem_status [cluster member status $member]
	# Map this to the proper enum value
	set mem_status [expr {($mem_status == 1) ? "up" : "down" } ]

	# This member name and state to the list
        lappend mem_list "$member $mem_status"

	# Keep track of longest name we've seen
	set len [string length $member]
	set max_name_len [expr max ($max_name_len, $len)]	

    } ;# end for each member


    # Now that we have the whole list, format it properly for
    # two columns based on the longest name in the first column
    foreach item $mem_list {
	lappend formatted_list \
		[format "%-${max_name_len}s  %s" \
		    [lindex $item 0] [lindex $item 1] ]
    }
    
    # Now convert to a suit list. Note that we make the list's
    # user-data the name of this object. That was we can 
    # easily get the proper object in the OK callback and not
    # resort to passing via globals. 
    set suit_list ""
    foreach item $formatted_list {
	$list setListItem suit_list $item $self
    }

    # Whew! Stuff it into the list box.
    $list setVal $suit_list

    # Preserve last selected item. What a royal pain in butt this
    # is!!! Just take is slow and steady....

    if {[info exists SM_last_selected_member] == 0 } {	;# If first time

        # The first time you see the dialog we want the following
        # defaults. If it's a "both" app then the default is 
        # the alias. If it's a member-specific app, the default
	# is the node you are on. If -focus is specified on the 
	# command line, then it wins. 
        # This is a critial UI default.

	# Default to member we are on to start with
	set SM_last_selected_member [cluster member name]

	# If -focus specified on the command line, then
	# use that member. 
	# Note that -focus <alias> leaves SysmanFocusHost set to ""
	# That means we can't distinguish between no -focus on the command
	# line and explicit focus to a alias
	if { $SysmanFocusHost != "" } {
	    set SM_last_selected_member $SysmanFocusHost
	} 

	# If this leaf can take alias focus  
	if { [$self set focus] == "both" } {	

	    # And explicit focus  wasn't on the command line, 
	    # set the alias selected.
	    if { $SysmanFocusHost == "" } {
		$list setSelection 0		;# Set alias selected
		set SM_alias_selected true	;# Flag we did that
	    } else {				;# Member focus on command line
		set SM_alias_selected false
		set member_index \
			[lsearch -exact $members $SM_last_selected_member]
		# First list item is the alias so add 1 to get the node
		# position
		$list setSelection [expr $member_index + 1]
	    }

	} else {				;# Else member-specific

	    set SM_alias_selected false
	    set member_index [lsearch -exact $members $SM_last_selected_member]
	    $list setSelection $member_index
	}

    } else {					;# Nth time though

	# If the current app can take alias focus...
	if { [$self set focus] == "both"} {

	    # and the previous app did chose that, then default to the alias
	    if {$SM_alias_selected == "true"} {
		$list setSelection 0	;# Set first item (alias) selected
	    } else {			;# Else select the last member
		# Find his position in the sorted list
		set pos [lsearch -exact $members $SM_last_selected_member]
		
		# Check to make sure the guy we want to select is 
		# still in the list - might have clu_del_member'd on us!
		if { $pos == -1 } {
		    $list setSelection 0	;# Select alias
						;# Set 1st member as default
		    set SM_last_selected_member [lindex $members 0]
		} else {			;# Found him, so select him
		    # Add one to compensate for the alias
		    incr pos
		    $list setSelection $pos
		}

	    } ;# end if alias was selected

	} else {			;# No alias in the dialog,
					;# just use last selected member
	    
	    if { $SM_menu_debug == "true" } {
		puts "display_focushost_db: last sel $SM_last_selected_member"
	    }

	    # Check to make sure the guy we want to select is 
	    # still in the list - might have clu_del_member'd on us!
	    set pos [lsearch -exact $members $SM_last_selected_member]
	    if { $pos == -1} {
		# If he's not still in the list, default to first item
		$list setSelection 0	;# Set first member selected
		set SM_last_selected_member [lindex $members 0]
	    } else {			;# Guy's still in the list
		$list setSelection $pos
	    }

	} ;# end if last focus was alias

    } ;# end if first time through


    # Make sure it's on-screen
    $list setViewable selected

    members_db display
    
}			;# end instproc display_focushost_db

#
# Procedure:
#	Get_attributes - format a leaf's attributes for displaying
#	a formatted menu hierarchy
#
# Inputs:
#	indent - string of spaces to indent with
# Outputs:
# 	None
# Returns:
#	formatted string of this leaf's attrs in the form:
#	   -menu_<attr1> value
#	   ...
#	   -menu_<attrN> value
# Notes:
#	Ug.. Should have named all the menu object attributes with 
#	a common prefix so they could be programmatically obtained instead
#	of enumerated here. 
#
Menu_leaf instproc Get_attributes { indent} {

	
    set attrs ""
    set indent "$indent   "		;# Add more indentation

    if { [$self set accel] != "" } {	;# Accelerator
	append attrs "\n$indent -menu_accel [$self set accel]"
    }
    if { [$self set target] != "" } {	;# Target
	append attrs "\n$indent -menu_target [$self set target]"
    }
    if { [$self set privs] != "" } {	;# Privs
	append attrs "\n$indent -menu_privs [$self set privs]"
    }
    if { [$self set keywords] != "" } {	;# Keywords
	append attrs "\n$indent -menu_keywords [$self Get_keyword_list]"
    }
    if { [$self set catalog] != "" } {	;# Catalog
	append attrs "\n$indent -menu_catalog [$self set catalog]"
    }
    if { [$self set help_volume] != "" } {	;# Help vol. 
	append attrs "\n$indent -menu_help_volume [$self set help_volume]"
    }
    if { [$self set help_locid] != "" } {	;# Help locid
	append attrs "\n$indent -menu_help_locid [$self set help_locid]"
    }
    if { [$self set focus] != "" } {	;# Help locid
	append attrs "\n$indent -menu_focus [$self set focus]"
    }
	
    return $attrs
    
}			;# end instproc Get_attributes
