#!/usr/share/sysman/bin/sysmansh
# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: evmviewer.cb.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:04:47  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.24.3  2002/08/27  16:15:19  Anthony_Hoffman
# 	QAR 94707 - fix regression with filter dialog apply and ok button
# 	move code to generate temp file name after if test to see if the filter
# 	changed since last time. Code is in load_summaries.
#
# Revision 1.1.24.2  2002/05/31  18:44:27  Anthony_Hoffman
# 	make changes per symlink_submit code review
# 	[2002/05/30  20:01:51  Anthony_Hoffman]
#
# 	redo of QAR 88391 - replace /usr/lbin/mkstemp with /usr/bin/mktemp
# 	[2002/05/21  13:29:57  Anthony_Hoffman]
#
# Revision 1.1.24.1  2001/11/27  19:45:09  Anthony_Hoffman
# 	QAR 88391
#
# Revision 1.1.2.65  2001/06/29  14:27:35  Anthony_Hoffman
# 	QAR 88391 - temp file security issue
#
# Revision 1.1.2.64  2001/02/13  20:22:50  Anthony_Hoffman
# 	QAR 82337 - resolves problem with filter dialog month popup windows
# 	this fixes the problem for now but something more general should
# 	be found.  The problem is with the return values of nl_langinfo.
#
# Revision 1.1.2.63  2000/05/24  20:39:36  Anthony_Hoffman
# 	remerge cosix work back into sysman,
# 	includes fix for qar 79805 - braces in format message
#
# Revision 1.1.18.1  2000/05/04  20:11:58  Peter_Wolfe
# 	Move from sysmanzc to cosixzulu
#
# Revision 1.1.16.1  2000/04/12  19:53:44  Anthony_Hoffman
# 	COSIX cleanup
#
# Revision 1.1.14.5  2000/03/17  17:12:18  Sai_Akkapeddi
# 	Code drop for Zulu BL9 (second drop)
#
# Revision 1.1.2.61  2000/03/10  16:14:19  Anthony_Hoffman
# insert eval in front of exec to fix qar 78355
#
# Revision 1.1.2.60  2000/01/27  20:49:15  Anthony_Hoffman
# 	add focus support, fix greying out in filter box
#
# Revision 1.1.2.59  2000/01/17  20:32:54  Anthony_Hoffman
# 	support for qar fix 70454 - when sorting by format use @@
#
# Revision 1.1.2.58  1999/12/16  18:29:52  Anthony_Hoffman
# 	qar 71423
#
# Revision 1.1.2.57  1999/10/22  15:13:36  Anthony_Hoffman
# 	fix qar 73012 - add double click callback for options menu
#
# Revision 1.1.2.56  1999/10/12  20:38:13  Anthony_Hoffman
# 	change ok to exit
#
# Revision 1.1.2.55  1999/06/15  20:09:17  Anthony_Hoffman
# 	change tasks to db-main
# 	[1999/06/15  20:08:57  Anthony_Hoffman]
#
# Revision 1.1.2.54  1999/06/15  19:37:23  Anthony_Hoffman
# 	make _hometopic tasks, thanks to Sandip
# 	[1999/06/15  19:37:10  Anthony_Hoffman]
# 
# Revision 1.1.2.53  1999/06/15  18:38:12  Anthony_Hoffman
# 	fix SMS help problem - change w-main to _hometopic
# 	[1999/06/15  18:37:42  Anthony_Hoffman]
# 
# Revision 1.1.2.52  1999/04/26  14:02:38  Anthony_Hoffman
# 	Fix qar 70461 and 70933
# 	close pipe to clean up defunct processes
# 	remove spaces from "equal to" so comparisons are correct
# 	[1999/04/26  14:01:41  Anthony_Hoffman]
# 
# Revision 1.1.2.51  1999/03/24  18:18:10  Anthony_Hoffman
# 	fix frink warning
# 	[1999/03/24  18:17:43  Anthony_Hoffman]
# 
# Revision 1.1.2.50  1999/03/19  20:54:18  Anthony_Hoffman
# 	change evmshow -f filter -F option
# 	[1999/03/19  20:53:59  Anthony_Hoffman]
# 
# Revision 1.1.2.49  1999/03/10  15:24:36  Anthony_Hoffman
# 	enhance advanced filter code to use new filter file syntax and evmshow -F
# 	option
# 	[1999/03/10  15:24:03  Anthony_Hoffman]
# 
# Revision 1.1.2.48  1999/02/26  20:59:57  Anthony_Hoffman
# 	QAR 65239 - fixed get events from dialog, it now displays last data
# 	entered when the ok/apply was pressed. All other fields are cleared. It
# 	also no longer tries to default the fields from cli input.
# 	[1999/02/26  20:59:31  Anthony_Hoffman]
# 
# Revision 1.1.2.47  1999/02/26  16:08:26  Anthony_Hoffman
# 	re-align dashes under host and cluster headings to be centered
# 	QAR 67937
# 	[1999/02/26  16:06:52  Anthony_Hoffman]
# 
# Revision 1.1.2.46  1999/02/08  15:40:43  Anthony_Hoffman
# 	performance fix to load_events
# 	[1999/02/08  15:40:21  Anthony_Hoffman]
# 
# Revision 1.1.2.45  1999/02/01  16:08:29  Anthony_Hoffman
# 	fix qars 67223 and 67828
# 	[1999/02/01  16:06:20  Anthony_Hoffman]
# 
# Revision 1.1.2.44  1999/01/19  21:50:28  Anthony_Hoffman
# 	fix qars 67257 and 67389
# 	[1999/01/19  21:49:56  Anthony_Hoffman]
# 
# Revision 1.1.2.43  1998/12/07  19:32:25  Anthony_Hoffman
# 	fix qar 66363 - add double click to get event details
# 	[1998/12/07  19:31:50  Anthony_Hoffman]
# 
# Revision 1.1.2.42  1998/12/03  20:34:40  Anthony_Hoffman
# 	check for empty event source file - QAR 65238
# 	[1998/12/03  20:33:51  Anthony_Hoffman]
# 
# Revision 1.1.2.41  1998/11/05  21:26:04  Girish_Malangi
# 	-fixed QAR 65235.
# 	-improved error messages and error handling when using EVM
# 	 utilities.
# 	[1998/11/05  21:22:41  Girish_Malangi]
# 
# Revision 1.1.2.40  1998/10/27  20:04:36  Girish_Malangi
# 	-added callback for newly added "Refresh" button.
# 	[1998/10/27  20:03:39  Girish_Malangi]
# 
# Revision 1.1.2.39  1998/10/23  15:42:05  Girish_Malangi
# 	-used getUI method to get domain rather than from
# 	 environment variable SuiUi.
# 	[1998/10/23  15:41:35  Girish_Malangi]
# 
# Revision 1.1.2.38  1998/10/23  15:24:01  Girish_Malangi
# 	-put in changes to handle event retrieval from
# 	 multiple remote hosts.
# 	[1998/10/23  15:22:44  Girish_Malangi]
# 
# Revision 1.1.2.37  1998/10/13  19:28:54  Girish_Malangi
# 	-number of spaces provided for 'pid' event item
# 	 has been changed from 6 to 10 in the display.
# 	-all user input will be trimmed of white spaces
# 	 on either ends.
# 	-removed callback for Number of Events to Display
# 	 dialog. This is now accomodated in the Customize
# 	 dialog.
# 	-the default value for advanced filter will be a
# 	 blank. The default values for the date fields
# 	 will be the current date.
# 	-added new titles for all InfoMsg boxes.
# 	[1998/10/13  19:27:09  Girish_Malangi]
# 
# Revision 1.1.2.36  1998/09/16  18:44:33  Girish_Malangi
# 	-made changes to proc check_file.
# 	[1998/09/16  18:43:49  Girish_Malangi]
# 
# Revision 1.1.2.35  1998/09/15  15:02:15  Girish_Malangi
# 	-Made changes to wSaveAdvanced and wDetSave callbacks.
# 	[1998/09/15  15:01:40  Girish_Malangi]
# 
# Revision 1.1.2.34  1998/09/14  20:26:55  Girish_Malangi
# 	-FROM THIS VERSION ONWARDS THE MCL COMPONENT HAS
# 	 BEEN DEFUNCTED.
# 	-Total rewrite of the callback file since the
# 	 Mcl file has been defuncted. Too many changes to
# 	 list.
# 	[1998/09/14  20:10:41  Girish_Malangi]
# 
# Revision 1.1.2.32  1998/07/14  21:27:29  Girish_Malangi
# 	-moved suitlet initialization code from genUID file to
# 	 the callback file.
# 	-removed all references to the repeat flag since we
# 	 do not use it anymore.
# 	-made changes to proc error_check_filter.
# 	-added some more validation while saving a advanced
# 	 filter.
# 	[1998/07/14  21:17:08  Girish_Malangi]
# 
# Revision 1.1.2.31  1998/05/20  22:15:12  Girish_Malangi
# 	-added exitCB proc. This proc catches the interrupt signals.
# 	 Moved cleanup proc from evmviewer file to cb file. QAR 57093.
# 	-increased width for timestamp so as to accomodate the
# 	 new timestamp format.
# 	-implemented the Label method to change labels
# 	 dynamically as recommended by SUIT.
# 	-added code to catch errors caused by invalid hostname passed
# 	 through command line. (QAR 60798)
# 	-added code to exit application if evmget or evmshow or evmsort
# 	 fails.
# 	[1998/05/20  22:09:27  Girish_Malangi]
# 
# Revision 1.1.2.30  1998/04/23  21:43:24  Girish_Malangi
# 	*** empty log message ***
# 	[1998/04/23  21:41:54  Girish_Malangi]
# 
# 	-changed "Time" in SummaryHeaders to "Timestamp" on suggestion
# 	 of the EVM team.
# 	-changed implementation of the callback for wSource so that
# 	 EVM error messages are now captured to a file and displayed
# 	 to the user in a pop up dialog box. QAR 60515.
# 	-removed the callbacks for the Apply buttons in the Save dialogs.
# 	 This is so since the Apply buttons are removed from the Save
# 	 dialogs. QAR 60529.
# 	-changed the implementation of print dialogs so that if a error
# 	 occurs while executing the print command the error is displayed
# 	 to the user through a error dialog.
# 	-changed slightly the implementation of the proc error_check_filter.
# 	-added proc check_app_errors to support the capturing of errors
# 	 to a file rather putting them out to stdout.
# 	[1998/04/23  16:53:21  Girish_Malangi]
# 
# Revision 1.1.2.29  1998/04/10  00:39:35  Girish_Malangi
# 	-modified the process_cli_arg procedure to handle filters passed from
# 	 the command line.
# 	-added help locid to the Summary window.
# 	-modified Page callback to handle non numeric strings.
# 	-reimplemented the filter validation procedure since it did not validate
# 	 non numeric strings. Now the procedure also sets invalid values in the
# 	 inactive filters to default. This is on suggestion of human factors.
# 	 The procedure error_check_unchecked_fields has now been removed since
# 	 it becomes redundant.
# 	-modified apply_save procedure so that the user is notified if the
# 	 filter could not be saved.
# 	[1998/04/10  00:21:10  Girish_Malangi]
# 	-added code to catch errors when saving summaries and details to file.
# 	-removed the set_default_values proc since the initialization of
# 	 the filter attributes and setting the host to local is now done in
# 	 the evmview.mcl file. The initialization is done only once
# 	 i.e. during startup.
# 	[1998/04/04  00:25:31  Girish_Malangi]
# 
# Revision 1.1.2.28  1998/03/31  20:29:19  Girish_Malangi
# 	-added callback procedures for the separate Advanced Filter dialog.
# 	-moved the signal handler and cleanup procedure to the evmviewer file.
# 	 This is so that the signal handler and the cleanup procedure are
# 	 read before the tmp files are created.
# 	-added wait signals for all the windows.
# 	-changed the name of some help volumes as per the Doc group's request.
# 	-included an info message in the wSource callback to notify the
# 	 user if no events are found.
# 	-added a catch to the SummSave callback so as to inform the user if
# 	 there was an error saving the summaries.
# 	-moved all Info message strings to the evmviewer.msg file.
# 	[1998/03/31  19:28:36  Girish_Malangi]
# 
# Revision 1.1.2.27  1998/03/16  22:47:27  Jovanna_Ignatowicz
# 	human factors changes in wOptions buttons
# 	[1998/03/16  22:46:39  Jovanna_Ignatowicz]
# 
# Revision 1.1.2.26  1998/03/16  22:15:32  Girish_Malangi
# 	- added procedure set_default_values to set the gSuitState
# 	  attributes except the Show attributes to default when appl'n
# 	  terminates. Also removed the set_filter_defaults procedure since
# 	  it becomes redundant after adding set_default_values.
# 	- removed the cleaning up code in wSummary.ok procedure and put
# 	  the call for cleanup procedure in the same. The cleanup procedure
# 	  now handles all the cleaning up when appl'n terminates.
# 	[1998/03/16  21:34:16  Girish_Malangi]
# 
# 	-moved the signal handler from evmviewer file to callback file
# 	-added a catch to the cleanup procedure. This catches any
# 	 exceptions while deleting the tmp files.
# 	-added a fix to the display of the hostname in the event
# 	 summaries window. The fix truncates the hostname so that only
# 	 the first part of the name i.e. up till the first "."(period)
# 	 is displayed.
# 	[1998/03/13  21:13:58  Girish_Malangi]
# 
# Revision 1.1.2.25  1998/03/03  18:34:26  Jovanna_Ignatowicz
# 		-removed key calls- replaced with getSelUserData
# 	[1998/03/03  18:29:37  Jovanna_Ignatowicz]
# 
# Revision 1.1.2.24  1998/02/21  19:27:14  Jovanna_Ignatowicz
# 		-added callbacks for the wOptions dialog apply button
# 		-QAR 56264- added function error_check_unchecked_fields to check
# 	          bad values in the filter widgets
# 	          -added resetting of filter defaults to the cleanup() func
# 	[1998/02/21  19:26:13  Jovanna_Ignatowicz]
# 
# Revision 1.1.2.23  1998/01/30  20:00:31  Jovanna_Ignatowicz
# 		- QAR 56264 added validation fuctions error_check_before_filter()
# 	          and error_check_since_filter() for QAR
# 	[1998/01/30  19:50:40  Jovanna_Ignatowicz]
# 
# 		-QAR 57148 check environment variable for placement of
# 	 	  temporary files
# 		-added process_cli_arguments() process_cli_arg() and
# 	          moved some code from WSummaries DisplayCB to
# 		  load_summaries
# 	        -added callback to the filters button which was moved
# 		  from a listbox to a button on the main window
# 		-changed wSource initCB to displayCB because the
# 	          checks need to be done every time the window
# 		  displays
# 	        -added advanced filter to error_check_filter
# 	[1998/01/29  17:53:03  Jovanna_Ignatowicz]
# 
# Revision 1.1.2.22  1998/01/08  20:30:58  Jovanna_Ignatowicz
# 		-QAR 57133 -fixed help (removed code to call dthelpview
# 				directly and left helpOn)
# 	        -added code to alert the user when a filter is applied
# 		  and no events are found
# 	[1998/01/08  20:22:08  Jovanna_Ignatowicz]
# 
# Revision 1.1.2.21  1998/01/08  17:12:11  Jovanna_Ignatowicz
# 		-QAR 57121 -added equality checks in error_check_filter
# 	                     to formulate the filter string
# 			   -added equality initializers in wFilter initCB
# 	[1998/01/08  17:06:18  Jovanna_Ignatowicz]
# 
# Revision 1.1.2.20  1997/12/11  18:24:22  Jovanna_Ignatowicz
# 		-QAR 57095
# 		   -added code in error_check_filter() to check the chosen
# 	             priority type (range, absolute, min, max)
# 	[1997/12/11  18:22:42  Jovanna_Ignatowicz]
# 
# 		-QAR 57126 added a header saved summaries
# 	  		    that states the page and the host
# 	  	            removed line numbers for summaries (kept
# 	 	 	    one space for left hand margin)
# 	[1997/12/09  18:48:49  Jovanna_Ignatowicz]
# 
# Revision 1.1.2.19  1997/11/30  17:34:17  Jovanna_Ignatowicz
# 	QAR 56241- added save options dialog, messages and callbacks for summary and details save
# 	[1997/11/30  17:10:14  Jovanna_Ignatowicz]
# 
# Revision 1.1.2.18  1997/10/29  21:09:23  Jovanna_Ignatowicz
# 		-QAR 56166 - added an error check- check that a remote
# 	                     host is specified if the remote toggle is
# 	                     set in the source host dialog
# 	[1997/10/29  21:06:15  Jovanna_Ignatowicz]
# 
# Revision 1.1.2.17  1997/10/29  20:02:51  Jovanna_Ignatowicz
# 		-QAR 56441 added function set_summary_window_label to
# 	                   display the name of the host the events are
# 	                   retrieved from in the event summary list label
# 	[1997/10/29  19:53:07  Jovanna_Ignatowicz]
# 
# 		-QAR 56300 viewer tries to connect to unknown
# 	           -added an initCB function to wSource
# 	             that sets the host to remote if there is one
# 	             specified in the mcl, or local if not
# 	           -in the wSource apply callback, ignore the
# 	             remote host string if the local host toggle
# 	             is set
# 	[1997/10/27  17:54:13  Jovanna_Ignatowicz]
# 
# Revision 1.1.2.16  1997/09/25  21:18:49  Jovanna_Ignatowicz
# 		-modified SummaryHeaders to have an extra space for EventId
# 	        -check if there is only one page in "Go to Page". Pop up
# 	            a warning if there is
# 	        -replaced calls to SUITbell with descriptive message dialogs
# 	            (the bell doesn't work on remote systems)
# 	        -retrieve the repeat flag as well as option strings from
# 		    message catalog
# 	        -changed error_check_filter to check if the
# 	            each filter is valid before applying all of them as one
# 	[1997/09/25  21:15:48  Jovanna_Ignatowicz]
# 
# Revision 1.1.2.15  1997/09/22  14:58:59  Jovanna_Ignatowicz
# 		-HF input:   added callback and error checking funtions to the
# 				"go to page" dialog
# 			     changed the "*" symbol for repeated events to "R"
# 			     modified options dialog box to contain a list
# 			    	of options as opposed to having a rows of buttons
# 	        	     in wSummary_wList_sel_change, added code to change
# 			        pages if valid when user changes details off
# 		                the current page
# 			     added error checking to fields of the filter dialog
# 	[1997/09/17  15:06:39  Jovanna_Ignatowicz]
# 
# Revision 1.1.2.14  1997/08/22  18:52:06  Jovanna_Ignatowicz
# 		-added the function code to go to the last event or first
# 	          event in the event details subdialog
# 	[1997/08/22  16:11:17  Jovanna_Ignatowicz]
# 
# 		-human factors: added callback to the options button in the main
# 		  dialog, created callbacks for options dialog and moved callbacks
# 	          to options dialog section for buttons that were in the main
# 	          dialog before the change
# 	[1997/08/15  17:58:35  Jovanna_Ignatowicz]
# 
# 		usability review- changes in button configurations needed change
# 		  in the button proc callbacks
# 	[1997/08/14  20:23:14  Jovanna_Ignatowicz]
# 
# Revision 1.1.2.13  1997/08/05  19:11:13  John_Hainsworth
# 	Incorporated suggestions from code review.
# 	Added SUITwait calls.
# 	[1997/08/05  19:08:36  John_Hainsworth]
# 
# Revision 1.1.2.12  1997/07/25  21:34:48  John_Hainsworth
# 	Added display of dUniqueId to the event summaries table.
# 	Combined "Page %d of %d" into one non-editable text field.
# 	[1997/07/25  21:27:01  John_Hainsworth]
# 
# Revision 1.1.2.11  1997/07/24  21:05:10  John_Hainsworth
# 	Remove temporary filename when shutting down.
# 	Fixed bug in printing event details.
# 	[1997/07/24  21:03:24  John_Hainsworth]
# 
# Revision 1.1.2.10  1997/07/21  21:42:34  John_Hainsworth
# 	replaced {} with "" wherever possible (for Tcl 8.0 compatability).
# 	Added file append/write option.
# 	[1997/07/21  21:41:52  John_Hainsworth]
# 
# Revision 1.1.2.9  1997/07/18  22:45:56  John_Hainsworth
# 	Changed attr names in gSummaries Mcl group to eliminate translations.
# 	Fix db-filters help tag.
# 	Added page handling interface.
# 	[1997/07/18  22:45:12  John_Hainsworth]
# 
# Revision 1.1.2.8  1997/07/11  19:37:42  John_Hainsworth
# 	Commented sort out of UI in preparation for code drop.
# 	Changed "cancel" to standard "ok" buttons in wDetails & wSummary.
# 	Added the help tags defined by Tom Zanfagna.
# 	[1997/07/11  19:36:56  John_Hainsworth]
# 
# 	Moved filter generation down to the Mcl.
# 	[1997/07/08  22:45:19  John_Hainsworth]
# 
# Revision 1.1.2.7  1997/07/07  15:17:59  John_Hainsworth
# 	Add comments and improve pagination.
# 	Make Details Next & Previous update the title.
# 	Added repeat count.
# 	[1997/07/07  15:14:49  John_Hainsworth]
# 
# Revision 1.1.2.6  1997/06/25  15:20:29  John_Hainsworth
# 	Implemented per-dialog help support.
# 	Partially implemented sort.
# 	Fixed bug: do not allow the user to get details on table header lines.
# 	Implemented Details Next & Previous buttons.
# 	Commented out Find buttons.
# 	[1997/06/25  15:19:04  John_Hainsworth]
# 
# Revision 1.1.2.5  1997/06/18  18:34:59  John_Hainsworth
# 	Make all Event summary fields be strings; no numerics.
# 	Implemented details & summary save & print.
# 	Implemented %d in filename for saving event details.
# 	Removed _parent stuff.
# 	[1997/06/18  18:30:22  John_Hainsworth]
# 
# Revision 1.1.2.4  1997/05/28  22:18:50  John_Hainsworth
# 	Changed wOk,wCancel,wApply,wHelp --> ok,cancel,apply,help
# 	Generated information correctly for getting event details.
# 	Eliminated all permGlobals (get all UserPrefs from Mcl).
# 	[1997/05/23  18:53:22  John_Hainsworth]
# 
# Revision 1.1.2.3  1997/05/19  20:50:54  John_Hainsworth
# 	Changed filenames.
# 	[1997/05/19  20:48:37  John_Hainsworth]
# 
# Revision 1.1.2.2  1997/05/19  15:38:52  John_Hainsworth
# 	Created.
# 	[1997/05/19  15:37:37  John_Hainsworth]
# 
# $EndLog$
# 
# @(#)$RCSfile: evmviewer.cb.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:04:47 $
##++ 
## MODULE:	evmviewer.cb.tcl
##
## ABSTRACT:	SUIT callback file for the EVM event viewer.
##--
## NOTES:	
## - Overview of EVM viewer:
##
##   The primary function of the EVM viewer is to display a list of events
##   from the event log as directed the user.  The user can control the
##   following characteristics of this event list:
##	- The set of events selected for display (filtering)
##	- The order of the list (sorting)
##	- The location of the event log (remote host selection)
##	- The information displayed for each event (visible items)
##   The viewer also provides the following secondary features:
##	- Event details view
##	- Save: event list or event details
##	- Print: event list or event details
##	- Automatic save & restore of user preferences

##########################################################
####### GLOBAL VARIABLES

# The ErrorFlag is set whenever there is an error condition.
# Following are the error conditions and their codes for ErrorFlag:
#      1 -> When there is a error connecting to a remote host.
#      2 -> When there is an irrecoverable error, application exits.
#      3 -> When the file name to read events from does not exist.
#      4 -> When the user does not have sufficient priveleges to read
#           events from the specified file.
#      5 -> When there is an error sourcing the User Preferences file.
#      6 -> When there is an error reading events from the specified
#	    file.
global 			ErrorFlag
set ErrorFlag 		0

# Flag to check to see if the advanced filter is to be applied.
global			AdvancedFilterFlag
set AdvancedFilterFlag 	0

# Host name to retrieve events from.
global 			EventSourceHost
set EventSourceHost 	""
global                  month_array

# The user preferences directory and user preferences file.
global 			UserPrefsDir 
global 			UserPrefsFile
global 			TempDir
global 			OKtowritePreferences

set UserPrefsDir 	[format "~/.sysman_%s" [ exec hostname -s ] ]
set UserPrefsFile 	"$UserPrefsDir/Evmviewer"

# Indicate that files are retrieved from a log(file).
global                  InputFileFlag
global                  InputFile
set InputFile 		""
set InputFileFlag 	0


# set temp dir. If TMPDIR is defined then make that the TMPDIR
# or set temp dir to /tmp.
if ![info exists env(TMPDIR)] {
        set TempDir /tmp
} else {
	    if { ![file writable $env(TMPDIR)] } {
		set TempDir /tmp
	    } else {
            		set TempDir $env(TMPDIR)
	      }
       }

# All the events are stored in TempFileName
global 			TempFileName


global 			SummaryFields
set SummaryFields 	{ event_id priority timestamp pid user_name \
				host_name cluster_name name format}

global 			SummaryHeaders1
set SummaryHeaders1 	""

global 			SummaryHeaders2
set SummaryHeaders2 	{ "-------- " "--- " "-------------------- " "---------- " \
"-------- " "-------- " "-------- " "----------" "--------" }

global 			Waiting
set Waiting 		0

global			NoOfEvents
set NoOfEvents 		500

global 			wSummSaveHide
global 			wDetSaveHide
global 			wOptionsHide
global 			PrevFilter
global 			PrevHost
global 			PrevSortKey
global 			LoadAnyway
global 			OldSortKey

set LoadAnyway 		0
set PrevFilter 		""
set PrevHost 		""
set PrevSortKey 	""
set OldSortKey 		""

# Directory which stores advanced filters
global 			AdvFiltersDir
set AdvFiltersDir 	"~/.sysman/evmfilters"

# tmp file into which errors are written to
global 			Error_File
set Error_File 		"$TempDir/evmerrors_[id user]_[pid].tmp"

#################
## Global variables to save state.

global			wDetPrintwValueState
global			wDetSavewValueState
global			wDetSaveOptionswAppendState

global			wFilterwNameFlagState
global			wFilterwNameEqualityChoiceState
global          	wFilterwNameState
global          	wFilterwHostFlagState
global          	wFilterwHostEqualityChoiceState
global          	wFilterwHostState
global          	wFilterwPriorityFlagState
global          	wFilterwPrioEqualityChoiceState
global          	wFilterwPriorityChoiceState
global          	wFilterwPriorityRangeMinState
global          	wFilterwPriorityRangeMaxState
global          	wFilterwPriorityAbsoluteState
global          	wFilterwPriorityMinState
global          	wFilterwPriorityMaxState
global          	wFilterwBeforeFlagState
global          	wFilterwBeforeHourState
global          	wFilterwBeforeMinState
global          	wFilterwBeforeSecState
global          	wFilterwSinceFlagState
global          	wFilterwSinceHourState
global          	wFilterwSinceMinState
global          	wFilterwSinceSecState
global                  wFilterwAgeFlagState
global                  wFilterwAgeEqualityChoiceState
global                  wFilterwAgeValueState
global                  wFilterwAgeQualiferState

global          	wItemsevent_idState
global			wItemspriorityState
global			wItemstimestampState
global			wItemspidState
global			wItemsuser_nameState
global			wItemshost_nameState
global			wItemscluster_nameState
global			wItemsnameState
global          	wItemsformatState

global			wSortwItemsState
global          	wSortwIsAscendingState

global			wAdvFilterwAdvFltFieldState
global	    		wSaveAdvancedwSaveAsFileState

global	    		wSourcewEventSourceChoiceState
global 	    		wSourcewFileState
global 	    		wSourcewSourceHostChoiceState
global	    		wSourcewHostState

global			wSummPrintwValueState

global			wSummSavewValueState
global 			wSummSaveOptionswAppendState

global			wNoOfEventswValueState

global                  wShowNonRootUserMsg 

###############################################################
####### INIT AND EXIT CALLBACKS for evmviewer

# initCB is called during startup.
evmviewer proc initCB { } {
    global ErrorFlag
    global UserPrefsFile
    global AdvancedFilterFlag
    global OKtowritePreferences
    global UserPrefsDir

    if { [ file writable $UserPrefsDir ] } {
	if { ! $OKtowritePreferences } {
	    InfoMsg "warning" \
		    [evmviewer.cat get evm_cannot_open_lock_file lbl] \
		    [get_warningmsg_title]  }
    } else {
	InfoMsg "warning" \
		[ format [evmviewer.cat get evm_cannot_save_prefs lbl] $UserPrefsDir ] \
		[get_warningmsg_title]
    }

    # if we are not root then check to see if we should display a warning
    # message saying that not all events are viewable if not root

    if { [id effective user] != "root" }  {
	if { [ wNotRoot.wShowNextTime getVal ] == 0 } {
	    wNotRoot display }
	}

    # Display the approproiate info message dialog. Remember
    # that we should not display more than one info dialog.
    if { $ErrorFlag == 1 } {
	InfoMsg "warning" \
		[evmviewer.cat get evm_connhost_error lbl] \
						[get_warningmsg_title]
    } elseif { $ErrorFlag == 3 } {
        InfoMsg "warning" \
		[evmviewer.cat get evm_invalid_file_name lbl] \
						[get_warningmsg_title]
      } elseif { $ErrorFlag == 4 } {
           InfoMsg "warning" \
		[evmviewer.cat get evm_insufficient_priveleges lbl] \
							[get_warningmsg_title]
        } elseif { $ErrorFlag == 6 } {
	     InfoMsg "warning" \
                [evmviewer.cat get evm_file_read_error lbl] \
                                                        [get_warningmsg_title]
          } else { 
                # If there is no filter specified on command line 
                # and no user prefs file then inform that only events of
                # 600-700 priority are displayed.
    		if { ((!$AdvancedFilterFlag) && \
				($ErrorFlag == 5)) } {
		     InfoMsg "warning" \
                     [evmviewer.cat get evm_no_filter lbl] [get_warningmsg_title]
		} else {
		     # If no events have been found matching the
		     # last used filter or the filter specified on
                     # command line then inform the user.
		     if  { [get_total_events] == 0 } {
		       InfoMsg "warning" \
		       [evmviewer.cat get evm_no_events lbl] [get_warningmsg_title]
	             }
          	  }
       } ;# end of else
    # Initialize the global Widget State variables.
    save_state
}

# exitCB is called whenever there is an abnormal exit.
evmviewer proc exitCB { } {
    cleanup
    exit
}

###########################################################################

##### GENERIC DIALOG BOX HANDLING ROUTINES

# These routines encapsulate code common to most dialog boxes.
#
# Most dialog boxes will have the following basic pattern of code:
#
#	dbox		proc initCB { } { <not needed> }
#	dbox		proc displayCB { } { <not needed> }
#	dbox.help	proc invokeCB { } { GENERIChelp dbox }
#	dbox.cancel	proc invokeCB { } { dbox hide }
#	dbox.ok		proc invokeCB { } { GENERICok dbox }
#	dbox.apply	proc invokeCB{} {
#	    <do the dialog box-specific action>
#	    dbox write
#	    evmviewer./evmview/gSuitState modify	;# FLUSH
#	}
#

# When the user hits OK, call the dialog box's apply and cancel callbacks.
proc GENERICok { a_dbox } {
    $a_dbox.apply invokeCB
    $a_dbox.cancel invokeCB
}    

# Will handle per-dialog box help when we figure it out.
proc GENERIChelp { a_tag } {
    evmviewer helpOn $a_tag
}

###########################################################################

##### SUIT-SPECIFIC UTILITY ROUTINES (APPLICATION-INDEPENDENT)
#
# get a message from your *.cat file.
#
# a_nameBase is the base name of the message (usually $self in your callback)
# a_nameSuffix is the suffix for the message type (usually _lbl or _hlp)
#
proc SUITcatget { a_nameBase a_nameSuffix } {
    global _UIT_g_main
    $_UIT_g_main catget $a_nameBase $a_nameSuffix
}

##########
# Get a $a_window's original title from the message catalog,
# append the text "$a_extra", and
# set the $a_window widget's title to this expanded string.

proc SUITtitleSet { a_window a_extra } {
    # set the title variable from this window object
    # to (its value from the message catalog) + $a_extra
    # (The WWW interface will update the next time this page is sent)
    $a_window instvar title
    set baseTitle "[SUITcatget $a_window lbl ]$a_extra"
    set ui [evmviewer getUI]
    # for GUI and CURSES, directly update the displayed widget
    if {$ui == "CURSES" || $ui == "GUI" || $ui == "JAVA"} {
        $a_window setLabel $baseTitle
    }
}

##########
# Ring bell or give equivalent indication of user error.
#
proc SUITbell { } {
    bell
}


##########
# Display or remove a watch cursor.
#
proc SUITwait { a_window a_waiting } {
    global SuitUi
    if {[evmviewer getUI] == "GUI"} {
        if {$a_waiting != 0 } {
            # change cursor to a watch cursor for this window
            .$a_window configure -cursor "watch"
            # FUTURE: fix window jumping
            update idletasks ;# force immediate display of new cursor
        } else {
            # change cursor back to a normal arrow cursor for this window
            .$a_window configure -cursor ""
            # no hurry to update cursor display here...
          }
    }
}

##########
# Pop up a dialog box.
#
proc SUITpopup { a_parent a_child } {
    # FUTURE: SUIT should display a wait cursor while do this.
    # The SUITwait calls appear to be more annoying than helpful here.
    # (uncomment them out and see for yourself...)
    #SUITwait $a_parent 1
    $a_child display
    #SUITwait $a_parent 0
}

#
# Common marker for features that are not yet implemented.
# FUTURE: remove this.
proc FUTURE { a_featureName } {
    puts stdout "Unimplemented Feature: $a_featureName"
    ###InfoMsg error "Unimplemented Feature:\n$a_featureName"
    SUITbell
}

###########################################################################
# proc Name:	  getValueOfSelection
# Input:	  a_listWidget = widget from which to get the selection
# Purpose:	  Return the "value" from the {text,value} pair for the
#		  line that is currently selected in this table.
# Return Value:	  "value" for the currently selected list item.
# Side Effects:	  none
# Preconditions:  exactly one line must be selected in the list widget.
# Other Notes:	  none
#--
proc getValueOfSelection { a_listWidget } {
    return [lindex [$a_listWidget getSelUserData] 0]
}


###########################################################################
#   Process CLI arguments- read from the command line
#   evmviewer -filter "<filter string>" -host "host" | -input "filename"
#   redid command line processing to handle cluster focus
#
#   Focus will not override any -host switch since the only way to set both
#   is for the user to set them on a sysman command line of the form
#   sysman -focus cluster_alias -accel event_viewer -host other_system
#   if focus is set and input source is also set then we have an error
#   because we cannot process input from two sources
#   the command line arg processing is more general to handle focus and any
#   additional parameters that may be added in the future

proc process_cli_arguments { } {
    global argc argv 
    global SysmanOnCluster
    global SysmanFocusHost


    set count 0
    set input_source 0
    set error_count 0

    set arglist(-filter) ""
    set arglist(-host) ""
    set arglist(-input) ""

if { $SysmanOnCluster  && ( $SysmanFocusHost != "" ) } {
    set arglist(-host) $SysmanFocusHost
    incr input_source
}

if { $SysmanOnCluster  && ( $SysmanFocusHost == "" ) } {
    set arglist(-host) [ cluster alias ]
    incr input_source
}

# no cli options to process nor we do not have a cluster focus source

    if { ( $argc == 0 ) && ( $input_source == 0 ) } {	 return { } } ;

    while { $count < $argc } {
	switch -- [lindex $argv $count] {

	    -f -
	    -filter {
		incr count
		if { $arglist(-filter) == "" } {
		    set arglist(-filter) [lindex $argv $count ]
		} else {
		    incr error_count }
		}

		-h -
		-host  {
		    incr count
		    if { ($arglist(-host) == "") || $SysmanOnCluster } {
			if { $SysmanOnCluster != 1 } { 
			   incr input_source }
			set arglist(-host) [lindex $argv $count]
		    } else {
			incr error_count
		    }
	    }

		    -i -
		    -input {
			incr count
			if { $arglist(-input) == "" } {
			    incr input_source
			    set arglist(-input) [lindex $argv $count]
			} else {
			    incr error_count }
			}

			default {
			    incr error_count
			}
		    }
		    incr count
		}

		if { ( $error_count > 0 ) || ( $input_source > 1 ) } {
		    puts "[SUITcatget evm_usage lbl]"
		    cleanup
		    exit
		}

		foreach i [array names arglist] {
		    #call process_cli_arg only if value not null
		    if { $arglist($i) != "" } {
			if { ! [ process_cli_arg $i $arglist($i) ] } {
			    puts "[SUITcatget evm_usage lbl]"
			    cleanup
			    exit
			}
		    }
		}

}

###########################################################################
#   process_cli_arg
#    -this funtion that's a cli argument and the data (-host <hostname>
#     or -filter <filter string>) and processes it

proc process_cli_arg { argument data} {
    global ErrorFlag
    global AdvancedFilterFlag
    global EventSourceHost
    global InputFile
    global InputFileFlag

    switch -- $argument {

        -h -
        -host {
		# If no hostname is specified then do not do anything.
		if { [string trim $data] == "" } { return 0 }
		wSource.wSourceHostChoice setVal "remote"
		set data [string trim $data]
                # If there are any invalid chars like braces, quotes in the
                # input then return error condition and set the global
		# EventSourceHost to the original input.
                if { [check_invalid_chars $data] } {
                        set ErrorFlag 1
                        set EventSourceHost $data
                        return 1
                }
                set counter 0
		set test_data $data
                set hostnames ""
                split $test_data
		set no_of_hosts [llength $test_data]
                while { $counter < $no_of_hosts } {
                        if { [catch { exec /usr/bin/evmget -h \
                            [lindex $test_data $counter] -e 2> /dev/null }] } {
                                set ErrorFlag 1
				set EventSourceHost $data
                        	return 1
                        }
                        append hostnames "[lindex $test_data $counter] "
                        incr counter
                }

                set EventSourceHost $hostnames
                return 1
        }

        -f -
        -filter {
            # Set the filter to advanced with this filter string.
	    # If no filter has been specified then do not do anything.
	    set AdvancedFilterFlag 1
	    if { "" == [string trim $data] } {
		return 0
	    } else {
                wAdvFilter.wAdvFltField setVal [string trim $data]
	      }
            return 1
        }

        -i -
        -input {
	   set data [string trim $data]
	   # If no string has been specified then do not do anything.
	   if { "" == $data } {
		return 0
	   }
           # Indicate event source is a file.
           set InputFileFlag 1
           set InputFile $data
  	   check_file $data
           wSource.wFile setVal $data
           return 1
        }

        default {
	     wAdvFilter.wAdvFltField setVal ""
	     return 0 
        }

    } ;# end switch
}

# lock user preferences file
# we will try to write a lock file.  if we can then we know we can update the
# user preferences otherwise no changes to the user's preferences can be made

proc lockPreferences { } {

    global OKtowritePreferences
    global UserPrefsDir

# make sure user preferences directory exists

if { ! [file exists $UserPrefsDir ] } {
    catch { mkdir $UserPrefsDir }
}

    set ecode [ catch { set fd [ open $UserPrefsDir/evmviewer_lock {  CREAT EXCL WRONLY } ] } errmsg ]

    if { $ecode } {
	set OKtowritePreferences 0
    } else {
	set OKtowritePreferences 1
	set proc_id [ pid ]
	puts $fd $proc_id
	close $fd
    }
}
###########################################################
## Nonroot message callback

# not much to do except set the title and labels

wNotRoot proc initCB { } {
    wNotRoot.wMsgWindow setVal [evmviewer.cat get not_root_user_warn lbl]
    wNotRoot instvar title
    set baseTitle [ get_infomsg_title ]
    wNotRoot setLabel $baseTitle
}

# if we get ok and that's the only button we just dismiss the dialog box

wNotRoot.ok proc invokeCB { } {
    wNotRoot hide
    return
}
###########################################################################

##### Event summary list dialog box (the main window): miscellaneous widgets

##### Widget Callbacks

wSummary 		proc initCB { } {
    global UserPrefsFile
    global NoOfEvents
    global OldSortKey
    global ErrorFlag
    global TempFileName
    global month_array

    lockPreferences

# set all standard user defaults first in case we cannot source in the user's
# preference file - it may not exist

    set_default_user_prefs

# initialize the months array the abbreviated names of the months in the
# current locale.  Then set the enumerated widget value on the fly.  We need
# to do this here before we do anything with the filter 

    init_months
    wFilter.wSinceMon setValueList $month_array
    wFilter.wBeforeMon setValueList $month_array

    # Source the user preferences file.
    if { [catch { source $UserPrefsFile }] } {
        # if UserPrefsFile does not exist set default user preferences.
	set ErrorFlag 5
        set_default_user_prefs
    }

    # Set global NoOfEvents
    set NoOfEvents [wItems.wNumOfEvents getVal]
}

wSummary		proc displayCB { } {
    global TempFileName
    global TempDir
    global ErrorFlag

    # Process the command line arguments 
    process_cli_arguments

    # Check if the user has write permissions on TEMPDIR if defined 
    # else if the user has write permissions on /tmp. We can do nothing
    # if we do not have write permissons in these DIRS.
    if { ![file writable $TempDir ] } {
	set error_msg [format [evmviewer.cat get evm_nowrite_permissions1 lbl] $TempDir ]
	set title [evmviewer.cat get evm_info_apperror_title lbl]
	InfoMsg "error" $error_msg $title "wait"
        cleanup
	exit
    }

    # Set default values in the widgets
    set_default_values

    load_summaries 
}

wSummary.exit		proc invokeCB { } {
    SUITwait wSummary 1
    # Procedure cleanup deletes the tmp files and exits
    write_preferences
    cleanup
    
    # FUTURE: clean up temp files from previous viewer runs that crashed?
    SUITwait wSummary 0
    exit
}

wSummary.help		proc invokeCB { } { GENERIChelp db-main  }

wSummary.wList.wItems		proc invokeCB { } { SUITpopup wSummary wItems }

wSummary.wList.wOptions       proc invokeCB { } { SUITpopup wSummary wOptions } 

#################################################

##### load_summaries proc
# This procedure does the most work. All of the requests to get,
# load, update events are run through this proc. The most generic
# operations are all done here.

proc load_summaries { } {
    global ErrorFlag
    global EventSourceHost
    global PrevFilter
    global PrevSortKey
    global PrevHost
    global LoadAnyway
    global InputFileFlag
    global TempFileName
    global TempDir

    set filter [build_filter]
    set sort_param [get_sort_parameter]
    set ecode 1

    # If the filter or sort param or host has been changed or Refresh has
    # been called get events with the new parameters. The first time
    # around the conditions will always fail since the global are initially
    # set to ""
    if { [string compare $PrevFilter $filter] || \
		[string compare $PrevSortKey $sort_param] || \
			[string compare $PrevHost $EventSourceHost] || \
			    			    ($LoadAnyway == 1) } {

	set TempFileName 	"$TempDir/vsumms_[id user]_[pid].XXXXXX"
	
	if { [ file executable /bin/mktemp ] } {
	    set ecode [ catch { set TempFileName [ exec /bin/mktemp $TempFileName
						  ] } errmsg ]
	}
	
	if  { ( $ecode != 0 ) ||  ![file writable $TempFileName] } {
	    InfoMsg "error" [ evmviewer.cat get evm_tempfile_error lbl ] [ get_errormsg_title ] "wait"
	    cleanup
	    exit
	}
	

    	# get events using the current filter
        if { ! $InputFileFlag } {
	    # In case of user input from command line, if hostnames are
	    # invalid then do not do anything.
	    if { ![check_invalid_hostnames $EventSourceHost] } {
    	        get_events $filter
	    }
        } else {
		    get_events_from_file $filter
          } ;# end of else

	# Sort event summaries.
        sort_events $sort_param

        # Set current values of filter, sort parameter and host.
	set PrevFilter $filter
        set PrevSortKey $sort_param
        set PrevHost $EventSourceHost
    }

    # Load events into the list box.
    load_events

    # Append the hostname to the title
    SUITtitleSet wSummary [id host]

    # Append the hostname from which the events are read
    # to the label of the summary list
    set_summary_window_label

}

# Check for irrecoverable errors. If there is one, exit.
proc handle_severe_errors { error } {
    global ErrorFlag
    set apperror_box_title [SUITcatget evm_info_apperror_title lbl]
    set error_msg [evmviewer.cat get evm_app_exit_error lbl]
    append error_msg $error
    append error_msg [evmviewer.cat get evm_exit lbl]
    if { $ErrorFlag == 2 } {
        InfoMsg "error" $error_msg $apperror_box_title "wait"
        set ErrorFlag 0
	cleanup
	exit
    }
}

#################################################

##### Support procs

# Set the labels in the summary window.
proc set_summary_window_label { } {
    global EventSourceHost
    global InputFile
    global InputFileFlag

    # Check whether events are read from a local host or a remote host.
    if { [wSource.wSourceHostChoice getVal] == "local" } {
        set host [exec /bin/hostname]
    } else {
		set host [string trim $EventSourceHost]
      } ;# end of else

    if { ! $InputFileFlag } {
             wSummary.wSummaryHostText setVal "[format \
      	     [SUITcatget evm_summ_from_host lbl] $host]"
    } else {
	       wSummary.wSummaryHostText setVal "[format \
	       [SUITcatget evm_summ_from_file lbl] $InputFile]"
      } ;# end of else

    # Set list widget label in main window to inform the user
    # the number of events displayed.
    SUITtitleSet wSummary.wList [get_list_label]
}

# Returns the label for the list widget.
proc get_list_label { } {
    global TempFileName

    set label1 [ format [SUITcatget evm_num_of_events1 lbl] [get_total_events] ]
    set label2 [ format [SUITcatget evm_num_of_events2 lbl] [expr ([wSummary.wList sizeOfList] - 2)] ]
    set label [ format "%s %s" $label1 $label2 ]

    return $label
}

# Write the preferences of the user to a user preferences file.
proc write_preferences { } {
     global UserPrefsFile
     global UserPrefsDir
     global TempDir
     global SummaryFields
     global NoOfEvents
     global OldSortKey
     global OKtowritePreferences

# if we cannot write to the preferences file then just return

    if { !$OKtowritePreferences } {
        return
    }

     set output ""
     # Write the show items preferences. 
     foreach v $SummaryFields {
	if [wItems.$v getVal] {
		append output "wItems.$v setVal 1\n"
	} else { append output "wItems.$v setVal 0\n" }
     }

     # Write the sort preference.
     append output "set OldSortKey $OldSortKey\n"
     append output "wSort.wIsAscending setVal [wSort.wIsAscending getVal]\n"
     
     # Write the number of events to display.
     append output "wItems.wNumOfEvents setVal $NoOfEvents\n"

     # Write the filter.
     append output "wFilter.wNameFlag setVal [wFilter.wNameFlag getVal]\n"
     append output "wFilter.wName setVal \"[wFilter.wName getVal]\"\n"
     append output \
     "wFilter.wNameEqualityChoice setVal [wFilter.wNameEqualityChoice getVal]\n"
     append output "wFilter.wHostFlag setVal [wFilter.wHostFlag getVal]\n"
     append output "wFilter.wHost setVal \"[wFilter.wHost getVal]\"\n"
     append output \
     "wFilter.wHostEqualityChoice setVal [wFilter.wHostEqualityChoice getVal]\n"
     append output \
     "wFilter.wPriorityFlag setVal [wFilter.wPriorityFlag getVal]\n"
     append output \
     "wFilter.wPrioEqualityChoice setVal [wFilter.wPrioEqualityChoice getVal]\n"
     append output \
     "wFilter.wPriorityChoice setVal \"[wFilter.wPriorityChoice getVal]\"\n"
     append output \
     "wFilter.wPriorityRangeMin setVal [wFilter.wPriorityRangeMin getVal]\n"
     append output \
     "wFilter.wPriorityRangeMax setVal [wFilter.wPriorityRangeMax getVal]\n"
     append output \
     "wFilter.wPriorityAbsolute setVal [wFilter.wPriorityAbsolute getVal]\n"
     append output "wFilter.wPriorityMin setVal [wFilter.wPriorityMin getVal]\n"
     append output "wFilter.wPriorityMax setVal [wFilter.wPriorityMax getVal]\n"
     append output "wFilter.wBeforeFlag setVal [wFilter.wBeforeFlag getVal]\n"
     append output "wFilter.wBeforeDay setVal [wFilter.wBeforeDay getVal]\n"
     append output "wFilter.wBeforeMon setVal [wFilter.wBeforeMon getVal]\n"
     append output "wFilter.wBeforeYear setVal [wFilter.wBeforeYear getVal]\n"
     append output "wFilter.wBeforeHour setVal [wFilter.wBeforeHour getVal]\n"
     append output "wFilter.wBeforeMin setVal [wFilter.wBeforeMin getVal]\n"
     append output "wFilter.wBeforeSec setVal [wFilter.wBeforeSec getVal]\n"
     append output "wFilter.wSinceFlag setVal [wFilter.wSinceFlag getVal]\n"
     append output "wFilter.wSinceDay setVal [wFilter.wSinceDay getVal]\n"
     append output "wFilter.wSinceMon setVal [wFilter.wSinceMon getVal]\n"
     append output "wFilter.wSinceYear setVal [wFilter.wSinceYear getVal]\n"
     append output "wFilter.wSinceHour setVal [wFilter.wSinceHour getVal]\n"
     append output "wFilter.wSinceMin setVal [wFilter.wSinceMin getVal]\n"
     append output "wFilter.wSinceSec setVal [wFilter.wSinceSec getVal]\n"
     append output "wFilter.wAgeFlag setVal [wFilter.wAgeFlag getVal]\n"
     append output "wFilter.wAgeEqualityChoice setVal [wFilter.wAgeEqualityChoice getVal]\n"
     append output "wFilter.wAgeValue setVal [wFilter.wAgeValue getVal]\n"
     append output "wFilter.wAgeQualifer setVal [wFilter.wAgeQualifer getVal]\n"

     append output "wAdvFilter.wAdvFltField setVal \{[wAdvFilter.wAdvFltField getVal]\}\n"
     append output "wNotRoot.wShowNextTime setVal [wNotRoot.wShowNextTime getVal]"
     if {$output != ""} {
            if { ! [file exists $UserPrefsDir] } {
                catch { mkdir $UserPrefsDir }
	    }

            catch {write_file $UserPrefsFile "$output"}
    }
}

# Set default values when starting up.
proc set_default_values { } {
    wDetSave.wValue			setVal "details.txt"
    wDetPrint.wValue			setVal "/usr/bin/lpr"
    wSummSave.wValue			setVal "summaries.txt"
    wSummPrint.wValue			setVal "/usr/bin/lpr"
}

# Set default user preferences if user preferences file could not be sourced.
proc set_default_user_prefs { } {
    global NoOfEvents
    global OldSortKey

    set NoOfEvents 500
    set OldSortKey "timestamp"

    wItems.event_id setVal 1
    wItems.priority setVal 1
    wItems.timestamp setVal 1
    wItems.pid setVal 0
    wItems.user_name setVal 0
    wItems.host_name setVal 1
    wItems.cluster_name setVal 0
    wItems.name setVal 0
    wItems.format setVal 1

    wItems.wNumOfEvents setVal 500

    wSort.wIsAscending setVal 0

    wFilter.wNameFlag 			setVal 0
    wFilter.wNameEqualityChoice 	setVal "notequalto"
    wFilter.wName 			setVal "[exec /usr/bin/evminfo -vp].*"
    wFilter.wHostFlag			setVal 0
    wFilter.wHostEqualityChoice		setVal "notequalto"
    wFilter.wHost			setVal ""
    wFilter.wPriorityFlag		setVal 1
    wFilter.wPrioEqualityChoice		setVal "equalto"
    wFilter.wPriorityChoice		setVal "range"
    wFilter.wPriorityRangeMin		setVal 600
    wFilter.wPriorityRangeMax		setVal 700
    wFilter.wPriorityAbsolute		setVal 0
    wFilter.wPriorityMin		setVal 0
    wFilter.wPriorityMax		setVal 700
    wFilter.wBeforeFlag			setVal 0
    wFilter.wBeforeHour			setVal 0
    wFilter.wBeforeMin			setVal 0
    wFilter.wBeforeSec			setVal 0
    wFilter.wSinceFlag			setVal 0
    wFilter.wSinceHour			setVal 0
    wFilter.wSinceMin			setVal 0
    wFilter.wSinceSec			setVal 0
    wFilter.wAgeFlag                    setVal 0
    wFilter.wAgeEqualityChoice          setVal "lessthan"
    wFilter.wAgeValue                   setVal 0
    wFilter.wAgeQualifer                setVal "days"
    wFilter.wBeforeDay			setVal \
					 [string trim [exec /bin/date +%e]]
    wFilter.wBeforeMon			setVal \
				      [string trimleft [exec /bin/date +%b] 0]
    wFilter.wBeforeYear			setVal \
						[exec /bin/date +%Y]
    wFilter.wSinceDay			setVal \
					[string trim [exec /bin/date +%e]]
    wFilter.wSinceMon			setVal \
				      [string trimleft [exec /bin/date +%b] 0]
    wFilter.wSinceYear			setVal [exec /bin/date +%Y]

    wAdvFilter.wAdvFltField		setVal ""
    wNotRoot.wShowNextTime              setVal 0
}

# This proc displays column titles in the event summary view.
proc header1 { } {
    global SummaryFields
    global SummaryHeaders1
    set evm_SummaryHeaders1_lbl [SUITcatget evm_SummaryHeaders1 lbl]
    set i 0
    set out ""
    append out " " ;# for left hand side margin
    foreach item $SummaryFields {
        if [ wItems.$item getVal ] {
            lappend SummaryFlags 1
            if { $item == "format" && [wItems.name getVal] != 0} {
                append out "/ "
            }
            append out [lindex $evm_SummaryHeaders1_lbl $i]
        #} else {
        #lappend SummaryFlags 0
        }
    incr i
    }
    return $out
}

# This proc draws lines under the column titles in the event summary view.
proc header2 { } {
    global SummaryFields
    global SummaryHeaders2
    set i 0
    set out ""
    append out " " ;# for left hand side margin

    foreach item $SummaryFields {
        if [ wItems.$item getVal ] {
            if { $item == "format" } {
                if [wItems.name getVal] {
                    append out "---"
                } else {
            # DEFECT: was adding a space, misaligned Summary with ---
            # append out " "
            }
        }
        append out [lindex $SummaryHeaders2 $i]
        }
    incr i
    }
    return $out
}

# Returns the title for InfoMessage dialogs or screens.
proc get_infomsg_title { } {
    set title [SUITcatget evm_info_title lbl]
    return $title
}

# Returns the title for InfoMessage dialogs or screens when reporting an error.
proc get_errormsg_title { } {
    set title [SUITcatget evm_error_title lbl]
    return $title
}

# Returns the title for InfoMessage dialogs or screens when reporting a warning.
proc get_warningmsg_title { } {
    set title [SUITcatget evm_warning_title lbl]
    return $title
}

# Check invalid chars in the supplied string.
proc check_invalid_chars { input_string } {

    if { ([string first \{ $input_string] != -1) || \
		([string first \} $input_string] != -1) || \
			 ([string first \" $input_string] != -1) } {
                return 1
    }
    return 0
}

# Check invalid hostnames in the input.
proc check_invalid_hostnames { input_string } {
    global errorCode
    if { [check_invalid_chars $input_string] } {
	return 1
    }

    set counter 0
    set test_data $input_string
    split $test_data
    set no_of_hosts [llength $test_data]
    while { $counter < $no_of_hosts } {
         set code [catch { exec /usr/bin/evmget -h \
              [lindex $test_data $counter] -e 2> /dev/null }]
	     set exit_code [ lindex $errorCode 2 ]
	     # Exit code 16 indicates a invalid hostname.
             if { $exit_code == 16 } {
                        return 1
             }
    	 incr counter
    }
    return 0
}

# Remove all the tmp files and exit.
proc cleanup { } {
    global TempDir
    global OKtowritePreferences
    global UserPrefsDir

    # Delete all temporary files in the temporary directory
    # that were created during this session and exit
    catch {
	    foreach f [glob $TempDir/*[id user]_[pid]*] {
		unlink -nocomplain $f
	  }
    }
	# delete the lock file if we own it

	if { $OKtowritePreferences } {
	catch { unlink -nocomplain $UserPrefsDir/evmviewer_lock }
	}
}

###########################################################################

##### Event summary list dialog box (the main window): widgets 

##### Widget Callbacks

wSummary.wList.wSort		proc invokeCB { } { SUITpopup wSummary wSort }

# To implement Hide, add the following button callback:
#wSummary.wList.wHide	proc invokeCB { } { FUTURE "hide event" }

wSummary.wList.wDetails	proc invokeCB { } {
    # if this is a header line, flag an error and exit
    if { [wSummary.wList curSelection] < 2} {
        InfoMsg "warning" \
	    [evmviewer.cat get evm_select_summary lbl] [get_warningmsg_title]

    } else {
        	wDetails_read
        	# Update the visible widget
        	wDetails display
      } ;# end of else
}

wSummary.wList.wFilters	proc invokeCB { } {
    global AdvancedFilterFlag

    SUITpopup wSummary wFilter
    if { $AdvancedFilterFlag } {
            InfoMsg "info" \
                    [evmviewer.cat get evm_advfilter_applied_info lbl] \
							[get_infomsg_title]
    }
}

wSummary.wList.wRefresh	proc invokeCB	 { } {
    global LoadAnyway
    SUITwait wSummary 1
    set LoadAnyway 1
    load_summaries 
    set LoadAnyway 0
    SUITwait wSummary 0
}

##########################################################

########################
# EVM related procs: These procs do the work of retriving, formatting
# and loading events onto the listbox.

# This proc reads event summaries from a file and inserts in the listbox.
proc load_events { } {
    global TempFileName
    global NoOfEvents
    global ErrorFlag

    set delim "|"
    set pipe "|/usr/bin/evmshow -t \"@event_id @priority {@timestamp}
@pid @user_name @host_name @cluster_name @name $delim @@\" -n
$NoOfEvents $TempFileName"

    if { [catch { set fd [open $pipe r] } error ] } {
	set ErrorFlag 2
	handle_severe_errors $error
    }

    set items ""

    # Insert the headers as the first two items.
    wSummary.wList setListItem items [header1] 0
    wSummary.wList setListItem items [header2] 1
    
    set event_id [ wItems.event_id getVal ]
    set priority [ wItems.priority getVal ]
    set timestamp [ wItems.timestamp getVal ]
    set pid [ wItems.pid getVal ]
    set user_name [ wItems.user_name getVal ]
    set host_name [ wItems.host_name getVal ]
    set cluster_name [ wItems.cluster_name getVal ]
    set fName [ wItems.name getVal ]
    set format1 [ wItems.format getVal ]

    # Set the counter to be pointing to the third row.
    # The items are extracted from a list depending whether
    # they have been selected or not in the show items dialog.
    set counter 2
    while { [gets $fd line] != -1 } {
        set out " "

        # Treat the formatted msg special because it may contain
	#   characters that break list syntax.
	set other [lassign [split $line $delim] line msg]
	foreach token $other {
	    append msg "${delim}${token}"
	}

        if { $event_id } {
            append out "[format "%8.8s" [lindex $line 0]] "
        }
        if { $priority  } {
            append out "[format "%3s" [lindex $line 1]] "
        }
        if { $timestamp  } {
            append out "[format "%20s" [lindex $line 2]] "
        }
        if { $pid } {
            append out "[format "%10s" [lindex $line 3]] "
        }
        if { $user_name } {
            append out "[format "%-8.8s" [lindex $line 4]] "
        }
        if { $host_name } {
	    set host [lindex $line 5]
	    if { [cequal $host "-"] } {
		set trunc_hostname "    -   "
	    } else {
		set trunc_hostname [lindex [split $host "."] 0]
	    }
	    append out "[format "%-8.8s" $trunc_hostname] "
        }
        if { $cluster_name } {
	    set cluster [lindex $line 6]
	    if { [cequal $cluster "-"] } {
		set cluster "    -   "
            }
            append out "[format "%-8.8s" $cluster] "
        }

        if { $fName } {
            append out [format "%s" [lindex $line 7]]
        }
        if { $format1 } {
            if { $fName } {
	        append out "/ "
            }
            append out [format "%s" $msg]
        }
        # Don't insert list items one at a time.
        # Collect a group of them and put them in all at once.
        # Either of the below two lines should work right.
        # wSummary.wList insertDspStr $n $out

        wSummary.wList setListItem items $out $counter
        incr counter
    } ; # end of while

    wSummary.wList setVal $items
# should close the pipe but may need a catch, need to check this out further
# so just hold the place here
    catch { close $fd }

}

##### Build filter string
proc build_filter { } {
    global AdvancedFilterFlag
    set filter ""
    set link ""

    if { $AdvancedFilterFlag != 0 } {
	append filter [string trim [wAdvFilter.wAdvFltField getVal]]
	if { $filter == "" } {
                set filter "0"
        }
        return $filter
    }

    if { [wFilter.wNameFlag getVal] != 0} {
        # which  equality choice was chosen?
        set equality_choice [wFilter.wNameEqualityChoice getVal]

        if {$equality_choice == "equalto"} {
            append filter "$link \[name [string trim [wFilter.wName getVal]]\]"
        } else {
            	append filter \
			 "$link !\[name [string trim [wFilter.wName getVal]]\]"
          } ;# end of else
        set link "&"
    }

    if { [wFilter.wHostFlag getVal] != 0} {
        # which  equality choice was chosen?
        set equality_choice [wFilter.wHostEqualityChoice getVal]

        if {$equality_choice == "equalto"} {
            append filter \
		 "$link\(\[host_name [string trim [wFilter.wHost getVal]]\]|" \
                "\[cluster_name [string trim [wFilter.wHost getVal]]\]\)"
        } else {
            	append filter \
	      "$link\(!\[host_name [string trim [wFilter.wHost getVal]]\] & " \
                "!\[cluster_name [string trim [wFilter.wHost getVal]]\]\)"
          } ;# end of else
        set link "&"
    }

    if { [wFilter.wPriorityFlag getVal] != 0} { ; # filter on priority

        # which  equality choice was chosen?
        set equality_choice [wFilter.wPrioEqualityChoice getVal]

        if { [wFilter.wPriorityChoice getVal] == "range"} {
           if {$equality_choice == "equalto"} {
               append filter "$link\(\[priority >= [string trim \
			 [wFilter.wPriorityRangeMin getVal]]\]" \
                        "&\[priority <= [string trim \
				 [wFilter.wPriorityRangeMax getVal]]\]\)"
           } else {
                	append filter \
			     "$link\(\[priority < [string trim \
				[wFilter.wPriorityRangeMin getVal]]\]" \
                        "|\[priority > [string trim \
				[wFilter.wPriorityRangeMax getVal]]\]\)"
             } ;# end of else
        }

        if { [wFilter.wPriorityChoice getVal] == "absolute"} {
           if {$equality_choice == "equalto"} {
                append filter "$link\[priority = [string trim \
				[wFilter.wPriorityAbsolute getVal]]\]"
           } else {
                append filter "$link\[priority != [string trim \
				[wFilter.wPriorityAbsolute getVal]]\]"
             } ;# end of else
        }

        if { [wFilter.wPriorityChoice getVal] == "min"} {
           if {$equality_choice == "equalto"} {
                append filter \
		    "$link\[priority >= [string trim \
					[wFilter.wPriorityMin getVal]]\]"
           } else {
                	append filter \
			     "$link\[priority < [string trim \
					[wFilter.wPriorityMin getVal]]\]"
             } ;# end of else
        }

        if { [wFilter.wPriorityChoice getVal] == "max"} {
           if {$equality_choice == "equalto"} {
                append filter \
		     "$link\[priority <= [string trim \
					[wFilter.wPriorityMax getVal]]\]"
           } else {
                    append filter \
		     "$link\[priority > [string trim \
					[wFilter.wPriorityMax getVal]]\]"
             } ;# end of else
        }
        set link "&"
    }

    if { [wFilter.wBeforeFlag getVal] != 0} {
        append filter "$link\[before " \
                "[string trim [wFilter.wBeforeYear getVal]]:" \
			"[string trim [ get_month_index [wFilter.wBeforeMon getVal]]]" \
                ":[string trim [wFilter.wBeforeDay getVal]]:" \
			"[string trim [wFilter.wBeforeHour getVal]]" \
                ":[string trim [wFilter.wBeforeMin getVal]]:" \
			"[string trim [wFilter.wBeforeSec getVal]]]"
        set link "&"
    }
    if { [wFilter.wSinceFlag getVal] != 0} {
        append filter "$link\[since " \
                "[string trim [wFilter.wSinceYear getVal]]:" \
			"[string trim [ get_month_index [wFilter.wSinceMon getVal]]]" \
                ":[string trim [wFilter.wSinceDay getVal]]:" \
			"[string trim [wFilter.wSinceHour getVal]]" \
                ":[string trim [wFilter.wSinceMin getVal]]:" \
			"[string trim [wFilter.wSinceSec getVal]]]"
	set link "&"
    }

    if { [wFilter.wAgeFlag getVal] != 0 } {
	if { [wFilter.wAgeEqualityChoice getVal] == "lessthan" } {
	    append filter "$link\[ age < " 
	} else {
	    append filter "$link\[ age > " }

	    append filter [string trim [wFilter.wAgeValue getVal] ]
	    append filter [string trim [wFilter.wAgeQualifer getVal] ]
	    append filter " ]"
	}

    if { $filter == "" } {
        set filter ""
    }
    return $filter

}

##############
# Build sort parameters for evmsort
proc get_sort_parameter { } {
    global OldSortKey

    set sortParam [getValueOfSelection wSort.wItems]
  
    # If the sort item is not displayed then set sort key to the old key.
    if { "" == $sortParam } {
	set sortParam $OldSortKey
    }

    # for qar 70454
    # if sorting by format then make sort spec use @@ to sort by
    # format after variable substitution

    if { "format" == $sortParam } {
	set sortParam @@
    }

    if { 1 == [wSort.wIsAscending getVal] } {
       	    append sortParam "+"
    } else {
               append sortParam "-"
      } ;# end of else

    # If sort key is other than timestamp sort the events
    # further in descending timestamps.
    if { [getValueOfSelection wSort.wItems] != {timestamp} } {
       	    append sortParam ":timestamp-"
    }

    return $sortParam
}

##############
# Get events using evmget into a file and sort them.
proc get_events { filter } {
    global ErrorFlag
    global TempFileName
    global EventSourceHost
    global Error_File
    set events_file $TempFileName
    set filter "-f \"$filter\""


    if { $EventSourceHost == "" } {
	set host ""
    } else {
	     # Here we are assuming that the host_names have
	     # no invalid chars in them. The following code will
	     # Tcl dump if that is not the case.
	     set host ""
	     set hostname $EventSourceHost
    	     split $hostname 
    	     set no_of_hosts [llength $hostname]
    	     set counter 0
    	     while { $counter < $no_of_hosts } {
		append host "-h \"[lindex $hostname $counter]\" "
		incr counter
    	     }
      } ;# end of else
    
    catch \
     {system "/usr/bin/evmget $filter $host 2>/dev/null > $events_file"} error
   
    # Error code 6 is returned by evmget when there is an I/O error.
    if { 6 == $error } {
        InfoMsg "error" \
                [evmviewer.cat get evm_write_error lbl] \
						[get_errormsg_title] "wait"	
	cleanup
	exit
    }
}

# Get events from a file.
proc get_events_from_file { filter } {
    global TempFileName
    global InputFile
    global ErrorFlag
    global Error_File
    set events_file $TempFileName
    set filter "-f '$filter'"

    # Error code 6 is returned by evmget when write fails or the file
    # system is full.
    if { [catch \
    {system "/usr/bin/evmshow -r $filter $InputFile 2>/dev/null >$events_file"} error]} {
          if { 6 == $error } {
              InfoMsg "error" \
                [evmviewer.cat get evm_write_error lbl] \
						[get_errormsg_title] "wait"	
	      cleanup
	      exit
          } elseif { 0 != $error } {
	      InfoMsg "error" \
                [evmviewer.cat get evm_evmshow_error lbl] \
                                                [get_errormsg_title] "wait"
              cleanup
              exit
           }
    }
}

# Sort the events in the tmp file.
proc sort_events { sort_param } {
    global ErrorFlag
    global TempFileName
    global EventSourceHost
    set events_file $TempFileName
global TempDir
    set tmp_sort_file "$TempDir/vsumms_[id user]_[pid]_s.XXXXXX"
    #set tmp_sort_file $events_file
    #set tmp_sort_file [append tmp_sort_file _s]
    set ecode 1

    if { [ file executable /bin/mktemp ] } {
	set ecode [ catch { set tmp_sort_file [ exec /bin/mktemp $tmp_sort_file
] } errmsg ]
    }

    if  { ( $ecode != 0 ) || ![file writable $tmp_sort_file] } {
	InfoMsg "error" [ evmviewer.cat get evm_tempfile_error lbl ] [ get_errormsg_title ] "wait"
        cleanup
        exit
    }

    if { [catch \
	{ exec /usr/bin/evmsort -s $sort_param $events_file >$tmp_sort_file \
					       		  } error ] } {
		set ErrorFlag 2
		handle_severe_errors $error
    }
    unlink -nocomplain $events_file
    frename $tmp_sort_file $events_file
}

# Return total number of events in the file.
proc get_total_events { } {
    global ErrorFlag
    global TempFileName

    if { [catch { set total_events \
	   [exec /usr/bin/evmshow -t \"\" $TempFileName 2>/dev/null | /usr/bin/wc -l] }] } {
	return 0
    } else {
    		return [string trim $total_events]
      } ;# end of else
}

#########################

##### Event source selection dialog box
##### Widget callbacks

wSource proc 		displayCB {} {
    global EventSourceHost
    global InputFileFlag

    if { [wSource.wEventSourceChoice getVal] == "file" } {
	wSource.wHost disable
	wSource.wFile  enable
	wSource.wHost setVal " "
    } else {
	wSource.wFile disable
	wSource.wFile setVal " "
	if { [wSource.wSourceHostChoice getVal] == "local" } {
	    wSource.wHost setVal " "
	}
    }
}

wSource.ok		proc invokeCB { } {
    SUITwait wSource 1
    if { ![wSource_apply] } {
        # if no events have been found- alert the user
        if { [get_total_events] == 0 } {
           InfoMsg "warning" \
                 [evmviewer.cat get evm_no_events_found lbl] \
						[get_warningmsg_title] "wait"
        }
        wSource hide
        hidewOptions
    }
    SUITwait wSource 0
}

wSource.apply		proc invokeCB { } {
    SUITwait wSource 1
    if { ![wSource_apply] } {
        # if no events have been found- alert the user
        if { [get_total_events] == 0 } {
             InfoMsg "warning" \
       	         [evmviewer.cat get evm_no_events_found lbl] \
						[get_warningmsg_title] "wait"
        }
    }
    SUITwait wSource 0
}
   
wSource.cancel		proc invokeCB { } {
     global wOptionsHide
     set wOptionsHide 0
     wSource hide
     load_saved_state
     hidewOptions 
}

wSource.help		proc invokeCB { } { GENERIChelp db-op-host }

# Callback for wEventSourceChoice Boolean widget.
wSource.wEventSourceChoice proc changeCB { } {
      set choice [wSource.wEventSourceChoice getVal]
      set host_choice [wSource.wSourceHostChoice getVal]
      
      if { "host" == $choice } {
	     wSource.wFile disable
	     wSource.wSourceHostChoice enable
	     if { "remote" == $host_choice } {
	          wSource.wHost enable
	     }
      } else {
		wSource.wFile enable
		wSource.wSourceHostChoice disable
		wSource.wHost disable		
	} ;# end of else
}

# Callback for wSourceHostChoice Boolean widget.
wSource.wSourceHostChoice proc changeCB { } {
      set choice [wSource.wSourceHostChoice getVal]

      if { "remote" == $choice } {
	    wSource.wHost enable
      } else {
		wSource.wHost disable
	}
}

# Check host name in the wHost text widget.
proc source_remote_ok { } {
    global errorCode
    global EventSourceHost
    global Error_File
    global TempDir
    global ErrorFlag
    if { [string trim [wSource.wHost getVal]] == "" } {
	InfoMsg "warning" \
  	    [evmviewer.cat get evm_specify_remote lbl] \
						[get_warningmsg_title]
	return 1
    }

    set hostname [string trim [wSource.wHost getVal]]
    # Make sure that there are no brackets or quotes in the input.
    if { [check_invalid_chars $hostname] } {
	InfoMsg "warning" \
		[evmviewer.cat get evm_invalid_chars lbl] \
                                                        [get_warningmsg_title]
                return 1
    }

    split $hostname
    set no_of_hosts [llength $hostname]
    set counter 0
    set no_of_errors 0
    set error_msg ""
    while { $counter < $no_of_hosts } {
         # Try a connection to the remote host.
         set code [catch { exec /usr/bin/evmget -h \
			 [lindex $hostname $counter] -e } error ]
	     if { $code != 0 } {
	         set exit_code [lindex $errorCode 2]
		 # Check exit code for invalid host names.
                 if { $exit_code == 16 } {
			append error_msg "$error\n"
			if { $no_of_errors > 3 } {
			    append error_msg "..."
			    break
			}
			incr no_of_errors
	         }
	     }
	 incr counter
    }

    # Check if any invalid hostnames were found in the specified list.
    if { "" != [string trim $error_msg] } {
	set msg [evmviewer.cat get evm_remote_host_error lbl]
	append msg $error_msg
	InfoMsg "warning" $msg [get_warningmsg_title]
        return 1
    }
   
    set counter 0
    set error_msg ""
    set no_of_errors 0
    set host_string ""
    # Check for connection errors.
    while { $counter < $no_of_hosts } {
        if { [catch { exec /usr/bin/evmget -h [lindex $hostname $counter] -e \
						          } error ] } {
	    if { $no_of_errors < 3 } {
	        append error_msg $error
		if { $no_of_errors == 2 } {
	            append error_msg "..."
		}
	    }
	    incr no_of_errors
        } else {
	    	append host_string "[lindex $hostname $counter] "
	  }
	incr counter
    }

    # If all the hosts specifed had connection errors then inform the
    # user and don't do anything.
    if { "" != $error_msg && [string trim $host_string] == ""} {
	set msg [evmviewer.cat get evm_remote_host_error lbl]
	append msg $error_msg
	InfoMsg "warning" $msg [get_warningmsg_title]
	return 1
    } else {
		# If only some of the host(s) had connection errors then
		# inform the user about the same and retrieve events from 
		# the host(s) which could be connected to.
		if { "" != $error_msg } {
		     set msg [evmviewer.cat get evm_remote_host_error lbl]
        	     append msg $error_msg
		     InfoMsg "warning" $msg [get_warningmsg_title] "wait"
		}
    		set EventSourceHost $host_string
    		return 0
      }
}

# Check for error conditions when trying to retrieve events from
# specified file.
proc check_input_file { } {
    if { [string trim [wSource.wFile getVal]] == "" } {
	InfoMsg "warning" \
                    [evmviewer.cat get evm_no_file_specified lbl] \
							[get_warningmsg_title]
                return 1
    }

    if { ! [file exists [string trim [wSource.wFile getVal]]] } {
         InfoMsg "warning" \
                    [evmviewer.cat get evm_invalid_file_name lbl] \
							[get_warningmsg_title]
	 return 1
    }

    # If file does not have read permissions then return error.
    if { ![file readable [string trim [wSource.wFile getVal]] ] } {
         InfoMsg "warning" \
                    [evmviewer.cat get evm_insufficient_priveleges lbl] \
							[get_warningmsg_title]
  	return 1
    }

    # If file specified does not have events in it then throw up the
    # error condition of evmshow. Here we are trying to just test
    # retrieving an event. If the file contains
    # anything other than events then evmshow will return an error.
    # This is not the best way to do it but since there is no other
    # way this has to be it.

    # see if file is empty, if so put out a different message QAR 65238

    file lstat [string trim [wSource.wFile getVal]] stat_result
    if { $stat_result(size) == 0 } {
        set error_msg [evmviewer.cat get evm_file_is_empty lbl]
        InfoMsg "warning" $error_msg [get_warningmsg_title]
        return 1
        }

    if { [catch { exec /usr/bin/evmshow -n 1 -r [string trim [wSource.wFile getVal]] >/dev/null } error] } {
	set error_msg [evmviewer.cat get evm_invalid_file lbl]
	append error_msg $error
	InfoMsg "warning" $error_msg [get_warningmsg_title]
        return 1
    }
    return 0
}

# The proc check_file is used by the process_cli_arg procedure
# to check for the input file if passed as a command line argument.
proc check_file { file } {
    global ErrorFlag

    if { ! [file exists [string trim $file]] } {
	set ErrorFlag 3
	return
    }

    if { ![file readable [string trim $file] ] } {
	set ErrorFlag 4
  	return
    }

    if { [catch { exec /usr/bin/evmshow -n 1 -r $file >/dev/null } error] } {
	set ErrorFlag 6
	return
    }
}

proc wSource_apply { } {
    global InputFileFlag
    global InputFile
    global LoadAnyway
    global EventSourceHost

    set ret_val 0

    # Process request if event source is from local or from
    # remote host(s).
    if { "host" == [wSource.wEventSourceChoice getVal] } {
	if { "remote" == [wSource.wSourceHostChoice getVal] } {
	    # Retrieve events from remote host(s).
            if { ![source_remote_ok] } {
                set InputFileFlag 0
                set LoadAnyway 1
    		load_summaries
	        set LoadAnyway 0
		set ret_val 0
	    } else { set ret_val 1 }
        } else {
		# Retrieve events from local host.
                set InputFileFlag 0
                set LoadAnyway 1
		set EventSourceHost ""
    		load_summaries
                set LoadAnyway 0
	    }
     # Process request if event source is a file.
     } else {
		if { ! [check_input_file] } {
		    set InputFileFlag 1
		    set InputFile [string trim [wSource.wFile getVal]]
  		    set LoadAnyway 1
    		    load_summaries
    		    set_summary_window_label
  		    set LoadAnyway 0
		    set ret_val 0
		} else { set ret_val 1 }
       } ;# end of else

     save_state

     return $ret_val
}

###########################################################################

##### Event options selection dialog box

##### Widget callbacks

wOptions proc 		initCB { } {
    insert_options
}

wOptions.ok		proc invokeCB { } { 
    SUITwait wOptions 1
    # whichever option will be called should check this
    # global and close the wOptions window when it is done

    global wOptionsHide
    set wOptionsHide 1
    wOptions_apply 
    SUITwait wOptions 0
}
    
wOptions.cancel         proc invokeCB { } { wOptions hide }

wOptions.help		proc invokeCB { } { GENERIChelp db-options }

wOptions.apply          proc invokeCB { } {
    SUITwait wOptions 1
    global wOptionsHide
    set wOptionsHide 0
    wOptions_apply
    SUITwait wOptions 0
}

wOptions.wList proc doubleClkCB { }  { 
    wOptions.ok invokeCB
}

proc wOptions_apply { } {
    set option_choice [wOptions.wList getItemDspStr \
	    [wOptions.wList getCurDspStrs] ]

    if { $option_choice == "" } {
	return
    }

    # Match the option chosen with an option string. If there
    # is a match, display the dialog for that option.
    
    if {$option_choice == [ evmviewer.cat get wOptions_wSource lbl] } \
	    { SUITpopup wSummary wSource }

    if {$option_choice == [ evmviewer.cat get wOptions_wSummPrint lbl] } \
	    { SUITpopup wSummary wSummPrint }

    if {$option_choice == [ evmviewer.cat get wOptions_wSummSave lbl] } \
	    {  
	       global wSummSaveHide 
	       set wSummSaveHide 0
               SUITpopup wSummary wSummSave 
            }
    
    if {$option_choice == [ evmviewer.cat get wOptions_wAdvanced lbl] } \
            { SUITpopup wSummary wAdvFilter }

}

proc hidewOptions { } {
    global wOptionsHide
    if { $wOptionsHide } { wOptions hide }
}

# Insert the options into the More Options... list box. If events are 
# being read from a file then the Refresh option is not displayed.
proc insert_options { } {
    wOptions.wList clear
    # enter the list of options into the options listbox
    set items {}
   
    wOptions.wList setListItem items \
	    [ evmviewer.cat get wOptions_wSource lbl]  {}

    wOptions.wList setListItem items \
            [ evmviewer.cat get wOptions_wAdvanced lbl]  {}

    wOptions.wList setListItem items \
	    [ evmviewer.cat get wOptions_wSummPrint lbl]  {}

    wOptions.wList setListItem items \
	    [ evmviewer.cat get wOptions_wSummSave lbl]  {}

    wOptions.wList insertDspStr end $items

}

# To implement Find, add the following button callback:
# proc wOptions_wSummFind { } { SUITpopup wSummary wSummFind }

#########################################################################

##### Event summaries save and print dialog boxes
##### Widget callbacks

wSummSave.ok		proc invokeCB { } { 
    SUITwait wSummSave 1
    global wSummSaveHide
    set wSummSaveHide 1
    SummSave_apply
    SUITwait wSummSave 0
}

wSummSave.cancel	proc invokeCB { } {
    global wOptionsHide
    set wOptionsHide 0
    load_saved_state
    wSummSave hide;
    hidewOptions
}

wSummSave.help		proc invokeCB { } { GENERIChelp db-op-save }

proc SummSave_apply { } {
    global wSummSaveHide
    global TempDir
    global full_pathname

    SUITwait wSummSave 1
    wSummSave write			;# commit the changes in this dbox

    set good 0
    set failed 0

    if { [string trim [wSummSave.wValue getVal]] == "" } {
	InfoMsg "error" \
		[evmviewer.cat get evm_detsumm_save_no_string_error lbl] \
							[get_errormsg_title]
	SUITwait wSummSave 0
	return
    }

    # get the name of the file to save summaries, set up pathnames to search
    # through to find a place that is writable

    set filename [ string trim [wSummSave.wValue getVal ] ]

    if { [ string compare "." [ file dirname $filename ] ] } {
	set search_path [ list $filename ]
    } else {
	set search_path [ list [ format "%s/%s" [ pwd ] $filename ] [ format "%s/%s" $TempDir $filename ] ]
    }

    foreach el $search_path {

    	# check if the file exists
	set full_pathname $el

    	if { [file exists $full_pathname ] } {
	    if { [file writable $full_pathname] } {
		set good 1
		SUITpopup wSummSave wSummSaveOptions
		SUITwait wSummSave 0
		return
		break
	    } else {
		set failed 1
		continue
	    }
	} else {
	    if { [file writable [ file dirname $full_pathname ] ] } {
		set good 1
		break
	    } else {
		set failed 1
		continue
	    }
	}
    }
    
    if {  ( $failed == 1 ) && ( $good == 0 ) } {
	if { [ file isdirectory [ file dirname $full_pathname ] ] } {
	    InfoMsg "error" \
		    [format [ evmviewer.cat get evm_unableto_save_nopriv lbl] \
		    $full_pathname] [get_errormsg_title]
	} else {
	    InfoMsg "error" \
		    [format [evmviewer.cat get evm_unableto_save_nodir lbl] \
		    $full_pathname [ file dirname $full_pathname ] ] \
		    [get_errormsg_title]
	}
    } else {
	if { [summaries_save $full_pathname \
		[wSummSaveOptions.wAppend getVal]] != 1 } { 
	    save_state	

	    if { $wSummSaveHide } { wSummSave hide; hidewOptions } 
	    InfoMsg "info" \
		    [format [evmviewer.cat get evm_summsave_save_to_file lbl] \
		    $full_pathname ] [get_infomsg_title]
	}
    }

    SUITwait wSummSave 0
}

wSummSaveOptions.ok 	proc invokeCB { } {
    global wSummSaveHide
    global full_pathname

    if { [summaries_save $full_pathname \
	  [wSummSaveOptions.wAppend getVal]] != 1 } { 
        save_state 
        wSummSaveOptions hide

        if { $wSummSaveHide } { wSummSave hide; hidewOptions }
        InfoMsg "info" \
	    [format [evmviewer.cat get evm_summsave_save_to_file lbl] \
	    $full_pathname ] [get_infomsg_title]
    }
}

wSummSaveOptions.cancel proc invokeCB { } {
    global wSummSaveHide

    # since the options were canceled, do not hide the wSummSave
    # dialog if the user clicked OK- the operation was stopped
    set wSummSaveHide 0

    # do not close the wSummSave dialog, just hide
    wSummSaveOptions hide
}

wSummSaveOptions.help 	proc invokeCB { } { GENERIChelp db-exist }

wSummPrint.ok		proc invokeCB { } {
    if { ![summprint_apply] } {
        save_state
        wSummPrint hide 
        hidewOptions
    }
}

wSummPrint.cancel	proc invokeCB { } { 
    global wOptionsHide
    set wOptionsHide 0
    load_saved_state
    wSummPrint hide 
    hidewOptions 
}

wSummPrint.help		proc invokeCB { } { GENERIChelp db-op-print }

wSummPrint.apply	proc invokeCB { } {
    SUITwait wSummPrint 1
    if { ! [summprint_apply] } {
	save_state
    }
    SUITwait wSummPrint 0
}

# Save the event summaries into the specified filename
proc summaries_save { a_filename a_append } {
    if { $a_append != 0 } {
	set mode a
    } else {
		set mode w
           }
    # The user's umask will determine the file protection
    if { [catch { set fd [open $a_filename $mode] } msg ] } {
	InfoMsg "error" \
		[evmviewer.cat get evm_unableto_summ_save_error lbl] \
							[get_errormsg_title]
		return 1;
    }
	
    if {$fd >= 0} {
	if { $a_append != 0 } {
	     puts $fd " "
	} 
        set header [wSummary.wSummaryHostText getVal]
        puts $fd $header
        puts $fd " "
	set i 0
	set n [wSummary.wList sizeOfList]
	while {$i <= $n} {
	    set summary [lindex [wSummary.wList getDspStr $i] 0]
	    puts $fd [lindex $summary 0]
	    incr i
	}
	close $fd
    }
    return {}
}

proc summprint_apply { } {
    global TempDir
    if { [string trim [wSummPrint.wValue getVal]] == "" } {
	InfoMsg "error" [evmviewer.cat get evm_noprint_command_error lbl] \
							[get_errormsg_title]
		return 1 
    }

    set filename  $TempDir/evmprint_[id user]_[pid].dat
    summaries_save $filename 0
    if { [catch { eval exec [wSummPrint.wValue getVal] $filename } error] } {
	set error_msg ""
	set error_msg \
	     [evmviewer.cat get evm_app_ext_error lbl]
	append error_msg "\n"
	append error_msg $error
	InfoMsg "error" $error_msg [get_errormsg_title] "wait"
	return 1
    } else { return 0 }
}

###########################################################################

##### Event Details save and print dialog boxes
##### Widget callbacks

wDetSave.ok		proc invokeCB { } { 
    SUITwait wDetSave 1
    global wDetSaveHide
    set wDetSaveHide 1
    DetSave_apply
    SUITwait wDetSave 0
}

wDetSave.cancel		proc invokeCB { } {
    load_saved_state
    wDetSave hide 
}

wDetSave.help		proc invokeCB { } { GENERIChelp db-ed-save }

proc DetSave_apply { } {
    global wDetSaveHide 
    SUITwait wDetSave 1
    set file_name [string trim [wDetSave.wValue getVal]] 
    if { $file_name == "" } {
	InfoMsg "error" \
		 [evmviewer.cat get evm_detsumm_save_no_string_error lbl] \
							[get_errormsg_title]
    } else {
    		# check if the file exists
    		if { [file exists $file_name] } {
        		SUITpopup wDetSave wDetSaveOptions
    	   } else { 
		     if {! [details_save $file_name \
			[wDetSaveOptions.wAppend getVal]] } {
			       save_state
		     	       if { $wDetSaveHide } { wDetSave hide }
			       InfoMsg "info" \
				  [evmviewer.cat get evm_detsave_saved lbl] \
							[get_infomsg_title]
		     }
      	     } ;# end of else
      } ;# end of else
    SUITwait wDetSave 0
}

wDetSaveOptions.ok 	proc invokeCB { } {
    global wDetSaveHide

    if { ! [details_save [string trim [wDetSave.wValue getVal]] \
	    		[wDetSaveOptions.wAppend getVal] ] } {
	  save_state
          wDetSaveOptions hide

          if { $wDetSaveHide } { wDetSave hide } 
	       InfoMsg "info" \
		  [evmviewer.cat get evm_detsave_saved lbl] \
						[get_infomsg_title]
    }
}

wDetSaveOptions.cancel 	proc invokeCB { } {
    global wDetSaveHide

    # Since the options were canceled, do not hide the wDetSave
    # dialog if the user clicked OK- the operation was stopped
    set wDetSaveHide 0

    # Do not close the wDetSave dialog, just hide
    wDetSaveOptions hide
}

wDetSaveOptions.help 	proc invokeCB { } { GENERIChelp db-exist }

wDetPrint.ok		proc invokeCB { } { 
    if { ![detprint_apply] } {
	save_state
	wDetPrint hide
    }
}

wDetPrint.cancel	proc invokeCB { } {
	load_saved_state
	wDetPrint hide
}

wDetPrint.help		proc invokeCB { } { GENERIChelp db-ed-print }

wDetPrint.apply		proc invokeCB { } {
    SUITwait wDetPrint 1
    if { ![detprint_apply] } {
	save_state
    }
    SUITwait wDetPrint 0
}

proc details_save { a_filename a_append } {
    if { $a_append != 0 } {
	set mode a
    } else {
	set mode w
      } ;# end of else
    # The user's umask will determine the file protection
    if { [catch { set fd [open $a_filename $mode] } msg ] } {
	InfoMsg "error" \
		[evmviewer.cat get evm_unableto_det_save_error lbl] \
							[get_errormsg_title]
	return 1 
    } else {
    	    if {$fd >= 0} {
	        puts $fd [wDetails.wText getVal]
		close $fd
      } ;# end of else
    	    return 0
    }
}

proc detprint_apply { } {
    global TempDir
    global Error_File

    if { [string trim [wDetPrint.wValue getVal]] == "" } {
	InfoMsg "error" [evmviewer.cat get evm_noprint_command_error lbl] \
							[get_errormsg_title]
		return 1 
    }

    set filename  $TempDir/evmprint_[id user]_[pid].dat
    details_save $filename 0
    # FUTURE: change dbox to accept printer and options
    if { [catch { exec [wDetPrint.wValue getVal] $filename } error] } {
	set error_msg ""
	set error_msg \
	     [evmviewer.cat get evm_app_ext_error lbl]
	append error_msg "\n"
	append error_msg $error
	InfoMsg "error" $error_msg [get_errormsg_title] "wait"
	return 1
    } else { return 0 }
}

###########################################################################

##### Find dialog boxes for Event Details and Event Summaries (unimplemented)
##### Widget callbacks

#wSummFind.ok		proc invokeCB { } { GENERICok wSummFind }
#wSummFind.cancel	proc invokeCB { } { wSummFind hide }
#wSummFind.help		proc invokeCB { } { GENERIChelp db-find }
#
#wSummFind.apply	proc invokeCB { } {
#    SUITwait wSummFind 1
#    wSummFind write			;# commit the changes in this dbox
#
#    FUTURE Find
#    SUITwait wSummFind 0
#}
#
#wDetFind.ok		proc invokeCB { } { GENERICok wDetFind }
#wDetFind.cancel		proc invokeCB { } { wDetFind hide }
#wDetFind.help		proc invokeCB { } { GENERIChelp db-ed-find }
#
#wDetFind.apply	proc invokeCB { } {
#    SUITwait wDetFind 1
#    wDetFind write			;# commit the changes in this dbox
#    evmviewer./evmview/gSuitState modify	;# FLUSH
#
#    FUTURE Find
#    SUITwait wDetFind 0
#}

###########################################################################

##### Event Details dialog box
##### Widget callbacks

wDetails		proc displayCB { } {
    # See wMain.wDetails proc invokeCB
    wDetails_title_set
}

wDetails.ok		proc invokeCB { } { wDetails hide }

wDetails.help		proc invokeCB { } { GENERIChelp db-details }

# To implement Find, add the following button callback:
#wDetails.wDetFind	proc invokeCB { } { SUITpopup wDetails wDetFind }

wDetails.wDetSave	proc invokeCB { } { 
    global wDetSaveHide 
    set wDetSaveHide 0
    SUITpopup wDetails wDetSave 
}

wDetails.wDetPrint	proc invokeCB { } { SUITpopup wDetails wDetPrint }

wDetails.wDetPrev	proc invokeCB { } { wDetailsChange -1 }

wDetails.wDetNext	proc invokeCB { } { wDetailsChange 1 }

wDetails.wDetFirst	proc invokeCB { } { 
    # The first event is actually the third item in the listbox.
    # The headers make up the first two items.
    if { [getValueOfSelection wSummary.wList] < 3 } {
	   InfoMsg "warning" \
		   [evmviewer.cat get evm_first_event lbl] [get_warningmsg_title]
	   return
    }

    # change selection and display new event details
    wSummary.wList setSelection 2

    SUITwait wDetails 1
    # update title and and display new event details
    wDetails_read
    wDetails_title_set
    wDetails.wText read
    SUITwait wDetails 0
}

wDetails.wDetLast	proc invokeCB { } { 
    if { [getValueOfSelection wSummary.wList] \
			 == [expr ([wSummary.wList sizeOfList] - 1)] } {
    	InfoMsg "warning" \
                   [evmviewer.cat get evm_last_event lbl] [get_warningmsg_title]
	return
    } 
    # change selection and display new event details
    wSummary.wList setSelection [expr ([wSummary.wList sizeOfList] - 1)]

    SUITwait wDetails 1
    # update title and and display new event details
    wDetails_read
    wDetails_title_set
    wDetails.wText read
    SUITwait wDetails 0
}

proc wDetailsChange { a_delta } {
    if { ! [wSummary_wList_sel_change $a_delta] } {
	# Info message displayed in wSummary_wList_sel_change
    } else {
		SUITwait wDetails 1
		# update title and and display new event details
		wDetails_read
		wDetails_title_set
		wDetails.wText read
		SUITwait wDetails 0
      } ;#end of else
}

proc wSummary_wList_sel_change { a_delta } {
    set isel [wSummary.wList curSelection]
    incr isel $a_delta

    # the current line is already at the top of the table and
    # the user decrements.

    if { ($isel <= 1) } {
	   InfoMsg "warning" \
		   [evmviewer.cat get evm_first_event lbl] [get_warningmsg_title]
	   return 0
    }
    if { ($isel >= [wSummary.wList sizeOfList]) } {
           InfoMsg "warning" \
                   [evmviewer.cat get evm_last_event lbl] [get_warningmsg_title]
           return 0
    }

    wSummary.wList setSelection [expr \
		 ([getValueOfSelection wSummary.wList] + $a_delta)] 
    return 1 
}

# This proc assumes that
# 1. there is exactly one event summary line selected
# 2. the selected line is not a table header line
#
proc wDetails_read { } {
    global TempFileName
    # At this point, exactly one list entry is selected
    # in event summaries list (wSummary.wList).
    #
    # To generate event details, I need to get a set of items that
    # uniquely identifies  the event. 

    set file_offset [expr ([getValueOfSelection wSummary.wList] - 2)]

    # dOffset is the number of events to skip when reading this event
    # from the temporary file.
    # iMcl is decremented by 3 because
    # - there are 2 header lines in the displayed list, and
    # - SUIT calls its first line #1, but the MCL calls its first row #0.

    if { [catch {
            set details [exec /usr/bin/evmshow -d -n 1 \
                -k $file_offset $TempFileName 2>/dev/null] } msg ] } {
            		set details $msg
    }
    wDetails.wText setVal $details
    wDetails write
}


proc wDetails_title_set { } {
    set file_offset [getValueOfSelection wSummary.wList]
    SUITtitleSet wDetails [get_event_id $file_offset]
}

proc get_event_id { file_offset } {
    global TempFileName
    global ErrorFlag

    if { [catch { \
    set id [exec /usr/bin/evmshow -t @event_id -k [expr ($file_offset - 2)] -n 1 $TempFileName]} msg ] } {
        return $msg
    } else { return $id }
}

###########################################################################

##### VISIBLE ITEMS SELECTION DIALOG BOX

wItems.ok		proc invokeCB { } {
    SUITwait wItems 1
    wNoOfEvents_apply 1
    SUITwait wItems 0
}

wItems.cancel		proc invokeCB { } {
     load_saved_state
     wItems hide 
}

wItems.help		proc invokeCB { } { GENERIChelp db-customize }

wItems.apply		proc invokeCB { } {
    SUITwait wItems 1
    wNoOfEvents_apply 0
    SUITwait wItems 0
}

proc                   wNoOfEvents_apply { close } {
    global NoOfEvents
    if { ![check_NumOfEvents_error] } {
        set NoOfEvents [string trim [wItems.wNumOfEvents getVal]]
        load_events
        save_state
        write_preferences
        SUITtitleSet wSummary.wList [get_list_label]
        if { $close } {
            wItems hide
        }
    }
}

proc check_NumOfEvents_error { } {
    set no_of_events [string trim [wItems.wNumOfEvents getVal]]
    if { ([catch {expr $no_of_events + 1}]) || \
	 ($no_of_events == "") || ($no_of_events < 1) || \
					($no_of_events > 100000) } {
         InfoMsg "error" \
                [evmviewer.cat get evm_invalid_no_of_events lbl] \
                                                        [get_errormsg_title]
        return 1
    } else { return 0 }
}


###########################################################################

##### SORT DIALOG BOX

wSort 			proc initCB { } {
    set_sort_selection
}

wSort 			proc displayCB { } {
    set_sort_selection
}

proc set_sort_selection { } {
    global SummaryFields
    global OldSortKey

    # For each item displayable in the event summaries
    # If it's currently visible, display it as a possible sort key
    wSort.wItems clear	;# clear out whatever we used last time
    set listText {}
    set isel ""
    set index 0
    foreach v $SummaryFields {
	if [wItems.$v getVal] {
	    wSort.wItems setListItem listText [SUITcatget wItems_$v lbl] $v
            if { $v == $OldSortKey } {
                set isel $index
            }
	    incr index
	}
    }

    if { $listText != {} } {
	wSort.wItems insertDspStr end $listText
    }
 
    # set the selection to whatever we last selected (if it's there)
    if { $isel != "" } {
        wSort.wItems setSelection $isel
    }
}

wSort.help		proc invokeCB { } { GENERIChelp db-sort }

wSort.ok		proc invokeCB { } { 
    wSort_apply
    save_state
    write_preferences
    wSort hide
}

wSort.cancel		proc invokeCB { } {
    load_saved_state
    wSort hide 
}

wSort.apply		proc invokeCB { } {
   wSort_apply
   save_state
   write_preferences
}

proc wSort_apply { } {
    global OldSortKey
    SUITwait wSort 1
    set OldSortKey [lindex [lindex [wSort.wItems getCurSelection] 0] 1]

    # We only need to sort here. So we call only the sort and load procs.
    sort_events [get_sort_parameter]
    load_events 
    SUITwait wSort 0
}

###########################################################################

##### FILTER DIALOG BOX

wFilter			proc displayCB { } { }

wFilter.ok		proc invokeCB { }  { 
    SUITwait wFilter 1

    # do error checking on the filter
    # if no errors, call 'apply_filter' which does the work 
    # and hide the dialog box
    if { ! [error_check_filter] } { 
	apply_filter ; 
        save_state
 	write_preferences
	wFilter hide 

	# if no events have been found- alert the user
	if { [get_total_events] == 0 } {
	    InfoMsg "warning" \
		    [evmviewer.cat get evm_no_events_found lbl] \
							[get_warningmsg_title]
	}
    }
    SUITwait wFilter 0
}

wFilter.apply		proc invokeCB { } {
    SUITwait wFilter 1
    if { ! [error_check_filter] } { 
	apply_filter
        save_state
	write_preferences
	# if no events have been found- alert the user
	if { [get_total_events] == 0 } {
	    InfoMsg "warning" \
		    [evmviewer.cat get evm_no_events_found lbl] \
							[get_warningmsg_title]
	}
    }
    SUITwait wFilter 0
}

wFilter.cancel		proc invokeCB { } {
    load_saved_state
    wFilter hide 
}

wFilter.help		proc invokeCB { } { GENERIChelp db-filter }


## EnableOrDisable -- enable or disable a set of widgets based on a boolean
## enable flag.  A single element is a valid list in TCL so you can easily do:
## code courtesy of Tom Popovich

##   EnableOrDisable  { foo bar} 1     ==> enables both foo and bar
##   EnableOrDisable  foo        1     ==> enables foo
proc EnableOrDisable { myWidgetList bEnableFlag } {
    if { $bEnableFlag } {
        foreach myWidget $myWidgetList {
            $myWidget enable
        }
    } else {
        foreach myWidget $myWidgetList {
            $myWidget disable
        }
    }
}

wFilter proc initCB {} {

    wFilter.wNameFlag  changeCB
    wFilter.wHostFlag  changeCB
    wFilter.wPriorityFlag  changeCB
    wFilter.wBeforeFlag  changeCB
    wFilter.wSinceFlag  changeCB
    wFilter.wAgeFlag       changeCB
}

wFilter.wNameFlag proc changeCB {} {
    set bCheckEnabled [wFilter.wNameFlag getVal ]

    EnableOrDisable   [list wFilter.wNameEqualityChoice wFilter.wName ] $bCheckEnabled
}

wFilter.wHostFlag proc changeCB {} {
    set bCheckEnabled [wFilter.wHostFlag getVal ]

    EnableOrDisable   [list wFilter.wHostEqualityChoice  wFilter.wHost ] $bCheckEnabled
}

wFilter.wPriorityFlag proc changeCB {} {
    set bCheckEnabled [wFilter.wPriorityFlag getVal ]

    EnableOrDisable   [list wFilter.wPrioEqualityChoice  \
                wFilter.wPriorityChoice ]  $bCheckEnabled
    wFilter.wPriorityChoice changeCB

}

wFilter.wPriorityChoice proc changeCB { } {

# handle the text fields within the Priority field
# if the Priority flag is off then this will disable all the text fields
# otherwise the text fields(s) associated with the Choice field will 
# be enabled

    set textfield(range) [ list wFilter.wPriorityRangeMin wFilter.wPriorityRangeMax ]
    set textfield(absolute) wFilter.wPriorityAbsolute
    set textfield(min) wFilter.wPriorityMin
    set textfield(max) wFilter.wPriorityMax
    set bCheckEnabled [wFilter.wPriorityFlag getVal]

    foreach i [array names textfield] {
	if { [wFilter.wPriorityChoice getVal] == $i } {
	    EnableOrDisable $textfield($i) $bCheckEnabled
	} else {
	    EnableOrDisable $textfield($i) 0 }
	}
    }

wFilter.wBeforeFlag proc changeCB {} {
    set bCheckEnabled [wFilter.wBeforeFlag getVal ]

    EnableOrDisable   [list wFilter.wBeforeDay  wFilter.wBeforeMon wFilter.wBeforeYear \
                wFilter.wBeforeHour \
                wFilter.wBeforeMin \
                wFilter.wBeforeSec \
                 \
     ]  $bCheckEnabled

}

wFilter.wSinceFlag proc changeCB {} {
    set bCheckEnabled [wFilter.wSinceFlag getVal ]

    EnableOrDisable   [list wFilter.wSinceDay \
                                            wFilter.wSinceMon \
                                            wFilter.wSinceYear \
                                            wFilter.wSinceHour \
                                            wFilter.wSinceMin \
                                            wFilter.wSinceSec \
                                            \
                                            ]  $bCheckEnabled

}

wFilter.wAgeFlag proc changeCB {} {
    set bCheckEnabled [wFilter.wAgeFlag getVal]

    EnableOrDisable [list wFilter.wAgeEqualityChoice \
	    wFilter.wAgeValue wFilter.wAgeQualifer] $bCheckEnabled
}

# DEFECT:moduleTest: forgot wSelect & wCustom in initCB

# for each widget in the filter widgets list, check if the
# flag is active. If so, test the filter. If not valid, pop
# up error message, otherwise continue checking each filter
# separately. If all active filters pass, apply the filter.
# Also checks the inactive filter values. If invalid the 
# same will be set to default.

proc error_check_filter { } {
    # check name filter if specified
    if { [wFilter.wNameFlag getVal] } {  

	# which  equality choice was chosen?
	set equality_choice [wFilter.wNameEqualityChoice getVal]

	if {$equality_choice == "equalto"} {
	    set filter "\[name [wFilter.wName getVal]\]"
	} else {
	    set filter "!\[name [wFilter.wName getVal]\]"
	}

	# FUTURE: make constant for the evmget command

	# an invalid filter will raise an exception and return
        # the message string as msg (currently unused)

	if { [catch { 
	    exec /usr/bin/evmget -e -f $filter  } msg ] } {
	    InfoMsg "error" \
		    [evmviewer.cat get evm_invalid_name_filter lbl] \
							[get_errormsg_title]
	    return 1
	} 
    }
    
    # check host if specified
    if { [wFilter.wHostFlag getVal] } {


	# which  equality choice was chosen?
	set equality_choice [wFilter.wHostEqualityChoice getVal]

	if {$equality_choice == "equalto"} {
	    set filter "\(\[host [wFilter.wHost getVal]\]|\[cluster_name [wFilter.wHost getVal]\]\)"
	} else {
	    set filter "\(!\[host [wFilter.wHost getVal]\] & !\[cluster_name [wFilter.wHost getVal]\]\)"
	}

	if { [catch { 
	    exec /usr/bin/evmget -e -f $filter  } msg ] } {
	    InfoMsg "error" \
		    [evmviewer.cat get evm_invalid_host_filter lbl] \
							[get_errormsg_title]
	    return 1
	}
    }

    # check priority if specified
    if { [wFilter.wPriorityFlag getVal] } {

	# which  priority choice was chosen?
	set priority_choice [wFilter.wPriorityChoice getVal]

	# which  equality choice was chosen?
	set equality_choice [wFilter.wPrioEqualityChoice getVal]

	############# Range #############
	if {$priority_choice == "range"} {
    	# check if the max and min priority range is within range

	if {![string length [string trim [wFilter.wPriorityRangeMax getVal]]] || 
	   ![string length [string trim [wFilter.wPriorityRangeMin getVal]]] } {
			InfoMsg "error" \
                    [evmviewer.cat get evm_invalid_priority_range_filter lbl] \
							[get_errormsg_title]
                        return 1
        }

	set test_value \
	[string trimleft [string trim [wFilter.wPriorityRangeMax getVal]] 0]
	if { ![string length $test_value] } { set test_value 0 }

    		if { $test_value < 0 ||
         		$test_value > 700 ||
			[catch {expr $test_value + 1}]} {
             		InfoMsg "error" \
                    [evmviewer.cat get evm_invalid_priority_range_filter lbl] \
							[get_errormsg_title]
             		return 1
         	}
	set test_value \
	[string trimleft [string trim [wFilter.wPriorityRangeMin getVal]] 0]
	if { ![string length $test_value] } { set test_value 0 }

    		if { $test_value < 0 ||
         		$test_value > 700 ||
			[catch {expr $test_value + 1}]} {
             		InfoMsg "error" \
                    [evmviewer.cat get evm_invalid_priority_range_filter lbl] \
							[get_errormsg_title]
             		return 1
		   }
	if { [string trimleft [string trim \
			 [wFilter.wPriorityRangeMin getVal]] 0] > [string \
	       trimleft [string trim [wFilter.wPriorityRangeMax getVal]] 0] } {
		InfoMsg "error" \
		[evmviewer.cat get evm_invalid_prio_ranges lbl] \
							 [get_errormsg_title]
		return 1
	} 
	} else {

	if {![string length [string trim [wFilter.wPriorityRangeMax getVal]]]} {
		wFilter.wPriorityRangeMax setVal 700
	} else {
		set test_value \
	[string trimleft [string trim [wFilter.wPriorityRangeMax getVal]] 0]
		if { ![string length $test_value] } { set test_value 0 }
			if { $test_value < 0 ||
                       		$test_value > 700 ||
				[catch {expr $test_value + 1}]} {
				wFilter.wPriorityRangeMax setVal 700 }
		}

	if {![string length [string trim [wFilter.wPriorityRangeMin getVal]]]} {
		wFilter.wPriorityRangeMin setVal 0
	} else {
		set test_value \
	[string trimleft [string trim [wFilter.wPriorityRangeMin getVal]] 0]
		if { ![string length $test_value] } { set test_value 0 }
			if { $test_value < 0 ||
                       		$test_value > 700 ||
				[catch {expr $test_value + 1}]} {
				wFilter.wPriorityRangeMin setVal 0 }
		}
	}

	############ Absolute ############

	if {$priority_choice == "absolute"} {

	if {![string length [string trim [wFilter.wPriorityAbsolute getVal]]]} {
		InfoMsg "error" \
           [evmviewer.cat get evm_invalid_absolute_priority_range_filter lbl] \
							[get_errormsg_title]
                        return 1
	}	

	set test_value \
	[string trimleft [string trim [wFilter.wPriorityAbsolute getVal]] 0]
	if { ![string length $test_value] } { set test_value 0 }
    		# check if the absolute priority is within range
    		if { $test_value < 0 ||
         		$test_value > 700 ||
			[catch {expr $test_value + 1}]} {
             		InfoMsg "error" \
           [evmviewer.cat get evm_invalid_absolute_priority_range_filter lbl] \
							[get_errormsg_title]
             		return 1
		}
        } else {

	if {![string length [string trim [wFilter.wPriorityAbsolute getVal]]]} {
		wFilter.wPriorityAbsolute setVal 0 
	} else {
		set test_value \
	[string trimleft [string trim [wFilter.wPriorityAbsolute getVal]] 0]
		if { ![string length $test_value] } { set test_value 0 }
		if { $test_value < 0 ||
                       	$test_value > 700 ||
			[catch {expr $test_value + 1}]} {
			wFilter.wPriorityAbsolute setVal 0 }
		}
	}
    
	############ Min ############

	if {$priority_choice == "min"} {

	if { ![string length [string trim [wFilter.wPriorityMin getVal]]] } {
		InfoMsg "error" \
                [evmviewer.cat get evm_invalid_min_priority_range_filter lbl] \
							[get_errormsg_title]
                return 1
	} else {
    	# check if the min priority specified is within range
		set test_value \
		[string trimleft [string trim [wFilter.wPriorityMin getVal]] 0]
		if { ![string length $test_value] } { set test_value 0 }
    			if { $test_value < 0 ||
         			$test_value > 700 ||
				[catch {expr $test_value + 1}]} {
             			InfoMsg "error" \
                [evmviewer.cat get evm_invalid_min_priority_range_filter lbl] \
							[get_errormsg_title]
             			return 1
         		}
		}
	
	} else {
		if { ![string length [string trim [wFilter.wPriorityMin getVal]]] } {
			wFilter.wPriorityMin setVal 0
		} else {
			set test_value \
		[string trimleft [string trim [wFilter.wPriorityMin getVal]] 0]
			if { ![string length $test_value] } { set test_value 0 }
			if { $test_value < 0 ||
                		$test_value > 700 ||
				[catch {expr $test_value + 1}]} {
				wFilter.wPriorityMin setVal 0 }
			}
		}

	############ Max ############

	if {$priority_choice == "max"} {

	if { ![string length [string trim [wFilter.wPriorityMax getVal]]] } {
		InfoMsg "error" \
                [evmviewer.cat get evm_invalid_max_priority_range_filter lbl] \
							[get_errormsg_title]
                        return 1
	} else {
    	# check if the max priority specified is within range
		set test_value \
		[string trimleft [string trim [wFilter.wPriorityMax getVal]] 0]
		if { ![string length $test_value] } { set test_value 0 }
    		if { $test_value < 0 ||
         		$test_value > 700 ||
			[catch {expr $test_value + 1}] } {
             		InfoMsg "error" \
                [evmviewer.cat get evm_invalid_max_priority_range_filter lbl] \
							[get_errormsg_title]
             		return 1
         		}
		}
	} else {

		if { ![string length [string trim [wFilter.wPriorityMax getVal]]] } {
			wFilter.wPriorityMax setVal 700
		} else {
	
			set test_value \
		[string trimleft [string trim [wFilter.wPriorityMax getVal]] 0]
			if { ![string length $test_value] } { set test_value 0 }
			if { $test_value < 0 ||
                        	$test_value > 700 ||
				[catch {expr $test_value + 1}]} {
				wFilter.wPriorityMax setVal 700 }
			}
		}

    } else {

	if {![string length [string trim [wFilter.wPriorityRangeMax getVal]]]} {
		wFilter.wPriorityRangeMax setVal 700
	} else {
		set test_value \
	[string trimleft [string trim [wFilter.wPriorityRangeMax getVal]] 0]
		if { ![string length $test_value] } { set test_value 0 }
		if { $test_value < 0 ||
                       	$test_value > 700 ||
			[catch {expr $test_value + 1}]} {
			wFilter.wPriorityRangeMax setVal 700 }
	}

	if {![string length [string trim [wFilter.wPriorityRangeMin getVal]]]} {
		wFilter.wPriorityRangeMin setVal 0
	} else {
		set test_value \
	[string trimleft [string trim [wFilter.wPriorityRangeMin getVal]] 0]
		if { ![string length $test_value] } { set test_value 0 }
		if { $test_value < 0 ||
                       	$test_value > 700 ||
			[catch {expr $test_value + 1}]} {
			wFilter.wPriorityRangeMin setVal 5 }
	}

	if {![string length [string trim [wFilter.wPriorityAbsolute getVal]]]} {
		wFilter.wPriorityAbsolute setVal 0
	} else {
		set test_value \
	[string trimleft [string trim [wFilter.wPriorityAbsolute getVal]] 0]
		if { ![string length $test_value] } { set test_value 0 }
		if { $test_value < 0 ||
                       	$test_value > 700 ||
			[catch {expr $test_value + 1}]} {
			wFilter.wPriorityAbsolute setVal 0 }
	}

	if { ![string length [string trim [wFilter.wPriorityMin getVal]]] } {
		wFilter.wPriorityMin setVal 0
	} else {
		set test_value \
		[string trimleft [string trim [wFilter.wPriorityMin getVal]] 0]
		if { ![string length $test_value] } { set test_value 0 }
		if { $test_value < 0 ||
                	$test_value > 700 ||
			[catch {expr $test_value + 1}]} {
			wFilter.wPriorityMin setVal 0 }
	}

	if { ![string length [string trim [wFilter.wPriorityMax getVal]]] } {
		wFilter.wPriorityMax setVal 700
	} else {
		set test_value \
		[string trimleft [string trim [wFilter.wPriorityMax getVal]] 0]
		if { ![string length $test_value] } { set test_value 0 }
		if { $test_value < 0 ||
                        $test_value > 700 ||
			[catch {expr $test_value + 1}]} {
			wFilter.wPriorityMax setVal 700 }
		}
   }

    # check before if specified
    if { [wFilter.wBeforeFlag getVal] } {

	if {![string length [string trim [wFilter.wBeforeDay getVal]]]} {
		InfoMsg "error" \
                        [evmviewer.cat get evm_invalid_before_day lbl] \
							[get_errormsg_title]
                return 1
        }
	if {![string length [string trim [wFilter.wBeforeYear getVal]]]} {
		InfoMsg "error" \
                        [evmviewer.cat get evm_invalid_before_year lbl] \
							[get_errormsg_title]
                return 1
        }
	if {![string length [string trim [wFilter.wBeforeHour getVal]]]} {
		InfoMsg "error" \
                        [evmviewer.cat get evm_invalid_before_hour lbl] \
							[get_errormsg_title]
                return 1
        }
	if {![string length [string trim [wFilter.wBeforeMin getVal]]]} {
		InfoMsg "error" \
                        [evmviewer.cat get evm_invalid_before_min lbl] \
							[get_errormsg_title]
                return 1
        }
	if {![string length [string trim [wFilter.wBeforeSec getVal]]]} {
		InfoMsg "error" \
                        [evmviewer.cat get evm_invalid_before_sec lbl] \
							[get_errormsg_title]
                return 1
        }
	
	set test_value \
	[string trimleft [string trim [wFilter.wBeforeDay getVal]] 0]
	if { ![string length $test_value] } { set test_value 0 }
	if { $test_value < 1 ||
         	$test_value > 31 ||
			[catch {expr $test_value + 1}]} {
             		InfoMsg "error" \
                    	[evmviewer.cat get evm_invalid_before_day lbl] \
							[get_errormsg_title]
             	return 1
       	}

	set test_value \
	[string trimleft [string trim [wFilter.wBeforeYear getVal]] 0]
	if { ![string length $test_value] } { set test_value 0 }
    	if { $test_value < 1970 ||
         	$test_value > 2030 ||
			[catch {expr $test_value + 1}]} {
             		InfoMsg "error" \
                    	[evmviewer.cat get evm_invalid_before_year lbl] \
							[get_errormsg_title]
             	return 1
       	}

	set test_value \
	[string trimleft [string trim [wFilter.wBeforeHour getVal]] 0]
	if { ![string length $test_value] } { set test_value 0 }
    	if { $test_value < 0 ||
         	$test_value > 23 ||
			[catch {expr $test_value + 1}]} {
             		InfoMsg "error" \
                    	[evmviewer.cat get evm_invalid_before_hour lbl] \
							[get_errormsg_title]
             	return 1
       	}

	set test_value \
	[string trimleft [string trim [wFilter.wBeforeMin getVal]] 0]
	if { ![string length $test_value] } { set test_value 0 }
    	# check if the minute is within range
    	if { $test_value < 0 ||
         	$test_value > 59 ||
			[catch {expr $test_value + 1}]} {
             		InfoMsg "error" \
                    	[evmviewer.cat get evm_invalid_before_min lbl] \
							[get_errormsg_title]
             	return 1
	}

	set test_value \
	[string trimleft [string trim [wFilter.wBeforeSec getVal]] 0]
	if { ![string length $test_value] } { set test_value 0 }
    	# check if the second is within range
     	if { $test_value < 0 ||
         	$test_value > 59 ||
			[catch {expr $test_value + 1}]} {
             		InfoMsg "error" \
                    	[evmviewer.cat get evm_invalid_before_sec lbl] \
							[get_errormsg_title]
             	return 1
	}
    } else {
	set test_value \
	[string trimleft [string trim [wFilter.wBeforeDay getVal]] 0]
	if { ![string length $test_value] } { set test_value 0 }
		if { $test_value < 1 ||
                $test_value > 31 ||
			[catch {expr $test_value + 1}]} {
			wFilter.wBeforeDay setVal 1 }

	set test_value \
	[string trimleft [string trim [wFilter.wBeforeYear getVal]] 0]
	if { ![string length $test_value] } { set test_value 0 }
		if { $test_value < 1970 ||
                $test_value > 2030 ||
		[catch {expr $test_value + 1}]} {
			wFilter.wBeforeYear setVal 1997 }

        set test_value \
	[string trimleft [string trim [wFilter.wBeforeHour getVal]] 0]
        if { ![string length $test_value] } { 
		set test_value 0 
		wFilter.wBeforeHour setVal 0 
	}
	if { $test_value < 0 ||
                $test_value > 23 ||
		[catch {expr $test_value + 1}]} {
			wFilter.wBeforeHour setVal 0 
	}

        set test_value \
	[string trimleft [string trim [wFilter.wBeforeMin getVal]] 0]
        if { ![string length $test_value] } { 
		set test_value 0 
		wFilter.wBeforeMin setVal 0 
	}
	if { $test_value < 0 ||
                $test_value > 59 ||
		[catch {expr $test_value + 1}]} {
			wFilter.wBeforeMin setVal 0 
	}

        set test_value \
	[string trimleft [string trim [wFilter.wBeforeSec getVal]] 0]
        if { ![string length $test_value] } { 
		set test_value 0 
		wFilter.wBeforeSec setVal 0 
	}
	if { $test_value < 0 ||
                $test_value > 59 ||
		[catch {expr $test_value + 1}]} {
			wFilter.wBeforeSec setVal 0 
	}
	   }
    
    if { [wFilter.wSinceFlag getVal] } {

	if { ![string length [string trim [wFilter.wSinceDay getVal]]] } {
		InfoMsg "error" \
                    [evmviewer.cat get evm_invalid_since_day lbl] \
							[get_errormsg_title]
                return 1
         }
	if { ![string length [string trim [wFilter.wSinceYear getVal]]] } {
		InfoMsg "error" \
                    [evmviewer.cat get evm_invalid_since_year lbl] \
							[get_errormsg_title]
             return 1
         }
	if { ![string length [string trim [wFilter.wSinceHour getVal]]] } {
		InfoMsg "error" \
                    [evmviewer.cat get evm_invalid_since_hour lbl] \
							[get_errormsg_title]
             return 1
         }
	if { ![string length [string trim [wFilter.wSinceMin getVal]]] } {
		InfoMsg "error" \
                    [evmviewer.cat get evm_invalid_since_min lbl] \
							[get_errormsg_title]
             return 1
         }
	if { ![string length [string trim [wFilter.wSinceSec getVal]]] } {
		InfoMsg "error" \
                    [evmviewer.cat get evm_invalid_since_sec lbl] \
							[get_errormsg_title]
             return 1
         }

    # check if the day is within range
    	set test_value \
		[string trimleft [string trim [wFilter.wSinceDay getVal]] 0]
    	if { ![string length $test_value] } { set test_value 0 }
    	if { $test_value < 1 ||
         	$test_value > 31 ||
	 	[catch {expr $test_value + 1}]} {
             	InfoMsg "error" \
                    [evmviewer.cat get evm_invalid_since_day lbl] \
							[get_errormsg_title]
             	return 1
         }

    # check if the year is within range
    	set test_value \
		[string trimleft [string trim [wFilter.wSinceYear getVal]] 0]
    	if { ![string length $test_value] } { set test_value 0 }
    	if { $test_value < 1970 ||
         	$test_value > 2030 ||
	 	[catch {expr $test_value + 1}]} {
             	InfoMsg "error" \
                    [evmviewer.cat get evm_invalid_since_year lbl] \
							[get_errormsg_title]
             	return 1
         }

    	# check if the hour is within range
    	set test_value \
		[string trimleft [string trim [wFilter.wSinceHour getVal]] 0]
    	if { ![string length $test_value] } { set test_value 0 }
    	if { $test_value < 0 ||
         	$test_value > 23 ||
	 	[catch {expr $test_value + 1}]} {
             	InfoMsg "error" \
                    [evmviewer.cat get evm_invalid_since_hour lbl] \
							[get_errormsg_title]
            	return 1
         }

    	# check if the minute is within range
    	set test_value \
		[string trimleft [string trim [wFilter.wSinceMin getVal]] 0]
    	if { ![string length $test_value] } { set test_value 0 }
    	if { $test_value < 0 ||
         	$test_value > 59 ||
	 	[catch {expr $test_value + 1}]} {
             	InfoMsg "error" \
                    [evmviewer.cat get evm_invalid_since_min lbl] \
							[get_errormsg_title]
             	return 1
         }

    	# check if the second is within range
    	set test_value \
		[string trimleft [string trim [wFilter.wSinceSec getVal]] 0]
    	if { ![string length $test_value] } { set test_value 0 }
     	if { $test_value < 0 ||
         	$test_value > 59 ||
	 	[catch {expr $test_value + 1}]} {
             	InfoMsg "error" \
                    [evmviewer.cat get evm_invalid_since_sec lbl] \
							[get_errormsg_title]
             	return 1
         }
    } else {
    		set test_value \
	[string trimleft [string trim [wFilter.wSinceDay getVal]] 0]
    		if { ![string length $test_value] } { 
			set test_value 0 
			wFilter.wSinceDay setVal 1 
		}
		if { $test_value < 1 ||
         		$test_value > 31 ||
	 		[catch {expr $test_value + 1}]} {
			wFilter.wSinceDay setVal 1 
		}

    		set test_value \
	[string trimleft [string trim [wFilter.wSinceYear getVal]] 0]
    		if { ![string length $test_value] } { 
			set test_value 0 
			wFilter.wSinceYear setVal 1997 
		}
		if { $test_value < 1970 ||
         		$test_value > 2030 ||
	 		[catch {expr $test_value + 1}]} {
			wFilter.wSinceYear setVal 1997 
		}

    		set test_value \
	[string trimleft [string trim [wFilter.wSinceHour getVal]] 0]
    		if { ![string length $test_value] } { 
			set test_value 0
			wFilter.wSinceHour setVal 0 
		}
		if { $test_value < 0 ||
         		$test_value > 23 ||
	 		[catch {expr $test_value + 1}]} {
			wFilter.wSinceHour setVal 0 
		}

    		set test_value \
	[string trimleft [string trim [wFilter.wSinceMin getVal]] 0]
    		if { ![string length $test_value] } { 
			set test_value 0 
			wFilter.wSinceMin setVal 0
		}
		if { $test_value < 0 ||
         		$test_value > 59 ||
	 		[catch {expr $test_value + 1}]} {
			wFilter.wSinceMin setVal 0 
		}

    		set test_value \
	[string trimleft [string trim [wFilter.wSinceSec getVal]] 0]
    		if { ![string length $test_value] } { 
			set test_value 0 
			wFilter.wSinceSec setVal 0 
		}
		if { $test_value < 0 ||
         		$test_value > 59 ||
	 		[catch {expr $test_value + 1}]} {
			wFilter.wSinceSec setVal 0 
		}
	}

	if { [wFilter.wAgeFlag getVal] } {
	    if { ![string length [string trim [wFilter.wAgeValue getVal] ] ] } {
	InfoMsg "error" \
		[evmviewer.cat get evm_invalid_age_filter lbl] \
		[get_errormsg_title] 
		return 1
	    }

	    set test_value [wFilter.wAgeValue getVal]

	    # see if the value is a valid number

	    if { ![regexp {^[0-9]+$} $test_value] } {
		InfoMsg "error" \
			[evmviewer.cat get evm_invalid_age_filter lbl] \
			[get_errormsg_title] 
		return 1
	    }

	    # see if the value is within range 0-99999
	    if { ($test_value < 0) || ($test_value > 99999) } {
		InfoMsg "error" \
			[evmviewer.cat get evm_invalid_age_filter lbl] \
			[get_errormsg_title] 
		return 1
	    }
	}

    return 0; # no invalid fields in selected filter options
}

proc apply_filter { } {
    global AdvancedFilterFlag

    wFilter write			;# commit the changes in this dbox

    # In case the previously applied filter was the advanced filter
    # set the advanced filter flag to zero.
    set AdvancedFilterFlag 0
 
    # Update the list widget in the main window using the new filter.
    load_summaries 
}

################################################

##### ADVANCED FILTER DIALOG BOX ###############

# Initialization for the Advanced Filter. initCB checks if the advanced
# filter directory exists and if not creates the directory. 

wAdvFilter    		proc initCB {} {
    global AdvFiltersDir
    if { ! [file exists $AdvFiltersDir] } {
                if [catch { mkdir $AdvFiltersDir} ] {
                }
    }
}

# Callbacks for the AdvFilter dialog
wAdvFilter.ok		proc invokeCB { } {
    SUITwait wAdvFilter 1

    if { ! [error_check_AdvFilter] } {
	AdvFilter_apply
	save_state
	wAdvFilter hide
	hidewOptions 	
	
	# if no events have been found- alert the user
        if { [get_total_events] == 0 } {
            InfoMsg "warning" \
                    [evmviewer.cat get evm_no_events_found lbl] \
							[get_warningmsg_title]
        }
    }
   SUITwait wAdvFilter 0
}

wAdvFilter.apply	proc invokeCB { } {
    SUITwait wAdvFilter  1

    if {! [error_check_AdvFilter] } {	
	AdvFilter_apply
        save_state 
	
	# if no events have been found- alert the user
	if { [get_total_events] == 0 } {
	    InfoMsg "warning" \
		    [evmviewer.cat get evm_no_events_found lbl] \
							[get_warningmsg_title]
	}
    }

   SUITwait wAdvFilter 0
}

wAdvFilter.cancel	proc invokeCB { } {
    global wOptionsHide
    set wOptionsHide 0
    load_saved_state
    wAdvFilter hide
}

wAdvFilter.help		proc invokeCB { } { GENERIChelp db-advanced }

# AdvFilter_apply does the real work of applying the advanced filter. This
# filter is applied independently and is not "and"ed with the the standard
# filter.

proc AdvFilter_apply { } {
    global AdvancedFilterFlag
    wAdvFilter write		;# commit the changes in this dbox

    set AdvancedFilterFlag 1
    # Update the list widget in the main window using the new filter.
    load_summaries 
}

proc error_check_AdvFilter { } {
	set filter [string trim [wAdvFilter.wAdvFltField getVal]]

        # an invalid filter will raise an exception and return.
        if { "" == $filter } {
	     InfoMsg "error" \
                    [evmviewer.cat get evm_advfiltr_no_string lbl] \
                                                        [get_errormsg_title]
	     return 1
	}

        if { [catch {
            exec /usr/bin/evmget -e -f $filter  } msg ] } {
            InfoMsg "error" \
                    [evmviewer.cat get evm_invalid_advanced_filter lbl] \
							[get_errormsg_title]
                    return 1;
	}

	return 0
}

# Callbacks to load a filter from a file

wAdvFilter.wLoadFilter	proc invokeCB { } {
	set which_list "wLoadAdvanced.wSavedFiles"
	if { [fill_list $which_list] } {
		InfoMsg "error" [evmviewer.cat get evm_listing_dir_error lbl] \
							[get_errormsg_title]
	} else {
		 SUITpopup wAdvFilter wLoadAdvanced 
	       }
}

wLoadAdvanced.ok	proc invokeCB { } {
    SUITwait wLoadAdvanced 1
    if { ![wLoadAdvanced.wSavedFiles selectedItemCount] } {
	wLoadAdvanced hide } else {
    		if { ![apply_load] } { wLoadAdvanced hide }
    }
    SUITwait wLoadAdvanced 0
}

wLoadAdvanced.cancel	proc invokeCB { } {
    wLoadAdvanced hide
}

wLoadAdvanced.apply     proc invokeCB { } {
    SUITwait wLoadAdvanced 1
    apply_load
    SUITwait wLoadAdvanced 0
}

wLoadAdvanced.help	proc invokeCB { } { GENERIChelp db-advanced-load }

# apply_load does the work of opening the file and getting the filter string
# and inserting in the AdvFltField widget

proc apply_load { } {
    global AdvFiltersDir
    global env

    set selection [wLoadAdvanced.wSavedFiles getCurDspStrs]
    
    if { [wLoadAdvanced.wSavedFiles sizeOfList] < 1 } {
	InfoMsg "error" \
                [evmviewer.cat get evm_advfiltr_nofiles_error lbl] \
							[get_errormsg_title]
        return 1
    }

    # check for the case when the user did not select an
    # entry to load
    if { $selection == "" } { 
	InfoMsg "error" \
		[evmviewer.cat get evm_advfiltr_load_sel_error lbl] \
							[get_errormsg_title]
	return 1 
    }

    set filter_selection "@"
    if [ info exists env(HOME) ] { 
	set home $env(HOME)
    } else {
	set home /
    }
    append filter_selection $home/.sysman/evmfilters/
    append filter_selection $selection
    append filter_selection .evf

    set result [ catch { exec /usr/bin/evmshow -f $filter_selection -F } filter_string ]
    if { 0 == $result }  {
	set filter_string [ string trimright $filter_string ]
    	wAdvFilter.wAdvFltField setVal $filter_string
	return 0
    } else {
	InfoMsg "error" \
		[evmviewer.cat get evm_advfiltr_cannot_load_error lbl] \
		[get_errormsg_title]
	return 1;
    }

}

# callback to delete a advanced filter file

wLoadAdvanced.wSavedFiles.wDelete proc invokeCB { } {
    global AdvFiltersDir
    set selection [wLoadAdvanced.wSavedFiles getCurDspStrs]
    append selection .evf

    unlink -nocomplain  $AdvFiltersDir/$selection
    set which_list "wLoadAdvanced.wSavedFiles"
    fill_list $which_list
}

# callbacks to save a filter to a file

wAdvFilter.wSaveFilter	proc invokeCB { } {
    # first check if there is a filter string to save!
    # get rid of leading spaces
    if { [string trim [wAdvFilter.wAdvFltField getVal]] == "" } {
	InfoMsg "error" [evmviewer.cat get evm_advfiltr_no_string lbl] \
							[get_errormsg_title]
	return;
    } else {
                 SUITpopup wAdvFilter wSaveAdvanced 
	   }
}

wSaveAdvanced.ok        proc invokeCB { } {
    SUITwait wSaveAdvanced 1
    if { ! [apply_save] } {
	save_state
 	wSaveAdvanced hide 
    }
    SUITwait wSaveAdvanced 0
}

wSaveAdvanced.cancel    proc invokeCB { } {
    wSaveAdvanced hide
}

wSaveAdvanced.help	proc invokeCB { } { GENERIChelp db-advanced-save }


# apply_save does the real work of checking if the file exists and if not
# opens a new file and writes the filter into it
proc apply_save { } {
    global AdvFiltersDir	
    set selection [string trim [wSaveAdvanced.wSaveAsFile getVal]]

    if { $selection == "" } { 
        InfoMsg "error" \
	    [evmviewer.cat get evm_advfiltr_save_filename lbl] \
							[get_errormsg_title]
        return 1;
    }

    if { [string index $selection 0] == "." ||
        	[string first " " $selection] != -1 } { 
        InfoMsg "error" \
                   [evmviewer.cat get evm_advfiltr_invalid_filename lbl] \
							[get_errormsg_title]
        return 1;
    }

    append selection .evf
    if {[catch {set fileid [open $AdvFiltersDir/$selection w]} msg ]} {
        InfoMsg "error" \
	    [evmviewer.cat get evm_advfiltr_unableto_save_error lbl] \
							[get_errormsg_title]
	    return 1;
    } else {
   		if { $fileid >= 0 } {
		    puts $fileid "filter { "
		    set o [ format "name %s" $selection ]
		    puts $fileid $o
		    set o [ format "value  \" %s \" " [wAdvFilter.wAdvFltField getVal] ]
		    puts $fileid $o
		    puts $fileid " } "

  	   	}
    		close $fileid
    		return 0
           }
}

# fill_list fills the lists in the Load dialog
proc fill_list { which_list } {
    global AdvFiltersDir
    $which_list clear
    set i 0

    if { ! [file exists $AdvFiltersDir] } {
	 return 1; } else {

    # glob pattern matches- in this case, looks for files
    # in this dir

    catch { ;# in case the dir exists but is empty
        foreach f [glob $AdvFiltersDir/*] {
	    # file tail returns the the chars after the last directory
	    # symbol "/"
	    if { [ regexp .evf [file extension $f] ] } {
	    	$which_list insertDspStr $i [file tail [file rootname $f]]
		incr i
	    }
	}
    }
   return 0
   }; # end of else
}


##########################################################################

## CHECK FOR ERRORS FROM EVM AND PRINTER. 
# Not being used in BL20+

proc check_app_errors { } {
    global Error_File
    set apperror_box_title [SUITcatget evm_info_apperror_title lbl]

    if { [file exists $Error_File] } {
	if { ![file size $Error_File] } {
		return 0
	} else {
		if { [catch { set fileID [open $Error_File] } ] } {
                       	InfoMsg "error" \
				[evmviewer.cat get evm_app_error lbl] \
		 				$apperror_box_title "wait"

		} else {
			    set error_string ""
			    set counter 1
			    while {[gets $fileID line] >= 0 & $counter <= 10} {
					append error_string "\n"
					append error_string $line
					if { $counter == 10 } {
					  append error_string "..." }
					incr counter
			    }
			    set error_msg ""
			    set error_msg \
				     [evmviewer.cat get evm_app_ext_error lbl]
			    append error_msg $error_string
                            InfoMsg "error" \
					$error_msg \
			 			[get_errormsg_title] "wait"
			}
			close $fileID
    			unlink -nocomplain $Error_File
			return 1
	       }
    } else { return 0 }
}

# Proc save_state saves the current state of the widgets into the 
# global State variables.
proc save_state { } {
    global	    wDetPrintwValueState
    global	    wDetSavewValueState
    global	    wDetSaveOptionswAppendState

    global	    wFilterwNameFlagState
    global	    wFilterwNameEqualityChoiceState
    global          wFilterwNameState
    global          wFilterwHostFlagState
    global          wFilterwHostEqualityChoiceState
    global          wFilterwHostState
    global          wFilterwPriorityFlagState
    global          wFilterwPrioEqualityChoiceState
    global          wFilterwPriorityChoiceState
    global          wFilterwPriorityRangeMinState
    global          wFilterwPriorityRangeMaxState
    global          wFilterwPriorityAbsoluteState
    global          wFilterwPriorityMinState
    global          wFilterwPriorityMaxState
    global          wFilterwBeforeFlagState
    global          wFilterwBeforeHourState
    global          wFilterwBeforeMinState
    global          wFilterwBeforeSecState
    global          wFilterwSinceFlagState
    global          wFilterwSinceHourState
    global          wFilterwSinceMinState
    global          wFilterwSinceSecState
    global          wFilterwAgeFlagState
    global          wFilterwAgeEqualityChoiceState
    global          wFilterwAgeValueState
    global          wFilterwAgeQualiferState

    global          wItemsevent_idState
    global	    wItemspriorityState
    global	    wItemstimestampState
    global	    wItemspidState
    global	    wItemsuser_nameState
    global	    wItemshost_nameState
    global	    wItemscluster_nameState
    global	    wItemsnameState
    global          wItemsformatState

    global	    wSortwItemsState
    global          wSortwIsAscendingState

    global	    wAdvFilterwAdvFltFieldState
    global	    wSaveAdvancedwSaveAsFileState

    global	    wSourcewEventSourceChoiceState
    global 	    wSourcewFileState
    global 	    wSourcewSourceHostChoiceState
    global	    wSourcewHostState

    global	    wSummPrintwValueState

    global	    wSummSavewValueState
    global 	    wSummSaveOptionswAppendState

    global	    wNoOfEventswValueState


    set wDetPrintwValueState 		[string trim [wDetPrint.wValue getVal]]
    set wDetSavewValueState  		[string trim [wDetSave.wValue getVal]]
    set wDetSaveOptionswAppendState	[wDetSaveOptions.wAppend getVal]
    set wFilterwNameFlagState		[wFilter.wNameFlag getVal]
    set wFilterwNameEqualityChoiceState [wFilter.wNameEqualityChoice getVal]
    set wFilterwNameState		[string trim [wFilter.wName getVal]]
    set wFilterwHostFlagState		[wFilter.wHostFlag getVal]
    set wFilterwHostEqualityChoiceState [wFilter.wHostEqualityChoice getVal]
    set wFilterwHostState		[string trim [wFilter.wHost getVal]]
    set wFilterwPriorityFlagState	[wFilter.wPriorityFlag getVal]
    set wFilterwPrioEqualityChoiceState [wFilter.wPrioEqualityChoice getVal]
    set wFilterwPriorityChoiceState	[wFilter.wPriorityChoice getVal]
    set wFilterwPriorityRangeMinState   \
				[string trim [wFilter.wPriorityRangeMin getVal]]
    set wFilterwPriorityRangeMaxState 	\
				[string trim [wFilter.wPriorityRangeMax getVal]]
    set wFilterwPriorityAbsoluteState	\
				[string trim [wFilter.wPriorityAbsolute getVal]]
    set wFilterwPriorityMinState	\
				[string trim [wFilter.wPriorityMin getVal]]
    set wFilterwPriorityMaxState	\
				[string trim [wFilter.wPriorityMax getVal]]
    set wFilterwBeforeFlagState		[wFilter.wBeforeFlag getVal]
    set wFilterwBeforeHourState		\
				[string trim [wFilter.wBeforeHour getVal]]
    set wFilterwBeforeMinState		\
				[string trim [wFilter.wBeforeMin getVal]]
    set wFilterwBeforeSecState		\
				[string trim [wFilter.wBeforeSec getVal]]
    set wFilterwSinceFlagState		[wFilter.wSinceFlag getVal]
    set wFilterwSinceHourState		\
				[string trim [wFilter.wSinceHour getVal]]
    set wFilterwSinceMinState		[string trim [wFilter.wSinceMin getVal]]
    set wFilterwSinceSecState		[string trim [wFilter.wSinceSec getVal]]
    set wFilterwAgeFlagState            [wFilter.wAgeFlag getVal]
    set wFilterwAgeEqualityChoiceState  [wFilter.wAgeEqualityChoice getVal]
    set wFilterwAgeValueState           [string trim [wFilter.wAgeValue getVal]]
    set wFilterwAgeQualiferState        [wFilter.wAgeQualifer getVal]

    set wItemsevent_idState           	[wItems.event_id getVal]
    set wItemspriorityState             [wItems.priority getVal]
    set wItemstimestampState            [wItems.timestamp getVal]
    set wItemspidState			[wItems.pid getVal]
    set wItemsuser_nameState		[wItems.user_name getVal]
    set wItemshost_nameState		[wItems.host_name getVal]
    set wItemscluster_nameState		[wItems.cluster_name getVal]
    set wItemsnameState			[wItems.name getVal]
    set wItemsformatState		[wItems.format getVal]

    set wSortwItemsState [lindex [lindex [wSort.wItems getCurSelection] 0] 1]
    set wSortwIsAscendingState 		[wSort.wIsAscending getVal]	

    set wAdvFilterwAdvFltFieldState	\
				[string trim [wAdvFilter.wAdvFltField getVal]]
    set wSaveAdvancedwSaveAsFileState	\
				[string trim [wSaveAdvanced.wSaveAsFile getVal]] 
    set wSourcewEventSourceChoiceState 	[wSource.wEventSourceChoice getVal]
    set wSourcewFileState		[string trim [wSource.wFile getVal]]
    set wSourcewSourceHostChoiceState	[wSource.wSourceHostChoice getVal]
    set wSourcewHostState		[string trim [wSource.wHost getVal]]

    set wSummPrintwValueState		[string trim [wSummPrint.wValue getVal]]

    set wSummSaveOptionswAppendState	[wSummSaveOptions.wAppend getVal]
    set wSummSavewValueState		[string trim [wSummSave.wValue getVal]]

    set wNoOfEventswValueState		\
				[string trim [wItems.wNumOfEvents getVal]]
}

# Proc load_saved_state loads the saved state onto the widgets.
proc load_saved_state { } {
    global	    wDetPrintwValueState
    global	    wDetSavewValueState
    global	    wDetSaveOptionswAppendState

    global	    wFilterwNameFlagState
    global	    wFilterwNameEqualityChoiceState
    global          wFilterwNameState
    global          wFilterwHostFlagState
    global          wFilterwHostEqualityChoiceState
    global          wFilterwHostState
    global          wFilterwPriorityFlagState
    global          wFilterwPrioEqualityChoiceState
    global          wFilterwPriorityChoiceState
    global          wFilterwPriorityRangeMinState
    global          wFilterwPriorityRangeMaxState
    global          wFilterwPriorityAbsoluteState
    global          wFilterwPriorityMinState
    global          wFilterwPriorityMaxState
    global          wFilterwBeforeFlagState
    global          wFilterwBeforeHourState
    global          wFilterwBeforeMinState
    global          wFilterwBeforeSecState
    global          wFilterwSinceFlagState
    global          wFilterwSinceHourState
    global          wFilterwSinceMinState
    global          wFilterwSinceSecState
    global          wFilterwAgeFlagState
    global          wFilterwAgeEqualityChoiceState
    global          wFilterwAgeValueState
    global          wFilterwAgeQualiferState

    global          wItemsevent_idState
    global	    wItemspriorityState
    global	    wItemstimestampState
    global	    wItemspidState
    global	    wItemsuser_nameState
    global	    wItemshost_nameState
    global	    wItemscluster_nameState
    global	    wItemsnameState
    global          wItemsformatState

    global	    wSortwItemsState
    global          wSortwIsAscendingState

    global	    wAdvFilterwAdvFltFieldState
    global	    wSaveAdvancedwSaveAsFileState
 
    global	    wSourcewEventSourceChoiceState
    global 	    wSourcewFileState
    global 	    wSourcewSourceHostChoiceState
    global	    wSourcewHostState

    global	    wSummPrintwValueState

    global	    wSummSavewValueState
    global 	    wSummSaveOptionswAppendState

    global	    wNoOfEventswValueState


    wDetPrint.wValue 		setVal 	$wDetPrintwValueState
    wDetSave.wValue  		setVal 	$wDetSavewValueState
    wDetSaveOptions.wAppend 	setVal 	$wDetSaveOptionswAppendState

    wFilter.wNameFlag		setVal	$wFilterwNameFlagState
    wFilter.wNameEqualityChoice setVal  $wFilterwNameEqualityChoiceState
    wFilter.wName		setVal  $wFilterwNameState
    wFilter.wHostFlag		setVal  $wFilterwHostFlagState
    wFilter.wHostEqualityChoice setVal  $wFilterwHostEqualityChoiceState
    wFilter.wHost		setVal  $wFilterwHostState
    wFilter.wPriorityFlag 	setVal  $wFilterwPriorityFlagState
    wFilter.wPrioEqualityChoice	setVal  $wFilterwPrioEqualityChoiceState
    wFilter.wPriorityChoice	setVal  $wFilterwPriorityChoiceState
    wFilter.wPriorityRangeMin	setVal  $wFilterwPriorityRangeMinState
    wFilter.wPriorityRangeMax	setVal  $wFilterwPriorityRangeMaxState
    wFilter.wPriorityAbsolute	setVal  $wFilterwPriorityAbsoluteState
    wFilter.wPriorityMin	setVal  $wFilterwPriorityMinState
    wFilter.wPriorityMax	setVal  $wFilterwPriorityMaxState
    wFilter.wBeforeFlag		setVal  $wFilterwBeforeFlagState
    wFilter.wBeforeHour		setVal  $wFilterwBeforeHourState
    wFilter.wBeforeMin		setVal  $wFilterwBeforeMinState
    wFilter.wBeforeSec		setVal  $wFilterwBeforeSecState
    wFilter.wSinceFlag		setVal  $wFilterwSinceFlagState
    wFilter.wSinceHour		setVal  $wFilterwSinceHourState
    wFilter.wSinceMin		setVal  $wFilterwSinceMinState
    wFilter.wSinceSec		setVal  $wFilterwSinceSecState
    wFilter.wAgeFlag            setVal  $wFilterwAgeFlagState
    wFilter.wAgeEqualityChoice  setVal  $wFilterwAgeEqualityChoiceState
    wFilter.wAgeValue           setVal  $wFilterwAgeValueState
    wFilter.wAgeQualifer        setVal  $wFilterwAgeQualiferState

    wItems.event_id		setVal 	$wItemsevent_idState
    wItems.priority		setVal 	$wItemspriorityState
    wItems.timestamp		setVal	$wItemstimestampState
    wItems.pid			setVal	$wItemspidState
    wItems.user_name		setVal  $wItemsuser_nameState
    wItems.host_name		setVal  $wItemshost_nameState
    wItems.cluster_name		setVal	$wItemscluster_nameState
    wItems.name			setVal	$wItemsnameState
    wItems.format		setVal	$wItemsformatState

    wSort.wIsAscending		setVal  $wSortwIsAscendingState
    wSort.wItems		setSelection	$wSortwItemsState

    wAdvFilter.wAdvFltField	setVal 	$wAdvFilterwAdvFltFieldState
    wSaveAdvanced.wSaveAsFile	setVal	$wSaveAdvancedwSaveAsFileState

    wSource.wEventSourceChoice	setVal	$wSourcewEventSourceChoiceState
    wSource.wFile		setVal	$wSourcewFileState
    wSource.wSourceHostChoice	setVal	$wSourcewSourceHostChoiceState
    wSource.wHost		setVal	$wSourcewHostState

    wSummPrint.wValue		setVal	$wSummPrintwValueState

    wSummSave.wValue		setVal	$wSummSavewValueState
    wSummSaveOptions.wAppend	setVal	$wSummSaveOptionswAppendState

    wItems.wNumOfEvents		setVal	$wNoOfEventswValueState
}

###########################################################################
# initialize this global array to the abbreviated names of the month in the
# current locale.

proc init_months { } {
    global month_array
    set parameter_array { ABMON_1 ABMON_2 ABMON_3 ABMON_4 ABMON_5 ABMON_6 ABMON_7 ABMON_8 ABMON_9 ABMON_10 ABMON_11 ABMON_12 }

    set month_array {}
    foreach a $parameter_array {
	lappend month_array [encoding convertfrom [encoding system] [ nl_langinfo $a ] ]
    }
}

# This routine converts the name of the month into a number.  The array 
# contains the names of the month in the current locale

proc get_month_index { a_month } {
    global month_array

    set i [ lsearch -exact $month_array $a_month ]

    return [ expr $i + 1 ]
}

##### DEBUGGING ROUTINES

# This proc forces Tcl to print synchronously.
# Both echo and puts seem to buffer up their messages and delay printing
# (or at least they do so in an emacs window).
# This delay is unacceptable when tracing code for debugging purposes.
# The following proc does not print in a neat format, but it does manage
# to print the specified message synchronously.

proc myecho { a_arg } {
    cmdtrace on notruncate
    echo $a_arg
    cmdtrace off
}
