# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: Toplevel.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:40  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.4.3  1997/05/19  18:05:42  William_Athanasiou
# 	Drop for pre-BL11 build
# 	[1997/05/16  17:37:08  William_Athanasiou]
#
# Revision 1.1.2.3  1997/01/16  14:03:58  William_Athanasiou
# 	Prepend _UIT_ to all classes
# 	[1997/01/15  21:11:57  William_Athanasiou]
# 
# Revision 1.1.2.2  1996/09/24  21:12:12  William_Athanasiou
# 	initial version of files/minor changes to TKutils files
# 	[1996/09/24  21:07:29  William_Athanasiou]
# 
# $EndLog$
# 
# @(#)$RCSfile: Toplevel.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:40 $
# 
Class _UIT_Toplevel -superclass _UIT_Archetype

_UIT_Toplevel instproc init {args} {

   $self set _Wdgt(hull) ""
   $self set _Wdgt(hullcmd) ""

   set class [$self info class]
   rename $self _ooTmp
   if {[catch {toplevel $self -class $class} err] != 0} {
      rename _ooTmp $self
      error $err
   } else {
      rename $self $self-cmd
      rename _ooTmp $self
   }

   set Xwin $self
   set Xwincmd $self-cmd
   eval [subst -nocommands {
      bind $Xwin <Destroy> {
	 if {[string compare "%W" "$self"]} {$self destroy}
      }
   }
   ]

   $self set _Wdgt(hull) $Xwin
   $self set _Wdgt(interior) $Xwin
   $self set _Wdgt(hullcmd) $Xwincmd
      
   $self _keep $Xwincmd -background -cursor

   return $self
}

_UIT_Toplevel instproc destroy args {   
   $self instvar _Wdgt
   
   # Must copy vars since they are destroyed by `otFreeObj'
   set wp $_Wdgt(hull)
   set w $_Wdgt(hullcmd)
   
   $self destroy

   catch {bind $w <Destroy> {}}
   if [string compare "-obj_only" $args] {
      if [string compare $w $wp] {
	 rename $w $wp
      }
      if [string compare "-keep_win" $args] {
	 destroy $wp
      }
   }
}
