# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: combobox.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:40  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.4.3  1997/05/19  18:05:44  William_Athanasiou
# 	Drop for pre-BL11 build
# 	[1997/05/16  17:37:13  William_Athanasiou]
#
# Revision 1.1.2.3  1997/01/16  14:04:01  William_Athanasiou
# 	Prepend _UIT_ to all classes
# 	[1997/01/15  21:12:06  William_Athanasiou]
# 
# Revision 1.1.2.2  1996/09/24  21:12:17  William_Athanasiou
# 	initial version of files/minor changes to TKutils files
# 	[1996/09/24  21:09:19  William_Athanasiou]
# 
# $EndLog$
# 
# @(#)$RCSfile: combobox.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:40 $
# 

Class Combobox -superclass _UIT_Entryfield

Combobox instproc init {args} {
   
   $self next
   $self instvar _Opt _Wdgt

   #
   # Removable list box.
   #

   set _Wdgt(topl) [toplevel $self.topl -borderwidth 0]
   wm withdraw $_Wdgt(topl)
   wm overrideredirect $_Wdgt(topl) 1
   wm transient $_Wdgt(topl) [winfo toplevel $self]
   
   set _Wdgt(lst) [listbox $_Wdgt(topl).lstbox -borderwidth 1 -relief sunken \
	 -width 5 -height 5 -selectmode single]
   pack $_Wdgt(lst) -side left -fill both -expand 1
   
   #
   # button to activate lstbox
   #

   set _Wdgt(btn) [button [$self childsite].btn -text "?" \
	 -command "$self _popup $_Wdgt(topl); focus $_Wdgt(lst)"]
   pack $_Wdgt(btn) -side right -fill y -padx 0
   $self config -childsitepos e


   eval [subst -nocommands {
      bind ComboEntry$self <Control-s> {$self popup}
      bind ComboEntry$self <Escape> {$self popup }
      bind ComboEntry$self <Control-f> {$self _find; break}
      bind ComboEntry$self <Return> {$self _add}

      bind ComboList$self <Escape> {$self _popup}
      bind ComboList$self <Return> {$self _get}
   }
   ]
  
   bindtags $_Wdgt(entry) [linsert [bindtags $_Wdgt(entry)] 1 ComboEntry$self]
   bindtags $_Wdgt(lst) [linsert [bindtags $_Wdgt(lst)] 1 ComboList$self]
}

Combobox instproc setlist {args} {
   $self instvar _Wdgt

   if [winfo ismapped $_Wdgt(topl)] {
      wm withdraw $_Wdgt(topl)
      $_Wdgt(btn) configure -relief raised
   }
   $_Wdgt(lst) delete 0 end
   eval $_Wdgt(lst) insert end $args
}

Combobox instproc getlist {} {
   $self instvar _Wdgt
   return $_Wdgt(lst) get 0 end
}

Combobox instproc _popup {a} {
   $self instvar _Wdgt

   if [winfo ismapped $_Wdgt(topl)] {
      wm withdraw $_Wdgt(topl)
      $_Wdgt(btn) configure -relief raised
   } else {
      wm geometry $_Wdgt(topl) \
	    [winfo width $_Wdgt(entry)]x[winfo reqheight $_Wdgt(topl)]+\
	    [winfo rootx $_Wdgt(entry)]+\
	    [expr [winfo rooty $self]+[winfo reqheight $self]]
      wm deiconify $_Wdgt(topl)
      raise $_Wdgt(topl)
      focus $_Wdgt(lst)
      $_Wdgt(btn) configure -relief sunken
   }
}

Combobox instproc _find {} {
   $self instvar _Wdgt

   set found 0
   set tmp [$self get]
   
   foreach item [$_Wdgt(lst) get 0 end] {
      if ![string first $tmp $item] {
	 incr found
	 set match $item
      }
   }

   switch $found {
      0 {}
      1 {
	 $self delete 0 end
	 $self insert end $match
      }
      default {
	 bell
      }
   }
   
}

Combobox instproc _add {} {
   $self instvar _Wdgt
   set i 1
   set tmp [$_Wdgt(entry) get]
   
   foreach item [$_Wdgt(lst) get 0 end] {
      if ![string compare $item $tmp] {
	 set i 0
	 break
      }
   }
   
   if $i {
      $_Wdgt(entry) insert end $tmp
   }
   wm withdraw $_Wdgt(topl)
}

Combobox instproc _get {} {
   $self instvar _Wdgt
   
   if [$_Wdgt(lst) size] {
      $_Wdgt(entry) delete 0 end
      $_Wdgt(entry) insert end [$_Wdgt(lst) get [$_Wdgt(lst) curselection]]
   }

   wm withdraw $_Wdgt(topl)
   $_Wdgt(btn) configure -relief raised
   focus $_Wdgt(entry)
}


