# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: dialogshell.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:40  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.4.10  1999/02/03  18:45:45  Sandip_Savalia
# 	Code drop for baselevel 22
# 	[1999/02/03  16:41:12  Sandip_Savalia]
#
# Revision 1.1.2.17  1998/12/03  22:32:11  William_Athanasiou
# 	Fix global grab and refresh
# 	[1998/12/03  22:17:47  William_Athanasiou]
# 
# Revision 1.1.2.16  1998/02/26  20:20:27  William_Athanasiou
# 	Add borders to curses infomsg's
# 	[1998/02/26  20:19:49  William_Athanasiou]
# 
# Revision 1.1.2.15  1997/12/22  20:01:05  William_Athanasiou
# 	Update to match TKutils/dialogshell
# 	[1997/12/22  20:00:19  William_Athanasiou]
# 
# Revision 1.1.2.14  1997/09/25  21:12:16  Todd_Moyer
# 	Fixed backward condition in _separator method.
# 	Got rid of pointer-focus help widget border to save real estate.
# 	Replaced window border with window title to save real estate.
# 	[1997/09/25  20:17:47  Todd_Moyer]
# 
# Revision 1.1.2.13  1997/09/19  15:40:26  Richard_Taft
# 	It's not an error to redisplay a displayed window
# 	[1997/09/19  15:37:29  Richard_Taft]
# 
# Revision 1.1.2.12  1997/08/27  21:26:45  William_Athanasiou
# 	Fixed bad code that showed up when whitespace removed
# 	[1997/08/27  21:25:51  William_Athanasiou]
# 
# Revision 1.1.2.11  1997/05/29  14:57:10  William_Athanasiou
# 	Changes for upgrade to tcl7.6
# 	[1997/05/29  14:51:18  William_Athanasiou]
# 
# Revision 1.1.2.10  1997/04/09  16:30:33  William_Athanasiou
# 	Correctly expand dialogshell keeping botton box at bottom of screen
# 	[1997/04/09  16:17:10  William_Athanasiou]
# 
# Revision 1.1.2.9  1997/03/31  18:49:22  William_Athanasiou
# 	Don't allow pointer focus help area and buttonbox to expand
# 	[1997/03/31  18:30:52  William_Athanasiou]
# 
# Revision 1.1.2.8  1997/03/21  15:55:22  William_Athanasiou
# 	Added pointer focus help window
# 	[1997/03/21  15:41:33  William_Athanasiou]
# 
# Revision 1.1.2.7  1997/03/13  16:01:07  William_Athanasiou
# 	Move <return> binding to creation of default button to ensure button exists
# 	[1997/03/13  16:00:38  William_Athanasiou]
# 
# Revision 1.1.2.6  1997/03/07  15:40:41  William_Athanasiou
# 	Make sure activated window is on top of display stack.
# 	[1997/03/07  15:09:50  William_Athanasiou]
# 
# Revision 1.1.2.5  1997/02/24  20:18:21  William_Athanasiou
# 	Fixed problem with window title
# 	[1997/02/24  20:16:41  William_Athanasiou]
# 
# Revision 1.1.2.4  1997/02/24  19:17:15  William_Athanasiou
# 	Added infomsg class; and used dialogshell for suit windows
# 	[1997/02/24  19:10:22  William_Athanasiou]
# 
# Revision 1.1.2.3  1997/01/16  14:04:04  William_Athanasiou
# 	Prepend _UIT_ to all classes
# 	[1997/01/15  21:12:14  William_Athanasiou]
# 
# Revision 1.1.2.2  1996/09/24  21:12:21  William_Athanasiou
# 	initial version of files/minor changes to TKutils files
# 	[1996/09/24  21:09:26  William_Athanasiou]
# 
# $EndLog$
# 
# @(#)$RCSfile: dialogshell.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:40 $
# 
# _UIT_Dialogshell
# ----------------------------------------------------------------------
# This class is implements a dialog shell which is a top level widget
# composed of a button box, separator, and child site area.  The class
# also has methods to control button construction.
#    
# ----------------------------------------------------------------------
#  AUTHOR: Mark L. Ulferts               EMAIL: mulferts@spd.dsccc.com
#
#  @(#) $Id: dialogshell.tcl,v 1.1.1.1 2003/01/23 18:34:40 ajay Exp $
# ----------------------------------------------------------------------
#            Copyright (c) 1995 DSC Technologies Corporation
# ======================================================================
# Permission to use, copy, modify, distribute and license this software 
# and its documentation for any purpose, and without fee or written 
# agreement with DSC, is hereby granted, provided that the above copyright 
# notice appears in all copies and that both the copyright notice and 
# warranty disclaimer below appear in supporting documentation, and that 
# the names of DSC Technologies Corporation or DSC Communications 
# Corporation not be used in advertising or publicity pertaining to the 
# software without specific, written prior permission.
# 
# DSC DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING 
# ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, AND NON-
# INFRINGEMENT. THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, AND THE
# AUTHORS AND DISTRIBUTORS HAVE NO OBLIGATION TO PROVIDE MAINTENANCE, 
# SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS. IN NO EVENT SHALL 
# DSC BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR 
# ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, 
# WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION,
# ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS 
# SOFTWARE.
# ======================================================================


# ------------------------------------------------------------------
#                            DIALOGSHELL
# ------------------------------------------------------------------
Class _UIT_Dialogshell -superclass _UIT_Toplevel

# ------------------------------------------------------------------
#                        CONSTRUCTOR
# ------------------------------------------------------------------
_UIT_Dialogshell instproc init {args} {
   $self _define -takefocus 0 Takefocus _takefocus
   $self _define -thickness 0 Thickness _thickness
   $self _define -buttonboxpos s Position _buttonBoxPos
   $self _define -busy 0 Busy _busy
   $self _define -separator off Separator _separator
   $self _define -title "Dialog" Title _title
   $self _define -showborder "no" ShowBorder _showBorder
   $self _define -padx 0 Pad _padX
   $self _define -pady 0 Pad _padY
   
   $self set _result {}     ;# Resultant value for modal activation.
   $self set _busied {}     ;# List of busied top level widgets.
   
   _UIT_Dialogshell instvar grabstack
   if ![info exists grabstack] {
      set grabstack {}
      label .dialogShellHoldTheFocus
   }

   $self next
   $self instvar _Wdgt _Opt _occluded _prev_focus
   set _occluded 0
   set _prev_focus {}

   # _UIT_Maintain a withdrawn state until activated.
   #
   wm withdraw $_Wdgt(hull)
   $_Wdgt(hullcmd) config -borderwidth 0 ;# removes border and title.
   
   # Create the title, user child site, separator, and button box,
   #
   set _Wdgt(title) [label $_Wdgt(interior).title -text $_Opt(-title)]
   pack $_Wdgt(title) -fill x -expand 0
   
   set _Wdgt(dschildsite) [frame $_Wdgt(interior).dschildsite]
   pack $_Wdgt(dschildsite) -fill both -expand 1 -padx 0 -pady 0
   
   set _Wdgt(separator) [frame $_Wdgt(interior).separator -relief flat -bd 0]
   pack $_Wdgt(separator) -padx 5p -fill x -expand 0
   
   set _Wdgt(helpwin) [text $_Wdgt(separator).txt -height 2 -width 40 \
	 -wrap word -state disabled -takefocus 0 -relief flat -bd 0]
   pack $_Wdgt(helpwin) -fill x -expand 0
   
   set _Wdgt(bbox) [_UIT_Buttonbox $_Wdgt(interior).bbox]
   $self _rename $_Wdgt(bbox) -padx -buttonboxpadx
   $self _rename $_Wdgt(bbox) -pady -buttonboxpady
   pack $_Wdgt(bbox) -expand no -padx 0 -pady 0
   
   #
   # Set the interior variable to be the childsite for derived 
   # classes.
   #
   set _Wdgt(interior) $_Wdgt(dschildsite)
   
   #
   # Bind the window manager delete protocol to deactivation of the 
   # widget.  This can be overridden by the user via the execution 
   # of a similar command outside the class.
   #
   wm protocol $_Wdgt(hull) WM_DELETE_WINDOW "$self deactivate"
   
   
   #
   # Explicitly handle configs that may have been ignored earlier.
   #
   if {![string compare _UIT_Dialogshell [$self info class]]} {
      $self configure -thickness 0 -buttonboxpos s \
	    -padx 0 -pady 0 -separator on -showborder no

      eval {$self configure} $args
   }
}

#
# Provide a lowercased access method for the _UIT_Dialogshell class.
# 
proc dialogshell {pathName args} {
    uplevel _UIT_Dialogshell $pathName $args
}


# ------------------------------------------------------------------
#                             OPTIONS
# ------------------------------------------------------------------

_UIT_Dialogshell instproc _takefocus {val} { 
   $self instvar _Opt
   set _Opt(-takefocus) 0
}

# ------------------------------------------------------------------
# OPTION: -thickness
#
# Specifies the thickness of the separator.  It sets the width and
# height of the separator to the thickness value and the borderwidth
# to half the thickness.
# ------------------------------------------------------------------
_UIT_Dialogshell instproc _thickness {val} {;}

# ------------------------------------------------------------------
# OPTION: -buttonboxpos
#
# Specifies the position of the button box relative to the child site.
# The separator appears between the child site and button box.
# ------------------------------------------------------------------
_UIT_Dialogshell instproc _buttonBoxPos {val} {
   $self instvar _Wdgt _Opt

   switch $_Opt(-buttonboxpos) {
      n {
	 pack config $_Wdgt(dschildsite) -side top
	 pack config $_Wdgt(separator) -side top \
	       -before $_Wdgt(dschildsite) -fill x
	 $_Wdgt(bbox) configure -orient horizontal
	 pack config $_Wdgt(bbox) -side top \
	       -before $_Wdgt(separator) -fill x 
      }
      s {
	 pack config $_Wdgt(dschildsite) -side top
	 pack config $_Wdgt(separator) -side top \
	       -after $_Wdgt(dschildsite) -fill x
	 $_Wdgt(bbox) configure -orient horizontal
	 pack config $_Wdgt(bbox) -side top \
	       -after $_Wdgt(separator) -fill x 
      }
      w {
	 pack config $_Wdgt(dschildsite) -side left
	 pack config $_Wdgt(separator) -side left \
		    -before $_Wdgt(dschildsite) -fill y
	 $_Wdgt(bbox) configure -orient vertical
	 pack config $_Wdgt(bbox) -side left \
	       -before $_Wdgt(separator) -fill y
      }
      e {
	 pack config $_Wdgt(dschildsite) -side left
	 pack config $_Wdgt(separator) -side left \
	       -after $_Wdgt(dschildsite) -fill y
	 $_Wdgt(bbox) configure -orient vertical
	 pack config $_Wdgt(bbox) -side left \
	       -after $_Wdgt(separator) -fill y
      }

      default {
	 error "bad buttonboxpos option\
	       \"$_Opt(-buttonboxpos)\": should be n,\
	       s, e, or w"
      }
   }
}

# ------------------------------------------------------------------
# OPTION: -busy
#
# Make the window busy
# ------------------------------------------------------------------
_UIT_Dialogshell instproc _busy {val} {
   $self instvar _Opt
   set _Opt(-busy) $val
   if {$val} {
      $self _mkBusy
   } else {
      $self _mkNotBusy
   }
}

_UIT_Dialogshell instproc _mkBusy {} {
   $self instvar _Wdgt _prev_focus _Opt _occluded
   if {!$_occluded} {
      set _prev_focus [focus]
      focus .dialogShellHoldTheFocus
   }
}   

_UIT_Dialogshell instproc _mkNotBusy {} {
   $self instvar _Wdgt _prev_focus _occluded _Opt
   _UIT_Dialogshell instvar grabstack

   if $_occluded {return}
   if ![cequal [lindex $grabstack end] $self] {return}
   
   if ![lempty $_prev_focus] {
      focus $_prev_focus
   } else {
      focus [tk_focusNext $_Wdgt(hull)]
   }
}

# ------------------------------------------------------------------
# OPTION: -separator 
#
# Boolean option indicating wheather to display the separator.
# ------------------------------------------------------------------
_UIT_Dialogshell instproc _separator {val} {
   $self instvar _Wdgt _Opt

   if {[cequal $_Opt(-separator) "on"]} {
      $_Wdgt(separator) configure -relief flat -bd 0
      pack $_Wdgt(helpwin) -fill x -expand 0
   } else {
      $_Wdgt(separator) configure -relief sunken
      pack forget $_Wdgt(helpwin)
   }
}

# ------------------------------------------------------------------
# OPTION: -title
#
# Specify the window title.
# ------------------------------------------------------------------
_UIT_Dialogshell instproc _title {val} {
   $self instvar _Wdgt
   
   $_Wdgt(title) configure -text $val
   wm title $_Wdgt(hullcmd) $val
}

# ------------------------------------------------------------------
# OPTION: -showborder
#
# Specify the window title.
# ------------------------------------------------------------------
_UIT_Dialogshell instproc _showBorder {val} {
   $self instvar _Wdgt _Opt
   if [cequal $val "no"] {
      pack $_Wdgt(title) -side top -fill x -expand 0
      $_Wdgt(hullcmd) config -borderwidth 0 ;# removes border and title.
   } else {
      pack forget $_Wdgt(title)
      $_Wdgt(hullcmd) config -borderwidth 1 ;# show border and title.
   }
}

# ------------------------------------------------------------------
# OPTION: -padx
#
# Specifies a padding distance for the childsite in the X-direction.
# ------------------------------------------------------------------
_UIT_Dialogshell instproc _padX {val} {
   $self instvar _Wdgt _Opt
   
   pack config $_Wdgt(dschildsite) -padx $_Opt(-padx)
}

# ------------------------------------------------------------------
# OPTION: -pady
#
# Specifies a padding distance for the childsite in the Y-direction.
# ------------------------------------------------------------------
_UIT_Dialogshell instproc _padY {val} {
   $self instvar _Wdgt _Opt
   
   pack config $_Wdgt(dschildsite) -pady $_Opt(-pady)
}
    
# ------------------------------------------------------------------
#                            METHODS
# ------------------------------------------------------------------

# ------------------------------------------------------------------
# METHOD: childsite
#
# Return the pathname of the user accessible area.
# ------------------------------------------------------------------
_UIT_Dialogshell instproc childsite {} {
   return [$self set _Wdgt(dschildsite)]
}

# ------------------------------------------------------------------
# METHOD: activate
#
# Display the dialog and wait based on the modality.  For application
# and global modal activations, execute a tkwait and wait for the 
# for the result.  The result may be returned via an argument to the
# "deactivate" method.
# ------------------------------------------------------------------
_UIT_Dialogshell instproc activate {} {
   $self instvar _Wdgt _Opt
   _UIT_Dialogshell instvar grabstack
   global _UIT_DialogshellWait
   
   if {[winfo ismapped $_Wdgt(hull)]} {
      return
   }
   
   set _UIT_DialogshellWait($self) 0
   wm deiconify $_Wdgt(hull)
   tkwait visibility $_Wdgt(hull)
   raise $_Wdgt(hull)
   
   if ![lempty $grabstack] {
      set w [lindex $grabstack end]
      $w set _occluded 1
      $w _mkBusy
   } 
   grab $_Wdgt(hull)
   lappend grabstack $self
   update
   focus [tk_focusNext $_Wdgt(hull)]
}

# ------------------------------------------------------------------
# METHOD: deactivate
#
# Deactivate the display of the dialog.  The method takes an optional
# argument to passed to the "activate" method which returns the value.
# This is only effective for application and global modal dialogs.
# ------------------------------------------------------------------
_UIT_Dialogshell instproc deactivate {args} {
   $self instvar _Wdgt _Opt
   _UIT_Dialogshell instvar grabstack
   
   if {! [winfo ismapped $_Wdgt(hull)]} {
      return
   }
   
   grab release $_Wdgt(hull)
   wm withdraw $_Wdgt(hull)
   if ![lempty [set grabstack [lreplace $grabstack end end]]] {
      # must un-occlude a window
      set win [lindex $grabstack end]
      $win set _occluded 0
      if ![$win cget -busy] {
	 $win _mkNotBusy
      }
   }
   return
}

# ------------------------------------------------------------------
# METHOD: center
#
# Centers the dialog with respect to another widget or the screen
# as a whole.
# ------------------------------------------------------------------
_UIT_Dialogshell instproc center {{widget {}}} {
   update idletasks
}

# ------------------------------------------------------------------
# METHOD: index index
#
# Thin wrapper of _UIT_Buttonbox's index method.
# ------------------------------------------------------------------
_UIT_Dialogshell instproc index {args} {
   uplevel [$self set _Wdgt(bbox)] index $args
}

# ------------------------------------------------------------------
# METHOD: add tag ?option value ...?
#
# Thin wrapper of _UIT_Buttonbox's add method.
# ------------------------------------------------------------------
_UIT_Dialogshell instproc add {args} {
   uplevel [$self set _Wdgt(bbox)] add $args
}

# ------------------------------------------------------------------
# METHOD: addTkButton tag ?option value ...?
#
# Thin wrapper of _UIT_Buttonbox's addTkButton method.
# ------------------------------------------------------------------
_UIT_Dialogshell instproc addTkButton {args} {
   uplevel [$self set _Wdgt(bbox)] addTkButton $args
}

# ------------------------------------------------------------------
# METHOD: insert index tag ?option value ...?
#
# Thin wrapper of _UIT_Buttonbox's insert method.
# ------------------------------------------------------------------
_UIT_Dialogshell instproc insert {args} {
   uplevel [$self set _Wdgt(bbox)] insert $args
}

# ------------------------------------------------------------------
# METHOD: delete tag
#
# Thin wrapper of _UIT_Buttonbox's delete method.
# ------------------------------------------------------------------
_UIT_Dialogshell instproc delete {args} {
   uplevel [$self set _Wdgt(bbox)] delete $args
}

# ------------------------------------------------------------------
# METHOD: hide index
#
# Thin wrapper of _UIT_Buttonbox's hide method.
# ------------------------------------------------------------------
_UIT_Dialogshell instproc hide {args} {
   uplevel [$self set _Wdgt(bbox)] hide $args
}

# ------------------------------------------------------------------
# METHOD: show index
#
# Thin wrapper of _UIT_Buttonbox's show method.
# ------------------------------------------------------------------
_UIT_Dialogshell instproc show {args} {
    uplevel [$self set _Wdgt(bbox)] show $args
}

# ------------------------------------------------------------------
# METHOD: default index
#
# Thin wrapper of _UIT_Buttonbox's default method.
# ------------------------------------------------------------------
_UIT_Dialogshell instproc default {args} {
   $self instvar _Wdgt

   uplevel $_Wdgt(bbox) default $args
   #
   # Set up the default button so that if <Return> is pressed in
   # any widget, it will invoke the default button.
   #
   bind $_Wdgt(hull) <Return> "$self invoke"
}

# ------------------------------------------------------------------
# METHOD: invoke ?index?
#
# Thin wrapper of _UIT_Buttonbox's invoke method.
# ------------------------------------------------------------------
_UIT_Dialogshell instproc invoke {args} {
    uplevel [$self set _Wdgt(bbox)] invoke $args
}

# ------------------------------------------------------------------
# METHOD: buttonconfigure index ?option? ?value option value ...?
#
# Thin wrapper of _UIT_Buttonbox's buttonconfigure method.
# ------------------------------------------------------------------
_UIT_Dialogshell instproc buttonconfigure {args} {
   uplevel [$self set _Wdgt(bbox)] buttonconfigure $args
}

_UIT_Dialogshell instproc updateHelp {str} {
   $self instvar _Wdgt
   $_Wdgt(helpwin) configure -state normal
   $_Wdgt(helpwin) delete 0.0 end
   $_Wdgt(helpwin) insert 0.0 $str
   $_Wdgt(helpwin) configure -state disabled
}
