# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: entryfield.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:40  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.5.8  1998/04/22  18:46:24  Anthony_Hoffman
# 	code drop for sysman bl 16 part 2
# 	[1998/04/21  15:24:04  Anthony_Hoffman]
#
# Revision 1.1.2.12  1998/04/08  21:04:03  William_Athanasiou
# 	Fixed focus for text widgets
# 	[1998/04/08  21:03:16  William_Athanasiou]
# 
# Revision 1.1.2.11  1998/02/26  21:44:07  William_Athanasiou
# 	Fix takefocus issues
# 	[1998/02/26  21:23:07  William_Athanasiou]
# 
# Revision 1.1.2.10  1998/02/11  18:44:07  William_Athanasiou
# 	Added disable/enable and change callbacks
# 	[1998/02/11  16:44:15  William_Athanasiou]
# 
# Revision 1.1.2.9  1997/12/09  22:19:25  Todd_Moyer
# 	Guard against spaces in validation strings.
# 	[1997/12/09  22:15:01  Todd_Moyer]
# 
# Revision 1.1.2.8  1997/12/01  18:10:52  William_Athanasiou
# 	Fixed acceptance of return for default button
# 	[1997/12/01  18:02:47  William_Athanasiou]
# 
# Revision 1.1.2.7  1997/10/24  13:57:44  William_Athanasiou
# 	remove 'option add' statements
# 	[1997/10/24  13:49:48  William_Athanasiou]
# 
# Revision 1.1.2.6  1997/03/28  16:46:49  William_Athanasiou
# 	Postpone UI creation until first display for performance reasons
# 	[1997/03/28  16:27:55  William_Athanasiou]
# 
# $EndLog$
# 
# @(#)$RCSfile: entryfield.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:40 $
# 
# Entryfield
# ----------------------------------------------------------------------
# Implements an enhanced text entry widget.
#
# ----------------------------------------------------------------------
#   AUTHOR:  Sue Yockey               E-mail: syockey@spd.dsccc.com
#                                             yockey@acm.org
#            Mark L. Ulferts          E-mail: mulferts@spd.dsccc.com
#
#   @(#) $Id: entryfield.tcl,v 1.1.1.1 2003/01/23 18:34:40 ajay Exp $
# ----------------------------------------------------------------------
#            Copyright (c) 1995 DSC Technologies Corporation
# ======================================================================
# Permission to use, copy, modify, distribute and license this software 
# and its documentation for any purpose, and without fee or written 
# agreement with DSC, is hereby granted, provided that the above copyright 
# notice appears in all copies and that both the copyright notice and 
# warranty disclaimer below appear in supporting documentation, and that 
# the names of DSC Technologies Corporation or DSC Communications 
# Corporation not be used in advertising or publicity pertaining to the 
# software without specific, written prior permission.
# 
# DSC DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING 
# ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, AND NON-
# INFRINGEMENT. THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, AND THE
# AUTHORS AND DISTRIBUTORS HAVE NO OBLIGATION TO PROVIDE MAINTENANCE, 
# SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS. IN NO EVENT SHALL 
# DSC BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR 
# ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, 
# WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION,
# ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS 
# SOFTWARE.
# ======================================================================

# ------------------------------------------------------------------
#                            ENTRYFIELD
# ------------------------------------------------------------------
Class _UIT_Entryfield -superclass _UIT_Labeledwidget 
    
#
# Provide a lowercased access method for the _UIT_Entryfield class.
# 
proc entryfield {pathName args} {
   uplevel _UIT_Entryfield $pathName $args
}

# ------------------------------------------------------------------
#                        CONSTRUCTOR
# ------------------------------------------------------------------
_UIT_Entryfield instproc init {args} {

   $self _define -command {} Command _Command
   $self _define -focuscommand {} Command _FocusCommand
   $self _define -validate {} Command _Validate
   $self _define -invalid {bell} Command _Invalid
   $self _define -fixed 0 Fixed _Fixed
   $self _define -childsitepos e Position _ChildSitePos

   eval {$self next} $args
   $self instvar _Wdgt _Opt
   
   $_Wdgt(hullcmd) configure -borderwidth 0
    
   set _Wdgt(entry) [entry $_Wdgt(interior).entry]
   $self _keep $_Wdgt(entry) -borderwidth -justify \
	 -show -state -textvariable -width -xscrollcommand
   pack $_Wdgt(entry) -fill x -expand yes -side left -padx 0
   
   #
   # Create the child site widget.
   #
   set _Wdgt(efchildsite) [frame $_Wdgt(interior).efchildsite]
   
   set _Wdgt(interior) $_Wdgt(efchildsite)
    
   #
   # _UIT_Entryfield instance bindings.
   #
   bind $_Wdgt(entry) <KeyPress> "$self _keyPress %A %K %s"
   bind $_Wdgt(entry) <FocusIn> "$self _focusCommand"
    
   #
   # Explicitly handle configs that may have been ignored earlier.
   #
   if {![string compare _UIT_Entryfield [$self info class]]} {
      $self configure -labelmargin 1 -command "tk_focusNext $self"
      eval {$self configure} $args
   }
}

# ------------------------------------------------------------------
#                             OPTIONS
# ------------------------------------------------------------------

# ------------------------------------------------------------------
# OPTION: -command
#
# Command associated upon detection of Return key press event
# ------------------------------------------------------------------
_UIT_Entryfield instproc _Command {val} {;}

# ------------------------------------------------------------------
# OPTION: -focuscommand
#
# Command associated upon detection of Return key press event
# ------------------------------------------------------------------
_UIT_Entryfield instproc _FocusCommand {val} {;}

# ------------------------------------------------------------------
# OPTION: -validate
#
# Specify a command to executed for the validation of _UIT_Entryfields.
# ------------------------------------------------------------------
_UIT_Entryfield instproc _Validate {val} {
   $self instvar _Wdgt _Opt
   switch $_Opt(-validate) {
      {} {
	 set _Opt(-validate) {}
      }
      numeric {
	 set _Opt(-validate) "$self numeric %c"
      }
      integer {
	 set _Opt(-validate) "$self integer %P"
      }
      hexidecimal {
	 set _Opt(-validate) "$self hexidecimal %P"
      }
      real {
	 set _Opt(-validate) "$self real %P"
      }
      alphabetic {
	 set _Opt(-validate) "$self alphabetic %c"
      }
      alphanumeric {
	 set _Opt(-validate) "$self alphanumeric %c"
      }
   }
}

# ------------------------------------------------------------------
# OPTION: -invalid
#
# Specify a command to executed should the current _UIT_Entryfield contents
# be proven invalid.
# ------------------------------------------------------------------
_UIT_Entryfield instproc _Invalid {val} {;}

# ------------------------------------------------------------------
# OPTION: -fixed
#
# Restrict entry to 0 (unlimited) chars.  The value is the maximum 
# number of chars the user may type into the field, regardles of 
# field width, i.e. the field width may be 20, but the user will 
# only be able to type -fixed number of characters into it (or 
# unlimited if -fixed = 0).
# ------------------------------------------------------------------
_UIT_Entryfield instproc _Fixed {val} {
   $self instvar _Wdgt _Opt
   if {[regexp {[^0-9]} $_Opt(-fixed)] || \
	 ($_Opt(-fixed) < 0)} {
      error "bad fixed option \"$_Opt(-fixed)\",\
	    should be positive integer"
   }
}

# ------------------------------------------------------------------
# OPTION: -childsitepos
#
# Specifies the position of the child site in the widget.
# ------------------------------------------------------------------
_UIT_Entryfield instproc _ChildSitePos {val} {
   $self instvar _Wdgt _Opt
   switch $_Opt(-childsitepos) {
      n {
	 pack configure $_Wdgt(efchildsite) -side top -padx 0
	 pack $_Wdgt(entry) -fill x -expand yes -side top \
	       -after $_Wdgt(efchildsite) -padx 0
      }
      
      e {
	 pack configure $_Wdgt(efchildsite) -side left -padx 0
	 pack $_Wdgt(entry) -fill x -expand yes -side left \
	       -before $_Wdgt(efchildsite) -padx 0
      }
      
      s {
	 pack $_Wdgt(entry) -fill x -expand yes -side top -padx 0
	 pack configure $_Wdgt(efchildsite) -side top \
	       -after $_Wdgt(entry) -padx 0
      }
      
      w {
	 pack configure $_Wdgt(efchildsite) -side left -padx 0
	 pack $_Wdgt(entry) -fill x -expand yes -side left \
	       -after $_Wdgt(efchildsite) -padx 0
      }
      
      default {
	    error "bad childsite option\
		  \"$_Opt(-childsitepos)\":\
		  should be n, e, s, or w"
      }
   }
}

# ------------------------------------------------------------------
#                            METHODS
# ------------------------------------------------------------------

# ------------------------------------------------------------------
# METHOD: childsite
#
# Returns the path name of the child site widget.
# ------------------------------------------------------------------
_UIT_Entryfield instproc childsite {} {
    return [$self set _Wdgt(efchildsite)]
}

# ------------------------------------------------------------------
# METHOD: get 
#
# Thin wrap of the standard entry widget get method.
# ------------------------------------------------------------------
_UIT_Entryfield instproc get {} {
    return [[$self set _Wdgt(entry)] get]
}

# ------------------------------------------------------------------
# METHOD: delete
#
# Thin wrap of the standard entry widget delete method.
# ------------------------------------------------------------------
_UIT_Entryfield instproc delete {args} {
    return [eval [$self set _Wdgt(entry)] delete $args]
}

# ------------------------------------------------------------------
# METHOD: icursor 
#
# Thin wrap of the standard entry widget icursor method.
# ------------------------------------------------------------------
_UIT_Entryfield instproc icursor {args} {
    return [eval [$self set _Wdgt(entry)] icursor $args]
}

# ------------------------------------------------------------------
# METHOD: index 
#
# Thin wrap of the standard entry widget index method.
# ------------------------------------------------------------------
_UIT_Entryfield instproc index {args} {
    return [eval [$self set _Wdgt(entry)] index $args]
}

# ------------------------------------------------------------------
# METHOD: insert 
#
# Thin wrap of the standard entry widget index method.
# ------------------------------------------------------------------
_UIT_Entryfield instproc insert {args} {
    return [eval [$self set _Wdgt(entry)] insert $args]
}

# ------------------------------------------------------------------
# METHOD: scan 
#
# Thin wrap of the standard entry widget scan method.
# ------------------------------------------------------------------
_UIT_Entryfield instproc scan {args} {
    return [eval [$self set _Wdgt(entry)] scan $args]
}

# ------------------------------------------------------------------
# METHOD: selection
#
# Thin wrap of the standard entry widget selection method.
# ------------------------------------------------------------------
_UIT_Entryfield instproc selection {args} {
    return [eval [$self set _Wdgt(entry)] selection $args]
}

# ------------------------------------------------------------------
# METHOD: xview 
#
# Thin wrap of the standard entry widget xview method.
# ------------------------------------------------------------------
_UIT_Entryfield instproc xview {args} {
    return [eval [$self set _Wdgt(entry)] xview $args]
}

# ------------------------------------------------------------------
# METHOD: clear 
#
# Delete the current entry contents.
# ------------------------------------------------------------------
_UIT_Entryfield instproc clear {} {
   [$self set $_Wdgt(entry)] delete 0 end
   $self icursor 0
}

# ------------------------------------------------------------------
# PROCEDURE: numeric char
#
# The numeric procedure validates character input for a given 
# _UIT_Entryfield to be numeric and returns the result.
# ------------------------------------------------------------------
_UIT_Entryfield instproc numeric {char} {
    return [regexp {[0-9]} $char]
}

# ------------------------------------------------------------------
# PROCEDURE: integer string
#
# The integer procedure validates character input for a given 
# _UIT_Entryfield to be integer and returns the result.
# ------------------------------------------------------------------
_UIT_Entryfield instproc integer {string} {
    return [regexp {^[-+]?[0-9]*$} $string]
}

# ------------------------------------------------------------------
# PROCEDURE: alphabetic char
#
# The alphabetic procedure validates character input for a given 
# _UIT_Entryfield to be alphabetic and returns the result.
# ------------------------------------------------------------------
_UIT_Entryfield instproc alphabetic {char} {
    return [regexp -nocase {[a-z]} $char]
}

# ------------------------------------------------------------------
# PROCEDURE: alphanumeric char
#
# The alphanumeric procedure validates character input for a given 
# _UIT_Entryfield to be alphanumeric and returns the result.
# ------------------------------------------------------------------
_UIT_Entryfield instproc alphanumeric {char} {
    return [regexp -nocase {[0-9a-z]} $char]
}

# ------------------------------------------------------------------
# PROCEDURE: hexadecimal string
#
# The hexidecimal procedure validates character input for a given 
# _UIT_Entryfield to be hexidecimal and returns the result.
# ------------------------------------------------------------------
_UIT_Entryfield instproc hexidecimal {string} {
    return [regexp {^(0x)?[0-9a-fA-F]*$} $string]
}

# ------------------------------------------------------------------
# PROCEDURE: real string
#
# The real procedure validates character input for a given _UIT_Entryfield
# to be real and returns the result.
# ------------------------------------------------------------------
_UIT_Entryfield instproc real {string} {
    return [regexp {^[-+]?[0-9]*\.?[0-9]*$} $string]
}

# ------------------------------------------------------------------
# PRIVATE METHOD: _peek char
#
# The peek procedure returns the value of the _UIT_Entryfield with the
# char inserted at the insert position.
# ------------------------------------------------------------------
_UIT_Entryfield instproc _peek {char} {
    set str [$self get]

    set insertPos [$self index insert] 
    set firstPart [string range $str 0 [expr $insertPos - 1]]
    set lastPart [string range $str $insertPos end]

    append rtnVal $firstPart $char $lastPart
    return $rtnVal
}

# ------------------------------------------------------------------
# PROTECTED METHOD: _focusCommand
#
# Method bound to focus event which evaluates the current command
# specified in the focuscommand option
# ------------------------------------------------------------------
_UIT_Entryfield instproc _focusCommand {} {
    uplevel #0 [$self set _Opt(-focuscommand)]
}

# ------------------------------------------------------------------
# PROTECTED METHOD: _keyPress 
#
# Monitor the key press event checking for return keys, fixed width
# specification, and optional validation procedures.
# ------------------------------------------------------------------
_UIT_Entryfield instproc _keyPress {char sym state} {
   $self instvar _Wdgt _Opt
   #
   # A Return key invokes the optionally specified command option.
   #
   if {$sym == "Return"} {
      uplevel #0 $_Opt(-command)
      return

      # Don't do this as it doesn't do the correct thing for windows with
      #   default buttons.
      #  return -code break
   }
   
   #
   # Tabs, BackSpace, and Delete and unprintable characters
   # are passed on for other bindings.
   #
   if {($sym == "Tab") || ($sym == "BackSpace") || \
	 ($sym == "Delete") || ($char == "") || ($state > 1)} {
      return
   }
   
   #
   # If the fixed length option is not zero, then verify that the
   # current length plus one will not exceed the limit.  If so then
   # invoke the invalid command procedure.
   #
   if {$_Opt(-fixed) != 0} {
      if {[string length [get]] >= $_Opt(-fixed)} {
	 uplevel #0 $_Opt(-invalid)
	 return -code break
      }
   }
   
   #
   # The validate option may contain a keyword (numeric, alphabetic),
   # the name of a procedure, or nothing.  The numeric and alphabetic
   # keywords engage typical base level checks.  If a command procedure
   # is specified, then invoke it with the object and character passed
   # as arguments.  If the validate procedure returns false, then the 
   # invalid procedure is called.
   #
   if {[string length $_Opt(-validate)] > 0} {
      set cmd $_Opt(-validate)
      
      regsub -all "%W" $cmd $_Wdgt(hull) cmd
      # need \" in case space entered
      regsub -all "%P" $cmd \"[$self _peek $char]\" cmd
      regsub -all "%S" $cmd [$self get] cmd
      
      if {$char == "\\"} {
	 regsub -all "%c" $cmd {\\\\} cmd
      } elseif {$char == "&"} {
	 regsub -all "%c" $cmd {\&} cmd
      } else {
	 regsub "\"|\\\[|\\\]|{|}| " $char {\\\0} char
	 regsub -all "%c" $cmd $char cmd
      }
      
      set valid [uplevel #0 $cmd]
      
      if {($valid == "") || (! $valid)} {
	 uplevel #0 $_Opt(-invalid)
	 return -code break
      }
   }
}
