#
# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: pushbutton.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:40  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.4.5  1998/10/23  23:16:53  Peter_Wolfe
# 	Code drop for bl20
# 	[1998/10/23  22:25:49  Peter_Wolfe]
#
# Revision 1.1.2.7  1998/10/16  20:15:12  William_Athanasiou
# 	Add underline capability
# 	[1998/10/16  20:13:44  William_Athanasiou]
# 
# Revision 1.1.2.6  1998/10/02  20:12:53  William_Athanasiou
# 	Fix problem with compressed if
# 	[1998/10/02  20:11:52  William_Athanasiou]
# 
# Revision 1.1.2.5  1997/10/24  13:57:46  William_Athanasiou
# 	remove 'option add' statements
# 	[1997/10/24  13:49:52  William_Athanasiou]
# 
# Revision 1.1.2.4  1997/01/16  14:04:10  William_Athanasiou
# 	Prepend _UIT_ to all classes
# 	[1997/01/15  21:12:24  William_Athanasiou]
# 
# Revision 1.1.2.3  1996/09/25  15:22:53  William_Athanasiou
# 	allow default button to have focus
# 	[1996/09/25  15:15:21  William_Athanasiou]
# 
# Revision 1.1.2.2  1996/09/24  21:12:29  William_Athanasiou
# 	initial version of files/minor changes to TKutils files
# 	[1996/09/24  21:09:34  William_Athanasiou]
# 
# Revision 1.1.2.2  1996/09/13  19:05:45  William_Athanasiou
# 	Original file.
# 	[1996/09/12  18:26:08  William_Athanasiou]
# 
# $EndLog$
# 
# @(#)$RCSfile: pushbutton.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:40 $
#
# _UIT_Pushbutton
# ----------------------------------------------------------------------
# Implements a Motif-like _UIT_Pushbutton with an optional default ring.
#
# WISH LIST:
#    1)  Allow bitmaps and text on the same button face (Tk limitation).
#    2)  provide arm and disarm bitmaps.
#
# ----------------------------------------------------------------------
#   AUTHOR:  Mark L. Ulferts        EMAIL: mulferts@spd.dsccc.com
#            Bret A. Schuhmacher    EMAIL: bas@wn.com
#
#   @(#) $Id: pushbutton.tcl,v 1.1.1.1 2003/01/23 18:34:40 ajay Exp $
# ----------------------------------------------------------------------
#            Copyright (c) 1995 DSC Technologies Corporation
# ======================================================================
# Permission to use, copy, modify, distribute and license this software 
# and its documentation for any purpose, and without fee or written 
# agreement with DSC, is hereby granted, provided that the above copyright 
# notice appears in all copies and that both the copyright notice and 
# warranty disclaimer below appear in supporting documentation, and that 
# the names of DSC Technologies Corporation or DSC Communications 
# Corporation not be used in advertising or publicity pertaining to the 
# software without specific, written prior permission.
# 
# DSC DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING 
# ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, AND NON-
# INFRINGEMENT. THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, AND THE
# AUTHORS AND DISTRIBUTORS HAVE NO OBLIGATION TO PROVIDE MAINTENANCE, 
# SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS. IN NO EVENT SHALL 
# DSC BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR 
# ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, 
# WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION,
# ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS 
# SOFTWARE.
# ======================================================================

# ------------------------------------------------------------------
#                            PUSHBUTTON
# ------------------------------------------------------------------
Class _UIT_Pushbutton -superclass _UIT_Widget

# ------------------------------------------------------------------
#                        CONSTRUCTOR
# ------------------------------------------------------------------
_UIT_Pushbutton instproc init {args} {
   $self _define -background

   $self next 
   $self instvar _Opts _Wdgt \
       _DefaultUnderline _NormalUnderline _reposition
      
   $self _define -padx 1 PadX _padX
   $self _define -pady 0 PadY _padY
   $self _define -text {} Text _text
   $self _define -borderwidth 0 BorderWidth _borderWidth
   $self _define -defaultring 0 DefaultRing _defaultRing
   $self _define -defaultringpad 1 Pad _defaultRingPad
   $self _define -height 0 Height _height
   $self _define -width 0 Width _width
   $self _define -underline -1 Underline _underline
      
   set _reposition ""  ;# non-null => _relayout pending
   set _NormalUnderline -1
   set _DefaultUnderline -1

   $_Wdgt(hullcmd) configure -borderwidth 0
   
   pack propagate $_Wdgt(hull) no
   
   set _Wdgt(pushButton) [button $_Wdgt(hull).pushButton]
   $self _keep $_Wdgt(pushButton) -anchor -justify -textvariable \
	 -wraplength -state -command 

   pack $_Wdgt(pushButton) -expand 1 -fill both -padx 0
   
   #
   # Explicitly handle configs that may have been ignored earlier.
   #
   if {![string compare _UIT_Pushbutton [$self info class]]} {
      $self configure -borderwidth 0 -padx 0 -pady 0 \
	    -defaultringpad 0 -text {}
      
      eval {$self configure} $args
   }

   
   #
   # Layout the pushbutton.
   #
   $self _relayout
}

#
# Provide a lowercased access method for the _UIT_Pushbutton class.
# 
proc pushbutton {pathName args} {
   uplevel _UIT_Pushbutton $pathName $args
}


# ------------------------------------------------------------------
#                           DESTRUCTOR
# ------------------------------------------------------------------
_UIT_Pushbutton instproc destroy {} {
   $self instvar _reposition
   if {$_reposition != ""} {after cancel $_reposition}
}

# ------------------------------------------------------------------
#                             OPTIONS
# ------------------------------------------------------------------

# ------------------------------------------------------------------
# OPTION: -padx
#
# Specifies the extra space surrounding the label in the x direction.
# ------------------------------------------------------------------
_UIT_Pushbutton instproc _padX {val} {
   $self instvar _Wdgt _Opt

   $_Wdgt(pushButton) configure -padx $_Opt(-padx)   
   $self _relayout
}

# ------------------------------------------------------------------
# OPTION: -pady
#
# Specifies the extra space surrounding the label in the y direction.
# ------------------------------------------------------------------
_UIT_Pushbutton instproc _padY {val} {
   $self instvar _Wdgt _Opt
   $_Wdgt(pushButton) configure -pady $_Opt(-pady)
   
   $self _relayout
}

# ------------------------------------------------------------------
# OPTION: -font
#
# Specifies the label font.
# ------------------------------------------------------------------
_UIT_Pushbutton instproc _font {val} {
   $self instvar _Wdgt _Opt
   $_Wdgt(pushButton) configure -font $_Opt(-font)
   
   $self _relayout
}

# ------------------------------------------------------------------
# OPTION: -text
#
# Specifies the label text.
# ------------------------------------------------------------------
_UIT_Pushbutton instproc _text {val} {
   $self instvar _Wdgt _Opt _DefaultLabel _NormalLabel

   set _DefaultLabel "\[$val\]"
   set _NormalLabel $val
   $_Wdgt(pushButton) configure -text $_Opt(-text)
   
   $self _relayout
}

# ------------------------------------------------------------------
# OPTION: -borderwidth
#
# Specifies the width of the relief border.
# ------------------------------------------------------------------
_UIT_Pushbutton instproc _borderWidth {val} {
   $self instvar _Wdgt _Opt
   $_Wdgt(pushButton) configure -borderwidth $_Opt(-borderwidth)
   
   $self _relayout
}

# ------------------------------------------------------------------
# OPTION: -defaultring
#
# Boolean describing whether the button displays its default ring.  
# ------------------------------------------------------------------
_UIT_Pushbutton instproc _defaultRing {val} {
   $self _relayout
}

# ------------------------------------------------------------------
# OPTION: -defaultringpad
#
# The size of the padded default ring around the button.
# ------------------------------------------------------------------
_UIT_Pushbutton instproc _defaultRingPad {val} {
}

# ------------------------------------------------------------------
# OPTION: -height
#
# Specifies the height of the button inclusive of any default ring.
# A value of zero lets the push button determine the height based
# on the requested height plus highlightring and defaultringpad.
# ------------------------------------------------------------------
_UIT_Pushbutton instproc _height {val} {
   $self _relayout
}

# ------------------------------------------------------------------
# OPTION: -width
#
# Specifies the width of the button inclusive of any default ring.
# A value of zero lets the push button determine the width based
# on the requested width plus highlightring and defaultringpad.
# ------------------------------------------------------------------
_UIT_Pushbutton instproc _width {val} {
   $self _relayout
}

_UIT_Pushbutton instproc _underline {val} {
   $self instvar _DefaultUnderline _NormalUnderline
   set _NormalUnderline $val
   if {$val < 0} {
      set _DefaultUnderline -1
   } else {
      set _DefaultUnderline [expr $val + 1]
   }
}
      

# ------------------------------------------------------------------
#                            METHODS
# ------------------------------------------------------------------

# ------------------------------------------------------------------
# METHOD: flash
#
# Thin wrap of standard button widget flash method.
# ------------------------------------------------------------------
_UIT_Pushbutton instproc flash {} {
   [$self set _Wdgt(pushButton)] flash
}

# ------------------------------------------------------------------
# METHOD: invoke
#
# Thin wrap of standard button widget invoke method.
# ------------------------------------------------------------------
_UIT_Pushbutton instproc invoke {} {
   [$self set _Wdgt(pushButton)] invoke
}

# ------------------------------------------------------------------
# PRIVATE METHOD: _relayout ?when?
#
# Adjust the width and height of the _UIT_Pushbutton to accomadate all the
# current options settings.  Add back in the highlightthickness to 
# the button such that the correct reqwidth and reqheight are computed.  
# Set the width and height based on the reqwidth/reqheight, 
# highlightthickness, and ringpad.  Finally, configure the defaultring
# properly. If "when" is "now", the change is applied immediately.  If 
# it is "later" or it is not specified, then the change is applied later,
# when the application is idle.
# ------------------------------------------------------------------
_UIT_Pushbutton instproc _relayout {{when later}} {
   $self instvar _Wdgt _Opt _reposition \
       _DefaultLabel _NormalLabel _DefaultUnderline _NormalUnderline

   if {$when == "later"} {
      if {$_reposition == ""} {
	 set _reposition [after idle "$self _relayout now"]
      }
      return
   } elseif {$when != "now"} {
      error "bad option \"$when\": should be now or later"
   }
    
   set _reposition ""
   
   if {[regexp -nocase {^(1|yes|true|on)$} $_Opt(-defaultring)]} {
      $_Wdgt(hullcmd) configure -relief sunken 
      
      $_Wdgt(pushButton) configure -text $_DefaultLabel \
	  -underline $_DefaultUnderline
      
   } else {
      $_Wdgt(hullcmd) configure -relief flat -takefocus 0
      
      $_Wdgt(pushButton) configure -text $_NormalLabel \
	  -underline $_NormalUnderline
   }

   if {$_Opt(-width) == 0} {
      set w [expr [winfo reqwidth $_Wdgt(pushButton)] \
	    + 2 * $_Opt(-borderwidth) + 1]
   } else {
      set w $_Opt(-width)
   }
   
   if {$_Opt(-height) == 0} {
      set h [expr [winfo reqheight $_Wdgt(pushButton)] \
	    + 2 * $_Opt(-borderwidth)]
   } else {
      set h $_Opt(-height)
   }
   
   $_Wdgt(hullcmd) configure -width $w -height $h
}

_UIT_Pushbutton instproc _widget {} { return $self }
