#!/usr/bin/sh
# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: scrolledframe.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:40  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.3.2  1997/05/20  15:24:09  William_Athanasiou
# 	Updated files for prebl11 errors
# 	[1997/05/20  15:22:16  William_Athanasiou]
#
# Revision 1.1.1.2  1997/05/20  15:19:34  William_Athanasiou
# 	Missing files for preBl11
# 
# $EndLog$
# 
# @(#)$RCSfile: scrolledframe.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:40 $
# 
#
# Scrolledframe
# ----------------------------------------------------------------------
# Implements horizontal and vertical scrollbars around a childsite
# frame.  Includes options to control display of scrollbars.
#
# ----------------------------------------------------------------------
#  AUTHOR: Sue Yockey                           syockey@spd.dsccc.com 
#          Mark Ulferts                         mulferts@spd.dsccc.com 
#
#  @(#) $Id: scrolledframe.tcl,v 1.1.1.1 2003/01/23 18:34:40 ajay Exp $
# ----------------------------------------------------------------------
#            Copyright (c) 1995 DSC Technologies Corporation
# ======================================================================
# Permission to use, copy, modify, distribute and license this software 
# and its documentation for any purpose, and without fee or written 
# agreement with DSC, is hereby granted, provided that the above copyright 
# notice appears in all copies and that both the copyright notice and 
# warranty disclaimer below appear in supporting documentation, and that 
# the names of DSC Technologies Corporation or DSC Communications 
# Corporation not be used in advertising or publicity pertaining to the 
# software without specific, written prior permission.
# 
# DSC DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING 
# ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, AND NON-
# INFRINGEMENT. THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, AND THE
# AUTHORS AND DISTRIBUTORS HAVE NO OBLIGATION TO PROVIDE MAINTENANCE, 
# SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS. IN NO EVENT SHALL 
# DSC BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR 
# ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, 
# WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION,
# ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS 
# SOFTWARE.
# ======================================================================

#
# Default resources.
#
#option add *Scrolledframe.borderWidth 2 widgetDefault
#option add *Scrolledframe.relief sunken widgetDefault
#option add *Scrolledframe.scrollMargin 3 widgetDefault
#option add *Scrolledframe.vscrollMode static widgetDefault
#option add *Scrolledframe.hscrollMode static widgetDefault
#option add *Scrolledframe.width 100 widgetDefault
#option add *Scrolledframe.height 100 widgetDefault
#option add *Scrolledframe.labelPos n widgetDefault

#
# Usual options.
#
#itk::usual Scrolledframe {
#    keep -activebackground -activerelief -background -borderwidth -cursor \
#	 -elementborderwidth -foreground -highlightcolor -highlightthickness \
#	 -jump -labelfont -troughcolor
#}

# ------------------------------------------------------------------
#                            SCROLLEDFRAME
# ------------------------------------------------------------------
Class _UIT_Scrolledframe -superclass _UIT_Labeledwidget


#
# Provide a lowercased access method for the Scrolledframe class.
# 
proc scrolledframe {pathName args} {
    uplevel _UIT_Scrolledframe $pathName $args
}

# ------------------------------------------------------------------
#                        CONSTRUCTOR
# ------------------------------------------------------------------
_UIT_Scrolledframe instproc init {args} {

   $self _define -sbwidth 15 Width _sbWidth
   $self _define -scrollmargin 0 ScrollMargin _scrollMargin
   $self _define -vscrollmode static VScrollMode _vscrollMode
   $self _define -hscrollmode static HScrollMode _hscrollMode
   $self _define -width 30 Width _width
   $self _define -height 30 Height _height
   
   $self set _vmode off              ;# Vertical scroll mode
   $self set _hmode off              ;# Vertical scroll mode
   
   $self set _initialized 0          ;# Initialization flag.
   
   eval {$self next} $args
   $self instvar _Wdgt _Opt

   $_Wdgt(hullcmd) configure -borderwidth 0
   pack propagate $_Wdgt(shell) no

   #
   # Create some frames to hold both the top and bottom halves of 
   # the widget.  The top will contain both the canvas and vertical 
   # scrollbar.  The bottom houses the horizontal scrollbar and 
   # some filler.
   #
   
   set _Wdgt(topFrame) [frame $_Wdgt(interior).topFrame]
   pack $_Wdgt(topFrame) -fill both -expand yes -padx 0 -pady 0
    
   #
   # Frame around horizontal scrollbar 
   #
   set _Wdgt(bottomHalf) [frame $_Wdgt(topFrame).bottomHalf]
   pack $_Wdgt(bottomHalf) -fill x -side bottom -padx 0 -pady 0
    
   #
   # Frame for horizontal margin between scrolled area & scrollbar
   #
   set _Wdgt(hMargin) [frame $_Wdgt(topFrame).hMargin]
   pack $_Wdgt(hMargin) -side bottom -padx 0 -pady 0

   #
   # Frame around canvas and vertical scrollbar
   #
   set _Wdgt(topHalf) [frame $_Wdgt(topFrame).topHalf]
   pack $_Wdgt(topHalf) -fill both -expand yes -padx 0 -pady 0
    
   # 
   # Create a frame for the canvas to provide relief for the canvas.
   #
   set _Wdgt(canvasFrame) [frame $_Wdgt(topHalf).canvasFrame \
		-borderwidth 2]
   $self _keep $_Wdgt(canvasFrame) -borderwidth 
   
   # 
   # Create a canvas to scroll
   #
   set _Wdgt(scrCanvas) [canvas $_Wdgt(canvasFrame).scrCanvas \
	 -height 1 -width 1 \
	 -scrollregion "0 0 1 1" \
	 -borderwidth 0  \
	 -xscrollcommand "$self _scrollFrame $_Wdgt(bottomHalf).hSB" \
	 -yscrollcommand "$self _scrollFrame $_Wdgt(topHalf).vSB"]
   pack $_Wdgt(scrCanvas) -fill both -expand yes -padx 0 -pady 0
   bind $_Wdgt(scrCanvas) <Configure> "$self _configureCanvas"
   
   #
   # Create a Frame inside canvas to hold widgets to be scrolled 
   #
   set _Wdgt(scrFrame) [frame $_Wdgt(scrCanvas).scrFrame]
   pack $_Wdgt(scrFrame) -fill both -expand yes -padx 0 -pady 0
   $_Wdgt(scrCanvas) create window 1 1 -tags frameTag \
	 -window $_Wdgt(scrFrame) -anchor nw
   set _Wdgt(interior) $_Wdgt(scrFrame)
   bind $_Wdgt(scrFrame) <Configure> "$self _configureFrame"
    
   #
   # Create frame for the vertical margin between the scrolling
   # area and the scrollbar.
   #
   set _Wdgt(vMargin) [frame $_Wdgt(topHalf).vMargin -width 0]
    
   # 
   # Create the vertical scroll bar.
   #
   set _Wdgt(vSB) [scrollbar $_Wdgt(topHalf).vSB -orient vertical \
	 -command "$_Wdgt(scrCanvas) yview" -takefocus 1]
   pack $_Wdgt(vSB) -side right -fill y -padx 0 -pady 0
   pack $_Wdgt(vMargin) -side right -padx 0 -pady 0
   pack $_Wdgt(canvasFrame) -fill both -expand yes -side left -pady 0 -padx 0
    
   #
   # Create the horizontal scrollbar.
   #
   set _Wdgt(hSB) [scrollbar $_Wdgt(bottomHalf).hSB -orient horizontal \
	 -command "$_Wdgt(scrCanvas) xview" -takefocus 1]
   pack $_Wdgt(hSB) -side left -fill x -expand yes -pady 0 -padx 0
    
   #
   # Create the filler frame and compute its width.
   #
   set _Wdgt(filler) [frame $_Wdgt(bottomHalf).filler \
	 -width [$self _fillerWidth]]
   pack $_Wdgt(filler) -side right -pady 0 -padx 0
    
   #
   # Explicitly handle configs that may have been ignored earlier.
   #
   if {![string compare _UIT_Scrolledframe [$self info class]]} {
      $self configure -borderwidth 1 -scrollmargin 0\
	    -vscrollmode dynamic -hscrollmode dynamic -width 30 \
	    -height 30 -labelpos nw
  
      eval {$self configure} $args
   }
    
   set _initialized 1
   $self configure -scrollmargin $_Opt(-scrollmargin)
}

# ------------------------------------------------------------------
#                             OPTIONS
# ------------------------------------------------------------------

# ------------------------------------------------------------------
# OPTION: -sbwidth
#
# Set the width of the scrollbars.
# ------------------------------------------------------------------
_UIT_Scrolledframe instproc _sbWidth {val} {
   $self instvar _initialized _Opt _Wdgt

   if {$_initialized} {
      $_Wdgt(vSB) configure -width $_Opt(-sbwidth)
      $_Wdgt(hSB) configure -width $_Opt(-sbwidth)
      
      update idletasks
      
      $_Wdgt(filler) config -width [$self _fillerWidth] -height 1
   }
}

# ------------------------------------------------------------------
# OPTION: -scrollmargin
#
# Set the distance between the scrollbars and the canvas.
# ------------------------------------------------------------------
_UIT_Scrolledframe instproc _scrollMargin {val} {
   $self instvar _initialized _Opt _Wdgt _hmode _vmode

   if {$_initialized} {
      set pixels [winfo pixels $_Wdgt(hMargin) $_Opt(-scrollmargin)]
      
      if {$_hmode == "on"} {
	 $_Wdgt(hMargin) config -width 1 -height $pixels
      }
      
      if {$_vmode == "on"} {
	 $_Wdgt(vMargin) config -width $pixels -height 1
      }
      
      $_Wdgt(filler) config -width [$self _fillerWidth] -height 1
   }
}

# ------------------------------------------------------------------
# OPTION: -vscrollmode
#
# Enable/disable display and mode of veritcal scrollbars.
# ------------------------------------------------------------------
_UIT_Scrolledframe instproc _vscrollMode {val} {
   $self instvar _Opt
   
   switch $_Opt(-vscrollmode) {
      static {
	 $self _vertScrollbarDisplay on
      }
      
      dynamic -
      none {
	 $self _vertScrollbarDisplay off
      }
      
      default {
	 error "bad vscrollmode option\
	       \"$_Opt(-vscrollmode)\": should be\
	       static, dynamic, or none"
      }
   }
}

# ------------------------------------------------------------------
# OPTION: -hscrollmode
#
# Enable/disable display and mode of horizontal scrollbars.
# ------------------------------------------------------------------
_UIT_Scrolledframe instproc _hscrollMode {val} {
   $self instvar _Opt

   switch $_Opt(-hscrollmode) {
      static {
	 $self _horizScrollbarDisplay on
      }
      
      dynamic -
      none {
	 $self _horizScrollbarDisplay off
      }
      
      default {
	 error "bad hscrollmode option\
	       \"$_Opt(-hscrollmode)\": should be\
	       static, dynamic, or none"
      }
   }
}

# ------------------------------------------------------------------
# OPTION: -width
#
# Specifies the width of the scrolled frame.  The value may be 
# specified in any of the forms acceptable to Tk_GetPixels.  
# ------------------------------------------------------------------
_UIT_Scrolledframe instproc _width {val} {
   $self instvar _Opt _Wdgt
   set pixels \
	 [winfo pixels $_Wdgt(shell) $_Opt(-width)]
   
   $_Wdgt(hullcmd) config -width $pixels
}

# ------------------------------------------------------------------
# OPTION: -height
#
# Specifies the height of the scrolled frame.  The value may be 
# specified in any of the forms acceptable to Tk_GetPixels.  
# ------------------------------------------------------------------
_UIT_Scrolledframe instproc _height {val} {
   $self instvar _initialized _Opt _Wdgt
   set pixels \
	 [winfo pixels $_Wdgt(shell) $_Opt(-height)]
   
   $_Wdgt(hullcmd) config -height $pixels
}

# ------------------------------------------------------------------
#                            METHODS
# ------------------------------------------------------------------

# ------------------------------------------------------------------
# METHOD: childsite
#
# Returns the path name of the child site widget.
# ------------------------------------------------------------------
_UIT_Scrolledframe instproc childsite {} {
   return [$self set _Wdgt(scrFrame)]
}

# ------------------------------------------------------------------
# METHOD: justify
#
# Justifies the scrolled region in one of four directions: top,
# bottom, left, or right.
# ------------------------------------------------------------------
_UIT_Scrolledframe instproc justify {direction} {
   $self instvar _initialized _Opt _Wdgt

   if {[winfo ismapped $_Wdgt(scrCanvas)]} {
      update idletasks
      
      switch $direction {
	 left {
	    $_Wdgt(scrCanvas) xview moveto 0
	 }
	 right {
	    $_Wdgt(scrCanvas) xview moveto 1
	 }
	 top {
	    $_Wdgt(scrCanvas) yview moveto 0
	 }
	 bottom {
	    $_Wdgt(scrCanvas) yview moveto 1
	 }
	 default {
	    error "bad justify argument \"$direction\": should be\
		  left, right, top, or bottom"
	 }
      }
   }
}

# ------------------------------------------------------------------
# METHOD: xview index
#
# Adjust the view in the frame so that character position index
# is displayed at the left edge of the widget.
# ------------------------------------------------------------------
_UIT_Scrolledframe instproc xview {args} {
   return [eval [$self set _Wdgt(scrCanvas)] xview $args]
}

# ------------------------------------------------------------------
# METHOD: yview index
#
# Adjust the view in the frame so that character position index
# is displayed at the top edge of the widget.
# ------------------------------------------------------------------
_UIT_Scrolledframe instproc yview {args} {
    return [eval [$self set _Wdgt(scrCanvas)] yview $args]
}

# ------------------------------------------------------------------
# PRIVATE METHOD: _configureCanvas 
#
# Responds to configure events on the canvas widget.  When canvas 
# changes size, adjust frame size.
# ------------------------------------------------------------------
_UIT_Scrolledframe instproc _configureCanvas {} {
   $self instvar _initialized _Opt _Wdgt

   set sr [$_Wdgt(scrCanvas) cget -scrollregion]
   set srw [lindex $sr 2]
   set srh [lindex $sr 3]
   
   $_Wdgt(scrFrame) configure -height $srh -width $srw
}

# ------------------------------------------------------------------
# PRIVATE METHOD: _configureFrame 
#
# Responds to configure events on the frame widget.  When the frame 
# changes size, adjust scrolling region size.
# ------------------------------------------------------------------
_UIT_Scrolledframe instproc _configureFrame {} {
   $self instvar _Opt _Wdgt

   $_Wdgt(scrCanvas) configure \
	 -scrollregion [$_Wdgt(scrCanvas) bbox frameTag] 
}

# ------------------------------------------------------------------
# PRIVATE METHOD: _fillerWidth 
#
# Compute the width of the filler frame based on the vertical 
# scrollbar width plus the margin.
# ------------------------------------------------------------------
_UIT_Scrolledframe instproc _fillerWidth {} {
   $self instvar _Wdgt _vmode

   if {$_vmode == "on"} {
      return [expr [winfo reqwidth $_Wdgt(vSB)] + \
	    [winfo reqwidth $_Wdgt(vMargin)]]
   } else {
      return 0
   }
}

# ------------------------------------------------------------------
# PRIVATE METHOD: _horizScrollbarDisplay 
#
# Displays the horizontal scrollbar based on the input mode.
# ------------------------------------------------------------------
_UIT_Scrolledframe instproc _horizScrollbarDisplay {mode} {
   $self instvar _initialized _Opt _Wdgt _hmode

   switch $mode  {
      on {
	 set _hmode on
	 
	 pack $_Wdgt(bottomHalf) -fill x -side bottom -padx 0 -pady 0

	 if {($_Opt(-scrollmargin)) > 0} {
	    $_Wdgt(hMargin) config -width 1 -height \
		  [winfo pixels $_Wdgt(hMargin) \
		  $_Opt(-scrollmargin)]
	    pack $_Wdgt(hMargin) -fill x -side bottom -padx 0 -pady 0
	 }
	 
	 update idletasks
	 
	 $_Wdgt(filler) config -width [$self _fillerWidth] -height 1
      }
      
      off {
	 set _hmode off

	 pack forget $_Wdgt(hMargin)
	 pack forget $_Wdgt(bottomHalf)
      }
      
      default {
	 error "invalid argument \"$mode\": should be on or off"
      }
   }
}

# ------------------------------------------------------------------
# PRIVATE METHOD: _vertScrollbarDisplay 
#
# Displays the vertical scrollbar based on the input mode.
# ------------------------------------------------------------------
_UIT_Scrolledframe instproc _vertScrollbarDisplay {mode} {
   $self instvar _initialized _Opt _Wdgt _vmode

   switch $mode  {
      on {
	 set _vmode on
	 
	 pack forget $_Wdgt(canvasFrame)
	 pack $_Wdgt(vSB) -side right -fill y -pady 0 -padx 0

	 if {($_Opt(-scrollmargin)) > 1} {
	    $_Wdgt(vMargin) config -height 1 -width \
		  [winfo pixels $_Wdgt(vMargin) \
		  $_Opt(-scrollmargin)]
	    
	    pack $_Wdgt(vMargin) -side right -pady 0 -padx 0
	 }
	 pack $_Wdgt(canvasFrame) -fill both -expand yes \
	       -side left -pady 0 -padx 0
	 
	 update idletasks
	 
	 $_Wdgt(filler) config -width [$self _fillerWidth] -height 1
      }
      
      off {
	 set _vmode off
	 
	 pack forget $_Wdgt(vSB)
	 pack forget $_Wdgt(vMargin)

	 $_Wdgt(filler) config -width 1 -height 1
      }
      
      default {
	 error "invalid argument \"$mode\": should be on or off"
      }
   }
}

# ------------------------------------------------------------------
# PRIVATE METHOD: _scrollFrame 
#
# Performs scrolling and display of scrollbars based on the total 
# and maximum frame size as well as the current -vscrollmode and 
# -hscrollmode settings.  Parameters are automatic scroll parameters.
# ------------------------------------------------------------------
_UIT_Scrolledframe instproc _scrollFrame {wid first last} {
   $self instvar _initialized _Opt _Wdgt _hmode _vmode

   $wid set $first $last
    
   if {$wid == $_Wdgt(vSB)} {
      if {$_Opt(-vscrollmode) == "dynamic"} {
	 if {($first == 0) && ($last == 1)} {
	    if {$_vmode != "off"} {
	       $self _vertScrollbarDisplay off
	    }
	    
	 } else {
	    if {$_vmode != "on"} {
	       $self _vertScrollbarDisplay on
	    }
	 }
      }
      
   } elseif {$wid == $_Wdgt(hSB)} {
      if {$_Opt(-hscrollmode) == "dynamic"} {
	 if {($first == 0) && ($last == 1)} {
	    if {$_hmode != "off"} {
	       $self _horizScrollbarDisplay off
	    }
	    
	 } else {
	    if {$_hmode != "on"} {
	       $self _horizScrollbarDisplay on
	    }
	 }
      }
   }
}
