# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: Archetype.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:40  ajay
# Initial submit to CVS.
#
#
# $EndLog$
# 
# @(#)$RCSfile: Archetype.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:40 $
# 
Class _UIT_Archetype

_UIT_Archetype instproc _keep {widget args} {
   $self instvar _Kept
   foreach i $args {
      lappend _Kept($i) $widget
   }
}

_UIT_Archetype instproc _rename {widget old new} {
   $self instvar _Renamed

   $self set _Renamed($new) "$widget %s $old"
}

_UIT_Archetype instproc _define \
      {opt {defval {}} {resourceClass {}} {configMethod {}}} {

   $self instvar _Defined _Opt

   # _UIT_Record default value.
   #
   set _Opt($opt) $defval

   # _UIT_Record defvalue and resource class in info array.
   #
   if {$resourceClass == ""} {
      set resourceClass \
	    [string toupper [string index $opt 1]][string range $opt 2 end]
   }

   set _Defined($opt) [list $resourceClass $defval $configMethod]
}

_UIT_Archetype instproc cget {var} {
   return [lindex [$self configure $var] 4]
}

_UIT_Archetype instproc config {args} {
   eval {$self configure} $args
}

_UIT_Archetype instproc configure {args} {
   $self instvar _Kept _Renamed _Defined _Opt
   
   set len [llength $args]

   if {$len == 0} {
      set str ""
      foreach i [array names _Kept] {
	 lappend str [[lindex $_Kept($i) 0] configure $i]
      }
      foreach i [array names _Renamed] {
	 lappend str [eval [format $_Renamed($i) configure]]
      }
      foreach i [array names _Defined] {
	 lappend str [concat $i \
	       [string range $i 1 end] \
	       [lrange $_Defined($i) 0 1] $_Opt($i)]
      }
      return $str
   }

   if {$len == 1} {
      if {[info exists _Kept($args)]} {
	 return [[lindex $_Kept($args) 0] configure $args]
      }
      if {[info exists _Renamed($args)]} {
	 return [eval [format $_Renamed($args) configure]]
      }
      if {[info exists _Defined($args)]} {
	 return [concat $args \
	       [string range $args 1 end] \
	       [lrange $_Defined($args) 0 1] $_Opt($args)]
      }
      error "unknown option \"$args\""
   }
   
   #
   # evaluate the args

   if {$len % 2 != 0} {
      error {invalid number of arguments}
   }
   set cmds {}
   array set opts $args
   foreach i [array names opts] {
      if {[info exists _Kept($i)]} {
	 foreach w $_Kept($i) {
	    lappend cmds [list $w configure $i $opts($i)]
	 }
      } else {
	 if {[info exists _Renamed($i)]} {
	    lappend cmds \
		  [list eval [format $_Renamed($i) configure] $opts($i)]
	 } else {
	    if {[info exists _Defined($i)]} {
	       lappend cmds [list set _Opt($i) $opts($i) ]
	       lappend cmds [list $self [lindex $_Defined($i) end] $opts($i)]
	    } else {
	       error "Invalid argument: $i"
	    }
	 }
      }
   }
   # Exec cmds
   foreach i $cmds {
      eval $i
   }
}
