# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: dialog.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:41  ajay
# Initial submit to CVS.
#
#
# $EndLog$
# 
# @(#)$RCSfile: dialog.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:41 $
# 
#
# _UIT_Dialog
# ----------------------------------------------------------------------
# Implements a standard dialog box providing standard buttons and a 
# child site for use in derived classes.  The buttons include ok, apply,
# cancel, and help.  Options exist to configure the buttons.
#    
# ----------------------------------------------------------------------
#  AUTHOR: Mark L. Ulferts               EMAIL: mulferts@spd.dsccc.com
#
#  @(#) $Id: dialog.tcl,v 1.1.1.1 2003/01/23 18:34:41 ajay Exp $
# ----------------------------------------------------------------------
#            Copyright (c) 1995 DSC Technologies Corporation
# ======================================================================
# Permission to use, copy, modify, distribute and license this software 
# and its documentation for any purpose, and without fee or written 
# agreement with DSC, is hereby granted, provided that the above copyright 
# notice appears in all copies and that both the copyright notice and 
# warranty disclaimer below appear in supporting documentation, and that 
# the names of DSC Technologies Corporation or DSC Communications 
# Corporation not be used in advertising or publicity pertaining to the 
# software without specific, written prior permission.
# 
# DSC DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING 
# ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, AND NON-
# INFRINGEMENT. THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, AND THE
# AUTHORS AND DISTRIBUTORS HAVE NO OBLIGATION TO PROVIDE MAINTENANCE, 
# SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS. IN NO EVENT SHALL 
# DSC BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR 
# ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, 
# WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION,
# ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS 
# SOFTWARE.
# ======================================================================

#
# Default resources.
#
option add *Dialog.padX 10 widgetDefault
option add *Dialog.padY 10 widgetDefault

#
# Usual options.
#
#itk::usual _UIT_Dialog {
#    keep -background -cursor -foreground -modality 
#}

# ------------------------------------------------------------------
#                            DIALOG
# ------------------------------------------------------------------
Class _UIT_Dialog -superclass _UIT_Dialogshell

# ------------------------------------------------------------------
#                        CONSTRUCTOR
# ------------------------------------------------------------------
_UIT_Dialog instproc init {args} {

   $self next
   $self instvar _Wdgt _Opt
   
   $self add OK -text OK -command "$self deactivate 1"
   $self add Apply -text Apply
   $self add Cancel -text Cancel -command "$self deactivate 0"
   $self add Help -text Help
   
   $self default OK
   
   #
   # Bind the window manager delete protocol to invocation of the
   # cancel button.  This can be overridden by the user via the
   # execution of a similar command outside the class.
   #
   wm protocol $_Wdgt(hull) WM_DELETE_WINDOW "$self invoke Cancel"
   
   #
   # Explicitly handle configs that may have been ignored earlier.
   #
   if {![string compare _UIT_Dialog [$self info class]]} {
      $self configure -thickness 3 -buttonboxpos s -modality none \
	    -separator on -padx 10 -pady 10

      eval {$self configure} $args
   }
}

#
# Provide a lowercased access method for the _UIT_Dialog class.
# 
proc dialog {pathName args} {
    uplevel _UIT_Dialog $pathName $args
}

