# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: dialogshell.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:41  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.7.1  2000/03/30  21:25:24  Todd_Moyer
# 	Removed tkwait to fix focus qar 78595.
#
# Revision 1.1.2.19  2000/03/30  20:42:19  Todd_Moyer
# 	Removed tkwait to fix focus qar 78595.
#
# Revision 1.1.2.18  1999/03/23  16:32:51  William_Athanasiou
# 	Shrink default size to accomidate large character sets
# 	[1999/03/23  16:32:35  William_Athanasiou]
#
# Revision 1.1.2.17  1999/01/06  21:18:46  William_Athanasiou
# 	Fix several tab/focus/hilight issues
# 	[1999/01/06  21:17:56  William_Athanasiou]
# 
# Revision 1.1.2.16  1998/12/03  22:32:11  William_Athanasiou
# 	Fix global grab and refresh
# 	[1998/12/03  22:17:51  William_Athanasiou]
# 
# Revision 1.1.2.15  1997/12/22  19:58:26  William_Athanasiou
# 	grabstack common variable was being set to {} each time
# 	an instance was created.  Added test to set it to {} only
# 	if it doesn't exist, thus preserving the grabstack history.
# 	[1997/12/22  19:57:49  William_Athanasiou]
# 
# Revision 1.1.2.14  1997/11/17  14:34:46  William_Athanasiou
# 	Fix incorrect assignment of width to separator frame
# 	[1997/11/17  14:33:57  William_Athanasiou]
# 
# Revision 1.1.2.13  1997/09/25  21:12:18  Todd_Moyer
# 	Fixed backward condition in _separator method.
# 	[1997/09/25  20:14:45  Todd_Moyer]
# 
# Revision 1.1.2.12  1997/09/19  15:40:29  Richard_Taft
# 	It's not an error to redisplay a displayed window
# 	[1997/09/19  15:39:05  Richard_Taft]
# 
# Revision 1.1.2.11  1997/08/27  21:26:43  William_Athanasiou
# 	Fixed bad code that showed up when whitespace removed
# 	[1997/08/27  21:25:53  William_Athanasiou]
# 
# Revision 1.1.2.10  1997/07/16  15:00:14  William_Athanasiou
# 	 	** Merge Information **
# 		** Command used:	bsubmit **
# 		** Ancestor revision:	1.1.2.8 **
# 		** Merge revision:	1.1.2.9 **
# 	 	** End **
# 	Fixed problem with extra whitespace
# 	[1997/07/10  14:33:34  William_Athanasiou]
# 
# Revision 1.1.2.9  1997/07/10  14:33:59  William_Athanasiou
# 	Fixed problem with extra whitespace
# 	[1997/07/10  14:33:34  William_Athanasiou]
# 
# Revision 1.1.2.8  1997/03/31  18:49:24  William_Athanasiou
# 	Don't allow pointer focus help area and buttonbox to expand
# 	[1997/03/31  18:30:56  William_Athanasiou]
# 
# Revision 1.1.2.7  1997/03/21  15:55:23  William_Athanasiou
# 	Added pointer focus help window
# 	[1997/03/21  15:41:35  William_Athanasiou]
# 
# Revision 1.1.2.6  1997/03/13  17:45:00  William_Athanasiou
# 	Correct expansion of window behavior and packing
# 	[1997/03/13  17:43:39  William_Athanasiou]
# 
# Revision 1.1.2.5  1997/03/13  15:58:20  William_Athanasiou
# 	Move <return> binding to creation of default button to ensure button exists
# 	[1997/03/13  15:57:53  William_Athanasiou]
# 
# Revision 1.1.2.4  1997/02/24  19:17:22  William_Athanasiou
# 	Added infomsg class; and used dialogshell for suit windows
# 	[1997/02/24  19:10:36  William_Athanasiou]
# 
# $EndLog$
# 
# @(#)$RCSfile: dialogshell.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:41 $
# 
# _UIT_Dialogshell
# ----------------------------------------------------------------------
# This class is implements a dialog shell which is a top level widget
# composed of a button box, separator, and child site area.  The class
# also has methods to control button construction.
#    
# ----------------------------------------------------------------------
#  AUTHOR: Mark L. Ulferts               EMAIL: mulferts@spd.dsccc.com
#
#  @(#) $Id: dialogshell.tcl,v 1.1.1.1 2003/01/23 18:34:41 ajay Exp $
# ----------------------------------------------------------------------
#            Copyright (c) 1995 DSC Technologies Corporation
# ======================================================================
# Permission to use, copy, modify, distribute and license this software 
# and its documentation for any purpose, and without fee or written 
# agreement with DSC, is hereby granted, provided that the above copyright 
# notice appears in all copies and that both the copyright notice and 
# warranty disclaimer below appear in supporting documentation, and that 
# the names of DSC Technologies Corporation or DSC Communications 
# Corporation not be used in advertising or publicity pertaining to the 
# software without specific, written prior permission.
# 
# DSC DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING 
# ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, AND NON-
# INFRINGEMENT. THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, AND THE
# AUTHORS AND DISTRIBUTORS HAVE NO OBLIGATION TO PROVIDE MAINTENANCE, 
# SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS. IN NO EVENT SHALL 
# DSC BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR 
# ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, 
# WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION,
# ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS 
# SOFTWARE.
# ======================================================================

#
# Default resources,
#
option add *Dialogshell.thickness 3 widgetDefault
option add *Dialogshell.buttonBoxPos s widgetDefault
option add *Dialogshell.resize yes widgetDefault
option add *Dialogshell.separator on widgetDefault
option add *Dialogshell.padX 10 widgetDefault
option add *Dialogshell.padY 10 widgetDefault

#
# Usual options.
#
#itk::usual _UIT_Dialogshell {
#    keep -background -cursor -foreground  
#}

# ------------------------------------------------------------------
#                            DIALOGSHELL
# ------------------------------------------------------------------
Class _UIT_Dialogshell -superclass _UIT_Toplevel

# ------------------------------------------------------------------
#                        CONSTRUCTOR
# ------------------------------------------------------------------
_UIT_Dialogshell instproc init {args} {
   $self _define -thickness 3 Thickness _thickness
   $self _define -buttonboxpos s Position _buttonBoxPos
   $self _define -separator on Separator _separator
   $self _define -busy 0 Busy _busy
   $self _define -title "Dialog" Title _title
   $self _define -padx 5 Pad _padX
   $self _define -pady 5 Pad _padY
   
   $self set _result {}     ;# Resultant value for modal activation.
   $self set _busied {}     ;# List of busied top level widgets.
   
   _UIT_Dialogshell instvar grabstack
   if ![info exists grabstack] {
      set grabstack {}
      label .dialogShellHoldTheFocus
   }

   $self next
   $self instvar _Wdgt _Opt _occluded
   set _occluded 0

   # _UIT_Maintain a withdrawn state until activated.
   #
   wm withdraw $_Wdgt(hull)
   
   set _Wdgt(dschildsite) [frame $_Wdgt(interior).dschildsite]
   $self _keep $_Wdgt(dschildsite) -background -cursor
   pack $_Wdgt(dschildsite) -fill both -expand 1
   
   set _Wdgt(separator) [frame $_Wdgt(interior).separator]
   $self _keep $_Wdgt(separator) -background -cursor
   pack $_Wdgt(separator) -padx 5 -expand 0 -fill x
   
   set _Wdgt(helpwin) [text $_Wdgt(separator).txt -height 2 -width 20 \
	 -wrap word -state disabled -takefocus 0 -relief ridge]
   $self _keep $_Wdgt(helpwin) -background -cursor
   pack $_Wdgt(helpwin) -fill x -expand 0
   
   set _Wdgt(bbox) [_UIT_Buttonbox $_Wdgt(interior).bbox]
   $self _keep $_Wdgt(bbox) -background -cursor -foreground
   $self _rename $_Wdgt(bbox) -padx -buttonboxpadx
   $self _rename $_Wdgt(bbox) -pady -buttonboxpady
   pack $_Wdgt(bbox) -expand 0
   
   #
   # Set the interior variable to be the childsite for derived 
   # classes.
   #
   set _Wdgt(interior) $_Wdgt(dschildsite)
   
   #
   # Bind the window manager delete protocol to deactivation of the 
   # widget.  This can be overridden by the user via the execution 
   # of a similar command outside the class.
   #
   wm protocol $_Wdgt(hull) WM_DELETE_WINDOW "$self deactivate"
   
   #
   # Explicitly handle configs that may have been ignored earlier.
   #
   if {![string compare _UIT_Dialogshell [$self info class]]} {
      $self configure -thickness 3 -buttonboxpos s \
	    -separator on -padx 5 -pady 5

      eval {$self configure} $args
   }
}

#
# Provide a lowercased access method for the _UIT_Dialogshell class.
# 
proc dialogshell {pathName args} {
    uplevel _UIT_Dialogshell $pathName $args
}


# ------------------------------------------------------------------
#                             OPTIONS
# ------------------------------------------------------------------

# ------------------------------------------------------------------
# OPTION: -thickness
#
# Specifies the thickness of the separator.  It sets the width and
# height of the separator to the thickness value and the borderwidth
# to half the thickness.
# ------------------------------------------------------------------
_UIT_Dialogshell instproc _thickness {val} {
   $self instvar _Wdgt _Opt
   return
   $_Wdgt(separator) config -height $_Opt(-thickness)
   $_Wdgt(separator) config -width $_Opt(-thickness)
   $_Wdgt(separator) config \
	 -borderwidth [expr $_Opt(-thickness) / 2]
}

# ------------------------------------------------------------------
# OPTION: -buttonboxpos
#
# Specifies the position of the button box relative to the child site.
# The separator appears between the child site and button box.
# ------------------------------------------------------------------
_UIT_Dialogshell instproc _buttonBoxPos {val} {
   $self instvar _Wdgt _Opt

   switch $_Opt(-buttonboxpos) {
      n {
	 pack config $_Wdgt(dschildsite) -side top
	 pack config $_Wdgt(separator) -side top \
	       -before $_Wdgt(dschildsite) -fill x
	 $_Wdgt(bbox) configure -orient horizontal
	 pack config $_Wdgt(bbox) -side top \
	       -before $_Wdgt(separator) -fill x 
      }
      s {
	 pack config $_Wdgt(dschildsite) -side top
	 pack config $_Wdgt(separator) -side top \
	       -after $_Wdgt(dschildsite) -fill x
	 $_Wdgt(bbox) configure -orient horizontal
	 pack config $_Wdgt(bbox) -side top \
	       -after $_Wdgt(separator) -fill x 
      }
      w {
	 pack config $_Wdgt(dschildsite) -side left
	 pack config $_Wdgt(separator) -side left \
		    -before $_Wdgt(dschildsite) -fill y
	 $_Wdgt(bbox) configure -orient vertical
	 pack config $_Wdgt(bbox) -side left \
	       -before $_Wdgt(separator) -fill y
      }
      e {
	 pack config $_Wdgt(dschildsite) -side left
	 pack config $_Wdgt(separator) -side left \
	       -after $_Wdgt(dschildsite) -fill y
	 $_Wdgt(bbox) configure -orient vertical
	 pack config $_Wdgt(bbox) -side left \
	       -after $_Wdgt(separator) -fill y
      }
      default {
	 error "bad buttonboxpos option\
	       \"$_Opt(-buttonboxpos)\": should be n,\
	       s, e, or w"
      }
   }
}

# ------------------------------------------------------------------
# OPTION: -separator 
#
# Boolean option indicating wheather to display the separator.
# ------------------------------------------------------------------
_UIT_Dialogshell instproc _separator {val} {
   $self instvar _Wdgt _Opt
   
   if {[cequal $_Opt(-separator) "on"]} {
      $_Wdgt(separator) configure -relief flat
      pack $_Wdgt(helpwin) -fill x -expand 0
   } else {
      $_Wdgt(separator) configure -relief sunken
      pack forget $_Wdgt(helpwin)
   }
}

# ------------------------------------------------------------------
# OPTION: -title
#
# Specify the window title.
# ------------------------------------------------------------------
_UIT_Dialogshell instproc _title {val} {
   $self instvar _Wdgt _Opt
   
   wm title $_Wdgt(hull) $_Opt(-title)
}

# ------------------------------------------------------------------
# OPTION: -padx
#
# Specifies a padding distance for the childsite in the X-direction.
# ------------------------------------------------------------------
_UIT_Dialogshell instproc _padX {val} {
   $self instvar _Wdgt _Opt
   
   pack config $_Wdgt(dschildsite) -padx $_Opt(-padx)
}

# ------------------------------------------------------------------
# OPTION: -pady
#
# Specifies a padding distance for the childsite in the Y-direction.
# ------------------------------------------------------------------
_UIT_Dialogshell instproc _padY {val} {
   $self instvar _Wdgt _Opt
   
   pack config $_Wdgt(dschildsite) -pady $_Opt(-pady)
}

# ------------------------------------------------------------------
# OPTION: -busy
#
# Specifies whether input should be allowed to the window.
# ------------------------------------------------------------------

_UIT_Dialogshell instproc _busy {val} {
   if {$val} {
      $self _mkBusy
   } else {
      $self _mkNotBusy
   }
}

_UIT_Dialogshell instproc _mkBusy {} {
   $self instvar _Wdgt _prev_focus
   if [lempty [busy isbusy $_Wdgt(hull)]] {
      busy $_Wdgt(hull)
      set _prev_focus [focus]
      update
      focus .dialogShellHoldTheFocus
   }
}   

_UIT_Dialogshell instproc _mkNotBusy {} {
   $self instvar _Wdgt _prev_focus _occluded
   
   if $_occluded {return}
   if [lempty [busy isbusy $_Wdgt(hull)]] {return}
   
   busy release $_Wdgt(hull)
   update
   if [cequal [focus] ".dialogShellHoldTheFocus"] {
      if ![lempty $_prev_focus] {
	 focus $_prev_focus
      } else {
	 focus [tk_focusNext $_Wdgt(hull)]
      }
   }
}

# ------------------------------------------------------------------
#                            METHODS
# ------------------------------------------------------------------

# ------------------------------------------------------------------
# METHOD: childsite
#
# Return the pathname of the user accessible area.
# ------------------------------------------------------------------
_UIT_Dialogshell instproc childsite {} {
   return [$self set _Wdgt(dschildsite)]
}

# ------------------------------------------------------------------
# METHOD: activate
#
# Display the dialog and wait based on the modality.  For application
# and global modal activations, perform a grab operation, and wait
# for the result.  The result may be returned via an argument to the
# "deactivate" method.
# ------------------------------------------------------------------
_UIT_Dialogshell instproc activate {} {
   $self instvar _Wdgt _Opt _result _prev_focus
   _UIT_Dialogshell instvar grabstack
   
   if {[winfo ismapped $_Wdgt(hull)]} {
      return
   }
   
   set _UIT_DialogshellWait($self) 0
   wm deiconify $_Wdgt(hull)
   # This doesn't seem necessary and it causes a serious
   #   problem in TK8.2 where it prevents windows from taking focus.
   #   Removed to fix qar 78595
   #   tkwait visibility $_Wdgt(hull)
   
   if ![lempty $grabstack] {
      set w [lindex $grabstack end]
      $w set _occluded 1
      $w _mkBusy
   } 
   grab $_Wdgt(hull)
   lappend grabstack $self
   update
   focus [tk_focusNext $_Wdgt(hull)]
}

# ------------------------------------------------------------------
# METHOD: deactivate
#
# Deactivate the display of the dialog.  The method takes an optional
# argument to passed to the "activate" method which returns the value.
# This is only effective for application and global modal dialogs.
# ------------------------------------------------------------------
_UIT_Dialogshell instproc deactivate {args} {
   $self instvar _Wdgt _Opt
   _UIT_Dialogshell instvar grabstack  
    
   if {! [winfo ismapped $_Wdgt(hull)]} {
      return
   }
   
   grab release $_Wdgt(hull)
   wm withdraw $_Wdgt(hull)
   if ![lempty [set grabstack [lreplace $grabstack end end]]] {
      # must un-occlude a window
      set win [lindex $grabstack end]
      $win set _occluded 0
      if ![$win cget -busy] {
	 $win _mkNotBusy
      }
   }
   return
}

# ------------------------------------------------------------------
# METHOD: center
#
# Centers the dialog with respect to another widget or the screen
# as a whole.
# ------------------------------------------------------------------
_UIT_Dialogshell instproc center {{widget {}}} {
   $self instvar _Wdgt _Opt
   
   update idletasks
   
   set hull $_Wdgt(hull)
   set w [winfo reqwidth $hull]
   set h [winfo reqheight $hull]
   set sh [winfo screenheight $hull]     ;# display screen's height/width
   set sw [winfo screenwidth $hull]
   
   #
   # User can request it centered with respect to root by passing in '{}'
   #
   if { $widget == "" } {
      set reqX [expr {($sw-$w)/2}]
      set reqY [expr {($sh-$h)/2}]
   } else {
      set wfudge 5      ;# wm width fudge factor
      set hfudge 20     ;# wm height fudge factor
      set widgetW [winfo width $widget]
      set widgetH [winfo height $widget]
      set reqX [expr [winfo rootx $widget]+($widgetW-($widgetW/2))-($w/2)]
      set reqY [expr [winfo rooty $widget]+($widgetH-($widgetH/2))-($h/2)]
      
      #
      # Adjust for errors - if too long or too tall
      #
      if { [expr $reqX+$w+$wfudge] > $sw } { set reqX [expr $sw-$w-$wfudge] }
      if { $reqX < $wfudge } { set reqX $wfudge }
      if { [expr $reqY+$h+$hfudge] > $sh } { set reqY [expr $sh-$h-$hfudge] }
      if { $reqY < $hfudge } { set reqY $hfudge }
   } 
   
   wm geometry $hull +$reqX+$reqY
}

# ------------------------------------------------------------------
# METHOD: index index
#
# Thin wrapper of _UIT_Buttonbox's index method.
# ------------------------------------------------------------------
_UIT_Dialogshell instproc index {args} {
   uplevel [$self set _Wdgt(bbox)] index $args
}

# ------------------------------------------------------------------
# METHOD: add tag ?option value ...?
#
# Thin wrapper of _UIT_Buttonbox's add method.
# ------------------------------------------------------------------
_UIT_Dialogshell instproc add {args} {
   uplevel [$self set _Wdgt(bbox)] add $args
}

# ------------------------------------------------------------------
# METHOD: addTkButton tag ?option value ...?
#
# Thin wrapper of _UIT_Buttonbox's addTkButton method.
# ------------------------------------------------------------------
_UIT_Dialogshell instproc addTkButton {args} {
   uplevel [$self set _Wdgt(bbox)] addTkButton $args
}

# ------------------------------------------------------------------
# METHOD: insert index tag ?option value ...?
#
# Thin wrapper of _UIT_Buttonbox's insert method.
# ------------------------------------------------------------------
_UIT_Dialogshell instproc insert {args} {
   uplevel [$self set _Wdgt(bbox)] insert $args
}

# ------------------------------------------------------------------
# METHOD: delete tag
#
# Thin wrapper of _UIT_Buttonbox's delete method.
# ------------------------------------------------------------------
_UIT_Dialogshell instproc delete {args} {
   uplevel [$self set _Wdgt(bbox)] delete $args
}

# ------------------------------------------------------------------
# METHOD: hide index
#
# Thin wrapper of _UIT_Buttonbox's hide method.
# ------------------------------------------------------------------
_UIT_Dialogshell instproc hide {args} {
   uplevel [$self set _Wdgt(bbox)] hide $args
}

# ------------------------------------------------------------------
# METHOD: show index
#
# Thin wrapper of _UIT_Buttonbox's show method.
# ------------------------------------------------------------------
_UIT_Dialogshell instproc show {args} {
    uplevel [$self set _Wdgt(bbox)] show $args
}

# ------------------------------------------------------------------
# METHOD: default index
#
# Thin wrapper of _UIT_Buttonbox's default method.
# ------------------------------------------------------------------
_UIT_Dialogshell instproc default {args} {
   $self instvar _Wdgt
   uplevel $_Wdgt(bbox) default $args

   #
   # Only set up binding for Hull if a default button exits.
   #
   bind $_Wdgt(hull) <Return> "$self invoke"
}

# ------------------------------------------------------------------
# METHOD: invoke ?index?
#
# Thin wrapper of _UIT_Buttonbox's invoke method.
# ------------------------------------------------------------------
_UIT_Dialogshell instproc invoke {args} {
   uplevel [$self set _Wdgt(bbox)] invoke $args
}

# ------------------------------------------------------------------
# METHOD: buttonconfigure index ?option? ?value option value ...?
#
# Thin wrapper of _UIT_Buttonbox's buttonconfigure method.
# ------------------------------------------------------------------
_UIT_Dialogshell instproc buttonconfigure {args} {
   uplevel [$self set _Wdgt(bbox)] buttonconfigure $args
}

_UIT_Dialogshell instproc updateHelp {str} {
   $self instvar _Wdgt
   $_Wdgt(helpwin) configure -state normal
   $_Wdgt(helpwin) delete 0.0 end
   $_Wdgt(helpwin) insert 0.0 $str
   $_Wdgt(helpwin) configure -state disabled
}
