# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: labeledwidget.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:41  ajay
# Initial submit to CVS.
#
#
# $EndLog$
# 
# @(#)$RCSfile: labeledwidget.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:41 $
# 
#
# _UIT_Labeledwidget
# ----------------------------------------------------------------------
# Implements a labeled widget which contains a label and child site.
# The child site is a frame which can filled with any widget via a 
# derived class or though the use of the childSite method.  This class
# was designed to be a general purpose base class for supporting the 
# combination of label widget and a childsite.  The options include the
# ability to position the label around the childsite widget, modify the
# font and margin, and control the display of the label.  
#
# ----------------------------------------------------------------------
#  AUTHOR: Mark L. Ulferts               EMAIL: mulferts@spd.dsccc.com
#
#  @(#) $Id: labeledwidget.tcl,v 1.1.1.1 2003/01/23 18:34:41 ajay Exp $
# ----------------------------------------------------------------------
#            Copyright (c) 1995 DSC Technologies Corporation
# ======================================================================
# Permission to use, copy, modify, distribute and license this software 
# and its documentation for any purpose, and without fee or written 
# agreement with DSC, is hereby granted, provided that the above copyright 
# notice appears in all copies and that both the copyright notice and 
# warranty disclaimer below appear in supporting documentation, and that 
# the names of DSC Technologies Corporation or DSC Communications 
# Corporation not be used in advertising or publicity pertaining to the 
# software without specific, written prior permission.
# 
# DSC DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING 
# ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, AND NON-
# INFRINGEMENT. THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, AND THE
# AUTHORS AND DISTRIBUTORS HAVE NO OBLIGATION TO PROVIDE MAINTENANCE, 
# SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS. IN NO EVENT SHALL 
# DSC BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR 
# ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, 
# WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION,
# ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS 
# SOFTWARE.
# ======================================================================

#
# Default resources.
#
#option add *Labeledwidget.labelMargin 1 widgetDefault

#
# Usual options.
#
#itk::usual _UIT_Labeledwidget {
#    keep -background -cursor -foreground -labelfont
#}

# ------------------------------------------------------------------
#                            LABELEDWIDGET
# ------------------------------------------------------------------
Class _UIT_Labeledwidget -superclass _UIT_Widget

# ------------------------------------------------------------------
#                        CONSTRUCTOR
# ------------------------------------------------------------------

_UIT_Labeledwidget instproc init {args} {

   $self _define -labelpos w Position _labelPos
   $self _define -labelmargin 1 Margin _labelMargin
   $self _define -labeltext {} Text _labelText
   $self _define -labelvariable {} Variable _labelVariable
   $self _define -labelbitmap {} Bitmap _labelBitmap
   $self _define -labelimage {} Image _labelImage
   $self _define -labelstate {} Value _labelState
   
   $self set _reposition ""

   # jump to init of superclass
   #
   #   eval {$self next} $args 
   #        (WRA this don't work yet _UIT_Widget.tcl is broke)
   eval {$self next}
   $self instvar _Wdgt _Opt

   # 
   # Create the outermost frame to maintain geometry.
   #
   set _Wdgt(shell) $_Wdgt(interior)
    
   #
   # Create a frame for the childsite widget.
   #

   set _Wdgt(lwchildsite) [frame $_Wdgt(shell).lwchildsite]
   $self _keep $_Wdgt(lwchildsite) -background -cursor

   pack $_Wdgt(lwchildsite) -fill both -expand yes
   
   set _Wdgt(interior) $_Wdgt(lwchildsite)
    
   #
   # Create label.
   #

   set _Wdgt(label) [label $_Wdgt(shell).label]
   $self _keep $_Wdgt(label) -background -foreground -cursor
   $self _rename $_Wdgt(label) -font -labelfont
   $self _rename $_Wdgt(label) -justify -labeljustify

   #
   # Create margin between label and the child site.
   #
   
   set _Wdgt(labmargin) [frame $_Wdgt(shell).labmargin]
   $self _keep $_Wdgt(labmargin) -background -cursor

   #
   # Explicitly handle configs that may have been ignored earlier.
   #
   if {![string compare _UIT_Labeledwidget [$self info class]]} {
      eval {$self configure} $args
   }
   # 
   # When idle, position the label.
   #
   $self _positionLabel
}
    
#
# Provide a lowercased access method for the _UIT_Labeledwidget class.
# 
proc labeledwidget {pathName args} {
   uplevel _UIT_Labeledwidget $pathName $args
}


# ------------------------------------------------------------------
#                           DESTURCTOR
# ------------------------------------------------------------------
_UIT_Labeledwidget instproc destroy {} {
   $self instvar _reposition
   if {$_reposition != ""} {
      after cancel $_reposition
   }
   $self next
}

# ------------------------------------------------------------------
#                             OPTIONS
# ------------------------------------------------------------------

# ------------------------------------------------------------------
# OPTION: -state
#
# Set the state of the label 
# ------------------------------------------------------------------

_UIT_Labeledwidget instproc _labelState {n} {
   global _UIT_Foreground
   if ![info exists _UIT_Foreground] {
      button .b_UIT_B
      set _UIT_Foreground(normal) [.b_UIT_B cget -foreground]
      set _UIT_Foreground(disabled) [.b_UIT_B cget -disabledforeground]
      destroy .b_UIT_B
   }
   if [info exists _UIT_Foreground($n)] {
      [$self set _Wdgt(label)] configure -foreground $_UIT_Foreground($n)
   }
}

# ------------------------------------------------------------------
# OPTION: -labelpos
#
# Set the position of the label on the labeled widget.  The margin
# between the label and childsite comes along for the ride.
# ------------------------------------------------------------------
_UIT_Labeledwidget instproc _labelPos {n} {
   $self set _Opt(-labelpos) $n
   
   $self _positionLabel
}

# ------------------------------------------------------------------
# OPTION: -labelmargin
#
# Specifies the distance between the widget and label.
# ------------------------------------------------------------------
_UIT_Labeledwidget instproc _labelMargin {n} {
   $self set _Opt(-labelmargin) $n; $self _positionLabel
}

# ------------------------------------------------------------------
# OPTION: -labeltext
#
# Specifies the label text.
# ------------------------------------------------------------------
_UIT_Labeledwidget instproc _labelText {val} {
   $self set _Opt(-labeltext) $val
   [$self set _Wdgt(label)] configure -text $val; $self _positionLabel
}

# ------------------------------------------------------------------
# OPTION: -labelvariable
#
# Specifies the label text variable.
# ------------------------------------------------------------------
_UIT_Labeledwidget instproc _labelVariable {val} {
   [$self set _Wdgt(label)] configure -textvariable $val; $self _positionLabel
}

# ------------------------------------------------------------------
# OPTION: -labelbitmap
#
# Specifies the label bitmap.
# ------------------------------------------------------------------
_UIT_Labeledwidget instproc _labelBitmap {val} {
   [$self set _Wdgt(label)] configure -bitmap $val; $self _positionLabel
}

# ------------------------------------------------------------------
# OPTION: -labelimage
#
# Specifies the label image.
# ------------------------------------------------------------------
_UIT_Labeledwidget instproc _labelImage {val} {
   [$self set _Wdgt(label)] configure -image $val; $self _positionLabel
}

# ------------------------------------------------------------------
#                            METHODS
# ------------------------------------------------------------------

# ------------------------------------------------------------------
# METHOD: childsite
#
# Returns the path name of the child site widget.
# ------------------------------------------------------------------
_UIT_Labeledwidget instproc childsite {} {
    return [$self set _Wdgt(lwchildsite)]
}

# ------------------------------------------------------------------
# PROCEDURE: alignlabels widget ?widget ...?
#
# The alignlabels procedure takes a list of widgets derived from
# the _UIT_Labeledwidget class and adjusts the label margin to align 
# the labels.
# ------------------------------------------------------------------
_UIT_Labeledwidget instproc alignlabels {args} {
   update
   set maxLabelWidth 0
   
   #
   # Verify that all the widgets are of type _UIT_Labeledwidget and 
   # determine the size of the maximum length label string.
   #
   foreach iwid $args {
      
      set wclass [$iwid info class]
      set hclass [$wclass info heritage _UIT_Labeledwidget]
      if {![cequal _UIT_Labeledwidget $wclass] && [cequal {} $hclass]} {
	 error "$iwid is not a \"Labeledwidget\""
      }
      
      set csWidth [winfo reqwidth $iwid.lwchildsite]
      set shellWidth [winfo reqwidth $iwid]

      if {[expr $shellWidth - $csWidth] > $maxLabelWidth} {
	 set maxLabelWidth [expr $shellWidth - $csWidth]
      }
   }

   #
   # Adjust the margins for the labels such that the child sites and
   # labels line up.
   #
   foreach iwid $args {
      set csWidth [winfo reqwidth $iwid.lwchildsite]
      set shellWidth [winfo reqwidth $iwid]
      
      set labelSize [expr $shellWidth - $csWidth]
      
      if {$maxLabelWidth > $labelSize} {
	 set dist [expr $maxLabelWidth - \
	       ($labelSize - [winfo reqwidth $iwid.labmargin])]

	 $iwid configure -labelmargin $dist
      }
   }	
}

# ------------------------------------------------------------------
# PROTECTED METHOD: _positionLabel ?when?
#
# Packs the label and label margin.  If "when" is "now", the
# change is applied immediately.  If it is "later" or it is not
# specified, then the change is applied later, when the application
# is idle.
# ------------------------------------------------------------------
_UIT_Labeledwidget instproc _positionLabel {{when later}} {
   $self instvar _Wdgt _Opt _reposition

   if {$when == "later"} {
      if {$_reposition == ""} {
	 set _reposition [after idle "$self _positionLabel now"]
      }
      return
   } elseif {$when != "now"} {
      error "bad option \"$when\": should be now or later"
   }

   if {$_Opt(-labeltext) != {} || $_Opt(-labelbitmap) != {} \
	 || $_Opt(-labelimage) != {}} {

      switch $_Opt(-labelpos) {
	 nw {
	    pack configure $_Wdgt(lwchildsite) -side top
	    
	    $_Wdgt(labmargin) configure -width 1 -height \
		  [winfo pixels $_Wdgt(labmargin) \
		                $_Opt(-labelmargin)]
	    pack configure $_Wdgt(labmargin) -side top \
		  -before $_Wdgt(lwchildsite)
	    pack configure $_Wdgt(label) -anchor w \
		  -side top -before $_Wdgt(labmargin)
	 }
	    
	 n {
	    pack configure $_Wdgt(lwchildsite) -side top
	    
	    $_Wdgt(labmargin) configure -width 1 -height \
		  [winfo pixels $_Wdgt(labmargin) \
		                $_Opt(-labelmargin)]
	    pack configure $_Wdgt(labmargin) -side top \
		  -before $_Wdgt(lwchildsite)
	    pack configure $_Wdgt(label) -anchor center \
		  -before $_Wdgt(labmargin) -side top
	 }
	    
	 ne {
	    pack configure $_Wdgt(lwchildsite) -side top
	    
	    $_Wdgt(labmargin) configure -width 1 -height \
		  [winfo pixels $_Wdgt(labmargin) \
		                $_Opt(-labelmargin)]
	    pack configure $_Wdgt(labmargin) -side top \
			-before $_Wdgt(lwchildsite)
	    pack configure $_Wdgt(label) -anchor e \
		  -side top -before $_Wdgt(labmargin)
	 }
	    
	 e {
	    pack configure $_Wdgt(lwchildsite) -side right
	    
	    $_Wdgt(labmargin) configure -height 1 -width \
		  [winfo pixels $_Wdgt(labmargin) \
		  $_Opt(-labelmargin)]
	    pack configure $_Wdgt(labmargin) \
		  -side right -before $_Wdgt(lwchildsite)
	    pack configure $_Wdgt(label) -anchor center \
		  -side right -before $_Wdgt(labmargin)
	 }
	    
	 se {
	    pack configure $_Wdgt(lwchildsite) -side top
	    
	    $_Wdgt(labmargin) configure -width 1 -height \
		  [winfo pixels $_Wdgt(labmargin) \
		  $_Opt(-labelmargin)]
	    pack configure $_Wdgt(labmargin) \
		  -side top -after $_Wdgt(lwchildsite)
	    pack configure $_Wdgt(label) -anchor e \
		  -side bottom -after $_Wdgt(labmargin)
	 }
	 
	 s {
	    pack configure $_Wdgt(lwchildsite) -side top
	    
	    $_Wdgt(labmargin) configure -width 1 -height \
		  [winfo pixels $_Wdgt(labmargin) \
		  $_Opt(-labelmargin)]
	    pack configure $_Wdgt(labmargin) \
		  -side top -after $_Wdgt(lwchildsite)
	    pack configure $_Wdgt(label) -anchor center \
		  -side bottom -after $_Wdgt(labmargin)
	 }
	    
	 sw {
	    pack configure $_Wdgt(lwchildsite) -side top
	    
	    $_Wdgt(labmargin) configure -width 1 -height \
		  [winfo pixels $_Wdgt(labmargin) \
		  $_Opt(-labelmargin)]
	    pack configure $_Wdgt(labmargin) \
		  -side top -after $_Wdgt(lwchildsite)
	    pack configure $_Wdgt(label) -anchor w \
		  -side bottom -after $_Wdgt(labmargin)
	 }
	    
	 w {
	    pack configure $_Wdgt(lwchildsite) -side right
	    
	    $_Wdgt(labmargin) configure -height 1 -width \
		  [winfo pixels $_Wdgt(labmargin) \
		  $_Opt(-labelmargin)]
	    pack configure $_Wdgt(labmargin) \
		  -side left -before $_Wdgt(lwchildsite)
	    pack configure $_Wdgt(label) -anchor center \
		  -side left -before $_Wdgt(labmargin)
	 }
      }

      #
      # Else, neither the  label text, bitmap, or image have a value, so
      # un pack them the label and margin.
      #
   } else {
      pack forget $_Wdgt(label)
      pack forget $_Wdgt(labmargin)
   }
   
   set _reposition ""
}
