#!/usr/bin/tclsh
# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: mcscrolledlist.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:41  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.6.1  2000/09/06  19:34:13  Peter_Wolfe
# 	Code drop for yankee bl2
#
# Revision 1.1.2.3  2000/06/19  15:14:59  Ramnath_Ravindran
# 	Adjusted _headings proc to accomodate the resize proc in listgui.tcl
#
# Revision 1.1.2.2  2000/01/28  20:52:07  Richard_Taft
# 	Track selection properly by adding "after idle" to singleclick proc
#
# Revision 1.1.2.1  2000/01/14  16:05:48  Richard_Taft
# 	New file to implement multi-column list widget
#
# $EndLog$
# 
# @(#)$RCSfile: mcscrolledlist.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:41 $
# 
catch {namespace import mclistbox::*}

#
# Default resources.
#
option add *Mcscrolledlistbox.borderWidth 2 widgetDefault
option add *Mcscrolledlistbox.relief sunken widgetDefault
option add *Mcscrolledlistbox.scrollMargin 1 widgetDefault
option add *Mcscrolledlistbox.vscrollMode static widgetDefault
option add *Mcscrolledlistbox.hscrollMode static widgetDefault
option add *Mcscrolledlistbox.selectmode browse widgetDefault
option add *Mcscrolledlistbox.width 0 widgetDefault
option add *Mcscrolledlistbox.height 0 widgetDefault
option add *Mcscrolledlistbox.visibleItems 20x10 widgetDefault
option add *Mcscrolledlistbox.labelPos n widgetDefault
option add *Mcscrolledlistbox.headings {} widgetDefault

Class _UIT_Mcscrolledlistbox -superclass _UIT_Labeledwidget

_UIT_Mcscrolledlistbox instproc init {args} {
   $self _define -scrollmargin 1 Margin _scrollMargin
   $self _define -sbwidth 10 Width _sbWidth
   $self _define -vscrollmode static ScrollMode _vscrollMode
   $self _define -hscrollmode static ScrollMode _hscrollMode
   $self _define -items {} Items _items
   $self _define -dblclickcommand {} Command _dblClickCommand
   $self _define -sortcommand {} Command _sortCommand
   $self _define -selectioncommand {} Command _selectionCommand
   $self _define -width 0 Width _width
   $self _define -height 0 Height _height
   $self _define -visibleitems 20x10 VisibleItems _visibleItems
   $self _define -headings {} Headings _headings

   $self set _vmode off              ;# Vertical scroll mode
   $self set _hmode off              ;# Vertical scroll mode
   $self set _selection {}           ;# Last selection indcies.

   $self set _initialized 0            ;# Initialization flag.
   
   eval {$self next} $args
   $self instvar _Wdgt _Opt

   $_Wdgt(hullcmd) configure -borderwidth 0
    
   #
   # Create some frames to hold both the top and bottom halfs of the 
   # widget.  The top will contain both the list and vertical scroll 
   # bar.  The bottom houses the horizontal scrollbar and some filler.
   #
   set _Wdgt(listframe) [frame $_Wdgt(interior).listframe]
   $self _keep $_Wdgt(listframe) -background -cursor

   pack $_Wdgt(listframe) -fill both -expand yes 
    
   $self set _Wdgt(bottomframe) [frame $_Wdgt(listframe).botttomframe]
   $self _keep $_Wdgt(listframe) -background -cursor

   pack $_Wdgt(bottomframe) -fill x -side bottom
    
   set _Wdgt(hmargin) [frame $_Wdgt(listframe).hmargin]
   $self _keep $_Wdgt(hmargin) -background -cursor
   
   pack $_Wdgt(hmargin) -side bottom
    
   set _Wdgt(topframe) [frame $_Wdgt(listframe).topframe]
   $self _keep $_Wdgt(topframe) -background -cursor
   
   pack $_Wdgt(topframe) -fill both -expand yes
    
   # 
   # Create the listbox.
   #
   set _Wdgt(listbox) [::mclistbox::mclistbox $_Wdgt(topframe).listbox \
	 -width 1 -height 1 \
	 -xscrollcommand "$self _scrollList $_Wdgt(bottomframe).horizsb" \
	 -yscrollcommand "$self _scrollList $_Wdgt(topframe).vertsb"]

   $self _keep $_Wdgt(listbox) -borderwidth -cursor -exportselection \
	 -foreground -highlightcolor \
	 -highlightthickness -relief -selectbackground \
	 -selectborderwidth -selectforeground -selectmode

   $self _rename $_Wdgt(listbox) -font -textfont 
   $self _rename $_Wdgt(listbox) -background -textbackground 
   $self _rename $_Wdgt(listbox) -highlightbackground -background 

   bind $_Wdgt(listbox) <Double-1> "$self _dblclick"
   bind $_Wdgt(listbox) <Button-1> "$self _singleclick"

   #
   # Create the vertical margin
   #
   set _Wdgt(vmargin) [frame $_Wdgt(topframe).vmargin -width 0]
   $self _keep $_Wdgt(vmargin) -background -cursor
   
   # 
   # Create the vertical scroll bar.
   #
   set _Wdgt(vertsb) [scrollbar $_Wdgt(topframe).vertsb \
	 -orient vertical -command "$_Wdgt(listbox) yview"]
   $self _keep $_Wdgt(vertsb) -activebackground -activerelief -background \
	 -borderwidth -cursor -elementborderwidth \
	 -highlightcolor -jump -highlightthickness -relief \
	 -repeatdelay -repeatinterval -troughcolor
   $self _rename $_Wdgt(vertsb) -highlightbackground -background
   
   pack $_Wdgt(vertsb) -side right -fill y
   pack $_Wdgt(vmargin) -side right
   pack $_Wdgt(listbox) -fill both -expand yes -side left
    
   #
   # Next the horizontal scrollbar.
   #
   set _Wdgt(horizsb) [scrollbar $_Wdgt(bottomframe).horizsb \
	 -orient horizontal -command "$_Wdgt(listbox) xview"]
   $self _keep $_Wdgt(horizsb) -activebackground -activerelief -background \
	 -borderwidth -cursor -elementborderwidth \
	 -highlightcolor -jump -highlightthickness -relief \
	 -repeatdelay -repeatinterval -troughcolor
   $self _rename $_Wdgt(horizsb) -highlightbackground -background

   pack $_Wdgt(horizsb) -side left -fill x -expand yes
   
   #
   # Create the filler frame and compute its width.
   #
   $self set _Wdgt(filler) [frame $_Wdgt(bottomframe).filler \
	 -width [$self _fillerWidth]]
   $self _keep $_Wdgt(filler) -background -cursor

   pack $_Wdgt(filler) -side right 
    
   # 
   # Create a set of bindings for monitoring the selection.
   #
   
   bind SLBSelect$self <Control-Key-backslash> "$self _makeSelection"
   bind SLBSelect$self <Control-Key-slash> "$self _makeSelection"
   bind SLBSelect$self <Key-Escape> "$self _makeSelection"
   bind SLBSelect$self <Shift-Key-Select> "$self _makeSelection"
   bind SLBSelect$self <Control-Shift-Key-space> "$self _makeSelection"
   bind SLBSelect$self <Key-Select> "$self _makeSelection"
   bind SLBSelect$self <Key-space> "$self _makeSelection"
   bind SLBSelect$self <Control-Shift-Key-End> "$self _makeSelection"
   bind SLBSelect$self <Control-Key-End> "$self _makeSelection"
   bind SLBSelect$self <Control-Shift-Key-Home> "$self _makeSelection"
   bind SLBSelect$self <Control-Key-Home> "$self _makeSelection"
   bind SLBSelect$self <Shift-Key-Down> "$self _makeSelection"
   bind SLBSelect$self <Shift-Key-Up> "$self _makeSelection"
   bind SLBSelect$self <Control-Button-1> "$self _makeSelection"
   bind SLBSelect$self <Shift-Button-1> "$self _makeSelection"
   bind SLBSelect$self <ButtonRelease-1> "$self _makeSelection"
   bind SLBSelect$self <Double-1> "$self _dblclick"
   bind SLBSelect$self <Button-1> "$self _singleclick"
   
   bindtags $_Wdgt(listbox) \
	 [linsert [bindtags $_Wdgt(listbox)] end SLBSelect$self]

   #
   # Explicitly handle configs that may have been ignored earlier.
   #
   if {![string compare _UIT_Mcscrolledlistbox [$self info class]]} {
      $self configure -borderwidth 2 -relief sunken -scrollmargin 1 \
	    -vscrollmode static -hscrollmode static -selectmode browse \
	    -width 0 -height 0 -visibleitems 20x10 -labelpos n \
	    -highlightthickness 2 -labeljustify left
      
      eval {$self configure} $args
   }
   
   $self set _initialized 1
   $self configure -scrollmargin $_Opt(-scrollmargin)
}

#
# Provide a lowercased access method for the _UIT_Mcscrolledlistbox class.
# 
proc mcscrolledlistbox {pathName args} {
   uplevel _UIT_Mcscrolledlistbox $pathName $args
}


_UIT_Mcscrolledlistbox instproc sortColumn {column} {
   $self instvar _Wdgt _Opt

    set data [$_Wdgt(listbox) get 0 end]
    set index [lsearch -exact [$_Wdgt(listbox) column names] $column]

    set result [lsort -index $index $data]

    $_Wdgt(listbox) delete 0 end

    eval $_Wdgt(listbox) insert end $result
}

# ------------------------------------------------------------------
#                             OPTIONS
# ------------------------------------------------------------------
_UIT_Mcscrolledlistbox instproc _headings {val} {
    $self instvar _initialized _Wdgt _Opt
    
    # val is a list whose elements are lists of the form:
    # {column name, column label, column width}
    # Note that none of this is optional.
    set _Opt(-headings) $val

    # the following code is specifically for the resize 
    # procedure implemented in the listgui.tcl file.  It
    # checks for an error returned by mclistbox.tcl which 
    # reports that the column name already exists.  If that
    # error occurs, it calls the configure proc directly
    foreach hlist $val {
	lassign $hlist name label width
	if [catch {$_Wdgt(listbox) column add $name -label \
		       $label -width $width} result] {
	    if {[cequal $result "column \"$name\" already exists"]} {
		$_Wdgt(listbox) column configure $name -width $width
	    }
	}
	$_Wdgt(listbox) label bind $name <ButtonPress-1> \
	    "$self _sort $name"
    }
}

# ------------------------------------------------------------------
# OPTION: -scrollmargin
#
# Set the distance between the scrollbars and the list box.
# ------------------------------------------------------------------
_UIT_Mcscrolledlistbox instproc _scrollMargin {val} {
   $self instvar _initialized _hmode _vmode _Wdgt _Opt
   
   if {$_initialized} {
      set _Opt(-scrollmargin) $val
      set pixels [winfo pixels $_Wdgt(hmargin) $val]
      
      if {$_hmode == "on"} {
	 $_Wdgt(hmargin) configure -width 1 -height $pixels
      }
      
      if {$_vmode == "on"} {
	 $_Wdgt(vmargin) configure -width $pixels -height 1
      }
      
      $_Wdgt(filler) configure -width [$self _fillerWidth] -height 1
   }
}

# ------------------------------------------------------------------
# OPTION: -sbwidth
#
# Set the width of the scrollbars.
# ------------------------------------------------------------------
_UIT_Mcscrolledlistbox instproc _sbWidth {val} {
   $self instvar _Wdgt _initialized _Opt
   
   if {$_initialized} {
      set _Opt(-sbwidth) $val
      $_Wdgt(vertsb) configure -width $_Opt(-sbwidth)
      $_Wdgt(horizsb) configure -width $_Opt(-sbwidth)
      
      update idletasks
      
      $_Wdgt(filler) configure -width [$self _fillerWidth] -height 1
   }
}

# ------------------------------------------------------------------
# OPTION: -vscrollmode
#
# Enable/disable display and mode of veritcal scrollbars.
# ------------------------------------------------------------------
_UIT_Mcscrolledlistbox instproc _vscrollMode {val} {
   $self instvar _Opt
   
   set _Opt(-vscrollmode) $val
   switch $_Opt(-vscrollmode) {
      static {
	 $self _vertScrollbarDisplay on
      }
      
      dynamic -
      none {
	 $self _vertScrollbarDisplay off
      }
      
      default {
	 error "bad vscrollmode option\
	       \"$_Opt(-vscrollmode)\": should be\
	       static, dynamic, or none"
      }
   }
}

# ------------------------------------------------------------------
# OPTION: -hscrollmode
#
# Enable/disable display and mode of horizontal scrollbars.
# ------------------------------------------------------------------
_UIT_Mcscrolledlistbox instproc _hscrollMode {val} {
   $self instvar _Opt
   
   switch [set _Opt(-hscrollmode) $val] {
      static {
	 $self _horizScrollbarDisplay on
      }
      
      dynamic -
      none {
	 $self _horizScrollbarDisplay off
      }
      
      default {
	 error "bad hscrollmode option\
	       \"$_Opt(-hscrollmode)\": should be\
	       static, dynamic, or none"
      }
   }
}

# ------------------------------------------------------------------
# OPTION: -items
#
# Set/get the current list of items in the listbox.
# ------------------------------------------------------------------
_UIT_Mcscrolledlistbox instproc _items {val} {
   $self instvar _Wdgt _Opt

   set index [$_Wdgt(listbox) nearest 0]

   $_Wdgt(listbox) delete 0 end

   eval {$_Wdgt(listbox) insert end} $val
#   foreach ent $_Opt(-items) {
#      $_Wdgt(listbox) insert end $ent
#   }
   
   if {$index < [$_Wdgt(listbox) size]} {
      $_Wdgt(listbox) yview $index
   }
}

# ------------------------------------------------------------------
# OPTION: -dblclickcommand
#
# Specify a command to be executed upon double click of a listbox 
# item.  
# ------------------------------------------------------------------
_UIT_Mcscrolledlistbox instproc _dblClickCommand {val} {
   $self set _Opt(-dblclickcommand) $val
}

# ------------------------------------------------------------------
# OPTION: -sortcommand
#
# Specify a command to be executed when the user clicks a
# column heading
# ------------------------------------------------------------------
_UIT_Mcscrolledlistbox instproc _sortCommand {val} {
   $self instvar _Opt _Wdgt
   set _Opt(-sortcommand) $val
}

# ------------------------------------------------------------------
# OPTION: -selectioncommand
#
# Specifies a command to be executed upon selection of a listbox 
# item.  The command will be called upon each selection regardless 
# of selection mode..
# ------------------------------------------------------------------
_UIT_Mcscrolledlistbox instproc _selectionCommand {val} {
   $self set _Opt(-selectioncommand) $val
}

# ------------------------------------------------------------------
# OPTION: -width
#
# Specifies the width of the scrolled list box as an entire unit.
# The value may be specified in any of the forms acceptable to 
# Tk_GetPixels.  Any additional space needed to display the other
# components such as labels, margins, and scrollbars force the listbox
# to be compressed.  A value of zero along with the same value for 
# the height causes the value given for the visibleitems option 
# to be applied which administers geometry constraints in a different
# manner.
# ------------------------------------------------------------------
_UIT_Mcscrolledlistbox instproc _width {val} {
   $self instvar _Wdgt _Opt _initialized
   
   if {$_Opt(-width) != 0} {
      pack propagate $_Wdgt(hull) no
      
      $_Wdgt(listbox) configure -width 1
      $_Wdgt(hullcmd) configure \
	    -width [winfo pixels $_Wdgt(hull) $_Opt(-width)] 
   } else {
      if {$_initialized} {
	 $self configure -visibleitems $_Opt(-visibleitems)
      }
   }
}

# ------------------------------------------------------------------
# OPTION: -height
#
# Specifies the height of the scrolled list box as an entire unit.
# The value may be specified in any of the forms acceptable to 
# Tk_GetPixels.  Any additional space needed to display the other
# components such as labels, margins, and scrollbars force the listbox
# to be compressed.  A value of zero along with the same value for 
# the width causes the value given for the visibleitems option 
# to be applied which administers geometry constraints in a different
# manner.
# ------------------------------------------------------------------
_UIT_Mcscrolledlistbox instproc _height {val} {
   $self instvar _Wdgt _Opt _initialized
   
   set _Opt(-height) $val
   if {$_Opt(-height) != 0} {
      pack propagate $_Wdgt(hull) no
      
      $_Wdgt(listbox) configure -height 1
      $_Wdgt(hullcmd) configure \
	    -height [winfo pixels $_Wdgt(hull) $_Opt(-height)] 
   } else {
      if {$_initialized} {
	 $self configure -visibleitems $_Opt(-visibleitems)
      }
   }
}

# ------------------------------------------------------------------
# OPTION: -visibleitems
#
# Specified the widthxheight in characters and lines for the listbox.
# This option is only administered if the width and height options
# are both set to zero, otherwise they take precedence.  With the
# visibleitems option engaged, geometry constraints are maintained
# only on the listbox.  The size of the other components such as 
# labels, margins, and scroll bars, are additive and independent, 
# effecting the overall size of the scrolled list box.  In contrast,
# should the width and height options have non zero values, they
# are applied to the scrolled list box as a whole.  The listbox 
# is compressed or expanded to maintain the geometry constraints.
# ------------------------------------------------------------------
_UIT_Mcscrolledlistbox instproc _visibleItems {val} {
   $self instvar _Wdgt _Opt

   if {[regexp {^[0-9]+x[0-9]+$} $_Opt(-visibleitems)]} {
      if {($_Opt(-width) == 0) && ($_Opt(-height) == 0)} {
	 set chars [lindex [split $_Opt(-visibleitems) x] 0]
	 set lines [lindex [split $_Opt(-visibleitems) x] 1]
	 
	 pack propagate $_Wdgt(hull) yes
	 
	 $_Wdgt(listbox) configure \
	       -width $chars -height $lines
      }
      
   } else {
      error "bad visibleitems option\
	    \"$_Opt(-visibleitems)\": should be\
	    widthxheight"
   }
}

# ------------------------------------------------------------------
#                            METHODS
# ------------------------------------------------------------------

# ------------------------------------------------------------------
# METHOD: curselection 
#
# Returns a list containing the indices of all the elements in the 
# listbox that are currently selected.
# ------------------------------------------------------------------
_UIT_Mcscrolledlistbox instproc curselection {} {
   return [[$self set _Wdgt(listbox)] curselection]
}

# ------------------------------------------------------------------
# METHOD: activate index
#
# Sets the active element to the one indicated by index.
# ------------------------------------------------------------------
_UIT_Mcscrolledlistbox instproc activate {index} {
    return [[$self set _Wdgt(listbox)] activate [$self index $index]]
}

# ------------------------------------------------------------------
# METHOD: see index
#
# Adjusts the view such that the element given by index is visible.
# ------------------------------------------------------------------
_UIT_Mcscrolledlistbox instproc see {index} {
    [$self set _Wdgt(listbox)] see [$self index $index]
}

# ------------------------------------------------------------------
# METHOD: index index
#
# Returns the decimal string giving the integer index corresponding 
# to index.  The index value may be a integer number, active,
# anchor, end, @x,y, or a pattern.
# ------------------------------------------------------------------
_UIT_Mcscrolledlistbox instproc index {index} {
   $self instvar _Opt _Wdgt
   
   if {[regexp \
	 {(^[0-9]+$)|(active)|(anchor)|(end)|(^@[0-9]+,[0-9]+$)} $index]} {
      return [$_Wdgt(listbox) index $index]
      
   } else {
      set indexValue [lsearch -glob $_Opt(-items) $index]
      
      if {$indexValue == -1} {
	 error "bad _UIT_Mcscrolledlistbox index \"$index\": must be\
	       active, anchor, end, @x,y, number, or a pattern"
      }
      
      return $indexValue
   }
}

# ------------------------------------------------------------------
# METHOD: getcurselection 
#
# Returns the contents of the listbox element indicated by the current 
# selection indexes.  Short cut version of get and curselection 
# command combination.
# ------------------------------------------------------------------
_UIT_Mcscrolledlistbox instproc getcurselection {} {
   $self instvar _Wdgt
   set rlist {}
   
   if {[$self selecteditemcount] > 0} {
      set cursels [$_Wdgt(listbox) curselection]
 
      foreach sel $cursels {
	 lappend rlist [$_Wdgt(listbox) get $sel]
      }
   }
   return $rlist
}

# ------------------------------------------------------------------
# METHOD: selection option first ?last?
#
# Adjusts the selection within the listbox.  The index value may be 
# a integer number, active, anchor, end, @x,y, or a pattern.
# ------------------------------------------------------------------
_UIT_Mcscrolledlistbox instproc selection {option first {last {}}} {
   $self instvar _Wdgt

   set first [$self index $first]
   
   if {$last != {}} {
      set last [$self index $last]
   } 
   
   switch $option {
      anchor {
	 $_Wdgt(listbox) selection anchor $first
      }
      
      clear {
	 if {$last == {}} {
	    $_Wdgt(listbox) selection clear $first 
	 } else {
	    $_Wdgt(listbox) selection clear $first $last
	 }
      }
      
      includes {
	 $_Wdgt(listbox) selection includes $first
      }
      
      set {
	 if {$last == {}} {
	    $_Wdgt(listbox) selection set $first 
	 } else {
	    $_Wdgt(listbox) selection set $first $last
	 }
      }
   }
}

# ------------------------------------------------------------------
# METHOD: selecteditemcount 
#
# Returns a decimal string indicating the total number of selected 
# elements in the listbox.
# ------------------------------------------------------------------
_UIT_Mcscrolledlistbox instproc selecteditemcount {} {
   return [llength [[$self set _Wdgt(listbox)] curselection]]
}

# ------------------------------------------------------------------
# METHOD: xview args
#
# Change or query the vertical position of the text in the list box.
# ------------------------------------------------------------------
_UIT_Mcscrolledlistbox instproc xview {args} {
   return [eval [$self set _Wdgt(listbox)] xview $args]
}

# ------------------------------------------------------------------
# METHOD: yview args
#
# Change or query the horizontal position of the text in the list box.
# ------------------------------------------------------------------
_UIT_Mcscrolledlistbox instproc yview {args} {
   return [eval [$self set _Wdgt(listbox)] yview $args]
}

# ------------------------------------------------------------------
# METHOD: column names
#
# Get names of columns
# ------------------------------------------------------------------
_UIT_Mcscrolledlistbox instproc cget {} {
    return [[$self set _Wdgt(listbox)]  cget]
}

# ------------------------------------------------------------------
# PRIVATE METHOD: _fillerWidth 
#
# Compute the width of the filler frame based on the vertical 
# scrollbar width plus the margin.
# ------------------------------------------------------------------
_UIT_Mcscrolledlistbox instproc _fillerWidth {} {
   $self instvar _Wdgt _vmode
   if {$_vmode == "on"} {
      return [expr [winfo reqwidth $_Wdgt(vertsb)] + \
	    [winfo reqwidth $_Wdgt(vmargin)]]
   } else {
      return 1
   }
}

# ------------------------------------------------------------------
# PROTECTED METHOD: _makeSelection 
#
# Evaluate the selection command.
# ------------------------------------------------------------------
_UIT_Mcscrolledlistbox instproc _makeSelection {} {
   after idle "uplevel #0 [$self set _Opt(-selectioncommand)]"
}

# ------------------------------------------------------------------
# PROTECTED METHOD: _dblclick 
#
# Evaluate the double click command option if not empty.
# ------------------------------------------------------------------
_UIT_Mcscrolledlistbox instproc _dblclick {} {
   uplevel #0 [$self set _Opt(-dblclickcommand)]
}	

# ------------------------------------------------------------------
# PROTECTED METHOD: _singleclick 
#
# Evaluate the single click command option if not empty.
# ------------------------------------------------------------------
_UIT_Mcscrolledlistbox instproc _singleclick {} {
   after idle "uplevel #0 [$self set _Opt(-selectioncommand)]"
}	

# ------------------------------------------------------------------
# PROTECTED METHOD: _sort
#
# Evaluate the sort command option if not empty.
# ------------------------------------------------------------------
_UIT_Mcscrolledlistbox instproc _sort {column} {
   $self instvar _Wdgt

   uplevel #0 [$self set _Opt(-sortcommand)] $column
}	

# ------------------------------------------------------------------
# PRIVATE METHOD: _vertScrollbarDisplay mode
#
# Displays the vertical scrollbar based on the input mode.
# ------------------------------------------------------------------
_UIT_Mcscrolledlistbox instproc _vertScrollbarDisplay {mode} {
   $self instvar _Wdgt _Opt _vmode
   
   switch $mode  {
      on {
	 set _vmode on
	 
	 $_Wdgt(vmargin) config -height 1 -width \
	       [winfo pixels $_Wdgt(vmargin) \
	       $_Opt(-scrollmargin)]
	 
	 pack forget $_Wdgt(listbox)
	 pack $_Wdgt(vertsb) -side right -fill y
	 pack $_Wdgt(vmargin) -side right
	 pack $_Wdgt(listbox) -fill both -expand yes -side left 
	 
	 update idletasks
	 
	 $_Wdgt(filler) config -width [$self _fillerWidth] -height 1
      }
      
      off {
	 set _vmode off
	 
	 pack forget $_Wdgt(vertsb)
	 
	 $_Wdgt(vmargin) config -width 1 -height 1
	 $_Wdgt(filler) config -width 1 -height 1
      }
      
      default {
	 error "invalid argument \"$mode\": should be on or off"
      }
   }
}

# ------------------------------------------------------------------
# PRIVATE METHOD: _horizScrollbarDisplay mode
#
# Displays the horizontal scrollbar based on the input mode.
# ------------------------------------------------------------------
_UIT_Mcscrolledlistbox instproc _horizScrollbarDisplay {mode} {
   $self instvar _Wdgt _hmode _Opt
   
   switch $mode  {
      on {
	 set _hmode on
	 
	 $_Wdgt(hmargin) config -width 1 -height \
	       [winfo pixels $_Wdgt(hmargin) \
	       $_Opt(-scrollmargin)]
	 
	 pack $_Wdgt(horizsb) -side left -fill x -expand yes
	 
	 update idletasks
	 
	 $_Wdgt(filler) config -width [$self _fillerWidth] -height 1
      }
      
      off {
	 set _hmode off
	 
	 pack forget $_Wdgt(horizsb)
	 
	 $_Wdgt(hmargin) config -width 1 -height 1
	 $_Wdgt(filler) config -width 1 -height 1
      }
      
      default {
	 error "invalid argument \"$mode\": should be on or off"
      }
   }
}

# ------------------------------------------------------------------
# PRIVATE METHOD: _scrollList wid first last
#
# Performs scrolling and display of scrollbars based on the first and
# last listbox views as well as the current -vscrollmode and -hscrollmode
# settings.
# ------------------------------------------------------------------
_UIT_Mcscrolledlistbox instproc _scrollList {wid first last} {
   $self instvar _Wdgt _Opt _hmode _vmode
   
   $wid set $first $last
   
   if {$wid == $_Wdgt(vertsb)} {
      if {$_Opt(-vscrollmode) == "dynamic"} {
	 if {($first == 0) && ($last == 1)} {
	    if {$_vmode != "off"} {
	       $self _vertScrollbarDisplay off
	    }
	    
	 } else {
	    if {$_vmode != "on"} {
	       $self _vertScrollbarDisplay on
	    }
	 }
      }
      
   } elseif {$wid == $_Wdgt(horizsb)} {
      if {$_Opt(-hscrollmode) == "dynamic"} {
	 if {($first == 0) && ($last == 1)} {
	    if {$_hmode != "off"} {
	       $self _horizScrollbarDisplay off
	    }
	    
	 } else {
	    if {$_hmode != "on"} {
	       $self _horizScrollbarDisplay on
	    }
	 }
      }
   }
}

_UIT_Mcscrolledlistbox instproc constrainSize {{true {1}}} {
   $self instvar _initialized _Opt _Wdgt

   if {$true} {
      pack propagate $_Wdgt(hull) no
      
      $_Wdgt(listbox) configure -width 1 -height 1
      $_Wdgt(hullcmd) configure \
	    -height [winfo pixels $_Wdgt(hull) $_Opt(-height)] \
	    -width [winfo pixels $_Wdgt(hull) $_Opt(-width)] 
   } else {
      if {$_initialized} {
	 $self configure -visibleitems $_Opt(-visibleitems)
      }
   }
}


