# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: boolgui.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:35  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.9.1  1999/11/05  14:52:38  Peter_Wolfe
# 	Code drop for zulu BL6
#
# Revision 1.1.3.20  1999/10/13  20:12:37  Richard_Taft
# 	When calculating leaf, use end, not 1.  The tabbed widget requires
# 	more levels.
# 	Call _parent's packSide proc to find out the side (top or left)
# 	to pack from.  Don't check the parent's name, it may not tell
#
# Revision 1.1.3.19  1998/12/03  22:32:12  William_Athanasiou
# 	Fix global grab and refresh
# 	[1998/12/03  22:17:53  William_Athanasiou]
#
# Revision 1.1.3.18  1998/09/28  19:46:10  Paul_Henderson
# 	Set highlightthickness for a checkbutton to 2 (from 0)
# 	[1998/09/28  19:44:48  Paul_Henderson]
# 
# Revision 1.1.3.17  1998/03/16  20:09:05  William_Athanasiou
# 	Add setLabel functionality to allow window and widget labels to be dynamically set
# 	[1998/03/16  20:05:17  William_Athanasiou]
# 
# Revision 1.1.3.16  1998/02/26  21:44:04  William_Athanasiou
# 	Set initial disable/enable state
# 	[1998/02/26  21:15:21  William_Athanasiou]
# 
# Revision 1.1.3.15  1998/02/11  18:44:03  William_Athanasiou
# 	Added disable/enable and change callbacks
# 	[1998/02/11  16:44:27  William_Athanasiou]
# 
# Revision 1.1.3.14  1997/08/18  17:11:03  William_Athanasiou
# 	Postpone catalog lookup until first time widget displayed
# 	[1997/08/18  16:17:18  William_Athanasiou]
# 
# Revision 1.1.3.13  1997/06/24  19:04:35  Fred_Cassirer
# 	Booleans needed to use the valueList strings instead of 0/1
# 	[1997/06/20  18:22:34  Fred_Cassirer]
# 
# Revision 1.1.3.12  1997/03/31  19:22:13  William_Athanasiou
# 	typo: setting isPacked instead of _displayedOnce
# 	[1997/03/31  19:20:04  William_Athanasiou]
# 
# Revision 1.1.3.11  1997/03/28  16:46:34  William_Athanasiou
# 	Postpone UI creation until first display for performance reasons
# 	[1997/03/28  16:28:01  William_Athanasiou]
# 
# Revision 1.1.3.10  1997/03/21  15:55:24  William_Athanasiou
# 	Added pointer focus help/creation of _helpStrs catalog
# 	[1997/03/21  15:44:32  William_Athanasiou]
# 
# Revision 1.1.3.9  1997/03/13  17:45:01  William_Athanasiou
# 	Correct expansion of window behavior and packing
# 	[1997/03/13  17:43:42  William_Athanasiou]
# 
# Revision 1.1.3.8  1997/03/07  19:07:58  William_Athanasiou
# 	Added geometry management for GUI
# 	[1997/03/07  19:05:19  William_Athanasiou]
# 
# Revision 1.1.3.7  1997/03/07  15:40:42  William_Athanasiou
# 	Pack widget correctly
# 	[1997/03/07  15:39:11  William_Athanasiou]
# 
# 	text now on right of button
# 	[1997/03/07  15:07:13  William_Athanasiou]
# 
# Revision 1.1.3.6  1997/01/16  20:37:35  William_Athanasiou
# 	Only pack the UIrep once
# 	[1997/01/16  20:30:02  William_Athanasiou]
# 
# Revision 1.1.3.5  1997/01/16  14:15:13  William_Athanasiou
# 	Prepend _UIT_ to all classes and globals
# 	[1997/01/15  21:12:50  William_Athanasiou]
# 
# Revision 1.1.3.4  1996/12/02  23:00:47  Todd_Moyer
# 	In display method call $self next to cause a read to occur.
# 	[1996/12/02  22:49:58  Todd_Moyer]
# 
# Revision 1.1.3.3  1996/10/01  13:31:34  William_Athanasiou
# 	Fixed slight formatting problems
# 	[1996/10/01  13:28:52  William_Athanasiou]
# 
# Revision 1.1.3.2  1996/09/24  14:17:05  William_Athanasiou
# 	Initial version
# 	[1996/09/24  13:59:06  William_Athanasiou]
# 
# $EndLog$
# 
# @(#)$RCSfile: boolgui.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:35 $
# 


Class _UIT_BooleanGUI -superclass _UIT_BooleanGeneric

_UIT_BooleanGUI instproc init {args} {   
   eval $self next $args
}

_UIT_BooleanGUI instproc display {} { 
   $self instvar _displayedOnce _True _False

   if {!$_displayedOnce} {
      incr _displayedOnce

      $self instvar _lbl _valuePtr _parent _displayedOnce \
	    _window _UIrep _enabledState
      
      set leaf [lindex [split $self .] end]
      set container [$_parent set containWdgt]
      
      set _UIrep [checkbutton $container.$leaf \
	    -text $_lbl -command "$self invokeWrapper" \
	    -onvalue $_True \
	    -offvalue $_False \
	    -variable $_valuePtr \
	    -highlightthickness 2 -anchor w]
      $_window _registerUImap $_UIrep $self

       pack $_UIrep -anchor nw -padx 0 -side [$_parent packSide]
      $self _setState $_enabledState
   }
   $self next
}

_UIT_BooleanGUI instproc invokeWrapper {} {
   $self instvar _window
   $_window _makeBusy
   $self changeCB
   $_window _makeNotBusy
}

_UIT_BooleanGUI instproc setLabel {s} {
   $self instvar _lbl _displayedOnce _UIrep
   set _lbl $s
   if $_displayedOnce {
      $_UIrep configure -text $s
   }
}

_UIT_BooleanGUI instproc _setState {val} {
   [$self set _UIrep] configure -state $val
}
