#!/usr/bin/sh
# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: booljava.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:35  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.5.9  1998/03/26  19:59:45  Anthony_Hoffman
# 	BL 16 shared sandbox submit
# 	[1998/03/25  19:00:35  Anthony_Hoffman]
#
# Revision 1.1.2.16  1998/03/16  20:09:06  William_Athanasiou
# 	Add setLabel functionality to allow window and widget labels to be dynamically set
# 	[1998/03/16  20:05:22  William_Athanasiou]
# 
# Revision 1.1.2.15  1998/02/13  22:27:42  William_Athanasiou
# 	Added enable/disable and changeCB funtionality
# 	[1998/02/13  22:18:52  William_Athanasiou]
# 
# Revision 1.1.2.14  1997/11/06  19:58:32  William_Athanasiou
# 	Replace all quoted strings with a call to safeXferString
# 	[1997/11/06  19:56:31  William_Athanasiou]
# 
# Revision 1.1.2.13  1997/10/21  14:57:11  Richard_Taft
# 	Added \#@ comments for automated documentation
# 	[1997/10/08  14:38:32  Richard_Taft]
# 
# Revision 1.1.2.12  1997/10/02  18:00:28  Richard_Taft
# 	Corrected getValue proc which returned true for false
# 	and false for true.  It would make more sense to have
# 	valueList contain { $_False $_True } rather than
# 	{ $_True $_False }, but that would require users to
# 	change their code.
# 	[1997/10/02  16:09:05  Richard_Taft]
# 
# Revision 1.1.2.11  1997/09/29  19:52:43  Richard_Taft
# 	Handle values other than {0 1} for true and false
# 	[1997/09/02  20:28:55  Richard_Taft]
# 
# Revision 1.1.2.10  1997/08/22  18:46:07  William_Athanasiou
# 	Remove resetval call and correct display logic
# 	[1997/08/22  18:28:37  William_Athanasiou]
# 
# Revision 1.1.2.9  1997/08/20  13:00:43  Richard_Taft
# 	 	** Merge Information **
# 		** Command used:	bsubmit **
# 		** Ancestor revision:	1.1.2.7 **
# 		** Merge revision:	1.1.2.8 **
# 	 	** End **
# 	call resetVal from display to set _javaKnowsMe and sync up values between java & suit
# 	[1997/07/24  19:40:00  Richard_Taft]
# 
# Revision 1.1.2.8  1997/08/18  17:11:04  William_Athanasiou
# 	Postpone catalog lookup until first time widget displayed
# 	[1997/08/18  16:17:22  William_Athanasiou]
# 
# Revision 1.1.2.7  1997/07/22  21:42:21  Richard_Taft
# 	Fixed display instproc
# 	[1997/07/22  21:30:59  Richard_Taft]
# 
# Revision 1.1.2.6  1997/07/21  18:19:01  Richard_Taft
# 	Fixed bug in setVal
# 	[1997/07/21  18:17:38  Richard_Taft]
# 
# Revision 1.1.2.5  1997/07/10  19:26:27  Richard_Taft
# 	 	** Merge Information **
# 		** Command used:	bsubmit **
# 		** Ancestor revision:	1.1.2.3 **
# 		** Merge revision:	1.1.2.4 **
# 	 	** End **
# 	Added getVal and setVal.
# 	Changed display to output creation information when _displayedOnce
# 	is false; display statement otherwise.
# 	[1997/07/10  18:45:45  Richard_Taft]
# 
# Revision 1.1.2.4  1997/07/09  20:12:19  Todd_Moyer
# 	Moved value to the end if display method.
# 	[1997/07/09  20:09:48  Todd_Moyer]
# 
# Revision 1.1.2.3  1997/07/02  19:01:11  Deepa_Bachu
# 	Modified the creation code being sent to the applet.
# 	Modified the creation code being sent to the applet.
# 	[1997/07/02  18:55:08  Deepa_Bachu]
# 
# Revision 1.1.2.2  1997/06/23  15:01:22  Deepa_Bachu
# 	Initial _UIT_BooleanJAVA class file.
# 	[1997/06/23  14:52:46  Deepa_Bachu]
# 
# $EndLog$
# 
# @(#)$RCSfile: booljava.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:35 $
# 

#@ BooleanJAVA is a boolean object, most likely a checkbox, that is 
#@ displayed in a Java window usually through a web browser.  It 
#@ communicates to the Java applet via the J-protocol.

Class _UIT_BooleanJAVA -superclass _UIT_BooleanGeneric

_UIT_BooleanJAVA instproc init {args} {

    eval $self next $args             ;# do parents init

}


#@ Tell the java applet to create and display a boolean widget

_UIT_BooleanJAVA instproc display {} {
   global _UIT_g_main
   $self instvar _displayedOnce
   
   if { ! $_displayedOnce } {
      $self instvar _lbl _helpTag _valuePtr _True _enabledState
      upvar #0 $_valuePtr val 

      putJava "_UIT_Boolean $self [safeXferString $_lbl] \
	    $_enabledState [safeXferString $_helpTag] [ cequal $val $_True ]"
      incr _displayedOnce
   }
}


#@ Return the value of the boolean widget.  The value is one of
#@ the symbols defined in the -valueList option.  It defaults
#@ to 1 for true and 0 for false.

_UIT_BooleanJAVA instproc getVal {} {
    $self instvar _displayedOnce valueList _True _False

    if { $_displayedOnce } {
	# Query java for the value
	putJava "$self getVal"
	if { [ getJava val ] < 0 } {
	    logMsg "Java Applet closed?"
	    error "Java Applet closed?"
	    return ""
	} else {
	    # This would have been right if
	    # valueList was in a logical order!
	    #return [lindex $valueList $val]

	    if { $val } {
		return $_True
	    } else {
		return $_False
	    }
	}

    } else {
	# Java doesn't know the value,
	# we do!
	return [$self next]
    }
}


#@ Set the value of the boolean widget.  The value must be
#@ one of the symbols defined in the -valueList option.  If
#@ -valueList was not specified, the symbols default to 1 for
#@ true and 0 for false.

_UIT_BooleanJAVA instproc setVal {val} {
   $self instvar _displayedOnce _True
   set val [$self next $val]
   
   if { $_displayedOnce } {
       putJava "$self setVal [cequal $val $_True]"
   }
   return $val
}

_UIT_BooleanJAVA instproc _setState {val} { 
   if [cequal $val "disabled"] { 
      putJava "$self disable" 
   } else {
      putJava "$self enable"
   }
}
