#!/usr/bin/otclsh
# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: buttongen.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:35  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.7.1  2000/09/06  19:34:15  Peter_Wolfe
# 	Code drop for yankee bl2
#
# Revision 1.1.2.8  2000/04/18  14:12:41  Todd_Moyer
# 	Added invokeWrapper method to handle common tasks.
#
# Revision 1.1.2.7  2000/04/12  18:41:32  Todd_Moyer
# 	Added hooks and procs to generate and play automated execution scripts.
#
# Revision 1.1.2.6  1998/10/16  20:19:37  William_Athanasiou
# 	Remove comment from inside invokeCB
# 	[1998/10/16  20:17:57  William_Athanasiou]
#
# Revision 1.1.2.5  1998/03/03  15:15:58  Todd_Moyer
# 	Ignore events received while processing a prev event.
# 	[1998/03/03  15:14:29  Todd_Moyer]
# 
# Revision 1.1.2.4  1997/01/16  14:15:16  William_Athanasiou
# 	Prepend _UIT_ to all classes and globals
# 	[1997/01/15  21:12:56  William_Athanasiou]
# 
# Revision 1.1.2.3  1996/09/24  18:29:48  William_Athanasiou
# 	Added button callback invocation
# 	[1996/09/24  18:28:09  William_Athanasiou]
# 
# Revision 1.1.2.2  1996/08/30  18:40:46  Deepa_Bachu
# 	Created this file to maintain the _UIT_ButtonGeneric class.
# 	[1996/08/30  17:42:13  Deepa_Bachu]
# 
# $EndLog$
# 
# @(#)$RCSfile: buttongen.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:35 $
# 


#@ Base class for common button functionality.

Class _UIT_ButtonGeneric -superclass _UIT_SuperWdgt


# ---------------------------------------------

_UIT_ButtonGeneric instproc init {args} {

    # This flag keeps one event from interrupting another
    $self set _busy 0

    eval $self next $args             ;# do parents init
}


# ---------------------------------------------
#@ Return a command that can be executed to do the callback.

_UIT_ButtonGeneric instproc getActCmd {} {
    return "$self invoke"
}


#-------------------------------------------------
#@ No-op base class's method.  These widgets don't need to
#@   save any state.  Intended for recording execution for automated testing.

_UIT_ButtonGeneric instproc getState {} {
    return ""
}


# ---------------------------------------------
#@ Default callback is just a no-op.

# don't do anything but prevent failure.
_UIT_ButtonGeneric instproc invokeCB {} {;}


# ---------------------------------------------
#@ Handle a button press.

_UIT_ButtonGeneric instproc invokeWrapper {} {
    global _UIT_g_main 

   # This hook records invocation for automated scripting
   $_UIT_g_main scriptOperCB   $self

   $self invokeCB
}

# =============================================
