# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: buttongui.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:35  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.10.1  2000/09/06  19:34:17  Peter_Wolfe
# 	Code drop for yankee bl2
#
# Revision 1.1.2.27  2000/04/18  14:12:43  Todd_Moyer
# 	Deleted unused optional arguement from invokeWrapper method.  Call base class's invokeWrapper method.
#
# Revision 1.1.2.26  2000/04/12  18:41:34  Todd_Moyer
# 	Added hooks and procs to generate and play automated execution scripts.
#
# Revision 1.1.2.25  1999/10/13  20:12:39  Richard_Taft
# 	Call _parent's packSide proc to find out the side (top or left)
# 	to pack from.  Don't check the parent's name, it may not tell
#
# Revision 1.1.2.24  1998/12/03  22:32:14  William_Athanasiou
# 	Fix global grab and refresh
# 	[1998/12/03  22:17:58  William_Athanasiou]
#
# Revision 1.1.2.23  1998/04/01  20:00:16  William_Athanasiou
# 	If button disabled; don't allow invokeWrapper to run
# 	[1998/04/01  19:55:58  William_Athanasiou]
# 
# Revision 1.1.2.22  1998/03/27  19:49:14  William_Athanasiou
# 	Ensure buttons come up correctly enabled/disabled
# 	[1998/03/27  19:47:41  William_Athanasiou]
# 
# Revision 1.1.2.21  1998/03/16  20:09:07  William_Athanasiou
# 	Add setLabel functionality to allow window and widget labels to be dynamically set
# 	[1998/03/16  20:05:25  William_Athanasiou]
# 
# Revision 1.1.2.20  1998/03/03  15:15:59  Todd_Moyer
# 	Ignore events received while processing a prev event.
# 	[1998/03/03  15:14:37  Todd_Moyer]
# 
# Revision 1.1.2.19  1998/03/02  16:49:52  Todd_Moyer
# 	Added comments and removed redundant code.
# 	[1998/03/02  16:43:35  Todd_Moyer]
# 
# Revision 1.1.2.18  1998/02/26  21:44:06  William_Athanasiou
# 	Set initial disable/enable state
# 	[1998/02/26  21:15:43  William_Athanasiou]
# 
# Revision 1.1.2.17  1998/02/11  18:44:03  William_Athanasiou
# 	Added disable/enable and change callbacks
# 	[1998/02/11  16:44:29  William_Athanasiou]
# 
# Revision 1.1.2.16  1997/12/16  18:51:26  Richard_Taft
# 	Added pfh string Working... after button press
# 	[1997/12/16  18:47:50  Richard_Taft]
# 
# Revision 1.1.2.15  1997/08/28  18:37:14  Richard_Taft
# 	Added instproc invokeWrapper as the buttons associated command.
# 	It will display a busy cursor before invoking the user's
# 	invokeCB and then reset the cursor on return.
# 	[1997/08/28  17:56:36  Richard_Taft]
# 
# Revision 1.1.2.14  1997/08/18  17:11:04  William_Athanasiou
# 	Postpone catalog lookup until first time widget displayed
# 	[1997/08/18  16:17:24  William_Athanasiou]
# 
# Revision 1.1.2.13  1997/03/31  18:49:29  William_Athanasiou
# 	set highlightthickness to 2 so its visible
# 	[1997/03/31  18:31:43  William_Athanasiou]
# 
# Revision 1.1.2.12  1997/03/28  16:46:36  William_Athanasiou
# 	Postpone UI creation until first display for performance reasons
# 	[1997/03/28  16:28:03  William_Athanasiou]
# 
# Revision 1.1.2.11  1997/03/21  15:55:25  William_Athanasiou
# 	Added pointer focus help/creation of _helpStrs catalog
# 	[1997/03/21  15:44:35  William_Athanasiou]
# 
# Revision 1.1.2.10  1997/03/13  17:45:02  William_Athanasiou
# 	Correct expansion of window behavior and packing
# 	[1997/03/13  17:43:44  William_Athanasiou]
# 
# Revision 1.1.2.9  1997/03/07  19:07:59  William_Athanasiou
# 	Added geometry management for GUI
# 	[1997/03/07  19:05:22  William_Athanasiou]
# 
# Revision 1.1.2.8  1997/01/16  20:37:37  William_Athanasiou
# 	Only pack the UIrep once
# 	[1997/01/16  20:30:06  William_Athanasiou]
# 
# Revision 1.1.2.7  1997/01/16  14:15:17  William_Athanasiou
# 	Prepend _UIT_ to all classes and globals
# 	[1997/01/15  21:12:59  William_Athanasiou]
# 
# Revision 1.1.2.6  1996/10/04  19:51:00  William_Athanasiou
# 	Remove puts left in by accident
# 	[1996/10/04  16:06:23  William_Athanasiou]
# 
# Revision 1.1.2.5  1996/10/04  14:23:16  William_Athanasiou
# 	The widget name for Buttons was being incorrectly calculated as
# 	$leaf.$container instead of $container.$leaf when the widget
# 	      name is not passed in.
# 	[1996/10/04  14:12:37  William_Athanasiou]
# 
# Revision 1.1.2.4  1996/10/01  13:31:35  William_Athanasiou
# 	Fixed slight formatting problems
# 	[1996/10/01  13:28:55  William_Athanasiou]
# 
# Revision 1.1.2.3  1996/09/24  18:29:49  William_Athanasiou
# 	Added button callback invocation
# 	[1996/09/24  18:28:12  William_Athanasiou]
# 
# Revision 1.1.2.2  1996/09/24  14:17:14  William_Athanasiou
# 	Initial version of file.
# 	_UIT_ButtonGUI class used by bottonbox class in [TK/Ctk]utils directory
# 		to ensure correct label names.
# 	[1996/09/24  14:03:58  William_Athanasiou]
# 
# $EndLog$
# 
# @(#)$RCSfile: buttongui.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:35 $
# 


#@ Gui specific implementation of button widgets.

Class _UIT_ButtonGUI -superclass _UIT_ButtonGeneric


# --------------------------------------------------------

_UIT_ButtonGUI instproc init {args} {
   $self instvar widgetname _UIrep

   set widgetname {}
   set _UIrep {}

   eval {$self next} $args
}


# --------------------------------------------------------

_UIT_ButtonGUI instproc cget {val} {
   [$self set _UIrep] cget $val
}


# --------------------------------------------------------

_UIT_ButtonGUI instproc config {args} {
   eval {[$self set _UIrep] config} $args
}


# --------------------------------------------------------

_UIT_ButtonGUI instproc configure {args} {
   eval {[$self set _UIrep] config} $args
}


# --------------------------------------------------------

_UIT_ButtonGUI instproc display {} {
   $self instvar _displayedOnce _enabledState
   if {!$_displayedOnce} {
      $self instvar widgetname _UIrep _parent _window

      if {"$_UIrep" == {}} {
	 if { $widgetname == {} } {
	    $self _createUIrep \
		  [$_parent set containWdgt].[lindex [split $self .] end]
	 } else {
	    $self _createUIrep $widgetname
	 }
      }
      pack $_UIrep -expand 0 -padx 0 -anchor nw -side [$_parent packSide]
   }
   $self _setState $_enabledState
   $self next
}


# --------------------------------------------------------

_UIT_ButtonGUI instproc invoke {} {
   [$self set _UIrep] invoke
}


# --------------------------------------------------------
#@ Do the before and after stuff for handling a button press.
#@ This is primarily to assure the user that the system is working on the
#@ requested action.

_UIT_ButtonGUI instproc invokeWrapper {} {
    $self instvar _busy _UIrep _enabledState _window

   # If button is disabled, ignore this event!
   if [cequal $_enabledState "disabled"] {return}

    # If already processing an event, ignore this one.
    # This avoids one event interferring with another, which is particularly
    # a problem if they are putting up windows or infomsgs.
    # This is common if user accidentally double clicks a button.

   if {$_busy} {return}

   set _busy 1
   $_window _makeBusy       ;# make window busy.

   $self next

   $_window _makeNotBusy
   set _busy 0
}


# --------------------------------------------------------
#@ Do UI-specific initialization.

_UIT_ButtonGUI instproc _createUIrep {w} {
   $self instvar _UIrep _lbl _window _displayedOnce
   incr _displayedOnce
   set _UIrep [_UIT_Pushbutton $w -text $_lbl -command "$self invokeWrapper"]
   $_window _registerUImap $_UIrep $self
}

_UIT_ButtonGUI instproc setLabel {s} {
   $self instvar _lbl _displayedOnce _UIrep
   set _lbl $s
   if $_displayedOnce { $_UIrep configure -text $_lbl }
}

# --------------------------------------------------------
#@ Enable or disable button.

_UIT_ButtonGUI instproc _setState {val} {
   [$self set _UIrep] configure -state $val
}


# --------------------------------------------------------
#@ Return UI-specific widget.

_UIT_ButtonGUI instproc _widget {} {
   return [$self set _UIrep]
}


