#!/usr/bin/otclsh
# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: buttonweb.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:36  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.4.3  1997/05/19  18:06:49  William_Athanasiou
# 	Drop for pre-BL11 build
# 	[1997/05/16  17:39:08  William_Athanasiou]
#
# Revision 1.1.2.11  1997/03/17  22:18:54  Deepa_Bachu
# 	Added class _UIT_WebButtobBox class for geom management
# 	of the window buttons.
# 	[1997/03/17  22:00:13  Deepa_Bachu]
# 
# Revision 1.1.2.10  1997/03/14  20:57:38  Deepa_Bachu
# 	Made changes to accomodate geometry management
# 	changes esp. in cases of listbox and window buttons.
# 	[1997/03/14  20:54:21  Deepa_Bachu]
# 
# Revision 1.1.2.9  1997/02/07  17:01:00  Deepa_Bachu
# 	Added double quotes around VALUE in the BUTTOn tag.
# 	[1997/02/07  16:59:06  Deepa_Bachu]
# 
# Revision 1.1.2.8  1997/01/16  14:15:19  William_Athanasiou
# 	Prepend _UIT_ to all classes and globals
# 	[1997/01/15  21:13:02  William_Athanasiou]
# 
# Revision 1.1.2.7  1996/12/09  19:47:35  Deepa_Bachu
# 	Added '$self next' in the display proc to
# 	cause read to occur.
# 	[1996/12/09  19:46:27  Deepa_Bachu]
# 
# Revision 1.1.2.6  1996/11/22  15:40:17  Deepa_Bachu
# 	Modified the attribute needselection of the list to needSelection.
# 	[1996/11/22  15:37:12  Deepa_Bachu]
# 
# Revision 1.1.2.5  1996/11/12  21:33:33  Deepa_Bachu
# 	Added code to take care of the needselection buttons for the
# 	listbox super widget.
# 	[1996/11/12  21:32:54  Deepa_Bachu]
# 
# Revision 1.1.2.4  1996/09/25  16:02:41  Deepa_Bachu
# 	Removed breaks, for ok apply cancel help buttons.
# 	[1996/09/25  14:35:49  Deepa_Bachu]
# 
# Revision 1.1.2.3  1996/09/09  14:06:09  Deepa_Bachu
# 	Removed all reference to g_* global variables.
# 	Replaced them with _UIT_g_main where necessary.
# 	[1996/09/09  13:55:00  Deepa_Bachu]
# 
# Revision 1.1.2.2  1996/08/30  18:40:48  Deepa_Bachu
# 	Created this file to maintain the _UIT_ButtonWEB class.
# 	[1996/08/30  17:27:17  Deepa_Bachu]
# 
# $EndLog$

Class _UIT_ButtonWEB -superclass _UIT_ButtonGeneric
Class _UIT_WebButtonBox -superclass _UIT_ButtonGeneric


_UIT_ButtonWEB instproc init {args} {

    $self set _activateBtns "" 
    eval $self next $args             ;# do parents init

}


_UIT_ButtonWEB instproc display {} {
    
    $self next
    $self set _activateBtns ""

    if {[cequal [[$self set _parent] info class] _UIT_ListWEB]} {
	foreach value [[$self set _parent] set needSelection] {
		[$self set _parent].$value set _activateBtns "onclick=\"listObj=\'[$self set _parent]\';\""
	}
    }

    if {[cequal [[$self set _parent] info class] _UIT_ListWEB] || [cequal [[$self set _parent] info class] _UIT_WindowWEB] } {
        ## if the buttons of a listbox or window are being displayed, we want to 
        ## omit the geoTag. Regardless of the goemetry, the buttons
        ## will be placed along a row.
        puts "<INPUT TYPE=SUBMIT NAME=$self VALUE=\"[$self set _lbl]\" [$self set _activateBtns]>"
    } else {
        puts "[[$self set _parent] geoTag]"
        puts " <TD COLSPAN=2 valign=top><INPUT TYPE=SUBMIT NAME=$self VALUE=\"[$self set _lbl]\" [$self set _activateBtns]> </TD>"
    }

    return $self
}

_UIT_WebButtonBox instproc init {args} {

     eval $self next $args             ;# do parents init

}


_UIT_WebButtonBox instproc display {} {

    $self next
    puts "<INPUT TYPE=SUBMIT NAME=$self VALUE=\"[$self set _lbl]\">"
}
