#!/usr/bin/otclsh
# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: cat.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:36  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.7.1  2000/09/06  19:34:18  Peter_Wolfe
# 	Code drop for yankee bl2
#
# Revision 1.1.2.14  2000/06/16  15:09:02  Peter_Wolfe
# 	Extend catget to accept optional substition parameters
# 	Add Todd code review comments (use cequal)
#
# Revision 1.1.2.13  2000/04/21  21:15:34  Todd_Moyer
# 	Exorcised evil obsolete constructor code.
#
# Revision 1.1.2.12  1998/06/08  15:39:04  Peter_Wolfe
# 	Fix hardwired source of catgets.tcl which destroys instantiated objects
# 	for SUIT consumers who have already autoloaded/sourced it.
# 	[1998/05/28  20:22:11  Peter_Wolfe]
#
# Revision 1.1.2.11  1998/04/22  14:31:33  Richard_Taft
# 	 	** Merge Information **
# 		** Command used:	bsubmit **
# 		** Ancestor revision:	1.1.2.10 **
# 		** Merge revision:	1.1.2.10 **
# 	 	** End **
# 	merge
# 	[1998/04/22  14:28:04  Richard_Taft]
# 
# 	Unhardcoded paths:  changed /usr/share/sysman $SysmanDir
# 	[1998/04/21  17:30:59  Richard_Taft]
# 
# Revision 1.1.2.10  1997/08/18  17:11:06  William_Athanasiou
# 	Speedup catalog access
# 	[1997/08/18  16:51:35  William_Athanasiou]
# 
# Revision 1.1.2.9  1997/05/16  21:19:03  Deepa_Bachu
# 	Added method exists
# 	[1997/05/16  21:18:35  Deepa_Bachu]
# 
# Revision 1.1.2.8  1997/05/02  18:38:15  Deepa_Bachu
# 	Made changes to use catgets.tcl i.e. to get info
# 	directly from .msg files
# 	[1997/05/02  14:25:11  Deepa_Bachu]
# 
# 	Added the ability to look through multiple catalogs.
# 	[1997/05/01  18:40:33  Deepa_Bachu]
# 
# Revision 1.1.2.7  1997/01/16  14:15:20  William_Athanasiou
# 	Prepend _UIT_ to all classes and globals
# 	[1997/01/15  21:13:06  William_Athanasiou]
# 
# Revision 1.1.2.6  1996/11/08  14:14:50  William_Athanasiou
# 	If catlog entry not found, use widget name as label
# 	[1996/11/08  14:14:06  William_Athanasiou]
# 
# Revision 1.1.2.5  1996/10/18  20:26:12  William_Athanasiou
# 	Fixed problem with executing cham scripts outside of sysman/cham dir.
# 	[1996/10/18  20:15:12  William_Athanasiou]
# 
# Revision 1.1.2.4  1996/09/24  19:57:52  William_Athanasiou
# 	Added check for existance of _msgNum($tag) before evaluating
# 		it.  This could cause a crash if a tag doesn't exist.
# 	Changed default messages to differentiate between missing
# 		catalog entry and missing tag value.
# 	[1996/09/24  17:40:29  William_Athanasiou]
# 
# Revision 1.1.2.3  1996/09/12  17:59:04  Deepa_Bachu
# 	Generated unique initMsgs methods/procs by prefixing
# 	the application name i.e. _UIT_g_main.
# 	[1996/09/12  17:56:01  Deepa_Bachu]
# 
# Revision 1.1.2.2  1996/08/30  18:40:52  Deepa_Bachu
# 	Created this file to contain the _UIT_Catalog class.
# 	[1996/08/30  17:28:10  Deepa_Bachu]
# 
# $EndLog$
# 
# @(#)$RCSfile: cat.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:36 $
# 

global SysmanDir


# Only source this in if it's not already in use. Otherwise, all
# existing instances of _Catalog objects will be destroyed! Apps
# like SysMan Menu use catalogs before SUIT is initialized. We
# could just let it autoload but this approach is significantly faster
if { [info commands _Catalog] == {} } {
    source ${SysmanDir}/utils/catgets.tcl
}



#@ Create an object to manage a catalog file.

Class _UIT_Catalog


# Revised args to get rid of obsolete code.
#   Was: _UIT_Catalog instproc init {appDir catFile cbFile args}
#   Args now:
#       msgFile:  *.msg (unqualified)
#       args:   not currently used, but could be used to call OTcl param procs.


_UIT_Catalog instproc init {msgFile args} {

    $self set _hdl [_Catalog ${self}.catalog [file rootname $msgFile]]
    eval $self next $args
}


_UIT_Catalog instproc destroy {} {
    catclose [$self set _hdl]
    $self next
}

#@ Get the specified message catalog entry using the 
#@ underlying catalog machinery
#@
#@ Arguments:
#@    sw - symbolic message id to fetch from the catalog
#@    args     - optional parameters to substitute into the message 
#@		(i.e. $1%s, $2%s, etc)
#@
_UIT_Catalog instproc _get {sw args} {
   set msg [[$self set _hdl] catgets $sw]

    if { [cequal $args {}] == 0 } {    ;# If there are message parameters

	# Then format them into the message
        set msg [eval {format "$msg"}  $args]
   }

   return $msg
}

_UIT_Catalog instproc _exists {sw} {
   return [[$self set _hdl] exists $sw]
}

_UIT_Catalog instproc get {sw ext} {
   $self instvar _msgNum _hdl

   set tag [translit . _ $sw]_$ext
   
   if {[$_hdl exists $tag] != {}} {
      return [$_hdl catgets $tag]
   } else {
      return {}
   }
}

_UIT_Catalog instproc exists {sw ext} {
   $self instvar _msgNum _hdl

   set tag [translit . _ $sw]_$ext
   if {[$_hdl exists $tag] != {}} {
        return 1
   } else {
        return 0
   }
}
