#
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: cham.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:36  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.15.4  2002/07/18  14:57:05  Richard_Taft
# 	Removed extra EndLog (QAR 94155)
#
# Revision 1.1.15.3  2002/05/30  15:40:36  Richard_Taft
# 	In Java mode, if the suitlet is updating a display because of an EVM
# 	event and the user clicks a button at the same time, values coming
# 	requested from the client by the SUIT server can be confused with
# 	operations that the client sends to the server because of button
# 	clicks, etc.  We attempt to reduce the probability of this happening
# 	by looking in the input queue and only returning things that don't
# 	look like commands if we are in the middle of a blocking read.
#
# Revision 1.1.15.2  2002/02/04  18:29:43  Richard_Taft
# Merge Information:  Non-Visual Merge: User specified tree v51asupportdx.bl2_pre
#     User Revision:  wcalphadx_br:1.1.15.1 Local Ancestor: n/a
#    Merge Revision:  v51asupportdx_bl2_pre:1.1.24.1
#   Common Ancestor:  1.1.11.2
# 	Merge from V51asupport BL2_PRE.
#
# Revision 1.1.15.1  2001/09/24  17:33:18  Richard_Taft
# 	Fix for QAR 85112
# 
# Revision 1.1.11.2  2001/01/11  15:53:40  William_Athanasiou
# 	Fix multicolumn listbox issues for qar 78664
# 
# Revision 1.1.11.1  2000/09/06  19:34:19  Peter_Wolfe
# 	Code drop for yankee bl2
# 
# Revision 1.1.2.115  2000/06/16  15:38:11  Peter_Wolfe
# 	{** Forced Submit **}
# 	Extend catget to accept optional substition parameters
# 
# Revision 1.1.2.113  2000/04/21  21:15:38  Todd_Moyer
# 	Make compatible with reduced cat constructor args.
# 
# Revision 1.1.2.112  2000/04/18  14:12:46  Todd_Moyer
# 	Renamed buttonCB method to scriptOperCB.  Removed obsolete regObj and regGlob methods.
# 
# Revision 1.1.2.111  2000/04/12  18:41:38  Todd_Moyer
# 	Added hooks and procs to generate and play automated execution scripts.
# 
# Revision 1.1.2.110  2000/01/26  15:56:09  Richard_Taft
# 	Uncommented Tcl8-dependent lines
# 
# Revision 1.1.2.109  2000/01/17  16:38:53  Richard_Taft
# 	Added lines to source in mclistbox and mcscrolledlist code,
# 	but left them commented.  Comment them out when Tcl8.x is
# 
# Revision 1.1.2.108  1999/12/15  21:43:00  Todd_Moyer
# 	Source in evm.tcl.
# 
# Revision 1.1.2.107  1999/12/15  14:33:39  Todd_Moyer
# 	Added context mgr to manage the run-time interface between suitlets and other apps.
# 
# Revision 1.1.2.106  1999/12/07  15:31:54  Todd_Moyer
# 	Added 'regForStartNotify' method to the class so classes can request notification when Suit initialized.
# 
# Revision 1.1.2.105  1999/10/21  19:02:22  Richard_Taft
# 	Start non-local timers
# 
# Revision 1.1.2.104  1998/12/04  17:23:52  William_Athanasiou
# 	Correct grab replacement; must return data
# 	[1998/12/04  17:23:34  William_Athanasiou]
# 
# Revision 1.1.2.103  1998/12/04  17:03:04  William_Athanasiou
# 	remove any possibility of doing a global grab
# 	[1998/12/04  17:02:47  William_Athanasiou]
# 
# Revision 1.1.2.102  1998/12/04  15:28:30  William_Athanasiou
# 	remove debug print statement
# 	[1998/12/04  15:26:54  William_Athanasiou]
# 
# Revision 1.1.2.101  1998/12/03  22:32:14  William_Athanasiou
# 	 	** Merge Information **
# 		** Command used:	bsubmit **
# 		** Ancestor revision:	1.1.2.99 **
# 		** Merge revision:	1.1.2.100 **
# 	 	** End **
# 	Fix global grab and refresh
# 	[1998/12/03  22:18:01  William_Athanasiou]
# 
# Revision 1.1.2.100  1998/12/01  16:54:03  Richard_Taft
# 	Override the grab command
# 	[1998/12/01  16:51:30  Richard_Taft]
# 
# Revision 1.1.2.99  1998/09/29  13:51:51  Paul_Henderson
# 	Changed the title and the message displayed in the 'splash screen'
# 	window shown at startup time. Also reduced the window's size.
# 	[1998/09/29  13:51:34  Paul_Henderson]
# 
# Revision 1.1.2.98  1998/07/31  16:46:50  Fred_Cassirer
# 	Added fix for QAR 62947.  Added acknowledgeParent call prior to
# 	going down an error exit path.
# 	[1998/07/31  16:45:49  Fred_Cassirer]
# 
# Revision 1.1.2.97  1998/07/30  12:18:29  Fred_Cassirer
# 	Added code to allow child process to override acknowledgeParent callback
# 	and to provide info text for parent to display
# 	[1998/07/30  12:17:52  Fred_Cassirer]
# 
# Revision 1.1.2.96  1998/07/24  14:17:15  William_Athanasiou
# 	Fixed stack dump when bad UI specified
# 	[1998/07/24  14:00:33  William_Athanasiou]
# 
# Revision 1.1.2.95  1998/07/14  17:55:12  William_Athanasiou
# 	Add keyboard help for curses
# 	[1998/07/14  17:54:36  William_Athanasiou]
# 
# Revision 1.1.2.94  1998/06/10  20:15:38  Fred_Cassirer
# 	Fixed bug in background_io handler, data read from the client was
# 	not being converted correctly.  Null responses were not being Q'd.
# 	[1998/06/10  20:15:14  Fred_Cassirer]
# 
# Revision 1.1.2.93  1998/06/09  19:14:22  Fred_Cassirer
# 	 	** Merge Information **
# 		** Command used:	bsubmit **
# 		** Ancestor revision:	1.1.2.89 **
# 		** Merge revision:	1.1.2.92 **
# 	 	** End **
# 	Re-worked java I/O streams to handle async processing.  Moved the
# 	temporary code from ptyio.cb.tcl permanently to here.
# 	Cleaned up the log tracing stuff
# 	[1998/06/09  19:11:37  Fred_Cassirer]
# 
# Revision 1.1.2.92  1998/05/04  20:04:13  Todd_Moyer
# 	Fixed startCB (it cann't be a method).
# 	[1998/05/04  20:01:29  Todd_Moyer]
# 
# Revision 1.1.2.91  1998/05/01  21:47:28  Todd_Moyer
# 	Added startCB and preDataCB for additional startup hooks.
# 	[1998/05/01  21:40:33  Todd_Moyer]
# 
# Revision 1.1.2.90  1998/04/23  13:47:30  Richard_Taft
# 	Fixed bad merge
# 	[1998/04/23  13:46:27  Richard_Taft]
# 
# Revision 1.1.2.89  1998/04/22  14:31:35  Richard_Taft
# 	 	** Merge Information **
# 		** Command used:	bsubmit **
# 		** Ancestor revision:	1.1.2.87 **
# 		** Merge revision:	1.1.2.88 **
# 	 	** End **
# 	merge
# 	[1998/04/22  14:28:09  Richard_Taft]
# 	Unhardcoded paths:  changed /usr/share/sysman $SysmanDir
# 	[1998/04/21  17:25:27  Richard_Taft]
# 
# Revision 1.1.2.88  1998/04/21  20:03:18  William_Athanasiou
# 	add t to fonts since they may contain spaces
# 	[1998/04/21  20:01:34  William_Athanasiou]
# 
# Revision 1.1.2.87  1998/04/10  15:45:06  William_Athanasiou
# 	Remove Return binding for checkbutton and radiobutton
# 	[1998/04/10  15:44:42  William_Athanasiou]
# 
# Revision 1.1.2.86  1998/04/10  14:54:29  William_Athanasiou
# 	Fixed multiple events from return key
# 	[1998/04/10  14:53:47  William_Athanasiou]
# 
# Revision 1.1.2.85  1998/04/10  02:33:49  William_Athanasiou
# 	Setup display attributes for gui
# 	[1998/04/10  02:22:00  William_Athanasiou]
# 
# Revision 1.1.2.84  1998/04/08  21:17:27  Fred_Cassirer
# 	 	** Merge Information **
# 		** Command used:	bsubmit **
# 		** Ancestor revision:	1.1.2.67 **
# 		** Merge revision:	1.1.2.83 **
# 	 	** End **
# 	Added death of a child callback support for 'Suitlet' command
# 	[1998/04/08  20:58:37  Fred_Cassirer]
# 
# Revision 1.1.2.83  1998/04/08  20:14:49  William_Athanasiou
# 	exit after error about CLI mode
# 	[1998/04/08  20:14:36  William_Athanasiou]
# 
# Revision 1.1.2.82  1998/04/06  18:32:18  Todd_Moyer
# 	Added exitCB so app can clean up.
# 	[1998/04/06  18:31:30  Todd_Moyer]
# 
# Revision 1.1.2.81  1998/04/02  21:48:57  William_Athanasiou
# 	handle control-c
# 	[1998/04/02  21:48:41  William_Athanasiou]
# 
# Revision 1.1.2.80  1998/04/01  20:00:18  William_Athanasiou
# 	Don't allow SUIT to run if CLI mode was forced by SYSMANUI
# 	[1998/04/01  19:58:24  William_Athanasiou]
# 
# Revision 1.1.2.79  1998/03/24  15:44:48  Todd_Moyer
# 	Changed default initErrorCB to filter redundant msgs.
# 	[1998/03/19  21:02:02  Todd_Moyer]
# 
# Revision 1.1.2.78  1998/03/13  19:25:55  William_Athanasiou
# 	tk_strictMotif is global var
# 	[1998/03/13  19:25:33  William_Athanasiou]
# 	set tk_strictMotif=0 to allow return for buttons
# 	[1998/03/13  19:23:16  William_Athanasiou]
# 
# Revision 1.1.2.77  1998/03/03  16:16:49  Richard_Taft
# 	 	** Merge Information **
# 		** Command used:	bsubmit **
# 		** Ancestor revision:	1.1.2.73 **
# 		** Merge revision:	1.1.2.76 **
# 	 	** End **
# 	Splash screen now centered.  Text doesn't move.
# 	Added "-splash {0|1}" flag (default -splash 1).  If zero,
# 	then don't display splash screen.
# 	Added getArgs proc to process command line arguments.
# 	[1998/03/03  16:14:58  Richard_Taft]
# 
# Revision 1.1.2.76  1998/03/02  17:59:34  Todd_Moyer
# 	Cleaned up _winStack API.
# 	[1998/03/02  17:58:54  Todd_Moyer]
# 
# Revision 1.1.2.75  1998/02/26  21:48:52  William_Athanasiou
# 	Update fiel
# 	[1998/02/26  21:48:23  William_Athanasiou]
# 
# Revision 1.1.2.74  1998/02/19  16:35:56  William_Athanasiou
# 	Fix problem with bad SysmanUi choices
# 	[1998/02/19  16:34:41  William_Athanasiou]
# 	Add -catopen argument for sysman help
# 	[1998/02/17  21:15:16  William_Athanasiou]
# 
# Revision 1.1.2.73  1998/02/13  22:27:44  William_Athanasiou
# 	Added enable/disable and changeCB funtionality
# 	[1998/02/13  22:18:57  William_Athanasiou]
# 
# Revision 1.1.2.72  1998/02/11  18:44:00  William_Athanasiou
# 	 	** Merge Information **
# 		** Command used:	bsubmit **
# 		** Ancestor revision:	1.1.2.70 **
# 		** Merge revision:	1.1.2.71 **
# 	 	** End **
# 	Added disable/enable and change callbacks
# 	[1998/02/11  16:44:32  William_Athanasiou]
# 
# Revision 1.1.2.71  1998/02/10  22:32:16  Todd_Moyer
# 	Moved init of _winStack earlier in init proc.
# 	Updated default initErrorCB to use infoMsg.
# 	Removed obsolete code.
# 	[1998/02/10  22:21:09  Todd_Moyer]
# 
# Revision 1.1.2.70  1998/01/21  14:24:12  William_Athanasiou
# 	Fixed typo in setHelpVolume
# 	[1998/01/21  14:23:25  William_Athanasiou]
# 
# Revision 1.1.2.69  1998/01/16  20:43:00  William_Athanasiou
# 	Fix problem with sends of lines w/ embedded newlines
# 	[1998/01/16  20:42:28  William_Athanasiou]
# 
# Revision 1.1.2.68  1997/12/30  18:56:20  Richard_Taft
# 	putJava now terminates lines with control-C in order
# 	to work around bug in Java compiler that kept EOL
# 	characters from being read until more input was sent.
# 	[1997/12/30  18:52:44  Richard_Taft]
# 	Added _UIT_ to SplashScreen class name.
# 	Added focus "grab" so that no events are sent to the new
# 	 window until the splash screen goes away.
# 	Potential problem:  Cannot internationalize splash screen
# 	 since the catalog is not loaded when window first appears.
# 	[1997/12/08  18:58:42  Richard_Taft]
# 
# Revision 1.1.2.67  1997/11/17  17:13:21  Todd_Moyer
# 	Check return value from initErrorCB to see if should
# 	continue or exit.
# 	[1997/11/17  17:12:49  Todd_Moyer]
# 
# Revision 1.1.2.66  1997/11/06  18:56:32  William_Athanasiou
# 	Use  as quote char for safe xfer strings
# 	[1997/11/06  18:55:41  William_Athanasiou]
# 
# Revision 1.1.24.1  2002/01/31  15:39:53  Robert_Fritz
# 	Fixed /tmp security bug
# 
# Revision 1.1.2.64  1997/11/06  15:23:37  William_Athanasiou
# 	splash screen should have watch cursor
# 	[1997/11/06  15:09:40  William_Athanasiou]
# 	Move withdraw of splash screen to before display of first window
# 	[1997/11/06  15:01:29  William_Athanasiou]
# 
# Revision 1.1.2.63  1997/10/27  19:00:46  William_Athanasiou
# 	Add refresh ability
# 	[1997/10/27  18:54:05  William_Athanasiou]
# 
# Revision 1.1.2.62  1997/10/21  14:57:14  Richard_Taft
# 	Added splash screen to keep user happy while suitlet starts
# 	[1997/10/17  18:41:50  Richard_Taft]
# 
# Revision 1.1.2.61  1997/09/16  21:09:17  Todd_Moyer
# 	Changed comments to special comments for Suit
# 	documentation generation.
# 	[1997/09/16  20:55:00  Todd_Moyer]
# 
# Revision 1.1.2.60  1997/08/27  19:23:51  William_Athanasiou
# 	fixed help system: added default arg and allow special locids
# 	[1997/08/27  19:07:44  William_Athanasiou]
# 
# Revision 1.1.2.59  1997/08/22  18:46:08  William_Athanasiou
# 	Correct replacement routine for exit for java mode
# 	[1997/08/22  18:33:15  William_Athanasiou]
# 
# Revision 1.1.2.58  1997/08/21  14:35:35  Todd_Moyer
# 	Added getContext method to pass along the contents of the
# 	  -sysmancontext command line option.
# 	Switched the default UI domain from WEB to CURSES.
# 	[1997/08/21  14:33:16  Todd_Moyer]
# 
# Revision 1.1.2.57  1997/08/19  18:33:14  Todd_Moyer
# 	 	** Merge Information **
# 		** Command used:	bsubmit **
# 		** Ancestor revision:	1.1.2.55 **
# 		** Merge revision:	1.1.2.56 **
# 	 	** End **
# 	Added initErrorCB to report intialization errors to the developer.
# 	Added initCB to allow the app to decide which window to display at run time.
# 	Commented out obsolete code.
# 	[1997/08/19  17:39:11  Todd_Moyer]
# 
# Revision 1.1.2.56  1997/08/18  17:11:07  William_Athanasiou
# 	Speedup catalog access
# 	[1997/08/18  16:51:39  William_Athanasiou]
# 
# Revision 1.1.2.55  1997/07/31  15:29:29  William_Athanasiou
# 	Added rename of exit proc to send _UIT_EXIT command to java applet
# 	[1997/07/31  15:29:13  William_Athanasiou]
# 	Add ability to set help volume name
# 	[1997/07/28  13:42:58  William_Athanasiou]
# 
# Revision 1.1.2.54  1997/07/22  21:42:22  Richard_Taft
# 	 	** Merge Information **
# 		** Command used:	bsubmit **
# 		** Ancestor revision:	1.1.2.52 **
# 		** Merge revision:	1.1.2.53 **
# 	 	** End **
# 	Changed logname.  Modified behavior when blank line received from Java
# 	[1997/07/22  21:35:32  Richard_Taft]
# 
# Revision 1.1.2.53  1997/07/16  21:25:24  William_Athanasiou
# 	Update help routines
# 	[1997/07/16  21:24:34  William_Athanasiou]
# 
# Revision 1.1.2.52  1997/07/10  19:26:29  Richard_Taft
# 	 	** Merge Information **
# 		** Command used:	bsubmit **
# 		** Ancestor revision:	1.1.2.50 **
# 		** Merge revision:	1.1.2.51 **
# 	 	** End **
# 	Added javaEventLoop to handle Java input.
# 	Added (non instproc) procedures to send and receive
# 	i/o from Java and to log same.
# 	[1997/07/10  18:51:28  Richard_Taft]
# 
# Revision 1.1.2.51  1997/07/03  20:53:09  Deepa_Bachu
# 	Modified defDir to be set to "/usr/share/sysman/suit"
# 	unless the env variable SUITDIR is set.
# 	[1997/07/03  20:52:44  Deepa_Bachu]
# 
# Revision 1.1.2.50  1997/06/19  15:26:46  Deepa_Bachu
# 	Added JAVA as a ui type and modified the sourcing
# 	of TK and Curses files when ui is JAVA.
# 	[1997/06/19  15:25:23  Deepa_Bachu]
# 
# Revision 1.1.2.49  1997/05/16  21:19:05  Deepa_Bachu
# 	Used the catalog method "exists" instead of checking
# 	return value null, for message catalogs.
# 	[1997/05/16  21:18:38  Deepa_Bachu]
# 
# Revision 1.1.2.48  1997/05/05  20:56:44  Deepa_Bachu
# 	Modified the catget instproc so that it accepts a
# 	null catalog list.
# 	[1997/05/05  20:56:15  Deepa_Bachu]
# 
# Revision 1.1.2.47  1997/05/02  19:28:52  Deepa_Bachu
# 	Added the missing close-brace.
# 	[1997/05/02  19:28:10  Deepa_Bachu]
# 
# Revision 1.1.2.46  1997/05/02  19:04:29  Deepa_Bachu
# 	bmerged the file prior to submission
# 	[1997/05/02  19:03:54  Deepa_Bachu]
# 	Modified the catget method to traverse through the
# 	list of catalogs or return the default string (if
# 	specified) or the widget name.
# 	[1997/05/02  14:25:16  Deepa_Bachu]
# 	Added ability to specify the -catalog option.
# 	Added the ability to look for tags in multiple catalogs.
# 	[1997/05/01  18:41:24  Deepa_Bachu]
# 
# Revision 1.1.2.45  1997/05/01  19:34:06  William_Athanasiou
# 	Fixed function argument definition for helpView/helpOn
# 	[1997/05/01  19:28:33  William_Athanasiou]
# 	Updated for use with Fred's new catalog system
# 	[1997/05/01  16:45:05  William_Athanasiou]
# 
# Revision 1.1.2.44  1997/04/24  20:39:51  William_Athanasiou
# 	Added helpOn functionality
# 	[1997/04/24  16:08:08  William_Athanasiou]
# 
# Revision 1.1.2.43  1997/04/09  16:30:37  William_Athanasiou
# 	Added scrolledtext to list of GUI files to load
# 	[1997/04/09  16:17:34  William_Athanasiou]
# 
# Revision 1.1.2.42  1997/03/28  16:46:38  William_Athanasiou
# 	 	** Merge Information **
# 		** Command used:	bsubmit **
# 		** Ancestor revision:	1.1.2.40 **
# 		** Merge revision:	1.1.2.41 **
# 	 	** End **
# 	Postpone UI creation until first display for performance reasons
# 	[1997/03/28  16:28:07  William_Athanasiou]
# 
# Revision 1.1.2.41  1997/03/26  19:56:00  Todd_Moyer
# 	Added getUI method
# 	[1997/03/26  16:20:24  Todd_Moyer]
# 
# Revision 1.1.2.40  1997/03/17  21:08:40  William_Athanasiou
# 	Added unique session ID for web persistance
# 	[1997/03/17  21:07:39  William_Athanasiou]
# 
# Revision 1.1.2.39  1997/03/13  15:17:38  William_Athanasiou
# 	Added Curses Geometry management
# 	[1997/03/13  15:16:34  William_Athanasiou]
# 
# Revision 1.1.2.38  1997/03/07  19:07:59  William_Athanasiou
# 	Added geometry management for GUI
# 	[1997/03/07  19:05:24  William_Athanasiou]
# 
# Revision 1.1.2.37  1997/02/24  22:42:22  Deepa_Bachu
# 	 	** Merge Information **
# 		** Command used:	bsubmit **
# 		** Ancestor revision:	1.1.2.34 **
# 		** Merge revision:	1.1.2.36 **
# 	 	** End **
# 	Fixed typo in proc permGlobal.
# 	[1997/02/24  22:38:57  Deepa_Bachu]
# 	Removed "global ui" used instvar instead.
# 	[1997/02/24  22:31:46  Deepa_Bachu]
# 
# Revision 1.1.2.36  1997/02/24  19:17:26  William_Athanasiou
# 	 	** Merge Information **
# 		** Command used:	bsubmit **
# 		** Ancestor revision:	1.1.2.34 **
# 		** Merge revision:	1.1.2.35 **
# 	 	** End **
# 	Added infomsg class; and used dialogshell for suit windows
# 	[1997/02/24  19:10:46  William_Athanasiou]
# 
# Revision 1.1.2.35  1997/02/20  16:46:33  Todd_Moyer
# 	Replaced search for initCallBacks proc with the cbFile flag.
# 	[1997/02/20  16:45:50  Todd_Moyer]
# 
# Revision 1.1.2.34  1997/02/06  15:40:46  Deepa_Bachu
# 	removed debug statements.
# 	changed dirNdx to */cham from */sysman/cham.
# 	[1997/02/06  15:40:06  Deepa_Bachu]
# 
# Revision 1.1.2.33  1997/02/05  21:51:19  Deepa_Bachu
# 	not overridding the Tcl "global" command in the case
# 	of the WEB.
# 	renamed newGlobal --> permGlobal
# 	renamed _orig_global --> global
# 	[1997/02/05  21:49:41  Deepa_Bachu]
# 
# Revision 1.1.2.32  1997/01/30  20:35:10  Deepa_Bachu
# 	re-submit to correct merge mistake.
# 	[1997/01/30  20:34:41  Deepa_Bachu]
# 
# Revision 1.1.2.31  1997/01/30  19:59:31  Deepa_Bachu
# 	 	** Merge Information **
# 		** Command used:	bsubmit **
# 		** Ancestor revision:	1.1.2.29 **
# 		** Merge revision:	1.1.2.30 **
# 	 	** End **
# 	Modified newGlobal to accept a list of args.
# 	Checked if the variable is in the array before
# 	passing the it to regGlob.
# 	[1997/01/30  19:52:33  Deepa_Bachu]
# 
# Revision 1.1.2.30  1997/01/30  16:08:04  William_Athanasiou
# 	Removed all reference to 'main' and replaced w/ _UIT_g_main
# 	[1997/01/30  16:05:57  William_Athanasiou]
# 
# Revision 1.1.2.29  1997/01/27  23:01:21  Deepa_Bachu
# 	Removed the save of new version of winStack since it
# 	being taken care of by the "encode" method in "State".
# 	[1997/01/27  23:01:00  Deepa_Bachu]
# 
# Revision 1.1.2.28  1997/01/27  22:54:32  Deepa_Bachu
# 	 	** Merge Information **
# 		** Command used:	bsubmit **
# 		** Ancestor revision:	1.1.2.26 **
# 		** Merge revision:	1.1.2.27 **
# 	 	** End **
# 	Added proc newGlobal to override the Tcl "global"
# 	command for the WEB UI.
# 	Added methods regObj and regGlob to register objects
# 	and globals respectively, in order to save state.
# 	Modified methods restore and save. "save"  provides
# 	a list of values of the "main" object that need to
# 	be saved and restore, reinitializes the values.
# 	[1997/01/27  22:45:31  Deepa_Bachu]
# 
# Revision 1.1.2.27  1997/01/24  14:29:22  William_Athanasiou
# 	Save new version of winStack after lvarpop
# 	[1997/01/24  14:27:35  William_Athanasiou]
# 
# Revision 1.1.2.26  1997/01/22  18:54:15  Deepa_Bachu
# 	commented the code that was written to remove the
# 	extra braces around _winStack, since cham.cgi now
# 	uses ctoken that returns a list.
# 	[1997/01/22  18:53:03  Deepa_Bachu]
# 	Added code to save and restore the _winStack variable.
# 	Modified _popDisplayStack since the WEB appended an
# 	extra set of braces.
# 	[1997/01/17  20:45:36  Deepa_Bachu]
# 
# Revision 1.1.2.25  1997/01/16  15:42:26  William_Athanasiou
# 	Added window initCB, which is done after kids
# 	[1997/01/16  15:39:29  William_Athanasiou]
# 
# Revision 1.1.2.24  1997/01/16  14:24:13  William_Athanasiou
# 	 	** Merge Information **
# 		** Command used:	bsubmit **
# 		** Ancestor revision:	1.1.2.22 **
# 		** Merge revision:	1.1.2.23 **
# 	 	** End **
# 	Prepend _UIT_ to all classes and globals
# 	[1997/01/15  21:13:09  William_Athanasiou]
# 
# Revision 1.1.2.23  1997/01/15  19:27:25  Todd_Moyer
# 	Added otherResourcs attribute so the system would fetch resources
# 	  in addition to those that are directly associated with widget(s).
# 	[1997/01/15  19:22:25  Todd_Moyer]
# 
# Revision 1.1.2.22  1997/01/10  16:20:54  Deepa_Bachu
# 	Removed instance of Maker called $self.maker.
# 	Deleted the method make since gensym is being
# 	used instead.
# 	[1997/01/10  16:18:56  Deepa_Bachu]
# 
# Revision 1.1.2.21  1997/01/08  21:10:19  Deepa_Bachu
# 	Changed the object preserveState _state and added methods
# 	save, restore and remove.
# 	[1996/12/30  18:06:50  Deepa_Bachu]
# 	Created an instance preserveState of Class State.
# 	[1996/12/23  21:31:37  Deepa_Bachu]
# 
# Revision 1.1.2.20  1996/12/23  16:38:15  William_Athanasiou
# 	added instvar _winstack
# 	[1996/12/23  16:28:53  William_Athanasiou]
# 
# Revision 1.1.2.19  1996/12/20  19:36:22  William_Athanasiou
# 	Fixed winStack problem.  Windows not being popped
# 	[1996/12/20  19:34:10  William_Athanasiou]
# 	_popDisplayStack: Fixed incorrect check of top of stack.
# 	[1996/12/18  19:33:20  William_Athanasiou]
# 
# Revision 1.1.2.18  1996/12/12  16:48:42  William_Athanasiou
# 	Added call to widget Read function to update values
# 	[1996/12/12  16:35:19  William_Athanasiou]
# 
# Revision 1.1.2.17  1996/12/09  20:12:05  Deepa_Bachu
# 	Changed the Class "Cham" to "Main".
# 	[1996/12/09  20:11:38  Deepa_Bachu]
# 
# Revision 1.1.2.16  1996/11/27  23:22:39  Todd_Moyer
# 	Moved the resource tree here from the windows.
# 	Added a write method.
# 	[1996/11/27  23:00:47  Todd_Moyer]
# 
# Revision 1.1.2.15  1996/11/25  15:29:46  Deepa_Bachu
# 	renamed popStack     -> _popDisplayStack
# 	and     displayWin   -> _pushDisplayStack
# 	passed the arguement $self to _popDisplayStack to ensure
# 	that only the top most window in the stack can be popped.
# 	[1996/11/25  15:23:52  Deepa_Bachu]
# 
# Revision 1.1.2.14  1996/11/22  20:50:08  Deepa_Bachu
# 	Added the _winStack attribute to keep track of the windows
# 	to be displayed and in which order.
# 	[1996/11/22  20:44:11  Deepa_Bachu]
# 
# Revision 1.1.2.13  1996/11/21  15:14:11  William_Athanasiou
# 	Replaced simple catch of problems with catch of CB file to
# 	   a check of file exists.  If the file doesn't exist, check
# 	   for the existance of a proc initCallBacks, and run it if
# 	   it exists.  This allows the callbacks to be declared in
# 	   the same file as the genuid.
# 	Source the TKutils/Ctkutils files in by hand instead of by using
# 	   the autoindex functionality.  This is significantly faster and
# 	   removes the problem of sysmansh including these directories by
# 	   default, since a tclIndex isn't needed anymore.
# 	[1996/11/21  15:11:15  William_Athanasiou]
# 
# Revision 1.1.2.12  1996/10/18  20:26:11  William_Athanasiou
# 	Fixed problem with executing cham scripts outside of sysman/cham dir.
# 	[1996/10/18  20:15:15  William_Athanasiou]
# 
# Revision 1.1.2.11  1996/10/11  20:05:19  William_Athanasiou
# 	Fixed problem with autopath and new sysmanshc
# 	[1996/10/11  20:02:57  William_Athanasiou]
# 
# Revision 1.1.2.10  1996/10/07  16:17:13  William_Athanasiou
# 	Fixed ui terminology collision with sysmansh.  Sysman used
# 	gui, Chameleon used GUI.  Sysman used cli, chameleon needed
# 	WEB.
# 	[1996/10/07  16:16:14  William_Athanasiou]
# 
# Revision 1.1.2.9  1996/10/01  19:37:04  William_Athanasiou
# 	auto_index should be declared as global scope
# 	[1996/10/01  19:35:38  William_Athanasiou]
# 
# Revision 1.1.2.8  1996/10/01  14:26:23  William_Athanasiou
# 	unset auto_index when changing auto_path
# 	[1996/10/01  14:21:36  William_Athanasiou]
# 
# Revision 1.1.2.7  1996/10/01  13:31:36  William_Athanasiou
# 	added code to fix auto_path sysmansh automatically generates
# 	[1996/10/01  13:27:17  William_Athanasiou]
# 
# Revision 1.1.2.6  1996/09/25  22:18:08  Todd_Moyer
# 	Take out debug statement.
# 	[1996/09/25  22:17:14  Todd_Moyer]
# 	Added Ctk and TK to auto_path.
# 	[1996/09/25  22:11:09  Todd_Moyer]
# 
# Revision 1.1.2.5  1996/09/24  17:05:15  Todd_Moyer
# 	Made call to cgiCB conditional for the WEB only.
# 	[1996/09/24  17:04:37  Todd_Moyer]
# 
# Revision 1.1.2.4  1996/09/06  18:41:00  Todd_Moyer
# 	Made into a class and encapsulated domain, catalog and maker.
# 	[1996/09/06  18:26:05  Todd_Moyer]
# 
# Revision 1.1.2.3  1996/09/03  20:22:50  Todd_Moyer
# 	Use g_parent instead of g_parentStak.
# 	[1996/09/03  19:35:38  Todd_Moyer]
# 
# Revision 1.1.2.2  1996/08/30  18:40:56  Deepa_Bachu
# 	Created this file to control the initialization and Run routines.
# 	[1996/08/30  17:30:59  Deepa_Bachu]
# 
# 
# $EndLog$
# 
# @(#)$RCSfile: cham.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:36 $

#@ This object takes care of a lot of housekeeping for Suit.
#@ There must be exactly one of them in each Suit application.
#@ All other objects are contained within it.

Class Main -superclass "_UIT_Tree _UIT_Param"


# Create this Class (not instance) variable to keep track of other
#   classes that want to be notified when Suit is finished with its
#   initialization.

Main set _startNotifyClasses ""
Main set _started            0


#@ Create this Class (not instance) method to see that the specified class
#@   is notified when the suit is initialized.  If it's already init, the
#@   class is notified immediately.  If not, it's added to the
#@   list of classes to be notified when Suit finished initializing.
#@   Relies on the fact that there will only be one instance of this
#@   class.  Needs to be at class level because needed before instances
#@   created.

Main proc regForStartNotify {className} {

    # If sys already ready, notify immediately.  Otherwise
    #   note the class for later notification.
    if {[Main set _started]} {
	catch "$className sysReadyCB"
    } else {
	set       classList            [Main set _startNotifyClasses]
	lappend   classList            $className
	Main set  _startNotifyClasses  $classList
    }
}



Main instproc init {contents args} {
   global argc argv auto_path env _UIT_g_main SysmanDir
   
   $self instvar catalog dataImp otherResources ui
   $self instvar _contextMgr _status _winStack _splash

   set time [getclock]
   # set ui instvar.  defaults to CURSES
   set ui CURSES
   if {[info exists env(SYSMANUI)]} {
      set NewUI [string toupper $env(SYSMANUI)]
      switch -exact -- $NewUI {
	 GUI {
	     set ui GUI
	 }
         JAVA { 
	    set ui JAVA
	    rename exit _tcl_orig_exit
	    proc exit {{exitcode 0}} {
	       putJava "_UIT_EXIT"
	       _tcl_orig_exit $exitcode
	    }
	 }
	 CUI -
	 CURSES -
	 default {
	    global tk_port
	    if {[info exists tk_port] && [cequal "curses" $tk_port]} {
	       set env(SYSMANUI) cui
	       set SysmanUi cui
	       set ui CURSES
	       ctk_refresh       ;# jump back into curses screen mode
	       global tk_strictMotif; set tk_strictMotif 0
	    } else {
	       puts stderr "SysMan does not run in $env(SYSMANUI) mode"
	       puts stderr "\tcheck supported arguments or SYSMANUI environment variable."
	       exit 1
	    }
	 }
      }
   }

    set dataImp        DMI
    set otherResources {}
    $self set currParent  $self
    $self set currWin     ""
    $self set _winStack   ""

    # read in additional catalogs
    set catalog ""

    # By default, look for callbacks in the file mainObjName.cb.tcl.
    # They can be put in the GenUID file, but some need to be inside the
    #   main object.
    $self set cbFile         1

   # do parents init
   eval $self next $args

   set _splash 1
   getArgs -splash _splash
   if { $_splash != 0 && $_splash != 1 } {
       set _splash 1
   }

   if {[info exists env(_SUIT_SPLASH_SCREEN)] != 0} {
       set _splash $env(_SUIT_SPLASH_SCREEN)
   }

   if { $_splash } {_UIT_SplashScreen splashWin $ui "Starting SysMan"}

   # initialize old and new global names
   set _UIT_g_main $self

   # If app exiting without calling a callback (by Control-c for example),
   # give opportunity for cleanup.
   signal trap {SIGINT SIGPIPE} _UIT_exitCB

   # Create an object to manage receiving and reporting changes to this
   #   suitlet's execution context (focus).  It will initialize the
   #   context from the -sysmancontext command-line option if given.
   getArgs -sysmancontext initContext
   set _contextMgr [ContextMgr gensym $self $initContext]

   if {[info exists env(SUITDIR)]} {
	set defDir $env(SUITDIR)
   } else {
        global SysmanDir
   	set defDir "${SysmanDir}/suit"
   }

   if { $_splash } { splashWin update "." }

   # Load in general purpose files, since they will almost always be used.
   source $defDir/chamwdgt.tcl
   source $defDir/super.tcl
   source $defDir/contain.tcl
   source $defDir/buttongen.tcl
   source $defDir/geogen.tcl
   source $defDir/wingen.tcl

   # This class is partly in OTcl and partly in C.  For some
   #   reason it isn't getting autoloaded.
   source ${SysmanDir}/utils/evm.tcl

   # Load Domain, Catalog and scripting modules.
   source $defDir/domain.tcl
   source $defDir/cat.tcl
   source $defDir/scriptor.tcl

   # if ui isn't the web add additional utilities to our auto_path.
   
   if {![cequal WEB $ui] && ![cequal JAVA $ui]} {
      # lvarpush auto_path $defDir/TKutils
      source $defDir/TKutils/Archetype.tcl
      source $defDir/TKutils/Widget.tcl
      source $defDir/TKutils/Toplevel.tcl
      if [cequal CURSES $ui] {
	 bind all <Control-c> { kill SIGINT [pid] }
	 source $defDir/curkeys.tcl
	 bind all <Control-g> { _UIT_showCursesKeys }
	 bind all <Control-l> { ctk_endwin; ctk_refresh }
	 source  $defDir/Ctkutils/labeledwidget.tcl
	 source  $defDir/Ctkutils/pushbutton.tcl
	 source  $defDir/Ctkutils/entryfield.tcl
	 source  $defDir/Ctkutils/buttonbox.tcl
	 source  $defDir/Ctkutils/scrolledlistbox.tcl
	 source  $defDir/Ctkutils/dialogshell.tcl
	 source  $defDir/Ctkutils/scrolledtext.tcl
	 source  $defDir/Ctkutils/paddedframe.tcl
	 source  $defDir/Ctkutils/mclistbox.tcl
      } else {
	 #@ calculate some global attributes that need to be used through
	 #@ out the code.
	 global _UIT_DisplayAttr; entry .e_UIT_ENTRY; button .b_UIT_BUTTON
	 array set _UIT_DisplayAttr \
	     [list \
		  EntryFont          [list [.e_UIT_ENTRY cget -font]] \
		  EntryBackground    [.e_UIT_ENTRY cget -background] \
		  EntryForeground    [.e_UIT_ENTRY cget -foreground] \
		  LabelFont          [list [.b_UIT_BUTTON cget -font]] \
		  Foreground         [.b_UIT_BUTTON cget -foreground] \
		  Background         [.b_UIT_BUTTON cget -background] \
		  DisabledForeground [.b_UIT_BUTTON cget -disabledforeground]]

	 set _UIT_DisplayAttr(normal) $_UIT_DisplayAttr(Foreground)
	 set _UIT_DisplayAttr(disabled) $_UIT_DisplayAttr(DisabledForeground)
	 set _UIT_DisplayAttr(EntryNonEditable) $_UIT_DisplayAttr(Background)
	 if [cequal $_UIT_DisplayAttr(EntryNonEditable) \
		 $_UIT_DisplayAttr(EntryForeground)] {
	    set _UIT_DisplayAttr(EntryNonEditable) \
		$_UIT_DisplayAttr(EntryBackground)
	 }
	 destroy .e_UIT_ENTRY .b_UIT_BUTTON
	 
	 source  $defDir/TKutils/labeledwidget.tcl
	 source  $defDir/TKutils/pushbutton.tcl
	 source  $defDir/TKutils/entryfield.tcl
	 source  $defDir/TKutils/buttonbox.tcl
	 source  $defDir/TKutils/scrolledlistbox.tcl
	 source  $defDir/TKutils/scrolledtext.tcl
	 source  $defDir/TKutils/dialogshell.tcl
	 source  $defDir/TKutils/paddedframe.tcl
	 source  $defDir/TKutils/mclistbox.tcl
	 source  $defDir/TKutils/mcscrolledlist.tcl
      }
   } else {
      # overriding the Tcl global command to be able to store
      # it in FORM HIDDEN variables.
      ### this has been commented because in lieu of "global" we are
      ### defining a new method called permGlobal
      ###rename global _orig_global
      ###rename newGlobal global
   } 
   
   # Find out where application is running and add its directory to the 
   # auto_path.  The callback and catalog file should reside in that
   # directory as well.

   if { $_splash } { splashWin update "." }

   $self instvar chamAppDir
   if {[info exists env(CHAM_APP_DIR)]} {
      set chamAppDir $env(CHAM_APP_DIR)
   } else {
      global argv0
      set chamAppDir [file dirname $argv0]
      if {[string index $chamAppDir 0] != "/"} {
	 set chamAppDir [format "%s/%s" [pwd] $chamAppDir]
      }
   }
   lvarpush auto_path $chamAppDir
 
   set nlsDir /usr/lib/nls/msg/en_US.ISO8859-1
   set i18nDir ${SysmanDir}/i18n

   if { $_splash } { splashWin update "." }

   # Pass nested command line args to the scriptor.
   #  Use nested args in style similar to sysmancontext
   getArgs -sysmanscriptargs scriptargs
   # @@@ temporary hack for evm viewer
   if {[cequal $scriptargs ""] &&
       [info exists env(SYSMANSCRIPTARGS)]} {
       set scriptargs $env(SYSMANSCRIPTARGS)
   }

   $self set _scriptor  [eval _UIT_Scriptor  $self.scr  $scriptargs]
   $self set _dom            [_UIT_Domain    $self.dom  $ui]
   $self set _cat            [_UIT_Catalog   $self.cat  $self.msg]
   $self set _i18ncat        [_UIT_Catalog   i18n.cat   \
				  i18n_motif_shared_text.msg]
   foreach msgCatalog $catalog {
	_UIT_Catalog $msgCatalog $msgCatalog 
   }

   # the first initialization callback
   # widgets have not be created yet nor has data been fetched.
   # This is not a method and cannot be in the *.cb.* file because
   # it must be defined before the main object and widgets.
   # There is no default because if it exists it will already be defined
   # when this file is loaded.
   if { ! [cequal [info proc startCB] ""]} {
       startCB
   }

   $self set _resTree   [_UIT_ResrcTree $self.resTree [$self set dataImp]]
   $self set _helpWin   [_UIT_Help${ui} gensym]

   $self instvar _resTree
   foreach res [$self set otherResources] {
       $self addResrc $res
   }
   
   if { $_splash } { splashWin update "." }

   # create child windows and their child widgets.
   # this also creates a resource tree that the widgets hold pointers to.
   eval $contents

   if { $_splash } { splashWin update "." }

   # if callbacks in separate file (the default), try to source them in.
   # Otherwise, assume there either aren't any, or they are with the GenUID.
   if {[$self set cbFile]} {
       if {[file exists $chamAppDir/$self.cb.tcl]} {
	   # Read in the user defined callbacks for each of the widgets.
	   # must source manually cause autoloader doesnt look for overrides
	   source $chamAppDir/$self.cb.tcl
       } else {
	   set    msg "Can't find callback file $chamAppDir/$self.cb.tcl.\n"
	   append msg "If there are no callbacks, "
	   append msg "set the main object's -cbFile flag to zero."
	   error $msg
       }
   }

   if { $_splash } { splashWin update "." }

   # the second initialization callback
   # widgets have been created, but the data has not yet been fetched
   $self predataCB

   # Fill in the resource tree from the data layer.
   # If there are issues, the developer can do something with them and then
   # continue or exit.
   set _status [$_resTree read]
   if {! [cequal $_status ""]} {

       # Acknowlege to the parent that we've at least started even if we
       #  are most likely going to exit
       $self acknowledgeParent

       set _status [$self initErrorCB]
       # if status not reset, exit
       if {! [cequal $_status ""]} {
	   exit
       }
    }

    # Foreach window populate its widgets from 
    #   data gathered in the resource tree.
    foreach w [$self set _kids] {
	$w read
    }

   if { $_splash } { splashWin update "." }
   # do developer-specified init
   foreach w [$self set _kids] {
      $w doInitCB
   }

   # Initialize unique Session Id.
   $self _initIdent

   if {$_splash} { splashWin withdraw 1 "." }

   # Draw all the windows to be displayed.
   foreach w [$self set _kids] {
       if {[$w isInitDisplay]} {
	   $w display
       }
   }

   # Acknowlege to the parent that we've started if needed
   $self acknowledgeParent

   # the third and last initialization callback
   $self initCB

   # Create a hook to clean up for normal termination
   rename exit origExit
   proc exit {{returnCode 0}} "
       $self destroy
       origExit \$returnCode
   "

   # Ready to start.  Need to notify any classes that asked for a callback.
   Main set _started 1
   foreach class [Main set _startNotifyClasses] {
       catch "$class sysReadyCB"
   }

   # @@@ This Timer start should be changed use the previous
   # @@@   "sysReadyCB" feature.
   # Start all file level and GenUID timers
   foreach t [Timer info instances] {
       set state [$t state]
       # Only start timers that aren't already on
       if {[cequal $state off] } {
	   $t start
       }
   }
   # Setting the class variable immediateStart lets 
   # timers know that they can start as soon as
   # their declaration is executed.
   Timer set immediateStart 1

   if [cequal JAVA $ui] {

       $self javaEventLoop
   }
}



Main instproc destroy {} {
    $self instvar _scriptor

    $_scriptor destroy
}



# ====================== public methods ==============================
#@ Add the specified resource to the window's resource tree if it isn't
#@ already there.
#@ Return the resource object's name if the ID is only a type and resource
#@ name (such as a list would have).  Or if the ID also includes an
#@ attribute name (such as the other super widgets would have), return
#@ the resource's expanded (such as the other super widgets would have),
#@ return the resource's expanded record buffer.
 
Main instproc addResrc {resrcID} {
    [$self set _resTree] addResrc $resrcID
}


# ---------------------------------------------------
#@ Get the specified catalog entry on another object's behalf.
#@
#@ Arguments:
#@    instance - symbolic message id prefix to fetch from the catalog
#@    ext      - message catalog suffix for the message id
#@    dstr     - default string. 
#@    args     - optional parameters to substitute into the message 
#@		(i.e. $1%s, $2%s, etc)
#@ Notes: 
#@    The concept of a default string is an anachronism from traditional
#@    (.cat) message catalogs. If the string you request can't be fetched
#@    the default string will be returned. 


Main instproc catget {inst ext {dstr {}} args} {
    $self instvar _cat _i18ncat

    set catalogList ""
    if {[$self set catalog] != ""} {
	set catalogList "$_cat [$self set catalog]"
    } else {
	lappend catalogList $_cat
    }
    set tag [translit . _ $inst]_$ext

    # The "catalog" can be a search list of catalogs. Search them 
    # in order and return the first occurrence. 
    foreach value $catalogList {
        if [$value _exists $tag] {
		return [eval $value _get $tag $args]
	}
    }

    ## search through the i18ncatalog by stripping
    ## of the window name and extension and widget name
    ## where necessary. 
    set i18ninst "i18n_[lindex [split $inst .] end]_txt"
    if [$_i18ncat _exists $i18ninst] {
	return [eval $_i18ncat _get $i18ninst $args]
    }
  
    # If we reach here, there we couldn't find the requested message
    # in the catalog search list nor the i18n catalog. 
    if [cequal $dstr ""] {	;# If there is no default string
	return $inst		;# Return the message id itself
    } else {			;# Else return the default string
        return $dstr
    }
}    



# ---------------------------------------------------
#@ Get the specified locid entry on another object's behalf.

Main instproc catgetid {{symbol {}}} {
   [$self set _cat] get $symbol
}


#-----------------------------------------------------
#@ Default callback for Suitlet child exit hook.  
#@ Once call is made the child instance is no longer
#@ valid. 
#@
#@ Arguments:
#@    instance - Name of child process instance object
#@    exitpid  - Pid of exiting child
#@    exitstr  - The exit string value (see 'wait')
#@    exitval  - The exit value of the child process
#@    
#@ 

Main instproc childExitCB {instance exitpid exitstr exitval} {
return
}


#-----------------------------------------------------
#@ Default callback for another app changing this suitlet's focus.

Main instproc contextChangeCB {} {
    # puts "  default contextChangeCB"
    return
}


#-----------------------------------------------------
#@ Default callback for exiting by Control-c.

Main instproc exitCB {} {
    # puts "  default exitCB"
    return
}


# ---------------------------------------------------
#@ Returns the string that was initialized by the command-line -sysmancontext
#@ switch, or set later from another app via an event.  It will be "" if not
#@ specified.  The meaning of this value is defined by each application.

Main instproc getContext {} {
    $self instvar _contextMgr

    return [$_contextMgr getContext]
}



# ---------------------------------------------------
#@ Return the name of the window that is on top in the stacking order
#@ or {} if none.

Main instproc getTopWin {} {
   return [lindex [$self set _winStack] 0]
}



# ---------------------------------------------------
#@ Will return GUI, CURSES, WEB or JAVA.
#@ Should be used sparingly, as overuse will defeat the goal
#@ of "write generic, run native"

Main instproc getUI {} {
    $self set ui
}



#-----------------------------------------------------
#@ Default callback once initialization is over (just before first window
#@ is displayed).

Main instproc initCB {} {
    # puts "  default initCB"
    return
}



#-----------------------------------------------------
#@ Default callback if there's any trouble with initialization.
#@ Return null string if problem corrected, or non-null if fatal problem.

Main instproc initErrorCB {} {
    global _UIT_g_main
    $self instvar _status

    # filter out redundant msgs
    set flt {}
    foreach stat $_status {
	if {![info exists got($stat)]} {
	    lappend flt $stat
	    set got($stat) 1
	}
    }

    InfoMsg error [join $flt "\n"] "$_UIT_g_main: Error" 1
    return $_status
}



#-----------------------------------------------------
#@ Default callback for after widgets are created but before data is fetched.

Main instproc predataCB {} {
    # puts "  default predataCB"
    return
}



# ---------------------------------------------------
#@ Remove the window from the window stack

Main instproc popDisplayStack {win} {
    global _UIT_g_main

    $self instvar _winStack

    # restore the value of _winStack from the hidden field
    # set _winStack [$_UIT_g_main restore _winStack]

    # Only the top most window in the stack is
    # allowed to be popped since the windows
    # are modal.

    if [cequal [lindex $_winStack 0] $win] { 
       lvarpop _winStack
       # $_UIT_g_main save _winStack $_winStack
    } else {
       error \
       "OutOfOrder hide: $win is not top window of display stack ($_winStack)"
    }
}


# ---------------------------------------------------
#@ Add the specified window to the window stack

Main instproc pushDisplayStack {win} {
   global _UIT_g_main

   $self instvar _winStack
   if {[lindex $_winStack 0] != $win} {
      lvarpush _winStack $win
   }

   # save _winStack as a hidden variable
   # $_UIT_g_main save _winStack $_winStack
}    


# ---------------------------------------------------
#@ Pass through proc for recording test scripts.  Called whenever a script
#@   trigger is tripped (usually a push button activation).

Main instproc scriptOperCB {trigger} {
    $self instvar _scriptor

    $_scriptor scriptOperCB $trigger
}


# ---------------------------------------------------
#@ Pass through proc for playing test scripts.  Called whenever an
#@   InfoMsg box is displayed.

Main instproc scriptInfoMsgHandler { infoMsgObj } {
    $self instvar _scriptor

    $_scriptor infoMsgHandler $infoMsgObj
}


# ---------------------------------------------------
#@ Publish this suitlet's focus via an event for any app that cares to listen.
#@ The meaning of this value is defined by each application.

Main instproc setContext {newContext} {
    $self instvar _contextMgr

    $_contextMgr setContext $newContext
}



# ---------------------------------------------------
#@ Write all data back to data layer.

Main instproc write {} {
    [$self set _resTree] write
}


#-----------------------------------------------------
# Methods to create and return a unique identifier.  
# The identifier is based on the initial process pid
# and the time of identifier creation.
#-----------------------------------------------------

Main instproc _initIdent {} {
   permGlobal _UIT_SessionId
   set _UIT_SessionId [pid][getclock]
}

Main instproc getIdent {} {
   permGlobal _UIT_SessionId
   return $_UIT_SessionId
}

#-----------------------------------------------------

Main instproc setHelpName {appname} {
   [$self set _helpWin] setHelpName $appname
}

Main instproc setHelpVolume {filename} {
   [$self set _helpWin] setHelpVolume $filename
}

Main instproc helpOn {{locid {}}} {
   [$self set _helpWin] viewHelp $locid
}

#-----------------------------------------------------
#@ 
#@ Handle any parent/child communications
#@ 

Main instproc acknowledgeParent {args} {
   global env
   $self instvar _acked ui
   #
   #  If we've already been here, then just get out
   #
   if [info exists _acked] {
      return
   } else {
      set _acked 1
      if [info exists env(_SYSMAN_CHILD_PROCESS)] {
	 if ![cequal $ui JAVA] {
	    puts stderr " PID"
	 }
      }
   }
}

#-----------------------------------------------------
#@ If application terminating abnormally (like by Control-c),
#@ give it a chance to clean up.

proc _UIT_exitCB {} {
    global _UIT_g_main

    $_UIT_g_main exitCB
    exit
}




# ======================= Start of Java Specific Code ==================

if {[cequal [string toupper $SysmanUi] JAVA]} {

global javaInputQ
set javaInputQ {}

#-----------------------------------------------------
#@ Wait for input from a Java front end, and execute the commands received.
#@ Don't stop until a blank line is received.  Insure that this
#@ is done in the background so that full async processing can occur
#@ in the java client and suit server.

Main instproc javaEventLoop {} {

    putJava "ACCEPT"
    while {[getJava line false] >= 0 } {
	if { [cequal $line "\04EOF\04"] } {
	    logMsg "Received blank line: $line"
	    exit
	} else {
	    # Eval the callback
   	    logMsg  "CLIENT: $line"
	    if [catch {eval $line} msg] {
		logMsg "$msg"
		error $msg
	    } else {
		
		# Tell the server that we're done
		putJava "ACCEPT"
	    }
	}
    }
}

#-----------------------------------------------------
# Methods relating to Java interaction
#-----------------------------------------------------

proc getJava_background_io {} {
    global javaInputQ 

    logMsg "ReadRequest" "(RR>>)"
    set n [gets stdin line]

    if {$n > 0} {
        set lline [revertXferString $line]
        logMsg "$lline" "(JJ>>)"
        lappend javaInputQ [list $lline]
    } else {
        logMsg "<EMPTY STRING>" "(JJ>>)"
    	lappend javaInputQ {}
    }
}

proc TRACE {args} {
    global _cmdtraceFd argv0

    if { ! [ info exists _cmdtraceFd ] } {

        #
        # Enable some debugging if needed.  By putting "on" in
        #  the file /tmp/SUITTRACE, debugging is enabled with
        #  cmdtrace mode
        #

        set _cmdtraceFd {}
        if {[file exists /tmp/SUITTRACE]} {
            set appname [file rootname [file tail $argv0]]

	    # Try to open a log file for debugging purposes.
	    # Don't sweat it if something goes wrong.
	    if { [catch { 
		# Open a log file safely
		lassign [sm_sectmpopen ${appname}.log] _cmdtraceFd fname } msg 
		 ] } {
    
                # If file fails to open, return quietly
                return
            }

            # Log file is open.  Print a nice header.
            puts $_cmdtraceFd "-----------------------------------------------"
            puts $_cmdtraceFd \
		"Process [pid] has established communication with Java"
            puts $_cmdtraceFd ""
            puts $_cmdtraceFd "J => Events and values sent by Java to SUIT"
            puts $_cmdtraceFd "S => Commands and requests sent by SUIT to Java"
            puts $_cmdtraceFd \
		"= => Information from SUIT written only to the log"
            puts $_cmdtraceFd ""
    
            set mode [read_file -nonewline /tmp/SUITTRACE]
            if {$mode != {}} {
                cmdtrace $mode $_cmdtraceFd
            }

        } else {
            return
        }
    }

    if {$_cmdtraceFd != {}} {
        puts $_cmdtraceFd $args
        flush $_cmdtraceFd
    }

}

fconfigure stdin -blocking true -buffering none -buffersize 4096
fileevent stdin readable getJava_background_io

proc getJava {name {blocking {true}}} {
    upvar $name line
    global javaInputQ 

    logMsg "ReadRequest: blocking=$blocking $javaInputQ" "JJ"

# If we don't want to block (the JavaEventLoop) then we
#  need to enable a fileevent so that our background
#  I/O handler will do the work and other asnyc processing
#  can occur.  (Client initiated button press for example)
#
#  If we do want to block (getval type call) then we need
#   to insure that we don't loose any I/O
#

    # idx is the index in the input queue to return.
    # If the call is blocking, this is important since
    # we don't want to return a command sent from Java
    # when the suitlet expects an answer to a query.
    set idx 0

    if {$blocking == "false"} {
        while {$javaInputQ == {}} {
            vwait javaInputQ
        }
    } else {

# Tiny race condition here, if the I/O has just completed
#  after testing javaInputQ then we potentially are
#  processing the request via the fileevent callback.
#  When it completes we will then issue the command
#  below and block waiting on a read that will never come.
#  We basically need a test & set instruction here to
#   test & set a flag on the javaInputQ ...

      # This is a blocking read.  Only return
      # something that's not a callback.
      set idx [firstNoncallback $javaInputQ]

      # Keep trying until something is in the
      # queue and that something is not a callback
      while {$javaInputQ == {} || $idx < 0} {
	  #  =>> the race condition is on ...
	  getJava_background_io
	  set idx [firstNoncallback $javaInputQ]
      }
  }

    # Pop the expected input from the queue
    set line [join [lvarpop javaInputQ $idx]]
    
    logMsg $line "JJ"
    logMsg ">>$javaInputQ\n" "JJ"

    return [string length $line]
}

# Return the index of the first element in Q that doesn't
# resemble a callback method.  If Q is empty or there are
# no non-callback elements, then return -1
proc firstNoncallback {Q} {

    if {$Q == {}} {
	return -1
    }

    set qLength [llength $Q]
    set i 0
    while {$i < $qLength && [isCallback [join [lindex $Q $i]]]} {
	incr i
    }

    if {$i >= $qLength} {
	# Couldn't find a non-callback element
	return -1
    } else {
	# Found a non-callback element.  Return its index.
	return $i
    }
}

# Return 1 if the line looks like one of the callbacks that the
# Java client sends to SUIT.
proc isCallback {line} {
    # The callbacks are of the form "widget.name callbackCB"
    set callBackRegExp {^[^      ]+[     ]+(.+)CB$}  ;# space-tab inside []
    # Except for "widget.name _columnSortColumnName"
    set otherRegExp    {^[^      ]+[     ]+_columnSort[^      ]$}  ;# those too

    # If it looks like a callbackCB, check to see that it is
    # really one of the four official ones
    if { [regexp $callBackRegExp $line match cbType] &&
	 ([cequal $cbType "change"] || [cequal $cbType "invoke"] ||
	  [cequal $cbType "doubleClk"] || [cequal $cbType "singleClk"]) } {
	return 1
    } elseif { [regexp $otherRegExp $line] } {
	return 1
    } else {
	return 0
    }
}



#-----------------------------------------------------

proc putJava {line} {
    logMsg $line "S"
    server_send stdout "$line \"
#    puts stdout $line
}    

#-----------------------------------------------------

proc putJava_noNL {line} {
    logMsg "$line \\" "S"
    server_send -nonewline stdout $line
#    puts -nonewline stdout $line
}    

#-----------------------------------------------------

}

# ======================= End of Java Specific Code ==================




#-----------------------------------------------------

proc logMsg {msg {mtype "="} } {
    set now [fmtclock [getclock] "%e-%b-%Y %T"]
    TRACE "$mtype $now> $msg"
}

#-----------------------------------------------------
# Procs calling this are pure virtual.  This should only get executed if
# a developer forgot to define a pure virtual function in a subclass.

proc pureVirtual {class method} {
   error "Subclasses of class $class need a definition for method $method"
}


# DEPRECATED
# here because this was once need for the WEB UI

proc permGlobal {args} {
    foreach varName $args {
	uplevel global $varName
    }
}

Class _UIT_SplashScreen

_UIT_SplashScreen instproc init { ui {txt {}} } {
   global _UIT_SplashText${self}
   $self instvar _title _window _label _time _ui
   
   set _ui $ui
   if {[cequal $_ui "JAVA"]} then return
   
   set _time [clock seconds]
   wm withdraw .
   
   set _window [toplevel .splash -cursor watch]

   set w [winfo reqwidth $_window]
   set h [winfo reqheight $_window]
   set sw [winfo screenwidth $_window]
   set sh [winfo screenheight $_window]
   set reqX [expr {($sw-$w)/2}]
   set reqY [expr {($sh-$h)/2}]
   wm geometry $_window +${reqX}+${reqY}
   
   wm title $_window "SysMan: Information"
   
   set _label [label .splash.lbl -textvariable _UIT_SplashText${self} \
		   -width 24 -height 2 -anchor w]
   
   set _UIT_SplashText${self} $txt
   pack $_label -padx 10
   tkwait visibility $_window
   grab set $_window
   
   set _time [clock seconds]
}

_UIT_SplashScreen instproc update {txt} {
   $self instvar _time _ui
   
   if {[cequal $_ui "JAVA"]} then return

   global _UIT_SplashText${self}
   append _UIT_SplashText${self} $txt
   update idletasks
   
   set _time [clock seconds]
}


_UIT_SplashScreen instproc withdraw { {delay 0} {txt {}} } {
   $self instvar _window _time _ui
   
   if {[cequal $_ui "JAVA"]} then return
   
   if { ! [cequal $txt {}] } {
      $self update $txt
   }
   
   # Sleep only if window has not been showing for $delay seconds
   set sleepTime [expr $delay - ([clock seconds] - $_time)]
   if { $sleepTime > 0 } then { sleep $sleepTime }

   grab release $_window
   wm withdraw $_window
}


proc safeXferString {str} {
   set quote \01
   set newln \02
   set charnl \n
   append str $quote
   regsub -all $charnl $str $newln str
   return [cconcat $quote $str]
}

proc revertXferString {str} {
   set quote \01
   set newln \02
   set charnl \n
   regsub -all $newln $str $charnl str
   regsub -all $quote $str {\"} str
   return $str
}



# ----------------------------------------------------
#@ proc getArgs { argSought argVal }
#@ Look for command line argument and assign its value
#@ to a variable.  If not found, set the value to "".
#@   argSought: the argument to look for
#@   argVal: the variable to get the arg's value
#@
#@ If a suitlet were executed as follows:
#@   mysuitlet -moo 1
#@ a call to "getArgs -moo _moo" would result in _moo
#@ being set to 1


proc getArgs { argSought argVal } {
    upvar $argVal val
    global argv argc

    set val ""
    set argIdx [lsearch -exact $argv $argSought]
    if {($argIdx >= 0) && ($argIdx < $argc -1)} {
	set val [lindex $argv [expr $argIdx + 1]]
    }
}

# grab has a nasty habit of failing every-so-often.
# This piece of code will keep retrying until it
# doesn't fail.
if {[info command grab] != ""} {
    rename grab _tcl_orig_grab

    proc grab {args} {
       while {[catch {
	  set ret [eval {_tcl_orig_grab} $args]
       } msg]} {
	  ;
       }
       return $ret
    }
}
