# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: contain.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:36  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.9.1  2000/09/06  19:34:20  Peter_Wolfe
# 	Code drop for yankee bl2
#
# Revision 1.1.2.20  2000/04/12  18:41:39  Todd_Moyer
# 	Added hooks and procs to generate and play automated execution scripts.
#
# Revision 1.1.2.19  1999/12/02  19:26:34  Richard_Taft
# 	Retrieve value of currParent without setting it in fillContents
#
# Revision 1.1.2.18  1999/10/13  20:12:40  Richard_Taft
# 	In fillContents, save currParent and restore from saved value.
# 	Don't use "$self set _parent".
#
# Revision 1.1.2.17  1998/10/16  20:19:39  William_Athanasiou
# 	Remove space from inside initCB
# 	[1998/10/16  20:18:46  William_Athanasiou]
#
# Revision 1.1.2.16  1998/05/08  15:45:02  Todd_Moyer
# 	Added isChanged method.
# 	[1998/05/08  15:43:45  Todd_Moyer]
# 
# Revision 1.1.2.15  1998/01/29  20:02:47  Todd_Moyer
# 	Added optimize flag to read.
# 	[1998/01/29  19:43:29  Todd_Moyer]
# 
# Revision 1.1.2.14  1997/08/18  17:11:08  William_Athanasiou
# 	use _displayedOnce to denote that window/widget has been displayed at least once
# 	[1997/08/18  16:49:38  William_Athanasiou]
# 
# Revision 1.1.2.13  1997/03/14  20:57:40  Deepa_Bachu
# 	Added default geoTag proc as default geometry for
# 	a container is Down.
# 	[1997/03/14  20:52:03  Deepa_Bachu]
# 
# Revision 1.1.2.12  1997/03/07  20:51:36  William_Athanasiou
# 	Added capability to align labels in chamwdgts
# 	[1997/03/07  20:50:21  William_Athanasiou]
# 
# Revision 1.1.2.11  1997/03/07  19:08:00  William_Athanasiou
# 	Added geometry management for GUI
# 	[1997/03/07  19:05:26  William_Athanasiou]
# 
# Revision 1.1.2.10  1997/01/23  19:28:24  William_Athanasiou
# 	Added displayCB functionality/removed read from display function
# 	[1997/01/23  19:23:07  William_Athanasiou]
# 
# Revision 1.1.2.9  1997/01/16  15:42:28  William_Athanasiou
# 	Added window initCB, which is done after kids
# 	[1997/01/16  15:39:32  William_Athanasiou]
# 
# Revision 1.1.2.8  1997/01/16  14:15:23  William_Athanasiou
# 	Prepend _UIT_ to all classes and globals
# 	[1997/01/15  21:13:16  William_Athanasiou]
# 
# Revision 1.1.2.7  1996/12/02  23:00:49  Todd_Moyer
# 	Changed setWdgtFromData and setDataFromWdgt to read and write.
# 	[1996/12/02  19:54:22  Todd_Moyer]
# 
# Revision 1.1.2.6  1996/09/25  19:28:17  Deepa_Bachu
# 	Added the norespCB to set a Boolean value to "0".
# 	[1996/09/25  19:27:29  Deepa_Bachu]
# 
# Revision 1.1.2.5  1996/09/09  19:15:52  Todd_Moyer
# 	Added invokeCB, findData, setDataFromWdgt and setWdgtFromData methods.
# 	[1996/09/09  19:01:34  Todd_Moyer]
# 
# Revision 1.1.2.4  1996/09/06  18:41:10  Todd_Moyer
# 	Use tree class and call _UIT_g_main object.
# 	[1996/09/06  18:28:04  Todd_Moyer]
# 
# Revision 1.1.2.3  1996/09/03  20:22:52  Todd_Moyer
# 	Take advantage of _UIT_Tree instead of doing own linkage.
# 	[1996/09/03  19:39:24  Todd_Moyer]
# 
# Revision 1.1.2.2  1996/08/30  18:40:58  Deepa_Bachu
# 	This file contains the common methods of the _UIT_Container class.
# 	[1996/08/30  17:32:27  Deepa_Bachu]
# 
# $EndLog$
# 
# @(#)$RCSfile: contain.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:36 $
# 

Class _UIT_Container -superclass _UIT_ChamWdgt


# ---------------------------------------
_UIT_Container instproc init {args} {
    eval $self next $args
    $self set _displayedOnce 0
}


# ---------------------------------------
_UIT_Container instproc display {} {
    foreach k [$self set _kids] {
       $k display
    }
}


# ---------------------------------------
_UIT_Container instproc doInitCB {} {
    foreach k [$self set _kids] {
	$k initCB
    }
    $self initCB
}


# ---------------------------------------
#@ Create all the widgets that live in this container.

_UIT_Container instproc fillContents {contents} {

    global _UIT_g_main

    set saveParent [$_UIT_g_main set currParent]
    $_UIT_g_main set currParent $self
    eval $contents
    $_UIT_g_main set currParent $saveParent
}


# ---------------------------------------
_UIT_Container instproc findData {dataTree} {
    foreach k [$self set _kids] {
	$k findData $dataTree
    }
}


# ---------------------------------------
_UIT_Container instproc geoTag {} {

   set returnTag "<TR>"
   set returnTag

}


# ---------------------------------------
#@ Container's state is just collection of childrens' states.

_UIT_Container instproc getState {} {

    set val ""
    foreach k [$self set _kids] {
	append val " [$k getState]"
    }
    return $val
}


# ---------------------------------------
_UIT_Container instproc initCB {} {;}


# ---------------------------------------
_UIT_Container instproc invokeCB {} {
    foreach k [$self set _kids] {
	$k invokeCB
    }
}


# ---------------------------------------
#@ Ask all children if their current value matches their associated data
#@ attribute's value.  If any are different, return 1 (true).
#@ Otherwise, return 0 (false).

_UIT_Container instproc isChanged {} {

    foreach k [$self set _kids] {
        if {[$k isChanged]} {
	    return 1
	}
    }
    return 0
}


# ---------------------------------------
_UIT_Container instproc norespCB {} {
    foreach k [$self set _kids] {
        $k norespCB
    }
}


# ---------------------------------------
#@ Tell all kids to (re)read their data from their associated resources.
#@   Args:  {optimize 0}
#@   The "optimize" arg is set to 1 if this is just the window refreshing
#@   itself, which enables some performance optimization.
#@   Generally, it should just be allowed to default to zero, which is slower
#@   but safer.

_UIT_Container instproc read {{optimize 0}} {
    foreach k [$self set _kids] {
        $k read $optimize
    }
}


# ---------------------------------------
_UIT_Container instproc updateData {} {
   $self read 1
}


# ---------------------------------------
#@ Tell all children to write their values.

_UIT_Container instproc write {} {
    foreach k [$self set _kids] {
        $k write
    }
}

# =======================================
