# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: contextmgr.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:36  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.4.1  1999/12/16  20:56:14  William_Athanasiou
# 	sysman bulk submit for BL7
#
# Revision 1.1.2.2  1999/12/15  21:43:01  Todd_Moyer
# 	Keep posting connection open.  Added destroy method.
#
# Revision 1.1.2.1  1999/12/15  14:33:41  Todd_Moyer
# 	Created.
# 	[1999/12/15  14:30:49  Todd_Moyer]
#
# $EndLog$
# 
# @(#)$RCSfile: contextmgr.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:36 $
# 


#@ A context manager manages the context interface between a suitlet and
#@ other apps for the main object.  It enables other apps to set the
#@ suitlet's context once it's running, and enables the suitlet to notify
#@ other apps when it changes its own context.  It achieves this using
#@ events.

Class ContextMgr


ContextMgr instproc init {mainObj initContext args} {
    $self instvar _context _eventSub _mainObj _pid _postEventApi

    set _mainObj       $mainObj
    set _context       $initContext
    set _postEventApi  ""        ;# don't create unless needed

    # Use this process's pid as the identifier to tag events as
    # to and from this suitlet.
    set _pid [pid]

    # Subscribe to set_context events so other apps can request
    #   context changes.
    set _eventSub  [EventSubscript gensym \
			-command "$self subscriptHandler" \
			-eventNamePrefix {sys.unix.sysman.suitlet.set_context}]

    # do general init
    eval $self next $args
}


ContextMgr instproc destroy {} {
    $self instvar _eventSub _postEventApi

    if { ! [cequal $_postEventApi ""]} {
	$_postEventApi destroy  
    }
    $_eventSub destroy  
}


# ------------------------------------------
#@ Return the current context value.

ContextMgr instproc getContext {} {
    return [$self set _context]
}


# ------------------------------------------
#@ Set the context value and publish an event for apps that
#@   care when it changes.

ContextMgr instproc setContext {val} {
    $self instvar _context

    set _context $val
    $self _postContext
}


# ------------------------------------------
#@ Receive requests to change context from other apps as events.  Store
#@   the new value and notify this suitlet of the change via the
#@   main object's contextChangeCB.  Only requests with IDs matching
#@   this object's pid or broadcast requests with no ID will be accepted.
#@   Others are simply ignored.

ContextMgr instproc subscriptHandler {args} {
    $self instvar _context _eventSub _mainObj _pid

    set eventInfo [$_eventSub getEventInfo]
    set id        [$eventInfo getVar instance_id]

    # Only grant this request if a broadcast or directed at this process.
    if { ! [cequal $id ""] && $id != $_pid} {
	return ""
    }

    # Set context and notify of change via callback.
    set _context  [$eventInfo getVar context]
    $_mainObj contextChangeCB
}


# ======================== Private Methods ========================

#@ Publish (post) this app's current context.

ContextMgr instproc _postContext {} {
    $self instvar _context _mainObj _pid _postEventApi

    # If event posting API not created, create one.  Can't
    #   re-use subscribing api, cause that's in listening mode.
    #   Somewhat expensive, so don't create ahead of time and
    #   keep around to re-use.
    if {[cequal $_postEventApi ""]} {
	set _postEventApi [Event gensym]
    }

    # Now publish an event notifying any interested apps about the change.
    $_postEventApi setVar suitlet_type STRING $_mainObj ""
    $_postEventApi setVar instance_id  STRING $_pid     ""
    $_postEventApi setVar context      STRING $_context ""
    $_postEventApi post "sys.unix.sysman.suitlet.context_changed"
}


# ======================== End ========================
