# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: curkeys.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:36  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.4.5  1999/02/08  20:40:43  Sandip_Savalia
# 	Second code drop for Steel baselevel 22
# 	[1999/02/08  20:35:00  Sandip_Savalia]
#
# Revision 1.1.2.4  1999/02/05  15:11:27  Richard_Taft
# 	Corrected keymap text
# 	[1999/02/05  15:11:03  Richard_Taft]
# 
# Revision 1.1.2.3  1998/12/03  22:32:15  William_Athanasiou
# 	Fix global grab and refresh
# 	[1998/12/03  22:18:05  William_Athanasiou]
# 
# Revision 1.1.2.2  1998/07/14  17:55:14  William_Athanasiou
# 	Add keyboard help for curses
# 	[1998/07/14  17:54:38  William_Athanasiou]
# 
# 	Initial keyboard help screen
# 	[1998/07/14  17:49:25  William_Athanasiou]
# 
# $EndLog$
# 
# @(#)$RCSfile: curkeys.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:36 $
# 
proc _UIT_showCursesKeys {} {
   if ![winfo exists .keys] {
      global _UIT_g_main
      _UIT_Dialogshell .keys -separator off \
	  -title "Keyboard Mapping Help Screen"
      set _uiRep [_UIT_Scrolledtext [.keys childsite].txt \
		      -visibleitems 75x16]
      pack $_uiRep -side top -expand 1 -fill both
      .keys addTkButton ok -text  [$_UIT_g_main catget help.ok _lbl] \
	  -command _UIT_closeKeys
      .keys default ok
      bind .keys <Return> "_UIT_closeKeys"
      wm geometry .keys =[winfo screenwidth .]x[winfo screenheight .]

      #
      # fill text.
      $_uiRep insert 0.0 \
	  "   The following key maps explain the keys used to 
activate widgets and traverse within screens and
widgets.  Key names followed by a '*' denote keys
that may not be supported, depending upon the
terminal characteristics and curses support.  In
these cases a control key sequence can be used 
instead.

   Hit <Return> or press the 'OK' button on the 
screen to return to the application window.

General Key Maps
   <ctrl-g>                  Display this message

   <ctrl-n>                  Move to next widget
   <down/left arrow>/<Tab>   Move to next widget

   <ctrl-p>                  Move to prev widget
   <up/right arrow           Move to prev widget

   <Space>                   Activate button/widget
   <Return>                  Activate default button

Line Entry Key Maps
   <right/left arrow>        Scroll right/left
   <ctrl-e>                  Jump to end of line
   <ctrl-a>                  Jump to start of line

Multi-Line Entry Key Maps
   <up/down arrow>           Scroll list up/down
   <right/left arrow>        Scroll list right/left
   <ctrl-u><Page-Up>*        Scroll up 1 page
   <ctrl-d><Page-Down>*      Scroll down 1 page
   <ctrl-a>                  Jump to start of line
   <ctrl-e>                  Jump to end of text

Lists
   <Return>                  Double Click
   <Space>                   Single Click/Select

   <up/down arrow>           Scroll list up/down
   <right/left arrow>        Scroll list right/left
   <ctrl-u>\n<Page-Up>*      Scroll up 1 page
   <ctrl-d>\n<Page-Down>*    Scroll down 1 page
   <ctrl-a>                  Jump to start of text
   <ctrl-e>                  Jump to end of text"
      set txt [$_uiRep component text]
      $txt configure -state disabled
   }
   
   #
   # Display window
   global _UIT_prevFocus
   set _UIT_prevFocus [focus]
   .keys activate
   update idletasks
   set txt [[.keys childsite].txt component text]
   focus $txt
   $txt mark set insert 0.0
   
}

proc _UIT_closeKeys {} {
   .keys deactivate
   global _UIT_prevFocus
   focus $_UIT_prevFocus
}
