#!/usr/share/sysman/bin/sysmansh
# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: docgen2.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:36  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.4.2  1997/09/30  19:45:21  Anthony_Hoffman
# 	pre BL13 submit from sysman sandbox
# 	[1997/09/29  19:21:52  Anthony_Hoffman]
#
# Revision 1.1.2.2  1997/09/16  21:09:21  Todd_Moyer
# 	Created.
# 	[1997/09/16  21:07:57  Todd_Moyer]
# 
# $EndLog$
# 
# @(#)$RCSfile: docgen2.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:36 $
# 

# Second stage for producing/updating design documentation from code.

if {$argc != 2} {
    puts "arguments are:  docgen2.tcl input_data_file output_directory"
    exit
}


puts "Defining design class"
source dsnclass.tcl


puts "Defining procs"

source doclib.tcl


set file [lindex $argv 0]
set dir  [lindex $argv 1]
puts "Creating objects for $file"

set desc    {}
set roots   {}
set classes {}

for_file line $file {

    # line may not be complete statement because of backslash or open brace
    # If incomplete, skip it
    if {[catch {set first [lindex $line 0]}]} {
	continue
    }

    if {[cequal $first Class]} {
	mkClass line
    } elseif {[cequal $first #@]} {
	mkDesc line
    } elseif {! [regexp {^#} $first]} {

	# line may not be complete statement because of backslash or open brace
	# If incomplete, skip it
	if {[catch {set sec [lindex $line 1]}]} {
	    continue
	}

	if {[cequal $sec instvar]} {
	    mkMems line
	} elseif {[cequal $sec instproc ]} {
	    mkMeth line
	}
    }
}


puts "Tell parents about kids"
foreach k $classes {
    $k addToParent
}


puts "Make $dir/HIER.html"
set f [open $dir/HIER.html w]

printHtmlIntro $f "Suit Inheritence Hierarchy"
puts $f "Derived (sub) classes are shown beneath base (super) classes."
puts $f "Classes that inherit from more than one base class have other "
puts $f "super classes shown in parenthises behind them."
puts $f "<P><PRE>"
foreach r [lsort $roots] {
    $r mkHier $f "" ""
}
puts $f "</PRE>"
puts $f "</BODY>"
puts $f "</HTML>"
close $f


puts "Make class pages in $dir"
foreach r $roots {
    $r reset
}
foreach r $roots {
    $r mkPage $dir
}


exit
