#!/usr/bin/sh
# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: doclib.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:36  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.4.2  1997/09/30  19:45:24  Anthony_Hoffman
# 	pre BL13 submit from sysman sandbox
# 	[1997/09/29  19:21:56  Anthony_Hoffman]
#
# Revision 1.1.2.2  1997/09/16  21:09:25  Todd_Moyer
# 	Created.
# 	[1997/09/16  21:08:02  Todd_Moyer]
# 
# $EndLog$
# 
# @(#)$RCSfile: doclib.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:36 $
# 

# These routines are common for both creating static inheritance and
# dynamic aggregation hierarchies (see the _UIT_dumpInstTree proc).


# --------------------------------------------------
#@ Dump an instance name, it's class and all its decendants in the
#@ aggregation hierarchy.

proc _UIT_dumpInstNode {file node indent {level 0}} {

    switch $level {
	1 {set prefix "${indent}="}
	2 {set prefix "${indent}+"}
	3 {set prefix "${indent}-"}
	4 {set prefix "${indent}."}
	default {set prefix "${indent}"}
    }

    puts $file "$prefix $node ([stripName [$node info class]])"

    set l [expr $level + 1]

    # if a tree, do children
    if {[$node info class _UIT_Tree]} {
	foreach k [lsort [$node getKids]] {
	    _UIT_dumpInstNode $file $k "$indent   " $l
	}
    }

    # if a main object, look for certain attributes
    if {[$node info class Main]} {
	_UIT_dumpInstNode $file [$node set _helpWin] "$indent   " $l
	_UIT_dumpInstNode $file [$node set _resTree] "$indent   " $l
	_UIT_dumpInstNode $file [$node set _cat]     "$indent   " $l
	_UIT_dumpInstNode $file [$node set _i18ncat] "$indent   " $l
	_UIT_dumpInstNode $file [$node set _dom]     "$indent   " $l
    }

    # if a resource, look for certain attributes
    if {[$node info class _UIT_Rsrc]} {
	_UIT_dumpInstNode $file [$node set _recBuf] "$indent   " $l
    }
}


# --------------------------------------------------
#@ Dump an HTML page in the specified directory for the specified object
#@ and all its decendants.

proc _UIT_dumpInstTree {dir name root} {

    # print name and description
    set f [open $dir/HASA.html w]
    printHtmlIntro $f "$name"

    puts $f "Here is the has-a relationships among object instances for a "
    puts $f "typical application running in an X Windows (GUI) environment."
    puts $f "The objects owned by a class are shown indented beneath it."
    puts $f "The instance's name is shown with its class in parenthises."
    puts $f "<P><PRE>"

    _UIT_dumpInstNode $f $root ""

    puts $f "</PRE>"
    puts $f "</BODY>"
    puts $f "</HTML>"
    close $f
}


# ---------------------------------------

proc mkClass {l} {
    upvar $l line
    global classes

    set name      [lindex $line 1]
    set className [padName   $name]
    set docName   [stripName $name]
    set supers    [lindex $line 3]
    set padSups   ""
    foreach s $supers {
	lappend padSups [padName $s]
    }
    lappend classes [_UIT_DsnClass $className $docName $padSups]
}


# ---------------------------------------

proc mkDesc {l} {
    upvar $l line
    global desc

    lvarpop line
    lappend desc $line
}


# ---------------------------------------

proc mkMems {l} {
    upvar $l line
    global currClass

    $currClass addMems [lreplace $line 0 1]
}


# ---------------------------------------

proc mkMeth {l} {
    upvar $l line
    global currClass

    $currClass addMeth [lindex $line 2]
}


# ---------------------------------------
# put a prefix on the names so as not to clash with existing classes
proc padName {name} {
    return _UIT_$name
}


# ---------------------------------------
# Print the title and heading of an HTML page.
proc printHtmlIntro {f name} {
    puts $f "<HTML>"
    puts $f "<HEAD>"
    puts $f "<TITLE>"
    puts $f "$name"
    puts $f "</TITLE>"
    puts $f "</HEAD>"
    puts $f "<BODY>"
    puts $f "<CENTER>"
    puts $f "<H1>$name</H1>"
    puts $f "</CENTER>"
}


# ---------------------------------------
# remove any standard prefix so names are more readable
proc stripName {name} {
    if {[regexp {^_UIT_(.*)} $name dummy stripped]} {
	return $stripped
    }
    return $name
}


# =======================================
