#!/usr/bin/otclsh
# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: domain.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:36  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.9.1  2000/09/21  19:50:30  Peter_Wolfe
# 	QAFFA code drop for yankee bl2
#
# Revision 1.1.2.16  2000/09/13  15:36:22  Richard_Taft
# 	Fixed problem with single separator in down widget
#
# Revision 1.1.2.15  1999/10/13  20:12:42  Richard_Taft
# 	Tabbed widgets don't need a name, either
# 	[1999/10/13  19:04:54  Richard_Taft]
#
# 	mfile.txt
# 	[1999/10/11  20:10:54  Richard_Taft]
#
# 	Geo-managers can now have names
# 	[1999/10/07  17:12:47  Richard_Taft]
#
# Revision 1.1.2.14  1999/08/20  19:58:38  Joseph_Ruvel
# 	Added Image widget Type
# 	[1999/08/05  15:24:41  Joseph_Ruvel]
#
# Revision 1.1.2.13  1997/10/21  14:57:16  Richard_Taft
# 	Added Suitlet to the special case classes
# 	[1997/10/17  18:41:00  Richard_Taft]
# 
# Revision 1.1.2.12  1997/09/25  21:12:19  Todd_Moyer
# 	Added Separator widget type.
# 	[1997/09/25  20:49:55  Todd_Moyer]
# 
# Revision 1.1.2.11  1997/04/29  13:58:22  Deepa_Bachu
# 	Added switch info for multi enum widget.
# 	[1997/04/29  13:54:44  Deepa_Bachu]
# 
# Revision 1.1.2.10  1997/04/28  17:58:39  Todd_Moyer
# 	Got rid of Msg super widget and added Tree.
# 	Do Across and Down in a loop.
# 	[1997/04/28  17:55:14  Todd_Moyer]
# 
# Revision 1.1.2.9  1997/03/07  19:08:02  William_Athanasiou
# 	Added geometry management for GUI
# 	[1997/03/07  19:05:29  William_Athanasiou]
# 
# Revision 1.1.2.8  1997/02/25  21:11:59  William_Athanasiou
# 	Fixed definition of infomsg proc
# 	[1997/02/25  21:11:33  William_Athanasiou]
# 
# Revision 1.1.2.7  1997/02/24  22:30:47  Deepa_Bachu
# 	Added InfoMsg proc, for error handling.
# 	[1997/02/24  22:30:23  Deepa_Bachu]
# 
# Revision 1.1.2.6  1997/01/16  14:15:24  William_Athanasiou
# 	Prepend _UIT_ to all classes and globals
# 	[1997/01/15  21:13:18  William_Athanasiou]
# 
# Revision 1.1.2.5  1997/01/03  15:00:50  Todd_Moyer
# 	Changed Enum to Enumerated to avoid clash with DMI.
# 	[1996/12/27  22:09:16  Todd_Moyer]
# 
# Revision 1.1.2.4  1996/12/03  19:42:50  William_Athanasiou
# 	Added 'info' capability to widgets.  Simplified quoting
# 	  requirements by using subst and eval.
# 	[1996/12/03  19:39:40  William_Athanasiou]
# 
# Revision 1.1.2.3  1996/09/06  18:41:15  Todd_Moyer
# 	Use _UIT_g_main object.
# 	[1996/09/06  18:29:50  Todd_Moyer]
# 
# Revision 1.1.2.2  1996/08/30  18:41:00  Deepa_Bachu
# 	This file was created to contain the _UIT_Domain class.
# 	[1996/08/30  17:33:18  Deepa_Bachu]
# 
# $EndLog$
# 
# @(#)$RCSfile: domain.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:36 $
# 

Class _UIT_Domain


_UIT_Domain instproc init {type} {
   global _UIT_g_main
   $self set ui $type
   
   # get rid of window that comes automatically with wish
   if {([string compare $type GUI] == 0) || \
	 ([string compare $type CURSES] == 0)} {
      wm withdraw .
   }

   # define window types
   eval [subst  -nocommand {
      proc Window {name contents args} { 
	 eval {_UIT_Window$type \$name \$contents} \$args
      }
   }
   ]
   
   # define super widget types
   foreach c {Boolean Button Label Image List Number Text Tree} {
      eval [subst -nocommand {
	 proc $c {subName args} {
	    global _UIT_g_main
	    if {[cequal \$subName "info"]} {
	       eval "_UIT_${c}$type info" \$args
	    } else {
	       eval "_UIT_${c}$type \
		     [$_UIT_g_main set currPath].\$subName" \$args
	    }
	 }
      }
      ]
   }

   # Enumerated remaps to Enum, do it separately.
   eval [subst -nocommand {
       proc Enumerated {subName args} {
	   global _UIT_g_main
	   if {[cequal \$subName "info"]} {
	       eval "_UIT_Enum$type info" \$args
	   } else {
	       eval "_UIT_Enum$type \
		     [$_UIT_g_main set currPath].\$subName" \$args
	   }
       }
   }
   ]

   eval [subst -nocommand {
       proc MultiEnum {subName args} {
           global _UIT_g_main
           if {[cequal \$subName "info"]} {
               eval "_UIT_MEnum$type info" \$args
           } else {
               eval "_UIT_MEnum$type \
                     [$_UIT_g_main set currPath].\$subName" \$args
           }
       }
   }
   ]

   # Geo-managers and Tabbed widgets are special because they 
   # may or may not be named.
   foreach c {Across Down Tabbed} {
      eval [subst -nocommand {
	 proc $c {contents args} {
	    global _UIT_g_main
	    if {[cequal \$contents "info"]} {
	       eval "_UIT_${c}$type info" \$args

	    } elseif {([llength \$contents] == 1) && ([llength \$args] > 0) &&
		      ([string first [string trim \$args] -] != 0)}  {
	       # This is a named geo-manager

	       # Explanation of hairy elseif-clause above:
	       # In this case, contents is the widget name, not really
	       # the geo's contents, so the name will have length 1. (Which
	       # means there are no names with spaces allowed.)
	       # Args may be the contents, if there are any and they are
	       # enclosed in braces.  Why the check for -?  Because
	       # "Down { Separator }" was thinking that this was a Down widget
	       # called Separator.  Args was getting a value of "-padx 0 
               # -pady 0" and that was screwing up the rest of this clause.

	       # Add a suffix, ##, to the name.  Tabbed widgets
	       # require this so that users can refer to the tab
	       # for a particular page in a message catalog using
	       # the name of the enclosing geo-manager.
	       set subName \${contents}\#\#
	       set contents [lindex \$args 0]
	       set args [lrange \$args 1 end]
	       eval "_UIT_${c}$type \
		     [$_UIT_g_main set currPath].\$subName {\$contents}" \$args

	    } else {
		# This is an unnamed geo-manager
		eval "_UIT_${c}$type gensym {\$contents}" \$args
	    }
	 }
      }
      ]
   }

   # some special cases where the object isn't named.
   foreach w {InfoMsg Separator Suitlet} {
       eval [subst -nocommand {
	   proc $w {args} {
	       eval {_UIT_${w}${type} gensym} \$args
	   }
       }
       ]
   }

}






