# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: dsnclass.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:36  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.4.2  1997/09/30  19:45:27  Anthony_Hoffman
# 	pre BL13 submit from sysman sandbox
# 	[1997/09/29  19:22:02  Anthony_Hoffman]
#
# Revision 1.1.2.2  1997/09/16  21:09:28  Todd_Moyer
# 	Created.
# 	[1997/09/16  21:08:06  Todd_Moyer]
# 
# $EndLog$
# 
# @(#)$RCSfile: dsnclass.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:36 $
# 

#@ Create an object that documents the design of another class.

Class _UIT_DsnClass

_UIT_DsnClass instproc init {name parents} {
    global currClass desc roots
    $self instvar _desc _kids _mems _meths _name _parents _touched
  
    set currClass   $self
    set _name       $name

    # note parents and save as root if no parents
    set _parents  $parents
    if {[cequal $parents ""]} {
        lappend roots $self
    }

    # will set these later (arrays not init, just here for documentation)
    set _kids     {}
    # set _mems
    # set _meths

    # use prevous desciption for this class
    set _desc   $desc
    set desc    {}

    set _touched    0
}


# --------------------------------------------------
#@ Note that the specified object is derived from this class.

_UIT_DsnClass instproc addKid {obj} {
    $self instvar _kids

    lappend _kids $obj
}


# --------------------------------------------------
#@ Add the specified member data to this class.
#@ Skip identifiers starting with a $.
#  Put in array to get rid of dups.

_UIT_DsnClass instproc addMems {mems} {
    $self instvar _mems

    foreach m $mems {
	if {! [regexp {^\$} $m]} {
	    set _mems($m) 1
	}
    }
}


# --------------------------------------------------
#@ Add the specified method to this class.
#@ Include the current set of comments.
#@ Don't add init or destroy.

_UIT_DsnClass instproc addMeth {meth} {
    global desc
    $self instvar _meths

    if {[cequal $meth init] || [cequal $meth destroy]} {
	return 
    }
    set _meths($meth) $desc
    set desc ""
}


# --------------------------------------------------
#@ Tell your superclasses that you are derived from them.

_UIT_DsnClass instproc addToParent {} {
    $self instvar _parents
    foreach p $_parents {
	$p addKid $self
    }
}


# --------------------------------------------------
#@ Get this object's documentation name.

_UIT_DsnClass instproc getName {} {
    $self set _name
}


# --------------------------------------------------
#@ Get a link to this object's HTML page.

_UIT_DsnClass instproc getLink {} {
    $self instvar _name

    return "<a href=\"$_name.html\">$_name</a>"
}


# --------------------------------------------------
#@ Write the HTML for this object and its untouched children in the
#@ inheritance hierarchy.

_UIT_DsnClass instproc mkHier {file parent indent {level 0}} {
    $self instvar _name _parents _touched

    # if already been here, don't do anything
    if {$_touched} {
        return 0
    }

    switch $level {
	1 {set prefix "${indent}="}
	2 {set prefix "${indent}+"}
	3 {set prefix "${indent}-"}
	4 {set prefix "${indent}."}
	default {set prefix "${indent}"}
    }

    # if more than one parent, list the others
    if {[llength $_parents] > 1} {
        set p ""
        foreach par $_parents {
            if {! [cequal $par $parent]} {
                lappend p [$par getLink]
            }
        }
        puts $file "$prefix [$self getLink] ([join $p])"
    } else {
        puts $file "$prefix [$self getLink]"
    }

    # do children
    foreach k [$self set _kids] {
        $k mkHier $file $self "$indent   " [expr $level + 1]
    }

    set _touched 1
}


# --------------------------------------------------
#@ Write the HTML page for this object and its untouched children in the
#@ specified directory.

_UIT_DsnClass instproc mkPage {dir} {
    $self instvar _desc _kids _mems _meths _name _parents _touched

    # if already been here, don't do anything
    if {$_touched} {
        return 0
    }

    # print name and description
    set f [open $dir/$_name.html w]
    printHtmlIntro $f "Suit's $_name Class"
    puts $f "[join $_desc \n]"

    # print base and derived classes, and create pages for derived classes.
    if {! [cequal $_parents ""]} {
	puts $f "<HR>"
	puts $f "<H2>Base Class(es)</H2> "
	foreach p [lsort $_parents] {
	    puts $f [$p getLink]
	}
	puts $f "<BR>"
    }
    if {! [cequal $_kids ""]} {
	puts $f "<HR>"
	puts $f "<H2>Derived Class(es)</H2> "
	foreach k [lsort $_kids] {
	    puts $f [$k getLink]
	    $k mkPage $dir
	}
    }

    # print members (stored in array to get rid of dups)
    set memIdxes [array names _mems]
    if {! [cequal $memIdxes ""]} {
	puts $f "<HR>"
	puts $f "<H2>Data Members</H2> "
	foreach m [lsort $memIdxes] {
	    puts $f "$m "
	}
    }

    # print methods (stored in array with descriptions)
    set privM [lsort [array names _meths]]
    set idx   [lsearch -regexp $privM {^[^_]}]
    if {$idx < 0} {
	set pubM {}
    } else {
	set pubM  [lrange   $privM $idx end]
	set privM [lreplace $privM $idx end]
    } 
    if {! [cequal $pubM  ""]} {
	puts $f "<HR>"
	puts $f "<H2>Public Methods</H2> "
	foreach m $pubM {
	    puts $f "<H3>$m</H3> "
	    puts $f "[join $_meths($m) \n]"
	}
    }
    if {! [cequal $privM  ""]} {
	puts $f "<HR>"
	puts $f "<H2>Private Methods</H2> "
	foreach m $privM {
	    puts $f "<H3>$m</H3> "
	    puts $f "[join $_meths($m) \n]"
	}
    }


    puts $f "</BODY>"
    puts $f "</HTML>"
    close $f

    set _touched 1
    return 1
}


# --------------------------------------------------
#@ Reset this object and its kids as being untouched.  This is useful when
#@ traversing the graph because a node may have more than one parent.

_UIT_DsnClass instproc reset {} {
    $self instvar _touched

    # all traversing from parent down, so if untouched, so is kid
    if {! $_touched} {
        return
    }

    foreach k [$self set _kids] {
        $k reset
    }
    set _touched 0
}


# =================================================
