# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: enumgen.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:36  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.4.6  1998/03/26  19:59:58  Anthony_Hoffman
# 	BL 16 shared sandbox submit
# 	[1998/03/25  19:00:58  Anthony_Hoffman]
#
# Revision 1.1.2.7  1998/03/24  22:18:46  William_Athanasiou
# 	Add styleHint capability to enumeration type
# 	[1998/03/24  22:17:25  William_Athanasiou]
# 
# Revision 1.1.2.6  1997/12/12  14:53:15  William_Athanasiou
# 	Fix setup of display list if no msg catalog stuff present
# 	[1997/12/12  14:49:45  William_Athanasiou]
# 
# Revision 1.1.2.5  1997/10/24  19:31:03  Richard_Taft
# 	Value defaults to first in list
# 	[1997/10/22  20:01:11  Richard_Taft]
# 
# Revision 1.1.2.4  1997/03/21  15:55:25  William_Athanasiou
# 	build displayList array index by valueList items
# 	[1997/03/21  15:45:32  William_Athanasiou]
# 
# Revision 1.1.2.3  1997/01/16  14:15:25  William_Athanasiou
# 	Prepend _UIT_ to all classes and globals
# 	[1997/01/15  21:13:21  William_Athanasiou]
# 
# Revision 1.1.2.2  1996/09/11  21:17:06  Deepa_Bachu
# 	_UIT_EnumGeneric class file.
# 	[1996/09/11  21:12:41  Deepa_Bachu]
# 
# $EndLog$
# 
# @(#)$RCSfile: enumgen.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:36 $
# 

Class _UIT_EnumGeneric -superclass _UIT_SuperWdgt

_UIT_EnumGeneric instproc init {args} {
	
   global _UIT_g_wdgtVals _UIT_g_main	
   $self instvar valueList displayList styleHint _valuePtr

   # set defaults
   set valueList ""
   set styleHint {}
   
   eval $self next $args             ;# do parents init
   set $_valuePtr ""

   # get the displayList array indexed by valueList elements
   foreach i $valueList {
      set displayList($i) [$_UIT_g_main catget $self $i $i]
   }

   $self _chooseStyle
   $self setVal [lindex $valueList 0] ;# make sure it has an initial value
}

_UIT_EnumGeneric instproc _chooseStyle {} {
   $self instvar styleHint valueList _chosenStyle

   set _chosenStyle combo
   set dlen [llength $valueList]

   if [cequal $styleHint ""] {
      if {$dlen <= 4} {set _chosenStyle radio
      } elseif {$dlen <= 24} {set _chosenStyle option}
   } else {
      if [cequal $styleHint "radio"] {
	 if {$dlen <= 4} {set _chosenStyle radio}
      } elseif [cequal $styleHint "option"] {
	 if {$dlen <= 24} {set _chosenStyle option}
      }
   }
   return $_chosenStyle
}
