
# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: enumgui.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:36  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.8.1  1999/11/05  14:52:42  Peter_Wolfe
# 	Code drop for zulu BL6
#
# Revision 1.1.2.39  1999/10/13  20:12:44  Richard_Taft
# 	When calculating leaf, use end, not 1.  The tabbed widget requires
# 	more levels.
# 	[1999/10/12  14:36:12  Richard_Taft]
#
# 	Call _parent's packSide proc to find out the side (top or left)
# 	to pack from.  Don't check the parent's name, it may not tell
# 	[1999/10/11  20:06:24  Richard_Taft]
#
# Revision 1.1.2.38  1998/12/03  22:32:16  William_Athanasiou
# 	Fix global grab and refresh
# 	[1998/12/03  22:18:07  William_Athanasiou]
#
# Revision 1.1.2.37  1998/07/23  20:22:19  Todd_Moyer
# 	Only set default value if current value is invalid.
# 	[1998/07/23  20:21:14  Todd_Moyer]
# 
# Revision 1.1.2.36  1998/06/24  13:33:27  William_Athanasiou
# 	Fix qar61352 (_buildEnum)
# 	[1998/06/24  13:31:56  William_Athanasiou]
# 
# Revision 1.1.2.35  1998/04/21  20:03:17  William_Athanasiou
# 	correctly position cursor in enum chooser window
# 	[1998/04/21  20:02:30  William_Athanasiou]
# 
# Revision 1.1.2.34  1998/04/10  16:15:32  William_Athanasiou
# 	fix focus and window resize issues
# 	[1998/04/10  16:14:52  William_Athanasiou]
# 
# Revision 1.1.2.33  1998/04/10  13:16:59  William_Athanasiou
# 	fix listbox selection mode
# 	[1998/04/10  13:16:08  William_Athanasiou]
# 
# Revision 1.1.2.32  1998/04/10  02:33:51  William_Athanasiou
# 	use display attr./correct enable modes
# 	[1998/04/10  02:22:53  William_Athanasiou]
# 
# Revision 1.1.2.31  1998/04/09  14:08:31  Richard_Taft
# 	Default was displayed as an index into display list, rather
# 	than as the text value.
# 	[1998/04/09  14:07:59  Richard_Taft]
# 
# Revision 1.1.2.30  1998/03/24  22:18:47  William_Athanasiou
# 	Add styleHint capability to enumeration type
# 	[1998/03/24  22:17:28  William_Athanasiou]
# 
# Revision 1.1.2.29  1998/03/16  20:09:09  William_Athanasiou
# 	Add setLabel functionality to allow window and widget labels to be dynamically set
# 	[1998/03/16  20:05:31  William_Athanasiou]
# 
# Revision 1.1.2.28  1998/03/05  20:50:09  William_Athanasiou
# 	Fix missing instvar in setVal of valuelist > 24
# 	[1998/03/05  20:49:44  William_Athanasiou]
# 
# Revision 1.1.2.27  1998/03/02  16:49:53  Todd_Moyer
# 	Cleaned up _winStack API.
# 	[1998/03/02  16:45:30  Todd_Moyer]
# 
# Revision 1.1.2.26  1998/02/26  21:12:39  William_Athanasiou
# 	setVal: set initial value selected and make it viewable
# 	[1998/02/26  20:58:30  William_Athanasiou]
# 
# Revision 1.1.2.25  1998/02/26  20:53:40  William_Athanasiou
# 	set initial value selected and make it viewable
# 	[1998/02/26  20:51:17  William_Athanasiou]
# 
# Revision 1.1.2.24  1998/02/25  15:44:00  William_Athanasiou
# 	Fix color of disabled widget to allow display on BW terminal
# 	[1998/02/25  15:43:04  William_Athanasiou]
# 
# Revision 1.1.2.23  1998/02/24  20:24:03  William_Athanasiou
# 	Fix usability issues with choose list
# 	[1998/02/24  20:23:34  William_Athanasiou]
# 
# Revision 1.1.2.22  1998/02/13  16:20:02  William_Athanasiou
# 	Move setstate after displaylist change to updateDispList
# 	[1998/02/13  16:19:41  William_Athanasiou]
# 
# Revision 1.1.2.21  1998/02/11  18:44:01  William_Athanasiou
# 	Added disable/enable and change callbacks
# 	[1998/02/11  16:44:35  William_Athanasiou]
# 
# Revision 1.1.2.20  1997/12/12  20:08:49  William_Athanasiou
# 	fix new UI for large Enums
# 	[1997/12/12  20:08:11  William_Athanasiou]
# 
# Revision 1.1.2.19  1997/12/12  16:11:26  William_Athanasiou
# 	Update UI for >24 items as per Paul and Todd's suggestions
# 	[1997/12/12  16:10:43  William_Athanasiou]
# 
# Revision 1.1.2.18  1997/12/12  14:53:16  William_Athanasiou
# 	Add fix for qar 54256 and 54159
# 	[1997/12/12  14:50:56  William_Athanasiou]
# 
# Revision 1.1.2.17  1997/10/24  19:31:04  Richard_Taft
# 	Noticed a missing $ in setValueList
# 	[1997/10/22  20:00:42  Richard_Taft]
# 
# Revision 1.1.2.16  1997/08/18  17:11:09  William_Athanasiou
# 	Postpone catalog lookup until first time widget displayed
# 	[1997/08/18  16:17:27  William_Athanasiou]
# 
# Revision 1.1.2.15  1997/05/13  18:50:15  Deepa_Bachu
# 	Put a catch around "unset displaylist" since it could
# 	be null if valueList is not specified.
# 	[1997/05/13  18:49:45  Deepa_Bachu]
# 
# Revision 1.1.2.14  1997/05/13  18:21:54  Deepa_Bachu
# 	Added methods setvalueList and updateDispList to
# 	allow for setting the valueList at runtime.
# 	[1997/05/13  17:38:06  Deepa_Bachu]
# 
# Revision 1.1.2.13  1997/03/31  18:49:30  William_Athanasiou
# 	set highlightthickness to 2 so its visible
# 	[1997/03/31  18:31:46  William_Athanasiou]
# 
# Revision 1.1.2.12  1997/03/28  16:46:37  William_Athanasiou
# 	Postpone UI creation until first display for performance reasons
# 	[1997/03/28  16:28:09  William_Athanasiou]
# 
# Revision 1.1.2.11  1997/03/21  15:55:26  William_Athanasiou
# 	Added pointer focus help/creation of _helpStrs catalog
# 	[1997/03/21  15:44:38  William_Athanasiou]
# 
# Revision 1.1.2.10  1997/03/13  17:45:03  William_Athanasiou
# 	Correct expansion of window behavior and packing
# 	[1997/03/13  17:43:46  William_Athanasiou]
# 
# Revision 1.1.2.9  1997/03/07  20:51:38  William_Athanasiou
# 	Added capability to align labels in chamwdgts
# 	[1997/03/07  20:50:25  William_Athanasiou]
# 
# Revision 1.1.2.8  1997/03/07  19:08:03  William_Athanasiou
# 	Added geometry management for GUI
# 	[1997/03/07  19:05:32  William_Athanasiou]
# 
# Revision 1.1.2.7  1997/01/16  20:37:38  William_Athanasiou
# 	Only pack the UIrep once
# 	[1997/01/16  20:30:09  William_Athanasiou]
# 
# Revision 1.1.2.6  1997/01/16  14:15:26  William_Athanasiou
# 	Prepend _UIT_ to all classes and globals
# 	[1997/01/15  21:13:24  William_Athanasiou]
# 
# Revision 1.1.2.5  1996/12/02  23:00:50  Todd_Moyer
# 	In display method call $self next to cause a read to occur.
# 	[1996/12/02  22:50:31  Todd_Moyer]
# 
# Revision 1.1.2.4  1996/10/01  13:31:37  William_Athanasiou
# 	Fixed slight formatting problems
# 	[1996/10/01  13:28:59  William_Athanasiou]
# 
# Revision 1.1.2.3  1996/09/25  19:12:52  William_Athanasiou
# 	Fixed multi word display value displays and added setVal method to handle option menu updates
# 	[1996/09/25  19:12:15  William_Athanasiou]
# 
# Revision 1.1.2.2  1996/09/24  19:57:54  William_Athanasiou
# 	initial version of implementation
# 	[1996/09/24  19:48:12  William_Athanasiou]
# 
# $EndLog$
# 
# @(#)$RCSfile: enumgui.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:36 $
# 


Class _UIT_EnumGUI -superclass _UIT_EnumGeneric


_UIT_EnumGUI instproc init {args} {
   eval $self next $args
}


_UIT_EnumGUI instproc display {} {
   $self instvar _displayedOnce 
   
   if {!$_displayedOnce} {
      incr _displayedOnce
      
      global _UIT_g_main
      $self instvar valueList displayList \
	  _UIrep _valuePtr _lbl _parent _window _enabledState
      
      set leaf      [lindex [split $self .] end]
      set container [$_parent set containWdgt]   
      set _UIrep [labeledwidget $container.$leaf -labeltext $_lbl]
      set Frm [$_UIrep childsite]
      
      $self _buildEnumUI
      $_window _registerUImap $_UIrep $self
      
      pack $_UIrep -fill x -anchor nw -padx 0 -side [$_parent packSide]
      $self _setState $_enabledState
   }
   $self next
}


_UIT_EnumGUI instproc _buildEnumUI {} {
   global _UIT_${self}OptionVal
   $self instvar _valuePtr displayList valueList \
       _displayedOnce _UIrep _UIframe _isAlignable _chosenStyle
   
   if [info exists _UIframe] {
      destroy $_UIframe
   }
   
   set _UIframe [frame [$_UIrep childsite].frm]
   pack $_UIframe -fill both -expand 1

   switch $_chosenStyle {
      radio {
	 #
	 # Radio buttons
	 #
	 $_UIrep config -labelpos nw -labelmargin 0
	 $_UIframe config -relief groove
	 set i 0
	 set maxWidth 0
	 
	 foreach v $valueList {
	    radiobutton $_UIframe.r$i -variable $_valuePtr -value $v -anchor w\
		-text $displayList($v) -highlightthickness 2 \
		-command "$self invokeWrapper"
	    pack $_UIframe.r$i -anchor w -padx 10p -pady 0
	    incr i
	 }
	 set _isAlignable {}
      }

      option {
	 #
	 # Option menu
	 #

	 set _isAlignable $_UIrep
	 $_UIrep config -labelpos w -labelmargin 1
	 menubutton $_UIframe.btn -textvariable _UIT_${self}OptionVal \
	     -indicatoron 1 -menu $_UIframe.btn.menu -relief sunken -anchor w
	 if [string match {*GUI} [$self info class]] {
	    $_UIframe.btn configure -highlightthickness 2 -takefocus 1
	 }
	 menu $_UIframe.btn.menu -tearoff 0 
	 pack $_UIframe.btn -side left -anchor w
	 
	 $self _mkOptionMenu $_UIframe.btn.menu
      }

      combobox -
      default {
	 #
	 # Combo box
	 #
	 $self instvar _enumWindow _enumList _window
	 set _isAlignable $_UIrep
	 $_UIrep config -labelpos w -labelmargin 1
	 global _UIT_DisplayAttr
	 
	 pack [entry $_UIframe.ntry -takefocus 0 \
		   -textvariable _UIT_${self}OptionVal] \
	     -side left -fill x -expand 1
	 pack [button $_UIframe.btn -command "$self _displayList" \
		   -text "Choose..."] -side right -padx 1
	 if [string match {*GUI} [$self info class]] {
	    $_UIframe.ntry configure -state disabled \
		-background $_UIT_DisplayAttr(EntryNonEditable)
	 }
	 
	 if [info exists _enumWindow] {
	    $_enumList clear
	 } else {
	    set _enumWindow [_UIT_Dialogshell .${self}Win]
	    if [string match {*CURSES} [$self info class]] {
	       [$_enumWindow set _Wdgt(hullcmd)] config -borderwidth 1
	    }
	    $_enumWindow configure -title [$_window set title] -separator off
	    $_enumWindow addTkButton ok -text Ok -command "$self _doSelection"
	    $_enumWindow default ok
	    
	    # window contents
	    set child [$_enumWindow childsite]
	    set _enumList [$self _mkEnumList $child]
	    pack $_enumList -fill both
	 }
	 foreach i $valueList {
	     $_enumList insert end $displayList($i)
	 }
     }
   }

   $self _checkValue
}


_UIT_EnumGUI instproc _setState {val} {
   $self instvar valueList _UIrep _UIframe _chosenStyle
   $_UIrep configure -labelstate $val

   switch $_chosenStyle {
      radio {
	 set i 0
	 foreach v $valueList {
	    $_UIframe.r$i configure -state $val
	    incr i
	 }
      }
      option {
	 $_UIframe.btn configure -state $val
      }
      default {
	 global _UIT_DisplayAttr
	 $_UIframe.btn configure -state $val
	 if [string match {*GUI} [$self info class]] {
	    $_UIframe.ntry configure -foreground $_UIT_DisplayAttr($val)
	 }
      }
   }
}

_UIT_EnumGUI instproc _displayList {} {
   $self instvar _enumWindow _enumList valueList
   global _UIT_g_main

   set parent [$_UIT_g_main getTopWin]
   if { ! [cequal $parent $self] && ! [cequal $parent {}]} {
      wm transient $_enumWindow .$parent
      $_enumWindow center .$parent
   } else {
      wm transient $_enumWindow
      $_enumWindow center
   }
   
   $_UIT_g_main pushDisplayStack $self	
   
   $_enumWindow activate
   update idletasks
   set ndx [lsearch $valueList [$self getVal]]
   if {$ndx < 0} { set ndx 0 }
   $_enumList selection set $ndx
   $_enumList activate $ndx
   $_enumList see $ndx

   wm minsize $_enumWindow \
       [winfo reqwidth $_enumWindow] [winfo reqheight $_enumWindow]
}


_UIT_EnumGUI instproc _doSelection {} {
   $self instvar _enumWindow _UIframe _enumList valueList
   
   $_enumWindow deactivate
   
   global _UIT_g_main
   $_UIT_g_main popDisplayStack $self
   
   ## Update selection/button
   
   $self setVal [lindex $valueList [$_enumList curselection]]
   $self invokeWrapper
}


_UIT_EnumGUI instproc _mkOptionMenu {m} {
   global _UIT_g_main
   $self instvar _valuePtr displayList valueList

   foreach i $valueList {
      $m add command -label $displayList($i) \
	  -command \
	  "set $_valuePtr $i; set _UIT_${self}OptionVal \"$displayList($i)\"; $self invokeWrapper"
   }
}

_UIT_EnumGUI instproc invokeWrapper {} {
   $self instvar _window
   $_window _makeBusy
   $self changeCB
   $_window _makeNotBusy
}

_UIT_EnumGUI instproc setVal {val} {
   $self instvar valueList displayList _enumList _chosenStyle _displayedOnce
   
   set ndx [lsearch -exact $valueList $val]
   if { $ndx == -1} {
      return {}
   }

   $self next $val      ;# set the global widgets data

   if [cequal $_chosenStyle "radio"] {return} 
   
   upvar #0 _UIT_${self}OptionVal OptionVal
   set OptionVal $displayList($val)
   
   if [cequal $_chosenStyle "combo"] {
      if [info exists _enumList] {
	 $_enumList selection set $ndx
	 $_enumList see $ndx
	 $_enumList activate $ndx
      }
   }
}


#----------------------------------------------
#@ Set the valueList at run-time

_UIT_EnumGUI instproc setValueList {valList} {
   $self instvar valueList

   set valueList $valList
   $self _chooseStyle
   $self updateDispList
   $self _checkValue
}


#----------------------------------------------
#@ Update the displayList of the widget with the new valueList. 

_UIT_EnumGUI instproc updateDispList {} {
   global _UIT_g_main
   $self instvar valueList displayList \
       _displayedOnce _isAlignable _enabledState

#  get the displayList array indexed by valueList elements
   catch {unset displayList}
   foreach i $valueList {
      set displayList($i) [$_UIT_g_main catget $self $i $i]
   }

   if {!$_displayedOnce} {
      return
   } else {
      $self _buildEnumUI
      set parent [$self set _parent]
      if [string match "_UIT_Down*" [$parent info class]] {
	 $parent _realignWdgts
      }
      $self _setState $_enabledState
   }
}


_UIT_EnumGUI instproc _alignableWidget {} {
   return [$self set _UIrep]
}


# --------------------------------------------
#@ Make sure the current value is one of the possible values.
#@ If not, choose the first value.  This needs to be done
#@ initially and whenever the value list is changed.

_UIT_EnumGUI instproc _checkValue {} {
    $self instvar valueList displayList

    set curVal [$self getVal]
    # If current value is not one of the possible values...
    # This check is based on the fact that all values have a display
    # string indexed by the value itself.
    if { ! [info exists displayList($curVal)]} {
	# ... use first value
	$self setVal [lindex $valueList 0]
    }
}


_UIT_EnumGUI instproc _mkEnumList {child} {
   set lst [scrolledlistbox $child.lst -labeltext "Select one:" \
		-labelpos nw -labelmargin 0 -selectmode browse \
		-visibleitems 50x15 -hscrollmode dynamic \
		-vscrollmode dynamic -dblclickcommand "$self _doSelection"]

   if [string match {*GUI} [$self info class]] {
      $lst configure -exportselection 0
   }
   return $lst
}
