#!/usr/bin/sh
# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: enumjava.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:36  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.10.1  2001/09/24  17:33:20  Richard_Taft
# 	Fixed QAR 87892: initial value always set to first item
#
# Revision 1.1.5.10  1998/07/16  17:47:15  Sai_Akkapeddi
# 	Code Drop for baselevel BL17
# 	[1998/07/15  17:18:42  Sai_Akkapeddi]
#
# Revision 1.1.2.18  1998/07/01  19:34:35  William_Athanasiou
# 	displayList must be accesed as an array not a list
# 	[1998/07/01  19:34:15  William_Athanasiou]
# 
# Revision 1.1.2.17  1998/03/27  21:11:07  William_Athanasiou
# 	Typo _choseStyle should be _chooseStyle
# 	[1998/03/27  21:10:50  William_Athanasiou]
# 
# Revision 1.1.2.16  1998/03/25  17:39:57  William_Athanasiou
# 	Make _chosenStyle an instvar
# 	[1998/03/25  17:39:09  William_Athanasiou]
# 
# Revision 1.1.2.15  1998/03/24  22:18:48  William_Athanasiou
# 	Add styleHint capability to enumeration type
# 	[1998/03/24  22:17:30  William_Athanasiou]
# 
# Revision 1.1.2.14  1998/03/16  20:09:11  William_Athanasiou
# 	Add setLabel functionality to allow window and widget labels to be dynamically set
# 	[1998/03/16  20:05:34  William_Athanasiou]
# 
# Revision 1.1.2.13  1998/02/13  22:27:45  William_Athanasiou
# 	Added enable/disable and changeCB funtionality
# 	[1998/02/13  22:18:59  William_Athanasiou]
# 
# Revision 1.1.2.12  1997/11/06  19:58:30  William_Athanasiou
# 	Replace all quoted strings with a call to safeXferString
# 	[1997/11/06  19:56:37  William_Athanasiou]
# 
# Revision 1.1.2.11  1997/09/04  13:31:32  Richard_Taft
# 	Default values were not correctly set
# 	[1997/09/04  13:12:43  Richard_Taft]
# 
# Revision 1.1.2.10  1997/08/22  18:46:09  William_Athanasiou
# 	Remove resetval call and correct display logic
# 	[1997/08/22  18:28:41  William_Athanasiou]
# 
# Revision 1.1.2.9  1997/08/20  13:00:45  Richard_Taft
# 	 	** Merge Information **
# 		** Command used:	bsubmit **
# 		** Ancestor revision:	1.1.2.7 **
# 		** Merge revision:	1.1.2.8 **
# 	 	** End **
# 	Call resetVal from display to set _javaKnowsMe and sync
# 	up values between java & suit.
# 
# 	Make sure items are quoted properly in display string.
# 	[1997/07/24  19:41:45  Richard_Taft]
# 
# Revision 1.1.2.8  1997/08/18  17:11:09  William_Athanasiou
# 	Postpone catalog lookup until first time widget displayed
# 	[1997/08/18  16:17:30  William_Athanasiou]
# 
# Revision 1.1.2.7  1997/07/23  22:04:42  Richard_Taft
# 	setVal & getVal now use numbers, not strings
# 	[1997/07/23  21:55:04  Richard_Taft]
# 
# Revision 1.1.2.6  1997/07/22  21:42:24  Richard_Taft
# 	Added getVal, setVal and setValueList
# 	[1997/07/22  21:36:19  Richard_Taft]
# 
# Revision 1.1.2.5  1997/07/18  19:54:47  Richard_Taft
# 	Changed puts to putJava
# 	[1997/07/18  19:48:26  Richard_Taft]
# 
# Revision 1.1.2.4  1997/07/09  20:12:20  Todd_Moyer
# 	Moved value to the end if display method.
# 	[1997/07/09  20:10:05  Todd_Moyer]
# 
# Revision 1.1.2.3  1997/07/02  19:01:13  Deepa_Bachu
# 	Modified the creation code being sent to the applet.
# 	[1997/07/02  18:56:16  Deepa_Bachu]
# 
# Revision 1.1.2.2  1997/06/23  15:44:20  Deepa_Bachu
# 	Initial _UIT_EnumJAVA class file.
# 	[1997/06/23  15:42:52  Deepa_Bachu]
# 
# $EndLog$
# 
# @(#)$RCSfile: enumjava.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:36 $
# 

Class _UIT_EnumJAVA -superclass _UIT_EnumGeneric

_UIT_EnumJAVA instproc display {} {
   $self instvar _displayedOnce _chosenStyle
   
   if { ! $_displayedOnce } {
      $self instvar valueIndex displayList valueList \
	  _lbl _helpTag _valuePtr _enabledState
      upvar #0 $_valuePtr val

      set valueIndex 0
      if {[set idx [lsearch $valueList $val]] > 0} {
	 set valueIndex  $idx
      }
      
      putJava_noNL "_UIT_Enumerated $self \
             [safeXferString $_lbl] $_enabledState \
             [safeXferString $_helpTag] $_chosenStyle \{"
      foreach itm $valueList {
	 putJava_noNL " [safeXferString $displayList($itm)]"
      }
      putJava " \} $valueIndex"
      incr _displayedOnce
   }
}


_UIT_EnumJAVA instproc setVal {val} {
   $self instvar _displayedOnce valueList
   
   set ndx [lsearch -exact $valueList $val]
   if { $ndx == -1} {
      return {}
   }

   set val [$self next $val]
   if { $_displayedOnce } {
      putJava "$self setVal [lsearch $valueList $val]"
   }
   return $val
}



_UIT_EnumJAVA instproc getVal {} {
    $self instvar _displayedOnce valueList

    if { $_displayedOnce } {
	# Query java for the value
	putJava "$self getVal"
	if { [ getJava val ] < 0 } {
	    logMsg "Java Applet closed?"
	    error "Java Applet closed?"
	    return ""
	} else {
	    return [lindex $valueList $val]
	}

    } else {
	# Java doesn't know the value,
	# we do!
	return [$self next]
    }
}


_UIT_EnumJAVA instproc setValueList {valList} {
   $self instvar _displayedOnce _chosenStyle \
       valueList displayList
   
   set curSelected [$self getVal]
   set valueList $valList
   
   $self _chooseStyle
   $self updateDispList
   set ndx 0
   if [info exists displayList($curSelected)] {
      set ndx [lsearch -exact $valueList $curSelected] 
      if {$ndx == -1} {set ndx 0}
   }
   
   if { $_displayedOnce } {
      putJava_noNL "$self setValueList $_chosenStyle \{"
      foreach itm $valueList {
	 putJava_noNL " [safeXferString $displayList($itm)]"
      }
      putJava " \} $ndx"
   }
}

###################################################
# Method that updates the displayList of the widget
# with the new valueList. 
###################################################
_UIT_EnumJAVA instproc updateDispList {} {
   global _UIT_g_main
   $self instvar valueList displayList

#  get the displayList array indexed by valueList elements
   catch {unset displayList}
   foreach i $valueList {
      set displayList($i) [$_UIT_g_main catget $self $i $i]
   }
}

_UIT_EnumJAVA instproc _setState {val} { 
   if [cequal $val "disabled"] { 
      putJava "$self disable" 
   } else {
      putJava "$self enable"
   }
}
