#!/usr/bin/tclsh
# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: eventinfo.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:36  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.4.1  1999/12/16  20:56:18  William_Athanasiou
# 	sysman bulk submit for BL7
#
# Revision 1.1.2.1  1999/12/15  14:33:42  Todd_Moyer
# 	Created.
# 	[1999/12/15  14:30:50  Todd_Moyer]
#
# $EndLog$
# 
# @(#)$RCSfile: eventinfo.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:36 $
# 


Class EventInfo

#@ Class to manage the info for one event.  When created, pulls out the
#@   current event's info from the API and saves it.
#@
#@ EventInfo name eventApi [-clientData clientData]


EventInfo instproc init {eventApi args} {
    $self instvar _clientData _formattedStr _infoArr _timestampTicks _varNames

    set _clientData      ""
    array set _infoArr   [$eventApi dump]
    set  _formattedStr   [$eventApi format]
    set  _varNames       [$eventApi vars]
    eval $self next $args
}



# ================ Creation parameter initialization ================
# These sevice arguments specified as part of creation, but can also
# be called afterwards.

#@ Creation parameter initialization.
#@   Set any kind of data for later retrieval from the callback.

EventInfo instproc clientData {clientData} {
    $self set _clientData $clientData
}




# ====================== Convenience Methods ======================


#@ Returns generic event attribute (item) values.  Not all attributes are
#@   defined for every event.  The attribute names are as defined in the
#@   EvmItemSet man page's "item_id" operand, except the leading
#@   "EvmITEM_" is removed.  If the attribute is not found, the null string
#@   will be returned.

EventInfo instproc getAtt {attName} {
    $self instvar _infoArr

    set attName2 "%[string tolower $attName]"
    if {[info exists _infoArr($attName2)]} {
	return $_infoArr($attName2)
    }
    return ""
}


#@ Returns the clientData set in the subscription, or "" if none specified.

EventInfo instproc getClientData {} {
    return [$self set _clientData]
}


#@ Returns the formatted event string for the current event.

EventInfo instproc getFormattedStr {} {
    return [$self set _formattedStr]
}


#@ Returns the formatted timestamp.
#@   May optionally specifiy a format string using the syntax defined
#@   in 'clock format'.  If not specified, uses the 'clock format' default.

EventInfo instproc getTimestamp {{formatStr ""}} {
    $self instvar _infoArr

    if {[info exists _infoArr(%timestamp)]} {
	return [fmtclock $_infoArr(%timestamp) $formatStr]
    }
    return ""
}



#@ Returns the value of a variable particular to this kind of event.
#@   If the variable is not found, the null string will be returned.

EventInfo instproc getVar {varName} {
    $self instvar _infoArr

    if {[info exists _infoArr($varName)]} {
	return $_infoArr($varName)
    }
    return ""
}


#@ Returns the list of all variable names for the current event.

EventInfo instproc getVarNames {} {
    return [$self set _varNames]
}


# ======================== Private Methods ========================
